/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataViewerFrame;
import oracle.dmt.dm4j.browser.viewer.results.apply.ExplainRankingPanel;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.jdmresult.OraMiningExplainResult;

public class ExplainResultViewer
extends GriddedPanel {
    JLabel m_name = new JLabel();
    JLabel m_explainAttributeName = new JLabel();
    JLabel m_inSchema = new JLabel();
    HyperlinkButtonDataSource m_inTable = new HyperlinkButtonDataSource();
    JLabel m_outSchema = new JLabel();
    HyperlinkButtonDataSource m_outTable = new HyperlinkButtonDataSource();
    JLabel m_startDate = new JLabel();
    JLabel m_startTime = new JLabel();
    JLabel m_endDate = new JLabel();
    JLabel m_endTime = new JLabel();
    JLabel m_aoNotFound = null;
    OraMiningExplainResult m_explain = null;

    public ExplainResultViewer(LeafNodeData leafNodeData) {
        try {
            this.m_explain = (OraMiningExplainResult)leafNodeData.getOdmObject();
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
            this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "dm4j_explain_html";
    }

    private void jbInit() throws Exception {
        JTabbedPane jTabbedPane = new JTabbedPane();
        GriddedPanel griddedPanel = new GriddedPanel();
        GriddedPanel griddedPanel2 = new GriddedPanel();
        jTabbedPane.addTab(DM4JResourceUtilities.getUIString("RESULT_EXPLAIN_OUTPUT_TAB"), null, griddedPanel2, DM4JResourceUtilities.getUIString("RESULT_EXPLAIN_OUTPUT_TAB"));
        jTabbedPane.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, griddedPanel, DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        jTabbedPane.setComponentAt(0, griddedPanel2);
        jTabbedPane.setComponentAt(1, griddedPanel);
        int n = 1;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_NAME"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_name, TOPVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_START_DATE"));
        griddedPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_startDate, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_START_TIME"));
        griddedPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_startTime, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_END_DATE"));
        griddedPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_endDate, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_END_TIME"));
        griddedPanel.addComponent(jLabel, MIDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_endTime, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_EXPLAIN"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_EXPLAIN"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n, 1, 1, 1, 17, 0);
        griddedPanel.addComponent(this.m_explainAttributeName, TOPVALUEITEMINSETS, n++, 2, 1, 1, 16, 0);
        jLabel.setLabelFor(this.m_explainAttributeName);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_INPUT_DATA"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_SCHEMA"));
        griddedPanel.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_inSchema, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TABLE_OR_VIEW"));
        griddedPanel.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_inTable, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_OUTPUT_DATA"));
        griddedPanel.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_SCHEMA"));
        griddedPanel.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_outSchema, MIDVALUEITEMINSETS, n++, 2);
        jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_TABLE_OR_VIEW"));
        griddedPanel.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 1);
        griddedPanel.addComponent(this.m_outTable, MIDVALUEITEMINSETS, n++, 2);
        griddedPanel.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
        n = 1;
        boolean bl = this.explainOutputExists();
        if (!bl) {
            this.m_aoNotFound = new JLabel(DM4JResourceUtilities.getUIString("EXPLAIN_RESULT_NO_OUTPUT_TABLE"));
            griddedPanel2.addComponent(this.m_aoNotFound, TOPVALUEITEMINSETS, n++, 2);
            JLabel jLabel2 = new JLabel();
            griddedPanel2.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n, 1, 2, 2, 1);
        } else {
            ExplainRankingPanel explainRankingPanel = new ExplainRankingPanel(this.m_explain);
            griddedPanel2.addFilledComponent(explainRankingPanel, MIDLABELITEMINSETS, n, 1, 2, 2, 1);
        }
        this.addFilledComponent(jTabbedPane, TOPLABELITEMINSETS, 0, 0, 5, 5, 1);
        jTabbedPane.setSelectedIndex(0);
    }

    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        String string = this.m_explain.getTaskName();
        this.m_name.setText(string);
        Timestamp timestamp = this.m_explain.getStartingTimestamp();
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string2 = dateFormat.format(timestamp);
        this.m_startDate.setText(string2);
        dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
        String string3 = dateFormat.format(timestamp);
        this.m_startTime.setText(string3);
        Timestamp timestamp2 = this.m_explain.getCompletionTimestamp();
        dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string4 = dateFormat.format(timestamp2);
        this.m_endDate.setText(string4);
        dateFormat = DateFormat.getTimeInstance(3, Locale.getDefault());
        String string5 = dateFormat.format(timestamp2);
        this.m_endTime.setText(string5);
        String string6 = this.m_explain.getExplainAttributeName();
        this.m_explainAttributeName.setText(string6);
        String string7 = this.m_explain.getSchemaName();
        this.m_inSchema.setText(string7);
        String string8 = this.m_explain.getInputTableName();
        this.m_inTable.setText(string8);
        this.m_inTable.setActive(true);
        this.m_inTable.setSchemaName(DM4JStringUtils.trimDoubleQuotes(string7));
        this.m_inTable.setTableName(DM4JStringUtils.trimDoubleQuotes(string8));
        this.m_inTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExplainResultViewer.this.selectOutputData_actionPerformed(actionEvent);
            }
        });
        String string9 = DM4JConnectionManager.getUser();
        this.m_outSchema.setText(string9);
        String string10 = this.m_explain.getExplainOutputTableName();
        this.m_outTable.setText(string10);
        this.m_outTable.setActive(true);
        this.m_outTable.setSchemaName(DM4JStringUtils.trimDoubleQuotes(string9));
        this.m_outTable.setTableName(DM4JStringUtils.trimDoubleQuotes(string10));
        this.m_outTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExplainResultViewer.this.selectOutputData_actionPerformed(actionEvent);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean explainOutputExists() {
        boolean bl;
        block11: {
            Connection connection = null;
            bl = false;
            connection = DM4JConnectionManager.getDbConnection();
            bl = DatabaseMetadata.datasourceExists(connection, DM4JConnectionManager.getUser(), this.m_explain.getExplainOutputTableName());
            Object var5_3 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block11;
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    Object var5_4 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block11;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    private void selectOutputData_actionPerformed(ActionEvent actionEvent) {
        try {
            final HyperlinkButtonDataSource hyperlinkButtonDataSource = (HyperlinkButtonDataSource)actionEvent.getSource();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block10: {
                        Connection connection = null;
                        connection = DM4JConnectionManager.getDbConnection();
                        if (DatabaseMetadata.isTable(connection, hyperlinkButtonDataSource.getSchemaName(), hyperlinkButtonDataSource.getTableName())) {
                            hyperlinkButtonDataSource.setIsView(false);
                        } else {
                            hyperlinkButtonDataSource.setIsView(true);
                        }
                        OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(hyperlinkButtonDataSource);
                        Object var4_4 = null;
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break block10;
                        {
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var4_5 = null;
                                try {
                                    connection.close();
                                }
                                catch (Exception exception2) {
                                    exception2.printStackTrace();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

