/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.export.ExportChartDialog;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.results.apply.ExplainRankTable;
import oracle.dmt.jdm.jdmresult.OraMiningExplainResult;
import oracle.dss.graph.Graph;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public class ExplainRankingPanel
extends GriddedPanel {
    OraMiningExplainResult m_miningExplainResult = null;
    ExplainRankTable m_rankTable = null;
    JCheckBox m_sortAbsoluteImportanceValue = new JCheckBox();
    JScrollPane m_rankScrollPane = new JScrollPane();
    Graph m_histogram = null;
    JButton m_exportButton = null;
    JButton m_exportChartButton = null;

    public ExplainRankingPanel(OraMiningExplainResult oraMiningExplainResult) {
        this.m_miningExplainResult = oraMiningExplainResult;
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "ATTRIBUTE_IMPORTANCE_MODEL";
    }

    private void jbInit() throws Exception {
        Cloneable cloneable;
        Serializable serializable;
        GriddedPanel griddedPanel = new GriddedPanel();
        GriddedPanel griddedPanel2 = new GriddedPanel();
        JSplitPane jSplitPane = new JSplitPane(0, griddedPanel, griddedPanel2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(350);
        Dimension dimension = new Dimension(100, 50);
        griddedPanel.setMinimumSize(dimension);
        griddedPanel2.setMinimumSize(dimension);
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("AI_SETTING_RANKS"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("AI_SETTING_RANKS"));
        griddedPanel2.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        griddedPanel2.addAnchoredComponent(jButton, MIDLABELITEMINSETS, n++, 2, 1, 1, 14);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(ExplainRankingPanel.this.m_rankTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_rankTable = new ExplainRankTable(this.m_miningExplainResult);
        this.m_rankScrollPane.getViewport().add(this.m_rankTable);
        jLabel.setLabelFor(this.m_rankTable);
        this.m_rankScrollPane.setPreferredSize(null);
        griddedPanel2.addFilledComponent(this.m_rankScrollPane, MIDLABELITEMINSETS, n, 0, 3, 3, 1);
        n = 0;
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("AI_HIST"));
        jLabel2.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("AI_HIST"));
        griddedPanel.addAnchoredComponent(jLabel2, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        JButton jButton2 = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton2.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        griddedPanel.addAnchoredComponent(jButton2, MIDLABELITEMINSETS, n++, 2, 1, 1, 14);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportChartDialog exportChartDialog = new ExportChartDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("EXPORT_TITLE"));
                    if (!exportChartDialog.isCancelled()) {
                        exportChartDialog.export(ExplainRankingPanel.this.m_histogram);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        if (null == this.m_histogram) {
            serializable = new DefaultErrorHandler();
            ((DefaultErrorHandler)serializable).setDebugMode(0);
            this.m_histogram = new Graph((ErrorHandler)((Object)serializable));
            this.m_histogram.setLocale(Locale.getDefault());
            this.m_histogram.setGraphType(24);
            this.m_histogram.setAutoLayout(2);
            this.m_histogram.getPFJ().setDisplay(this.m_histogram.getPFJ().getLegendArea(), false);
            this.m_histogram.setScrollbarPresenceGroups(2);
            cloneable = this.m_histogram.getImageSize();
            this.m_histogram.setImageSize((Dimension)cloneable);
            this.m_histogram.setVisible(false);
        }
        serializable = new JPanel(new GridBagLayout());
        cloneable = new GridBagConstraints();
        cloneable.anchor = 18;
        cloneable.fill = 1;
        cloneable.weightx = 1.0;
        cloneable.weighty = 1.0;
        ((JComponent)serializable).setPreferredSize(this.m_histogram.getImageSize());
        ((Container)serializable).add(this.m_histogram, cloneable);
        jScrollPane.getViewport().add((Component)serializable);
        jScrollPane.setPreferredSize(null);
        griddedPanel.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n, 0, 3, 3, 1);
        this.addFilledComponent(jSplitPane, TOPLABELITEMINSETS, 0, 0, 5, 5, 1);
    }

    protected void m_sortAbsoluteImportanceValue_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            boolean bl = this.m_sortAbsoluteImportanceValue.isSelected();
            int n = 2;
            if (bl) {
                this.m_rankTable.setSortAbsoluteImportance(true);
            } else {
                this.m_rankTable.setSortAbsoluteImportance(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private void runTimePanelLoad() throws Exception {
        this.m_rankTable.load(this.m_histogram);
        Grid grid = this.m_rankTable.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_rankTable);
        this.m_sortAbsoluteImportanceValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExplainRankingPanel.this.m_sortAbsoluteImportanceValue_actionPerformed(actionEvent);
            }
        });
    }
}

