/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.EventObject;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.results.apply.AbsoluteNumberComparator;
import oracle.dmt.dm4j.browser.viewer.results.apply.ExplainRankTableModel;
import oracle.dmt.dm4j.browser.worker.LoadExplainOutputWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ExplainOutputLoadedListener;
import oracle.dmt.jdm.jdmresult.OraMiningExplainResult;
import oracle.dss.graph.Graph;

public final class ExplainRankTable
extends Dm4jSpreadTable
implements ExplainOutputLoadedListener {
    int[] m_colSortOrders = null;
    int m_curSortOrder = 2;
    String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("AI_RANK_ATTR_NAME"), DM4JResourceUtilities.getUIString("AI_RANK_ATTR_RANK"), DM4JResourceUtilities.getUIString("AI_RANK_ATTR_IMPORTANCE")};
    int[] m_colWidths = new int[]{50, 25, 25};
    ExplainRankTableModel m_tableModel;
    Graph m_histogram;

    public ExplainRankTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_colSortOrders = new int[this.m_columnNames.length];
        this.m_colSortOrders[0] = 0;
        this.m_colSortOrders[1] = 0;
        this.m_colSortOrders[2] = 2;
    }

    public void load(Graph graph) throws Exception {
        this.load(null, false, graph);
    }

    public void displayLoadingStatus() throws Exception {
        super.displayLoadingStatus();
    }

    public void load(String string, boolean bl, Graph graph) throws Exception {
        this.setColumnWidths(this.m_colWidths, true);
        this.m_histogram = graph;
        OraMiningExplainResult oraMiningExplainResult = (OraMiningExplainResult)this.getDataItem();
        if (null == oraMiningExplainResult) {
            throw new Exception("Cannot load data. OraMiningExplainResult not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadExplainOutputWorker loadExplainOutputWorker = (LoadExplainOutputWorker)workerThreadManager.getLoadExplainOutputWorker(oraMiningExplainResult, string, bl, graph);
        loadExplainOutputWorker.addExplainOutputLoadedListener(this);
        loadExplainOutputWorker.start();
    }

    public void setSortAbsoluteImportance(boolean bl) {
        if (this.m_tableModel != null) {
            if (bl) {
                this.m_tableModel.setColumnComparator(2, AbsoluteNumberComparator.getComparator());
            } else {
                this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
            }
        }
    }

    public void tableLoaded(EventObject eventObject) {
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = (ExplainRankTableModel)eventObject.getSource();
        this.m_tableModel.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(1, NumberComparator.getComparator());
        this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
        this.setModels((TwoDModel)this.m_tableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler(new SortHandler(this.m_tableModel));
        header.setCanMoveItems(false);
        this.m_tableModel.sort(1, true);
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Grid grid = this.getGrid();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 10));
        grid.setColumnPainter(2, dM4JTruncatingNumberFormatPainter);
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        public SortHandler(SortableTwoDModel sortableTwoDModel) {
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            try {
                int n2 = ExplainRankTable.this.m_colSortOrders[n];
                if (n2 == -1) {
                    return;
                }
                if (n2 == 0) {
                    n2 = ExplainRankTable.this.m_curSortOrder;
                } else if (n2 == 1) {
                    n2 = 2;
                } else if (n2 == 2) {
                    n2 = 1;
                }
                ExplainRankTable.this.m_colSortOrders[n] = n2;
                ExplainRankTable.this.m_curSortOrder = n2;
                ExplainRankTable.this.m_tableModel.sort(n, n2 == 1);
                if (n >= 0) {
                    int n3 = ExplainRankTable.this.m_tableModel.getRowCount();
                    String[] stringArray = new String[n3];
                    double[] dArray = new double[n3];
                    int n4 = 0;
                    int n5 = 2;
                    for (int i = 0; i < n3 - 1; ++i) {
                        stringArray[i] = (String)ExplainRankTable.this.m_tableModel.getData(n4, i);
                        dArray[i] = (Double)ExplainRankTable.this.m_tableModel.getData(n5, i);
                    }
                    ExplainRankTable.this.m_tableModel.loadGraph(ExplainRankTable.this.m_histogram, stringArray, dArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }
}

