/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.results.apply;

import java.awt.Cursor;
import java.awt.Insets;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.datamining.NamedObject;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.resource.Connection;
import javax.datamining.rule.CompoundPredicate;
import javax.datamining.rule.Rule;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraClusteringModel;
import oracle.dmt.dm4j.browser.viewer.results.apply.RuleDisplayDialog;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.clustering.OraClusteringModel;
import oracle.dmt.jdm.jdmresult.OraMiningApplyResult;

public class ClusteringRuleDisplayPanel
extends GriddedPanel {
    RuleDisplayDialog m_parentDialog;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblRule = new JLabel();
    JTextArea txtRule = new JTextArea();
    JScrollPane scrollRule = new JScrollPane();
    JLabel lblFiller = new JLabel();
    OraMiningApplyResult m_mar = null;
    int m_ruleId;
    private static final String _and = " and ";

    public ClusteringRuleDisplayPanel(RuleDisplayDialog ruleDisplayDialog, OraMiningApplyResult oraMiningApplyResult, int n) throws Exception {
        this.m_mar = oraMiningApplyResult;
        this.m_ruleId = n;
        this.m_parentDialog = ruleDisplayDialog;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        this.mlblStepDescription.setText(DM4JResourceUtilities.getUIString("APPLY_RESULT_RULE_VIEWER_DESC"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, new Insets(10, 0, 10, 0), n++, 0, 2, 1, 1);
        n += 2;
        this.lblRule.setText(DM4JResourceUtilities.getUIString("COMMON_RULE_DETAIL"));
        this.lblRule.setLabelFor(this.txtRule);
        this.addComponent(this.lblRule, new Insets(5, 0, 0, 0), n++, 0);
        this.txtRule.setEditable(false);
        this.txtRule.setLineWrap(true);
        this.txtRule.setWrapStyleWord(true);
        this.scrollRule.getViewport().add(this.txtRule);
        this.addFilledComponent(this.scrollRule, new Insets(5, 0, 0, 0), n, 0, 2, 2, 1);
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() throws Exception {
        this.displayRule(this.m_ruleId);
    }

    protected void displayRule(int n) {
        this.setCursor(new Cursor(3));
        final int n2 = n;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block13: {
                    Connection connection = null;
                    ClusteringRuleDisplayPanel.this.txtRule.setText(DM4JResourceUtilities.getUIString("COMMON_LOADING"));
                    connection = DM4JConnectionManager.getConnection();
                    ClusteringModel clusteringModel = (ClusteringModel)connection.retrieveObject(ClusteringRuleDisplayPanel.this.m_mar.getMiningModel().toUpperCase(), NamedObject.model);
                    if (clusteringModel instanceof OraClusteringModel) {
                        clusteringModel = new ODMrOraClusteringModel(connection, (OraClusteringModel)clusteringModel);
                    }
                    Cluster cluster = clusteringModel.getCluster(n2);
                    Rule rule = ((ODMrOraClusteringModel)clusteringModel).getRule(n2);
                    if (rule == null) {
                        throw new Exception();
                    }
                    Hashtable hashtable = DatabaseMetadata.getODMrTextLookupTable(clusteringModel.getName());
                    CompoundPredicate compoundPredicate = (CompoundPredicate)rule.getAntecedent();
                    StringBuffer stringBuffer = new StringBuffer(BrowserUtils.getAntecedentString(compoundPredicate, hashtable));
                    CompoundPredicate compoundPredicate2 = (CompoundPredicate)rule.getConsequent();
                    StringBuffer stringBuffer2 = new StringBuffer(BrowserUtils.getConsequentString(compoundPredicate2, hashtable));
                    String string = DM4JResourceUtilities.getUIString("COMMON_RULES_IF");
                    String string2 = DM4JResourceUtilities.getUIString("COMMON_RULES_THEN");
                    StringBuffer stringBuffer3 = new StringBuffer(string + "\n");
                    stringBuffer3.append(stringBuffer.toString());
                    stringBuffer3.append("\n\n");
                    stringBuffer3.append(string2 + "\n");
                    stringBuffer3.append(stringBuffer2.toString());
                    stringBuffer3.append("\n\n");
                    stringBuffer3.append(DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE") + "=" + ClusteringRuleDisplayPanel.this.toPercent(rule.getConfidence()));
                    stringBuffer3.append("\n");
                    long l = cluster.getCaseCount();
                    long l2 = (long)((double)l * rule.getSupport());
                    stringBuffer3.append(DM4JResourceUtilities.getUIString("SORT_DIALOG_RULE_SUPPORT") + "=" + l2);
                    ClusteringRuleDisplayPanel.this.txtRule.setText(stringBuffer3.toString());
                    Object var18_16 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block13;
                    }
                    catch (Exception exception) {}
                    break block13;
                    {
                        catch (Exception exception) {
                            ClusteringRuleDisplayPanel.this.txtRule.setText(DM4JResourceUtilities.getUIString("MINING_RULE_ERROR_MSG"));
                            Object var18_17 = null;
                            try {
                                if (connection != null) {
                                    connection.close();
                                }
                                break block13;
                            }
                            catch (Exception exception2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_18 = null;
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        this.setCursor(new Cursor(0));
    }

    private String toPercent(double d) {
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 2, 2);
        BigDecimal bigDecimal = new BigDecimal(d * 100.0);
        bigDecimal = bigDecimal.setScale(2, 4);
        String string = numberFormat.format(bigDecimal.doubleValue());
        return string;
    }
}

