/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.regression;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.regression.SVMRegressionSettings;
import javax.datamining.supervised.regression.RegressionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.FilterAttributesDialog;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.regression.SVMRegCoefficientTable;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class SVMRegressionModelContentPanel
extends GriddedPanel
implements VetoableChangeListener {
    private RegressionModel m_model = null;
    private JLabel m_targetAttribName = new JLabel();
    JLabel lblBias = new JLabel();
    JLabel lblBiasValue = new JLabel();
    JButton m_filter = new JButton();
    JButton m_scale = new JButton();
    boolean m_isScaled = false;
    JButton m_exportButton = new JButton();
    JCheckBox m_sortAbsoluteCoefficientValue = new JCheckBox();
    NumberTextField m_tfSize = new NumberTextField();
    JLabel m_lblSize = new JLabel();
    JButton m_btnRefresh = new JButton();
    Integer m_defaultFectchSize = new Integer(100);
    String m_defaultSortBy = null;
    String m_defaultSortOrder = null;
    Hashtable m_xformTables = null;
    SVMRegCoefficientTable m_coefficientTable = null;
    JScrollPane m_coefficientScrollPane = new JScrollPane();
    HashMap m_condition = new HashMap();
    Hashtable m_lookupTableMap = null;

    public SVMRegressionModelContentPanel(LeafNodeData leafNodeData) {
        this.m_model = (RegressionModel)leafNodeData.getOdmObject();
        try {
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "SVM_REGRESSION_MODEL";
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        SVMRegressionSettings sVMRegressionSettings = (SVMRegressionSettings)this.m_model.getBuildSettings().getAlgorithmSettings();
        if (sVMRegressionSettings.getKernelFunction().equals(KernelFunction.kLinear)) {
            JLabel jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
            this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
            this.addComponent(this.m_targetAttribName, TOPVALUEITEMINSETS, n++, 1);
            this.lblBias.setText(DM4JResourceUtilities.getUIString("CLASS_SVM_BIAS") + ":");
            this.lblBias.setLabelFor(this.lblBiasValue);
            this.addComponent(this.lblBias, MIDLABELITEMINSETS, n, 0);
            this.addComponent(this.lblBiasValue, MIDLABELITEMINSETS, n++, 1);
            this.m_coefficientTable = new SVMRegCoefficientTable(this.m_model);
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_COEFFICIENTS"));
            this.addAnchoredComponent(jLabel2, TOPLABELITEMINSETS, n++, 0, 1, 1, 16);
            this.m_sortAbsoluteCoefficientValue.setText(DM4JResourceUtilities.getUIString("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT"));
            this.m_sortAbsoluteCoefficientValue.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT"));
            this.m_sortAbsoluteCoefficientValue.setSelected(false);
            this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
            this.m_exportButton.setEnabled(false);
            this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
            this.m_exportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                        ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                        if (!exportDialog.isCancelled()) {
                            exportDialog.export(SVMRegressionModelContentPanel.this.m_coefficientTable);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
            this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
            this.m_filter.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER"));
            this.m_filter.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER"));
            this.m_coefficientScrollPane.getViewport().add(this.m_coefficientTable);
            this.m_coefficientScrollPane.setPreferredSize(null);
            this.m_defaultSortBy = DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_COEFFICIENT");
            this.m_defaultSortOrder = DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC");
            JPanel jPanel = new JPanel();
            this.m_tfSize.setDataType(Integer.TYPE);
            this.m_tfSize.setNumber(this.m_defaultFectchSize);
            this.m_tfSize.setSigned(false);
            this.m_tfSize.setColumns(5);
            this.m_tfSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
            this.m_lblSize.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHSIZE"));
            this.m_lblSize.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHSIZE"));
            this.m_lblSize.setLabelFor(this.m_tfSize);
            this.m_btnRefresh.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH"));
            this.m_btnRefresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_REFRESH"));
            this.m_btnRefresh.setEnabled(true);
            this.m_btnRefresh.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SVMRegressionModelContentPanel.this.m_btnRefresh_actionPerformed(actionEvent);
                }
            });
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)this.m_lblSize, gridBagConstraints);
            jPanel.add((Component)this.m_tfSize, gridBagConstraints);
            jPanel.add((Component)this.m_btnRefresh, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)new JLabel(), gridBagConstraints);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel(new FlowLayout());
            jPanel2.add((Component)jPanel, "West");
            jPanel3.add(this.m_scale);
            jPanel3.add(this.m_filter);
            jPanel3.add(this.m_exportButton);
            jPanel2.add((Component)jPanel3, "East");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JPanel jPanel5 = new JPanel(new FlowLayout());
            jPanel4.add((Component)jPanel5, "West");
            jPanel5.add(this.m_sortAbsoluteCoefficientValue);
            JPanel jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)jPanel2, "North");
            jPanel6.add((Component)this.m_coefficientScrollPane, "Center");
            jPanel6.add((Component)jPanel4, "South");
            this.addFilledComponent(jPanel6, MIDLABELITEMINSETS, n++, 0, 2, 2, 1);
            this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
        } else {
            this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 2, 2, 1);
        }
    }

    protected void m_sortAbsoluteCoefficientValue_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            boolean bl = this.m_sortAbsoluteCoefficientValue.isSelected();
            int n = 2;
            if (bl) {
                this.m_coefficientTable.setSortAbsoluteCoefficient(true);
            } else {
                this.m_coefficientTable.setSortAbsoluteCoefficient(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    protected void m_filter_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setCursor(new Cursor(3));
            FilterAttributesDialog filterAttributesDialog = new FilterAttributesDialog(null, this.m_model, this.m_condition, DM4JResourceUtilities.getUIString("COMMON_FILTER_ATTRIBUTES_DIALOG"), true);
            this.setCursor(new Cursor(0));
            filterAttributesDialog.display();
            if (!filterAttributesDialog.isCancelled()) {
                Vector vector = filterAttributesDialog.getSelectedAttributes();
                Double d = filterAttributesDialog.getTopValue();
                Double d2 = filterAttributesDialog.getBottomValue();
                Boolean bl = filterAttributesDialog.isFilterByAbsoluteValue();
                Boolean bl2 = filterAttributesDialog.isIncludedAttributes();
                String string = filterAttributesDialog.getSortByValue();
                String string2 = filterAttributesDialog.getSortOrderValue();
                this.m_condition = new HashMap();
                this.m_condition.put("COMMON_FILTER_ATTRIBUTES", vector);
                this.m_condition.put("COMMON_FILTER_TOP", d);
                this.m_condition.put("COMMON_FILTER_BOTTOM", d2);
                this.m_condition.put("COMMON_FILTER_BY_ABSOULTE_VALUES", bl);
                this.m_condition.put("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES", bl2);
                Number number = this.m_tfSize.getNumber();
                if (number == null) {
                    DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
                this.m_condition.put("COMMON_FILTER_SORT_VALUE", string);
                this.m_condition.put("COMMON_FILTER_SORT_ORDER", string2);
                this.m_condition.put("COMMON_TEXT_LOOKUP", this.m_lookupTableMap);
                this.m_coefficientTable.load(this.m_condition);
                this.m_coefficientTable.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void m_btnRefresh_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            Number number = this.m_tfSize.getNumber();
            if (number == null) {
                DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                this.setCursor(new Cursor(0));
                return;
            }
            this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
            this.m_coefficientTable.load(this.m_condition);
            this.m_coefficientTable.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    protected void m_scale_actionPerformed(ActionEvent actionEvent) {
        String string = this.m_scale.getText();
        try {
            if (string.equals(DM4JResourceUtilities.getUIString("COMMON_SCALE"))) {
                this.m_isScaled = true;
                this.m_condition.put("MENU_DATA_XFORM_NORMALIZE", this.m_xformTables);
                this.m_coefficientTable.load(this.m_condition);
                this.loadBias();
                this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
                this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
            } else {
                this.m_isScaled = false;
                this.m_condition.put("MENU_DATA_XFORM_NORMALIZE", null);
                this.m_coefficientTable.load(this.m_condition);
                this.loadBias();
                this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
                this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runTimePanelLoad(LeafNodeData var1_1) throws Exception {
        this.m_model = (RegressionModel)var1_1.getOdmObject();
        var2_2 = (SVMRegressionSettings)this.m_model.getBuildSettings().getAlgorithmSettings();
        if (var2_2.getKernelFunction().equals(KernelFunction.kLinear)) {
            block14: {
                this.m_targetAttribName.setText(this.m_model.getTargetAttributeName());
                this.m_condition.put("COMMON_FETCH_SIZE", this.m_defaultFectchSize);
                this.m_condition.put("COMMON_FILTER_SORT_VALUE", this.m_defaultSortBy);
                this.m_condition.put("COMMON_FILTER_SORT_ORDER", this.m_defaultSortOrder);
                this.m_lookupTableMap = DatabaseMetadata.getODMrTextLookupTable(this.m_model.getName());
                this.m_condition.put("COMMON_TEXT_LOOKUP", this.m_lookupTableMap);
                this.m_xformTables = null;
                var3_3 = null;
                try {
                    var3_3 = DM4JConnectionManager.getDbConnection();
                    var4_4 = DMEMetadata.getInstance();
                    this.m_xformTables = var4_4.getTransparencyTables(var3_3, null, this.m_model.getName());
                    var6_6 = null;
                    ** if (null == var3_3) goto lbl-1000
                }
                catch (Throwable var5_11) {
                    var6_7 = null;
                    if (null != var3_3) {
                        try {
                            var3_3.close();
                        }
                        catch (Exception var7_10) {
                            // empty catch block
                        }
                    }
                    throw var5_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var3_3.close();
                    }
                    catch (Exception var7_8) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block14;
                    catch (Exception var4_5) {
                        var6_6 = null;
                        if (null != var3_3) {
                            try {
                                var3_3.close();
                            }
                            catch (Exception var7_9) {}
                        }
                    }
                }
            }
            if (this.m_xformTables != null) {
                this.m_condition.put("MENU_DATA_XFORM_NORMALIZE", this.m_xformTables);
                this.m_isScaled = true;
                this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
                this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
            } else {
                this.m_condition.put("MENU_DATA_XFORM_NORMALIZE", null);
                this.m_isScaled = false;
                this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
                this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
            }
            this.m_coefficientTable.load(this.m_condition);
            this.loadBias();
            var4_4 = this.m_coefficientTable.getGrid();
            var5_12 = new GeneralGridSelectionManager(0, 2, 0);
            var4_4.setGridSelectionManager(var5_12);
            var5_12.addVetoableChangeListener(this);
            var6_6 = new Dm4jSpreadTableExcelAdapter(this.m_coefficientTable);
            this.m_filter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SVMRegressionModelContentPanel.this.m_filter_actionPerformed(actionEvent);
                }
            });
            this.m_scale.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SVMRegressionModelContentPanel.this.m_scale_actionPerformed(actionEvent);
                }
            });
            this.m_sortAbsoluteCoefficientValue.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SVMRegressionModelContentPanel.this.m_sortAbsoluteCoefficientValue_actionPerformed(actionEvent);
                }
            });
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n2 = twoDSelection2.getSingleRow();
        if (n2 != (n = twoDSelection.getSingleRow())) {
            String string = DM4JResourceUtilities.getUIString("CLASS_SVM_NO_COEFFICIENT");
            String string2 = DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED");
            String string3 = "";
            if (this.m_coefficientTable != null && n2 >= 0) {
                string3 = (String)this.m_coefficientTable.getGrid().getModel().getData(0, n2);
            }
            if (string3 != null) {
                if (string3.equals(string) || string3.equals(string2)) {
                    this.m_sortAbsoluteCoefficientValue.setEnabled(false);
                    this.m_exportButton.setEnabled(false);
                    this.m_scale.setEnabled(false);
                } else {
                    this.m_sortAbsoluteCoefficientValue.setEnabled(true);
                    this.m_exportButton.setEnabled(true);
                    this.m_filter.setEnabled(true);
                    if (this.m_model != null) {
                        if (this.m_xformTables != null) {
                            this.m_scale.setEnabled(true);
                        } else {
                            this.m_scale.setEnabled(false);
                        }
                    }
                }
                return;
            }
            this.m_sortAbsoluteCoefficientValue.setEnabled(true);
            this.m_exportButton.setEnabled(true);
            this.m_filter.setEnabled(true);
            if (this.m_model != null) {
                if (this.m_xformTables != null) {
                    this.m_scale.setEnabled(true);
                } else {
                    this.m_scale.setEnabled(false);
                }
            }
        }
        if (this.m_isScaled) {
            this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
            this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
        } else {
            this.m_scale.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
            this.m_scale.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadBias() {
        Object object;
        Vector vector;
        int n;
        block19: {
            Object[] objectArray = "SELECT ((s.coefficient*target.scale + target.shift) - de_norm.sum_coefficient)  as bias  FROM  (SELECT (b * -1) as coefficient FROM \"DM$PZ<model_name>\") s,  (SELECT nvl(SUM(c.coefficient * n.shift / n.scale), 0) as sum_coefficient    FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m, \"<norm_table>\" n    WHERE m.attr = n.col (+) AND c.attr_id = m.aid AND m.aid != 1 AND n.scale <> 0) de_norm,  (SELECT scale, shift FROM \"<norm_table>\" where COL = '<target>') target ";
            String string = "SELECT b * -1 FROM \"DM$PZ<model_name>\"";
            n = 0;
            vector = new Vector();
            Connection connection = null;
            connection = DM4JConnectionManager.getDbConnection();
            object = null;
            if (this.m_isScaled) {
                object = objectArray;
                if (this.m_xformTables != null) {
                    object = BrowserUtils.getReplacedString((String)object, "<norm_table>", (String)this.m_xformTables.get("XNORM"));
                }
                if (this.m_model != null) {
                    object = BrowserUtils.getReplacedString((String)object, "<target>", this.m_model.getTargetAttributeName().toUpperCase());
                }
            } else {
                object = string;
            }
            object = BrowserUtils.getReplacedString((String)object, "<model_name>", this.m_model.getName());
            vector = BrowserUtils.getVectorData(connection, (String)object);
            Object var8_8 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block19;
            }
            catch (Exception exception) {}
            break block19;
            {
                catch (Exception exception) {
                    Object var8_9 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block19;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        int n2 = n = vector != null ? vector.size() : 0;
        if (n > 0) {
            object = (Object[])vector.get(0);
            if (object[0] != null) {
                double d = new Double((String)object[0]);
                this.lblBiasValue.setText(DM4JNumericFormat.format(d, true, 8) + "");
            } else {
                this.lblBiasValue.setText("");
            }
        } else {
            this.lblBiasValue.setText("");
        }
    }
}

