/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.regression;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.supervised.regression.RegressionModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.jdm.data.OraAttributeCoefficient;

public class SVMRegCoefficientTableModel
extends Dm4jSortableTwoDModel {
    private OraAttributeCoefficient[] m_attributeCoefficients = null;
    private int m_totalCnt = 0;
    private Hashtable m_lookupTableMap = null;
    private static String QRY_REGRESSION_ALL_COEFFICIENTS = " SELECT r.attribute_name, r.attribute_value, r.coefficient FROM  (SELECT m.attr as attribute_name, m.sval as attribute_value, c.coefficient   FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m   WHERE c.attr_id = m.aid AND m.aid != 1   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private static String QRY_REGRESSION_ALL_COEFFICIENTS_11G = "SELECT NVL2( r.attribute_subname, r.attribute_name || '.' || r.attribute_subname, r.attribute_name) attribute_name, \n       r.attribute_value, r.coefficient FROM  (SELECT m.attr as attribute_name, m.attr_subname as attribute_subname, m.sval as attribute_value, c.coefficient   FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m   WHERE c.attr_id = m.aid AND m.aid != 1   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private static String QRY_DENORMALIZED_REGRESSION_ALL_COEFFICIENTS = " SELECT r.attribute_name, r.attribute_value, r.coefficient FROM  (SELECT m.attr as attribute_name, m.sval as attribute_value, c.coefficient*target.scale/nvl(n.scale, 1) as coefficient   FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m, <norm_table> n,        (SELECT * FROM <norm_table> WHERE COL = '<target>') target   WHERE m.attr = n.col (+) AND c.attr_id = m.aid AND m.aid != 1   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private static String QRY_DENORMALIZED_REGRESSION_ALL_COEFFICIENTS_11G = "SELECT NVL2( r.attribute_subname, r.attribute_name || '.' || r.attribute_subname, r.attribute_name) attribute_name, \n       r.attribute_value, r.coefficient FROM  (SELECT m.attr as attribute_name, m.attr_subname as attribute_subname, m.sval as attribute_value, c.coefficient*target.scale/nvl(n.scale, 1) as coefficient   FROM \"DM$PX<model_name>\" c, \"DM$PD<model_name>\" m, <norm_table> n,        (SELECT * FROM <norm_table> WHERE COL = '<target>') target   WHERE m.attr = n.col (+) AND c.attr_id = m.aid AND m.aid != 1   <and1>   <and2>   <and3>   <order> ) r   <rownum> ";
    private int m_fetchSize = 1000;

    public OraAttributeCoefficient getAttributeCoefficient(int n) {
        return this.m_attributeCoefficients != null ? this.m_attributeCoefficients[n] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updateTable(String string) {
        block27: {
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block22: {
                this.addRows(0, 1);
                this.addColumns(0, 2);
                connection = null;
                statement = null;
                resultSet = null;
                connection = DM4JConnectionManager.getDbConnection();
                statement = connection.createStatement();
                statement.setFetchSize(this.m_fetchSize);
                resultSet = statement.executeQuery(string);
                int n = 0;
                int n2 = this.m_fetchSize;
                this.addRows(n, n2);
                this.addColumns(0, 1);
                boolean bl = true;
                while (resultSet.next()) {
                    bl = false;
                    String string2 = resultSet.getString("attribute_name");
                    String string3 = resultSet.getString("attribute_value");
                    Double d = resultSet.getDouble("coefficient");
                    if (this.m_lookupTableMap == null) {
                        this.setData(0, n, string2);
                    } else {
                        String string4 = string2;
                        String string5 = string2;
                        string5 = (String)this.m_lookupTableMap.get(string4);
                        if (string5 != null) {
                            this.setData(0, n, string5);
                        } else {
                            this.setData(0, n, string2);
                        }
                    }
                    this.setData(1, n, string3);
                    this.setData(2, n, d);
                    if (this.getRowCount() > ++n) continue;
                    this.addRows(n, n2);
                }
                int n3 = this.getRowCount() - n;
                if (n3 > 0) {
                    this.removeRows(n, n3);
                }
                if (!bl) break block22;
                this.addRows(0, 1);
                this.setData(0, 0, DM4JResourceUtilities.getUIString("CLASS_SVM_NO_COEFFICIENT"));
            }
            Object var14_15 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                connection.close();
            }
            catch (Exception exception) {}
            break block27;
            {
                catch (Exception exception) {
                    this.addRows(0, 1);
                    this.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED"));
                    Object var14_16 = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        connection.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void load(Object object, HashMap hashMap) {
        RegressionModel regressionModel = (RegressionModel)object;
        String string = null;
        Hashtable hashtable = (Hashtable)hashMap.get("MENU_DATA_XFORM_NORMALIZE");
        if (hashtable != null) {
            string = (String)hashtable.get("XNORM");
        }
        this.m_lookupTableMap = (Hashtable)hashMap.get("COMMON_TEXT_LOOKUP");
        try {
            String string2;
            String string3 = "";
            if (hashtable != null) {
                string3 = BrowserFrame.is11Server() ? QRY_DENORMALIZED_REGRESSION_ALL_COEFFICIENTS_11G : QRY_DENORMALIZED_REGRESSION_ALL_COEFFICIENTS;
                string3 = BrowserUtils.getReplacedString(string3, "<norm_table>", string);
                string3 = BrowserUtils.getReplacedString(string3, "<target>", DM4JStringUtils.escapeSingleQuotesForSQL(regressionModel.getTargetAttributeName()));
            } else {
                string3 = BrowserFrame.is11Server() ? QRY_REGRESSION_ALL_COEFFICIENTS_11G : QRY_REGRESSION_ALL_COEFFICIENTS;
            }
            String string4 = regressionModel.getName();
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            Vector vector = null;
            Double d = null;
            Double d2 = null;
            Boolean bl = null;
            Boolean bl2 = null;
            Integer n = null;
            String string10 = null;
            String string11 = null;
            String string12 = string2 = BrowserFrame.is11Server() ? " NVL2( m.attr_subname, m.attr || '.' || m.attr_subname, m.attr) " : " m.attr ";
            if (hashMap != null) {
                vector = (Vector)hashMap.get("COMMON_FILTER_ATTRIBUTES");
                d = (Double)hashMap.get("COMMON_FILTER_TOP");
                d2 = (Double)hashMap.get("COMMON_FILTER_BOTTOM");
                bl = (Boolean)hashMap.get("COMMON_FILTER_BY_ABSOULTE_VALUES");
                bl2 = (Boolean)hashMap.get("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES");
                n = (Integer)hashMap.get("COMMON_FETCH_SIZE");
                string10 = (String)hashMap.get("COMMON_FILTER_SORT_VALUE");
                string11 = (String)hashMap.get("COMMON_FILTER_SORT_ORDER");
                if (vector != null && vector.size() > 0) {
                    String string13 = "";
                    String string14 = "";
                    String string15 = "";
                    for (int i = 0; i < vector.size(); ++i) {
                        string15 = (String)vector.get(i);
                        if (this.m_lookupTableMap != null) {
                            Enumeration enumeration = this.m_lookupTableMap.keys();
                            String string16 = null;
                            String string17 = string15;
                            while (enumeration.hasMoreElements()) {
                                string16 = (String)enumeration.nextElement();
                                if (this.m_lookupTableMap.get(string16) == null || !string17.equalsIgnoreCase((String)this.m_lookupTableMap.get(string16))) continue;
                                string15 = string16;
                                break;
                            }
                        }
                        string14 = string14 == "" ? string14 + "'" + DM4JStringUtils.escapeSingleQuotesForSQL(string15) + "'" : string14 + ",'" + DM4JStringUtils.escapeSingleQuotesForSQL(string15) + "'";
                        if ((i + 1) % 1000 != 0) continue;
                        if (i + 1 > 1000) {
                            string13 = bl2 != null && bl2 == true ? string13 + " OR " : string13 + " AND ";
                        }
                        string13 = bl2 != null && bl2 == true ? string13 + string2 + " in (" + string14 + " )" : string13 + string2 + " not in (" + string14 + " )";
                        string14 = "";
                    }
                    if (string13.length() > 0) {
                        if (string14.length() > 0) {
                            string13 = bl2 != null && bl2 == true ? string13 + " OR " + string2 + " in (" + string14 + " )" : string13 + " AND " + string2 + " not in (" + string14 + " )";
                        }
                        string5 = " AND ( " + string13 + " ) ";
                    } else {
                        string5 = bl2 != null && bl2 == true ? " AND " + string2 + " in (" + string14 + " )" : " AND " + string2 + " not in (" + string14 + " )";
                    }
                }
                if (d != null) {
                    string6 = bl != null && bl == true ? " AND abs(coefficient) <= " + d : " AND coefficient <= " + d;
                }
                if (d2 != null) {
                    string7 = bl != null && bl == true ? " AND abs(coefficient) >= " + d2 : " AND coefficient >= " + d2;
                }
                if (n != null) {
                    string8 = " where rownum <= " + n.toString();
                    this.m_fetchSize = n;
                }
                if (string10 != null) {
                    if (string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_COEFFICIENT"))) {
                        string9 = " order by coefficient ";
                    } else if (string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_ATTRIBUTE"))) {
                        string9 = " order by attribute_name ";
                    } else if (string10.equalsIgnoreCase(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_VALUE"))) {
                        string9 = " order by attribute_value ";
                    }
                    if (string11 != null) {
                        if (string11.equalsIgnoreCase(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_ASC"))) {
                            string9 = string9 + " ASC ";
                        } else if (string11.equalsIgnoreCase(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC"))) {
                            string9 = string9 + " DESC ";
                        }
                    }
                }
            }
            string3 = BrowserUtils.getReplacedString(string3, "<model_name>", string4);
            string3 = BrowserUtils.getReplacedString(string3, "<and1>", string5);
            string3 = BrowserUtils.getReplacedString(string3, "<and2>", string6);
            string3 = BrowserUtils.getReplacedString(string3, "<and3>", string7);
            string3 = BrowserUtils.getReplacedString(string3, "<order>", string9);
            string3 = BrowserUtils.getReplacedString(string3, "<rownum>", string8);
            this.updateTable(string3);
        }
        catch (Exception exception) {
            this.addRows(0, 1);
            this.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED"));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.addColumns(0, 1);
            this.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_DECREASE_FETCH_SIZE"));
            this.setData(1, 0, "");
            this.setData(2, 0, BigDecimal.ZERO);
        }
    }

    public void load(Object object) {
    }
}

