/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.regression;

import java.text.Collator;
import java.util.EventObject;
import java.util.HashMap;
import javax.datamining.supervised.regression.RegressionModel;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.regression.AbsoluteNumberComparator;
import oracle.dmt.dm4j.browser.viewer.regression.LoadSVMRegCoefficientWorker;
import oracle.dmt.dm4j.browser.viewer.regression.SVMRegCoefficientLoadedListener;
import oracle.dmt.dm4j.browser.viewer.regression.SVMRegCoefficientTableModel;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;
import oracle.dmt.jdm.data.OraAttributeCoefficient;

public final class SVMRegCoefficientTable
extends Dm4jSpreadTable
implements SVMRegCoefficientLoadedListener {
    private LoadSVMRegCoefficientWorker m_worker = null;
    private SVMRegCoefficientTableModel m_tableModel;
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_NAME"), DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_VALUE"), DM4JResourceUtilities.getUIString("CLASS_SVM_COEFFICIENT")};
    int[] m_colWidths = new int[]{40, 40, 20};

    public SVMRegCoefficientTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(HashMap hashMap) throws Exception {
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setColumnWidths(this.m_colWidths, true);
        RegressionModel regressionModel = (RegressionModel)this.getDataItem();
        if (null == regressionModel) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        this.m_worker = (LoadSVMRegCoefficientWorker)workerThreadManager.getLoadSVMRegCoefficientWorker(regressionModel, hashMap);
        this.m_worker.addSVMRegCoefficientLoadedListener(this);
        this.m_worker.start();
    }

    public void setSortAbsoluteCoefficient(boolean bl) {
        if (this.m_tableModel != null) {
            if (bl) {
                this.m_tableModel.setColumnComparator(2, AbsoluteNumberComparator.getComparator());
            } else {
                this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
            }
            this.m_tableModel.sort(2, false);
        }
    }

    public void svmRegCoefficientLoaded(EventObject eventObject) {
        Object object;
        SVMRegCoefficientTableModel sVMRegCoefficientTableModel;
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = sVMRegCoefficientTableModel = (SVMRegCoefficientTableModel)eventObject.getSource();
        this.setModels((TwoDModel)sVMRegCoefficientTableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        this.m_worker = null;
        header.setItemInputHandler(new SortInputHandler(this.m_tableModel));
        this.m_tableModel.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_tableModel.getRowCount() > 0) {
            try {
                object = new TwoDSelection(0, true);
                this.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.getGrid();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 10));
        ((Grid)object).setColumnPainter(2, dM4JTruncatingNumberFormatPainter);
    }

    public OraAttributeCoefficient getAttributeCoefficient(int n) {
        return this.m_tableModel.getAttributeCoefficient(n);
    }
}

