/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.regression;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.NumberFormat;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.regression.SVMRegressionSettings;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.data.PhysicalDataSet;
import javax.datamining.supervised.regression.RegressionModel;
import javax.datamining.supervised.regression.RegressionSettings;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.AttributeTable;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.regression.RegressionModelViewer;
import oracle.dmt.jdm.algorithm.glm.OraGLMRegressionSettings;
import oracle.dmt.jdm.algorithm.svm.regression.OraSVMRegressionSettings;
import oracle.dmt.jdm.base.OraBuildSettings;

public class RegressionSettingsPanel
extends GriddedPanel {
    JLabel m_modelType = new JLabel();
    JLabel m_algorithmType = new JLabel();
    JLabel m_targetAttribName = new JLabel();
    JLabel m_sequenceID = new JLabel();
    JLabel m_automaticDataPreparation = new JLabel();
    JLabel m_kernelFunction = new JLabel();
    JLabel m_standardDeviation = new JLabel();
    JLabel m_kernelCacheSize = new JLabel();
    JLabel m_complexityFactor = new JLabel();
    JLabel m_tolerance = new JLabel();
    JLabel m_autoNormalization = new JLabel();
    JLabel m_epsilon = new JLabel();
    JLabel m_learningEnabled = new JLabel();
    JLabel m_confidenceLevel = new JLabel();
    JLabel m_diagnosticsTableName = new JLabel();
    JLabel m_missingValueTreatment = new JLabel();
    JLabel m_ridgeValue = new JLabel();
    JLabel m_varianceInflationFactor = new JLabel();
    JScrollPane m_attribPanel = new JScrollPane();
    JScrollPane m_settingPanel = new JScrollPane();
    SettingTable m_settingTable = null;
    AttributeTable m_attribTable = null;
    RegressionSettings m_settings = null;
    RegressionModel m_model = null;
    PhysicalDataSet m_pds = null;

    public RegressionSettingsPanel(RegressionModel regressionModel) {
        this.m_model = regressionModel;
        this.m_settings = (RegressionSettings)this.m_model.getBuildSettings();
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RegressionSettingsPanel(RegressionModel regressionModel, PhysicalDataSet physicalDataSet) {
        this.m_model = regressionModel;
        this.m_settings = (RegressionSettings)this.m_model.getBuildSettings();
        this.m_pds = physicalDataSet;
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        Container container = this.getParent();
        if (container instanceof RegressionModelViewer) {
            if (this.m_settings.getAlgorithmSettings() instanceof SVMRegressionSettings) {
                return "SVM_REGRESSION_MODEL";
            }
            if (this.m_settings.getAlgorithmSettings() instanceof OraGLMRegressionSettings) {
                return "GLM_REGRESSION_MODEL";
            }
            return "";
        }
        return "";
    }

    private void jbInit() throws Exception {
        Object object;
        Object object2;
        JComponent jComponent;
        Object object3;
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        this.m_modelType.setText(DM4JResourceUtilities.getUIString("REGRE_REGRESSION"));
        this.addComponent(this.m_modelType, TOPVALUEITEMINSETS, n++, 1);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITHM_TYPE"));
        this.addComponent(jLabel2, MIDLABELITEMINSETS, n, 0);
        if (this.m_settings.getAlgorithmSettings() instanceof SVMRegressionSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("REGRE_MODEL_TYPE_SVM"));
        } else if (this.m_settings.getAlgorithmSettings() instanceof OraGLMRegressionSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("REGRE_MODEL_TYPE_GLM"));
        } else {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
        }
        this.addComponent(this.m_algorithmType, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        this.addComponent(jLabel3, MIDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_targetAttribName, MIDVALUEITEMINSETS, n++, 1);
        if (BrowserFrame.is11Server()) {
            object3 = new JLabel();
            ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("AUTOMATIC_DATA_PREPARATION"));
            this.addComponent((JComponent)object3, MIDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_automaticDataPreparation, MIDVALUEITEMINSETS, n++, 1);
        }
        if (this.m_settings.getAlgorithmSettings() instanceof SVMRegressionSettings) {
            JLabel jLabel4;
            JLabel jLabel5;
            Serializable serializable;
            object3 = (SVMRegressionSettings)this.m_settings.getAlgorithmSettings();
            jComponent = new JLabel();
            ((JLabel)jComponent).setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
            this.addComponent(jComponent, TOPLABELITEMINSETS, n++, 0);
            object2 = new JLabel();
            ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("CLASS_KERNEL_FUNCTION"));
            this.addComponent((JComponent)object2, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_kernelFunction, MIDVALUEITEMINSETS, n++, 1);
            if (object3.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                object = new Insets(0, 30, 0, 5);
                serializable = new Insets(0, 0, 0, 5);
                jLabel5 = new JLabel();
                jLabel5.setText(DM4JResourceUtilities.getUIString("CLASS_STANDARD_DEVIATION"));
                this.addComponent(jLabel5, (Insets)object, n, 0);
                this.addComponent(this.m_standardDeviation, (Insets)serializable, n++, 1);
                jLabel4 = new JLabel();
                jLabel4.setText(DM4JResourceUtilities.getUIString("CLASS_KERNEL_CACHE_SIZE"));
                this.addComponent(jLabel4, (Insets)object, n, 0);
                this.addComponent(this.m_kernelCacheSize, (Insets)serializable, n++, 1);
            }
            object = new JLabel();
            ((JLabel)object).setText(DM4JResourceUtilities.getUIString("CLASS_COMPLEXITY_FACTOR"));
            this.addComponent((JComponent)object, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_complexityFactor, MIDVALUEITEMINSETS, n++, 1);
            serializable = new JLabel();
            ((JLabel)serializable).setText(DM4JResourceUtilities.getUIString("CLASS_TOLERANCE"));
            this.addComponent((JComponent)serializable, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_tolerance, MIDVALUEITEMINSETS, n++, 1);
            jLabel5 = new JLabel();
            jLabel5.setText(DM4JResourceUtilities.getUIString("REGRE_EPSILON"));
            this.addComponent(jLabel5, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_epsilon, MIDVALUEITEMINSETS, n++, 1);
            jLabel4 = new JLabel();
            jLabel4.setText(DM4JResourceUtilities.getUIString("CLASS_SVM_ACTIVE_LEARNING"));
            this.addComponent(jLabel4, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_learningEnabled, MIDVALUEITEMINSETS, n++, 1);
        } else if (this.m_settings.getAlgorithmSettings() instanceof OraGLMRegressionSettings) {
            object3 = new JLabel();
            ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
            this.addComponent((JComponent)object3, TOPLABELITEMINSETS, n++, 0);
            jComponent = new JLabel();
            ((JLabel)jComponent).setText(DM4JResourceUtilities.getUIString("GLM_CONFIDENCE_LEVEL"));
            this.addComponent(jComponent, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_confidenceLevel, MIDVALUEITEMINSETS, n++, 1);
            object2 = new JLabel();
            ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("GLM_DIAGNOSTICS_TABLE"));
            this.addComponent((JComponent)object2, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_diagnosticsTableName, MIDVALUEITEMINSETS, n++, 1);
            object = new JLabel();
            ((JLabel)object).setText(DM4JResourceUtilities.getUIString("GLM_MISSING_VAL_TREAT"));
            this.addComponent((JComponent)object, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_missingValueTreatment, MIDVALUEITEMINSETS, n++, 1);
            JLabel jLabel6 = new JLabel();
            jLabel6.setText(DM4JResourceUtilities.getUIString("GLM_RIDGE_REGRESSION_VALUE"));
            this.addComponent(jLabel6, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_ridgeValue, MIDVALUEITEMINSETS, n++, 1);
            JLabel jLabel7 = new JLabel();
            jLabel7.setText(DM4JResourceUtilities.getUIString("GLM_VARIANCE_INFLATION_FACTOR"));
            this.addComponent(jLabel7, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_varianceInflationFactor, MIDVALUEITEMINSETS, n++, 1);
        } else {
            throw new Exception("Unexpected functions settings object type" + this.m_settings.getClass().getName());
        }
        object3 = new JLabel();
        ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("COMMON_ATTRIBUTES"));
        ((JLabel)object3).setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_ATTRIBUTES"));
        this.addAnchoredComponent((JComponent)object3, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        this.m_attribTable = new AttributeTable(this.m_model);
        jComponent = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jComponent.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jComponent, MIDLABELITEMINSETS, n++, 2, 1, 1, 14);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(RegressionSettingsPanel.this.m_attribTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_attribPanel.getViewport().add(this.m_attribTable);
        ((JLabel)object3).setLabelFor(this.m_attribTable);
        this.m_attribPanel.setPreferredSize(null);
        this.addFilledComponent(this.m_attribPanel, MIDLABELITEMINSETS, n, 0, 3, 6, 1);
        object2 = new GeneralGridSelectionManager(0, 2, 0);
        this.m_attribTable.getGrid().setGridSelectionManager((GridSelectionManager)object2);
        object = new Dm4jSpreadTableExcelAdapter(this.m_attribTable);
        n += 6;
    }

    private void runTimePanelLoad() throws Exception {
        String string;
        this.m_attribTable.load();
        if (BrowserFrame.is11Server()) {
            string = ((OraBuildSettings)((Object)this.m_settings)).useAutomatedDataPreparations() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
            this.m_automaticDataPreparation.setText(string);
        }
        if ((string = this.m_settings.getTargetAttributeName()) == null) {
            string = this.m_model.getTargetAttributeName();
        }
        this.m_targetAttribName.setText(string);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(false, 10, 10);
        NumberFormat numberFormat2 = DM4JNumericFormat.getInstance(false, 10);
        if (this.m_settings.getAlgorithmSettings() instanceof SVMRegressionSettings) {
            double d;
            OraSVMRegressionSettings oraSVMRegressionSettings = (OraSVMRegressionSettings)this.m_settings.getAlgorithmSettings();
            String string2 = new String(oraSVMRegressionSettings.getKernelFunction().name());
            if (oraSVMRegressionSettings.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                this.m_kernelFunction.setText("Gaussian");
            } else if (oraSVMRegressionSettings.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kLinear.name())) {
                this.m_kernelFunction.setText("Linear");
            } else if (oraSVMRegressionSettings.getKernelFunction().name().equalsIgnoreCase(KernelFunction.systemDetermined.name())) {
                this.m_kernelFunction.setText("System Determined");
            } else {
                this.m_kernelFunction.setText(string2);
            }
            if (oraSVMRegressionSettings.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                d = 0.0;
                try {
                    d = oraSVMRegressionSettings.getStandardDeviation();
                    this.m_standardDeviation.setText(numberFormat.format(d));
                }
                catch (RuntimeException runtimeException) {
                    this.m_standardDeviation.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                }
                int n = 0;
                try {
                    n = oraSVMRegressionSettings.getKernelCacheSize();
                    this.m_kernelCacheSize.setText(numberFormat.format(n));
                }
                catch (RuntimeException runtimeException) {
                    this.m_kernelCacheSize.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                }
            }
            d = 0.0;
            try {
                d = oraSVMRegressionSettings.getComplexityFactor();
                this.m_complexityFactor.setText(numberFormat.format(d));
            }
            catch (RuntimeException runtimeException) {
                this.m_complexityFactor.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
            }
            double d2 = 0.0;
            try {
                d2 = oraSVMRegressionSettings.getTolerance();
                this.m_tolerance.setText(numberFormat.format(d2));
            }
            catch (RuntimeException runtimeException) {
                this.m_tolerance.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
            }
            double d3 = 0.0;
            try {
                d3 = oraSVMRegressionSettings.getEpsilon();
                this.m_epsilon.setText(numberFormat.format(d3));
            }
            catch (RuntimeException runtimeException) {
                this.m_epsilon.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
            }
            String string3 = "";
            try {
                string3 = oraSVMRegressionSettings.getActiveLearning() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
                this.m_learningEnabled.setText(string3);
            }
            catch (RuntimeException runtimeException) {
                this.m_learningEnabled.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
            }
        } else if (this.m_settings.getAlgorithmSettings() instanceof OraGLMRegressionSettings) {
            OraGLMRegressionSettings oraGLMRegressionSettings = (OraGLMRegressionSettings)this.m_settings.getAlgorithmSettings();
            this.m_confidenceLevel.setText(numberFormat2.format(oraGLMRegressionSettings.getConfidenceLevel()));
            this.m_diagnosticsTableName.setText(oraGLMRegressionSettings.getDiagnosticsTableName());
            String string4 = oraGLMRegressionSettings.getMissingValueTreatmentType();
            if (string4.equals("ODMS_MISSING_VALUE_MEAN_MODE")) {
                this.m_missingValueTreatment.setText(DM4JResourceUtilities.getUIString("GLM_MISSING_VAL_MIN_MEAN"));
            } else if (string4.equals("ODMS_MISSING_VALUE_DELETE_ROW")) {
                this.m_missingValueTreatment.setText(DM4JResourceUtilities.getUIString("GLM_MISSING_DROP_REC"));
            } else {
                this.m_missingValueTreatment.setText("Unknown");
            }
            Double d = oraGLMRegressionSettings.getRidgeValue();
            if (d != null) {
                this.m_ridgeValue.setText(numberFormat2.format(d));
            }
            String string5 = oraGLMRegressionSettings.produceVIFforRidgeRegression() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
            this.m_varianceInflationFactor.setText(string5);
        } else {
            throw new Exception("Unexpected functions settings object type" + this.m_settings.getClass().getName());
        }
    }

    class SettingTable
    extends Dm4jSpreadTable {
        String[] m_SVMLinearColumnNames;
        int[] m_SVMLinearColWidths;
        String[] m_SVMGaussianColumnNames;
        int[] m_SVMGaussianColWidths;

        SettingTable(Object object) {
            Object object2;
            super(object);
            this.m_SVMLinearColumnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TBL_KERNEL_FUNCTION"), DM4JResourceUtilities.getUIString("CLASS_TBL_COMPLEXITY_FACTOR"), DM4JResourceUtilities.getUIString("CLASS_TBL_TOLERANCE"), DM4JResourceUtilities.getUIString("CLASS_TBL_AUTO_NORMALIZATION"), DM4JResourceUtilities.getUIString("REGRE_TBL_EPSILON"), DM4JResourceUtilities.getUIString("REGRE_TBL_ERROR_METRIC")};
            this.m_SVMLinearColWidths = new int[]{50, 50, 50, 50, 50, 50};
            this.m_SVMGaussianColumnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TBL_KERNEL_FUNCTION"), DM4JResourceUtilities.getUIString("CLASS_TBL_STANDARD_DEVIATION"), DM4JResourceUtilities.getUIString("CLASS_TBL_KERNEL_CACHE_SIZE"), DM4JResourceUtilities.getUIString("CLASS_TBL_COMPLEXITY_FACTOR"), DM4JResourceUtilities.getUIString("CLASS_TBL_TOLERANCE"), DM4JResourceUtilities.getUIString("CLASS_TBL_AUTO_NORMALIZATION"), DM4JResourceUtilities.getUIString("REGRE_TBL_EPSILON"), DM4JResourceUtilities.getUIString("REGRE_TBL_ERROR_METRIC")};
            this.m_SVMGaussianColWidths = new int[]{50, 50, 50, 50, 50, 50, 50, 50};
            if ((AlgorithmSettings)object instanceof SVMRegressionSettings) {
                object2 = (SVMRegressionSettings)object;
                if (object2.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                    this.setColumnNames(this.m_SVMGaussianColumnNames);
                } else {
                    this.setColumnNames(this.m_SVMLinearColumnNames);
                }
            }
            object2 = this.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
            ((Grid)object2).setGridSelectionManager(generalGridSelectionManager);
            try {
                this.displayLoadingStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void load() throws Exception {
            AlgorithmSettings algorithmSettings = (AlgorithmSettings)this.getDataItem();
            if (null == algorithmSettings) {
                throw new Exception("Cannot load data. MiningAlgorithmSettings not supplied");
            }
            if (algorithmSettings instanceof SVMRegressionSettings) {
                SVMRegressionSettings sVMRegressionSettings = (SVMRegressionSettings)algorithmSettings;
                if (sVMRegressionSettings.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                    this.setColumnWidths(this.m_SVMGaussianColWidths, true);
                } else {
                    this.setColumnWidths(this.m_SVMLinearColWidths, true);
                }
            }
            final int n = this.getColModel().getItemCount();
            Dm4jSortableTwoDModel dm4jSortableTwoDModel = new Dm4jSortableTwoDModel(){

                public void load(Object object) {
                    AlgorithmSettings algorithmSettings = (AlgorithmSettings)object;
                    this.addColumns(0, n);
                    if (algorithmSettings instanceof SVMRegressionSettings) {
                        SVMRegressionSettings sVMRegressionSettings = (SVMRegressionSettings)algorithmSettings;
                        this.addRows(0, 1);
                        this.setData(0, 0, sVMRegressionSettings.getKernelFunction().name() + "");
                        this.setData(1, 0, sVMRegressionSettings.getComplexityFactor() + "");
                        this.setData(2, 0, sVMRegressionSettings.getTolerance() + "");
                        this.setData(3, 0, "");
                    }
                }
            };
            dm4jSortableTwoDModel.load(algorithmSettings);
            this.setVerticalSeparatorsVisible(true);
            this.setModels((TwoDModel)dm4jSortableTwoDModel, this.getColModel(), null);
            Header header = this.getColumnHeader();
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setItemInputHandler(null);
            header.setCanMoveItems(false);
            try {
                if (algorithmSettings instanceof SVMRegressionSettings) {
                    SVMRegressionSettings sVMRegressionSettings = (SVMRegressionSettings)algorithmSettings;
                    if (sVMRegressionSettings.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                        this.setColumnWidths(this.m_SVMGaussianColWidths, true);
                    } else {
                        this.setColumnWidths(this.m_SVMLinearColWidths, true);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

