/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.folder;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.tree.NavigatorTree;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.tree.node.JLabelNode;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class StaticFolderTableModel
extends AbstractTableModel {
    String m_folderType = null;
    String m_schema = null;
    Vector m_rows = new Vector();
    public static final int NAME_COLUMN = 0;
    public static final int TYPE_COLUMN = 1;
    private static String[] columns = new String[]{"Name", "Type"};
    private static final int COLUMN_COUNT = columns.length;
    private static final String FOLDER = "Folder";
    private static final String TABLES = "Tables";
    private static final String VIEWS = "Views";

    public StaticFolderTableModel(String string, String string2) {
        this.m_folderType = string;
        this.m_schema = string2;
        this.loadFolder(string);
    }

    private DefaultMutableTreeNode getRootNode(String string, NavigatorTree navigatorTree) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.m_folderType.equals("MODELS")) {
            defaultMutableTreeNode = navigatorTree.getModelsRoot();
        } else if (this.m_folderType.equals("RESULTS")) {
            defaultMutableTreeNode = navigatorTree.getResultsRoot();
        } else if (this.m_folderType.equals("ACTIVITIES")) {
            defaultMutableTreeNode = navigatorTree.getActivitiesRoot();
        } else if (this.m_folderType.equals("CONNECTION")) {
            defaultMutableTreeNode = navigatorTree.getTop();
        }
        return defaultMutableTreeNode;
    }

    public Object getValueAt(int n, int n2) {
        Object[] objectArray = (Object[])this.m_rows.get(n);
        if (objectArray != null) {
            return objectArray[n2];
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    private void loadFolderFromTree(String string) {
        Object[] objectArray = null;
        NavigatorTree navigatorTree = BrowserFrame.getMainFrame().getNavigatorTree();
        DefaultMutableTreeNode defaultMutableTreeNode = this.getRootNode(string, navigatorTree);
        if (defaultMutableTreeNode == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            objectArray = new Object[2];
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeData nodeData = (NodeData)defaultMutableTreeNode2.getUserObject();
            nodeData.setSchemaName(this.m_schema);
            JLabelNode jLabelNode = new JLabelNode(nodeData);
            objectArray[0] = jLabelNode;
            objectArray[1] = nodeData instanceof LeafNodeData ? nodeData.getNodeType() : FOLDER;
            this.m_rows.add(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadFolderFromDB(String string) {
        block15: {
            Connection connection = null;
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            Object[] objectArray = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("DMS_CONNECTION_NOCREATE"), DM4JVersion.getFullBrowserName(), 0);
                return;
            }
            if (string.equals("SCHEMAS")) {
                Vector vector = DatabaseMetadata.getAccessibleSchemas(connection);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    objectArray = new Object[2];
                    String string2 = (String)iterator.next();
                    FolderNodeData folderNodeData = new FolderNodeData(string2, "SCHEMA");
                    folderNodeData.setSchemaName(string2);
                    JLabelNode jLabelNode = new JLabelNode(folderNodeData);
                    objectArray[0] = jLabelNode;
                    objectArray[1] = FOLDER;
                    this.m_rows.add(objectArray);
                }
            }
            Object var11_12 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block15;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block15;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var11_13 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block15;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void refreshFolder() {
        this.loadFolder(this.m_folderType);
    }

    private void loadFolder(String string) {
        if (string.equals("SCHEMAS")) {
            this.loadFolderFromDB(string);
        } else if (string.equals("SCHEMA")) {
            this.loadSchemaFolder();
        } else {
            this.loadFolderFromTree(string);
        }
        this.fireTableStructureChanged();
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    private void loadSchemaFolder() {
        try {
            Object[] objectArray = new Object[2];
            FolderNodeData folderNodeData = new FolderNodeData(VIEWS, "VIEWS_SCHEMA");
            folderNodeData.setSchemaName(this.m_schema);
            JLabelNode jLabelNode = new JLabelNode(folderNodeData);
            objectArray[0] = jLabelNode;
            objectArray[1] = FOLDER;
            this.m_rows.add(objectArray);
            folderNodeData = new FolderNodeData(TABLES, "TABLES_SCHEMA");
            folderNodeData.setSchemaName(this.m_schema);
            JLabelNode jLabelNode2 = new JLabelNode(folderNodeData);
            objectArray = new Object[]{jLabelNode2, FOLDER};
            this.m_rows.add(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

