/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.featureExtraction;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.FilterAttributesDialog;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.NMFFeaturesTable;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionAlgorithmSettings;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;

public class NMFFeaturesPanel
extends GriddedPanel
implements VetoableChangeListener {
    OraFeatureExtractionModel m_model = null;
    JLabel lblFeature = new JLabel();
    JComboBox featureComboBox = new JComboBox();
    HashMap m_featureMap = new HashMap();
    JButton m_filter = new JButton();
    JButton m_exportButton = new JButton();
    JCheckBox m_sortAbsoluteCoefficientValue = new JCheckBox();
    NumberTextField m_tfSize = new NumberTextField();
    JLabel m_lblSize = new JLabel();
    JButton m_btnRefresh = new JButton();
    Integer m_defaultFectchSize = new Integer(100);
    String m_defaultSortBy = null;
    String m_defaultSortOrder = null;
    NMFFeaturesTable m_featuresTable = null;
    JScrollPane m_featuresScrollPane = new JScrollPane();
    HashMap m_condition = new HashMap();
    Hashtable m_lookupTableMap = null;

    public NMFFeaturesPanel(LeafNodeData leafNodeData) {
        this.m_model = (OraFeatureExtractionModel)leafNodeData.getOdmObject();
        try {
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "NMF_MODEL";
    }

    private void m_btnRefresh_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            Integer n = (Integer)this.featureComboBox.getSelectedItem();
            if (n != null) {
                Number number = this.m_tfSize.getNumber();
                if (number == null) {
                    DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
                this.m_featuresTable.load(n, this.m_condition);
                this.m_featuresTable.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getFeatures() {
        block29: {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            int n = 1000;
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            statement.setFetchSize(n);
            String string = "select distinct feature_id from \"DM$PZ<model_name>\" order by feature_id";
            if (this.m_model != null) {
                string = BrowserUtils.getReplacedString(string, "<model_name>", this.m_model.getName());
            }
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString("feature_id");
                if (string2 == null) continue;
                this.featureComboBox.addItem(new Integer(string2));
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block29;
            }
            catch (Exception exception) {}
            break block29;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var8_9 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block29;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.lblFeature.setText(DM4JResourceUtilities.getUIString("COMMON_FEATURES"));
        this.lblFeature.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FEATURES"));
        this.lblFeature.setLabelFor(this.featureComboBox);
        this.getFeatures();
        this.featureComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NMFFeaturesPanel.this.featureComboBox_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.lblFeature, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.featureComboBox, TOPLABELITEMINSETS, n++, 1);
        this.m_featuresTable = new NMFFeaturesTable(this.m_model);
        this.m_sortAbsoluteCoefficientValue.setVisible(false);
        this.m_sortAbsoluteCoefficientValue.setEnabled(false);
        this.m_sortAbsoluteCoefficientValue.setText(DM4JResourceUtilities.getUIString("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT"));
        this.m_sortAbsoluteCoefficientValue.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT"));
        this.m_sortAbsoluteCoefficientValue.setSelected(false);
        this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(NMFFeaturesPanel.this.m_featuresTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_filter.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER"));
        this.m_filter.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER"));
        this.m_featuresScrollPane.getViewport().add(this.m_featuresTable);
        this.m_featuresScrollPane.setPreferredSize(null);
        this.m_defaultSortBy = DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_COEFFICIENT");
        this.m_defaultSortOrder = DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC");
        JPanel jPanel = new JPanel();
        this.m_tfSize.setDataType(Integer.TYPE);
        this.m_tfSize.setNumber(this.m_defaultFectchSize);
        this.m_tfSize.setSigned(false);
        this.m_tfSize.setColumns(5);
        this.m_tfSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this.m_lblSize.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setLabelFor(this.m_tfSize);
        this.m_btnRefresh.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setEnabled(true);
        this.m_btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NMFFeaturesPanel.this.m_btnRefresh_actionPerformed(actionEvent);
            }
        });
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.m_lblSize, gridBagConstraints);
        jPanel.add((Component)this.m_tfSize, gridBagConstraints);
        jPanel.add((Component)this.m_btnRefresh, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JLabel(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel2.add((Component)jPanel, "West");
        jPanel3.add(this.m_sortAbsoluteCoefficientValue);
        jPanel3.add(this.m_filter);
        jPanel3.add(this.m_exportButton);
        jPanel2.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)this.m_featuresScrollPane, "Center");
        this.addFilledComponent(jPanel4, MIDLABELITEMINSETS, n++, 0, 2, 2, 1);
        this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
    }

    protected void m_filter_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setCursor(new Cursor(3));
            FilterAttributesDialog filterAttributesDialog = new FilterAttributesDialog(null, this.m_model, this.m_condition, DM4JResourceUtilities.getUIString("COMMON_FILTER_ATTRIBUTES_DIALOG"), true);
            this.setCursor(new Cursor(0));
            filterAttributesDialog.display();
            if (!filterAttributesDialog.isCancelled()) {
                Vector vector = filterAttributesDialog.getSelectedAttributes();
                Double d = filterAttributesDialog.getTopValue();
                Double d2 = filterAttributesDialog.getBottomValue();
                Boolean bl = filterAttributesDialog.isFilterByAbsoluteValue();
                Boolean bl2 = filterAttributesDialog.isIncludedAttributes();
                String string = filterAttributesDialog.getSortByValue();
                String string2 = filterAttributesDialog.getSortOrderValue();
                this.m_condition = new HashMap();
                this.m_condition.put("COMMON_FILTER_ATTRIBUTES", vector);
                this.m_condition.put("COMMON_FILTER_TOP", d);
                this.m_condition.put("COMMON_FILTER_BOTTOM", d2);
                this.m_condition.put("COMMON_FILTER_BY_ABSOULTE_VALUES", bl);
                this.m_condition.put("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES", bl2);
                Number number = this.m_tfSize.getNumber();
                if (number == null) {
                    DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
                this.m_condition.put("COMMON_FILTER_SORT_VALUE", string);
                this.m_condition.put("COMMON_FILTER_SORT_ORDER", string2);
                this.m_condition.put("COMMON_TEXT_LOOKUP", this.m_lookupTableMap);
                Integer n = (Integer)this.featureComboBox.getSelectedItem();
                if (n != null) {
                    this.m_featuresTable.load(n, this.m_condition);
                    this.m_featuresTable.repaint();
                }
                this.m_featuresTable.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void m_sortAbsoluteCoefficientValue_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            boolean bl = this.m_sortAbsoluteCoefficientValue.isSelected();
            int n = 2;
            if (bl) {
                this.m_featuresTable.setSortAbsoluteCoefficient(true);
            } else {
                this.m_featuresTable.setSortAbsoluteCoefficient(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    protected void featureComboBox_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            Integer n = (Integer)this.featureComboBox.getSelectedItem();
            if (n != null) {
                this.m_featuresTable.load(n, this.m_condition);
                this.m_featuresTable.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        this.m_model = (OraFeatureExtractionModel)leafNodeData.getOdmObject();
        OraFeatureExtractionAlgorithmSettings oraFeatureExtractionAlgorithmSettings = (OraFeatureExtractionAlgorithmSettings)this.m_model.getBuildSettings().getAlgorithmSettings();
        Integer n = (Integer)this.featureComboBox.getSelectedItem();
        if (n != null) {
            this.m_condition.put("COMMON_FETCH_SIZE", this.m_defaultFectchSize);
            this.m_condition.put("COMMON_FILTER_SORT_VALUE", this.m_defaultSortBy);
            this.m_condition.put("COMMON_FILTER_SORT_ORDER", this.m_defaultSortOrder);
            this.m_lookupTableMap = DatabaseMetadata.getODMrTextLookupTable(this.m_model.getName());
            this.m_condition.put("COMMON_TEXT_LOOKUP", this.m_lookupTableMap);
            this.m_featuresTable.load(n, this.m_condition);
        }
        Grid grid = this.m_featuresTable.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        generalGridSelectionManager.addVetoableChangeListener(this);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_featuresTable);
        this.m_filter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NMFFeaturesPanel.this.m_filter_actionPerformed(actionEvent);
            }
        });
        this.m_sortAbsoluteCoefficientValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NMFFeaturesPanel.this.m_sortAbsoluteCoefficientValue_actionPerformed(actionEvent);
            }
        });
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n2 = twoDSelection2.getSingleRow();
        if (n2 != (n = twoDSelection.getSingleRow())) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            String string = DM4JResourceUtilities.getUIString("CLASS_SVM_NO_COEFFICIENT");
            String string2 = DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED");
            String string3 = "";
            if (n2 >= 0) {
                string3 = (String)this.m_featuresTable.getGrid().getModel().getData(0, n2);
            }
            if (string3 != null) {
                if (string3.equals(string) || string3.equals(string2)) {
                    this.m_sortAbsoluteCoefficientValue.setEnabled(false);
                    this.m_exportButton.setEnabled(false);
                } else {
                    this.m_sortAbsoluteCoefficientValue.setEnabled(true);
                    this.m_exportButton.setEnabled(true);
                    this.m_filter.setEnabled(true);
                }
                return;
            }
            this.m_sortAbsoluteCoefficientValue.setEnabled(true);
            this.m_exportButton.setEnabled(true);
            this.m_filter.setEnabled(true);
        }
    }
}

