/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.featureExtraction;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.datamining.base.AlgorithmSettings;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.AttributeTable;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.FeatureExtractionModelViewer;
import oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettings;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionAlgorithmSettings;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionSettings;

public class FeatureExtractionSettingsPanel
extends GriddedPanel {
    JLabel m_modelType = new JLabel(DM4JResourceUtilities.getUIString("FEATU_EXTRACTION"));
    JLabel m_algorithmType = new JLabel();
    JLabel m_runTimeLimit = new JLabel();
    JLabel m_featureDepth = new JLabel();
    JLabel m_modelBuildType = new JLabel();
    JLabel m_automaticDataPreparation = new JLabel();
    JLabel m_minimumConvergenceTolerance = new JLabel();
    JLabel m_maxNumberOfIterations = new JLabel();
    JLabel m_randomSeed = new JLabel();
    JScrollPane m_attribPanel = new JScrollPane();
    JScrollPane m_settingPanel = new JScrollPane();
    SettingTable m_settingTable = null;
    AttributeTable m_attribTable = null;
    OraFeatureExtractionSettings m_settings = null;
    OraFeatureExtractionModel m_model = null;

    public FeatureExtractionSettingsPanel(OraFeatureExtractionModel oraFeatureExtractionModel) {
        this.m_model = oraFeatureExtractionModel;
        this.m_settings = (OraFeatureExtractionSettings)this.m_model.getBuildSettings();
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        Container container = this.getParent();
        if (container instanceof FeatureExtractionModelViewer) {
            if (this.m_settings.getAlgorithmSettings() instanceof OraFeatureExtractionAlgorithmSettings) {
                return "NMF_FEATURE_EXTRACTION_MODEL";
            }
            return "NMF_FEATURE_EXTRACTION_MODEL";
        }
        if (this.m_settings.getAlgorithmSettings() instanceof OraFeatureExtractionAlgorithmSettings) {
            return "FEATURE_EXTRACTION_NMF_SETTING";
        }
        return "FEATURE_EXTRACTION_NMF_SETTING";
    }

    private void jbInit() throws Exception {
        Object object;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_modelType, TOPVALUEITEMINSETS, n++, 1);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITHM_TYPE"));
        this.addComponent(jLabel2, MIDLABELITEMINSETS, n, 0);
        if (this.m_settings.getAlgorithmSettings() instanceof OraFeatureExtractionAlgorithmSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("FEATU_MODEL_TYPE_NMF"));
        } else {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
        }
        this.addComponent(this.m_algorithmType, MIDVALUEITEMINSETS, n++, 1);
        if (BrowserFrame.is11Server()) {
            object = new JLabel();
            ((JLabel)object).setText(DM4JResourceUtilities.getUIString("AUTOMATIC_DATA_PREPARATION"));
            this.addComponent((JComponent)object, MIDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_automaticDataPreparation, MIDVALUEITEMINSETS, n++, 1);
        }
        if (!(this.m_settings.getAlgorithmSettings() instanceof OraFeatureExtractionAlgorithmSettings)) {
            throw new Exception("Unexpected functions settings object type" + this.m_settings.getClass().getName());
        }
        object = (OraFeatureExtractionAlgorithmSettings)this.m_settings.getAlgorithmSettings();
        JComponent jComponent = new JLabel();
        ((JLabel)jComponent).setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
        this.addComponent(jComponent, TOPLABELITEMINSETS, n++, 0);
        Object object2 = new JLabel();
        ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("FEATU_MIN_CONVERGENCE_TOLERANCE"));
        this.addComponent((JComponent)object2, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_minimumConvergenceTolerance, MIDVALUEITEMINSETS, n++, 1);
        Object object3 = new JLabel();
        ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("FEATU_MAX_NUMBER_ITERATIONS"));
        this.addComponent((JComponent)object3, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_maxNumberOfIterations, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("FEATU_RANDOM_SEED"));
        this.addComponent(jLabel3, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_randomSeed, MIDVALUEITEMINSETS, n++, 1);
        object = new JLabel();
        ((JLabel)object).setText(DM4JResourceUtilities.getUIString("COMMON_ATTRIBUTES"));
        ((JLabel)object).setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_ATTRIBUTES"));
        this.addAnchoredComponent((JComponent)object, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        this.m_attribTable = new AttributeTable(this.m_model);
        jComponent = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jComponent.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jComponent, MIDLABELITEMINSETS, n++, 2, 1, 1, 14);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(FeatureExtractionSettingsPanel.this.m_attribTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_attribPanel.getViewport().add(this.m_attribTable);
        ((JLabel)object).setLabelFor(this.m_attribTable);
        this.m_attribPanel.setPreferredSize(null);
        this.addFilledComponent(this.m_attribPanel, MIDLABELITEMINSETS, n, 0, 3, 6, 1);
        object2 = new GeneralGridSelectionManager(0, 2, 0);
        this.m_attribTable.getGrid().setGridSelectionManager((GridSelectionManager)object2);
        object3 = new Dm4jSpreadTableExcelAdapter(this.m_attribTable);
        n += 6;
    }

    private void runTimePanelLoad() throws Exception {
        Object object;
        this.m_attribTable.load();
        if (BrowserFrame.is11Server()) {
            object = this.m_settings.useAutomatedDataPreparations() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
            this.m_automaticDataPreparation.setText((String)object);
        }
        if (!(this.m_settings.getAlgorithmSettings() instanceof OraFeatureExtractionAlgorithmSettings)) {
            throw new Exception("Unexpected functions settings object type" + this.m_settings.getClass().getName());
        }
        object = DM4JNumericFormat.getInstance(false, 10, 10);
        OraFeatureExtractionAlgorithmSettings oraFeatureExtractionAlgorithmSettings = (OraFeatureExtractionAlgorithmSettings)this.m_settings.getAlgorithmSettings();
        OraNMFAlgorithmSettings oraNMFAlgorithmSettings = (OraNMFAlgorithmSettings)oraFeatureExtractionAlgorithmSettings;
        this.m_minimumConvergenceTolerance.setText(((NumberFormat)object).format(oraNMFAlgorithmSettings.getMinConvergenceTolerance()));
        this.m_maxNumberOfIterations.setText(DM4JNumericFormat.format(oraNMFAlgorithmSettings.getMaxNumberOfIterations()));
        this.m_randomSeed.setText(DM4JNumericFormat.format(oraNMFAlgorithmSettings.getSeedValue()));
    }

    class SettingTable
    extends Dm4jSpreadTable {
        String[] m_ColumnNames;
        int[] m_ColWidths;

        SettingTable(Object object) {
            super(object);
            this.m_ColumnNames = new String[]{DM4JResourceUtilities.getUIString("FEATU_TBL_MIN_CONVERGENCE_TOLERANCE"), DM4JResourceUtilities.getUIString("FEATU_TBL_MAX_NUMBER_ITERATIONS")};
            this.m_ColWidths = new int[]{50, 50};
            if ((AlgorithmSettings)object instanceof OraFeatureExtractionAlgorithmSettings) {
                this.setColumnNames(this.m_ColumnNames);
            }
            Grid grid = this.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
            grid.setGridSelectionManager(generalGridSelectionManager);
            try {
                this.displayLoadingStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void load() throws Exception {
            AlgorithmSettings algorithmSettings = (AlgorithmSettings)this.getDataItem();
            if (null == algorithmSettings) {
                throw new Exception("Cannot load data. MiningAlgorithmSettings not supplied");
            }
            if (algorithmSettings instanceof OraFeatureExtractionAlgorithmSettings) {
                this.setColumnWidths(this.m_ColWidths, true);
            }
            final int n = this.getColModel().getItemCount();
            Dm4jSortableTwoDModel dm4jSortableTwoDModel = new Dm4jSortableTwoDModel(){

                public void load(Object object) {
                    AlgorithmSettings algorithmSettings = (AlgorithmSettings)object;
                    this.addColumns(0, n);
                    if (algorithmSettings instanceof OraFeatureExtractionAlgorithmSettings) {
                        OraFeatureExtractionAlgorithmSettings oraFeatureExtractionAlgorithmSettings = (OraFeatureExtractionAlgorithmSettings)algorithmSettings;
                        this.addRows(0, 1);
                    }
                }
            };
            dm4jSortableTwoDModel.load(algorithmSettings);
            this.setVerticalSeparatorsVisible(true);
            this.setModels((TwoDModel)dm4jSortableTwoDModel, this.getColModel(), null);
            Header header = this.getColumnHeader();
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setItemInputHandler(null);
            header.setCanMoveItems(false);
            try {
                if (algorithmSettings instanceof OraFeatureExtractionAlgorithmSettings) {
                    this.setColumnWidths(this.m_ColWidths, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

