/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.export;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.plaf.FileChooserUI;
import oracle.bali.ewt.grid.hGrid.HArrayTwoDModel;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.classification.DetailRulesTableModel;
import oracle.dmt.dm4j.browser.viewer.classification.SVMCoefficientTableModel;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodeTableModel;
import oracle.dmt.dm4j.browser.viewer.clustering.ClustersTableModel;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrCluster;
import oracle.dmt.dm4j.browser.viewer.export.ExampleFileFilter;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.export.ExportTextAdapter;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.NMFFeaturesTableModel;
import oracle.dmt.dm4j.browser.viewer.regression.SVMRegCoefficientTableModel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class ExportPanel
extends GriddedPanel {
    ExportDialog m_parentDialog;
    static final int CSV_FORMAT = 0;
    static final int TEXT_FORMAT = 1;
    int m_format = 0;
    File m_file = null;
    String COMMA = DM4JResourceUtilities.getUIString("EXPORT_COMMA");
    String COMMA_VALUE = ",";
    String VERTICAL_BAR = DM4JResourceUtilities.getUIString("EXPORT_VERTICAL_BAR");
    String VERTICAL_BAR_VALUE = "|";
    String HYPHEN = DM4JResourceUtilities.getUIString("EXPORT_HYPHEN");
    String HYPHEN_VALUE = "-";
    String PERIOD = DM4JResourceUtilities.getUIString("EXPORT_PERIOD");
    String PERIOD_VALUE = ".";
    String SPACE = DM4JResourceUtilities.getUIString("EXPORT_SPACE");
    String SPACE_VALUE = " ";
    String TAB = DM4JResourceUtilities.getUIString("EXPORT_TAB");
    String TAB_VALUE = "\t";
    JLabel lblFieldDelimiter = new JLabel();
    JComboBox comboFieldDelimiter = new JComboBox();
    String m_delimiter = this.COMMA_VALUE;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JRadioButton csvFormat = new JRadioButton();
    JRadioButton textFormat = new JRadioButton();
    ButtonGroup exportFormat = new ButtonGroup();
    JLabel lblFiller = new JLabel(" ");

    public ExportPanel(ExportDialog exportDialog) throws Exception {
        this.m_parentDialog = exportDialog;
        this.jbInit();
    }

    public void export(Object object) throws Exception {
        JFileChooser jFileChooser = null;
        File file = null;
        String string = UserPreferences.getInstance().getWorkingDirectory();
        jFileChooser = string != null ? new JFileChooser(string) : new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        jFileChooser.setDialogTitle(DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        if (this.m_format == 0) {
            exampleFileFilter.addExtension("csv");
            exampleFileFilter.setDescription("CSV");
        } else {
            exampleFileFilter.addExtension("txt");
            exampleFileFilter.setDescription("TXT");
        }
        jFileChooser.setFileFilter(exampleFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            jFileChooser.getSelectedFile().delete();
            file = this.m_format == 0 ? new File(string2 + ".csv") : new File(string2 + ".txt");
        }
        if (file == null) {
            return;
        }
    }

    public boolean specifyFileNameAndLocation() {
        JFileChooser jFileChooser = null;
        this.m_file = null;
        String string = UserPreferences.getInstance().getWorkingDirectory();
        jFileChooser = string != null ? new JFileChooser(string) : new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        jFileChooser.setDialogTitle(DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        if (this.m_format == 0) {
            exampleFileFilter.addExtension("csv");
            exampleFileFilter.setDescription("CSV");
        } else {
            exampleFileFilter.addExtension("txt");
            exampleFileFilter.setDescription("TXT");
        }
        jFileChooser.setFileFilter(exampleFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            jFileChooser.getSelectedFile().delete();
            this.m_file = this.m_format == 0 ? new File(string2 + ".csv") : new File(string2 + ".txt");
        } else {
            return false;
        }
        return true;
    }

    public void exportWithExistingNameSpecification(JTable jTable) throws Exception {
        jTable.selectAll();
        if (this.m_format == 0) {
            this.m_delimiter = this.COMMA_VALUE;
            ExportTextAdapter exportTextAdapter = new ExportTextAdapter(jTable);
            exportTextAdapter.executeExport(this.m_file, this.m_delimiter, true);
        } else if (this.m_format == 1) {
            ExportTextAdapter exportTextAdapter = new ExportTextAdapter(jTable);
            exportTextAdapter.executeExport(this.m_file, this.m_delimiter, false);
        }
    }

    public void export(JTable jTable) throws Exception {
        Object object;
        JFileChooser jFileChooser = null;
        File file = null;
        String string = UserPreferences.getInstance().getWorkingDirectory();
        jFileChooser = string != null ? new JFileChooser(string) : new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        jFileChooser.setDialogTitle(DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        if (this.m_format == 0) {
            exampleFileFilter.addExtension("csv");
            exampleFileFilter.setDescription("CSV");
        } else {
            exampleFileFilter.addExtension("txt");
            exampleFileFilter.setDescription("TXT");
        }
        jFileChooser.setFileFilter(exampleFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            object = jFileChooser.getSelectedFile().getAbsolutePath();
            jFileChooser.getSelectedFile().delete();
            file = this.m_format == 0 ? new File((String)object + ".csv") : new File((String)object + ".txt");
        }
        if (file == null) {
            return;
        }
        jTable.selectAll();
        if (this.m_format == 0) {
            this.m_delimiter = this.COMMA_VALUE;
            object = new ExportTextAdapter(jTable);
            ((ExportTextAdapter)object).executeExport(file, this.m_delimiter, true);
        } else if (this.m_format == 1) {
            object = new ExportTextAdapter(jTable);
            ((ExportTextAdapter)object).executeExport(file, this.m_delimiter, false);
        }
    }

    public void export(Dm4jSpreadTable dm4jSpreadTable) throws Exception {
        int n;
        Object object;
        JFileChooser jFileChooser = null;
        File file = null;
        String string = UserPreferences.getInstance().getWorkingDirectory();
        jFileChooser = string != null ? new JFileChooser(string) : new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        jFileChooser.setDialogTitle(DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        if (this.m_format == 0) {
            exampleFileFilter.addExtension("csv");
            exampleFileFilter.setDescription("CSV");
        } else {
            exampleFileFilter.addExtension("txt");
            exampleFileFilter.setDescription("TXT");
        }
        jFileChooser.setFileFilter(exampleFileFilter);
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 == 0) {
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            jFileChooser.getSelectedFile().delete();
            file = this.m_format == 0 ? new File(string2 + ".csv") : new File(string2 + ".txt");
        }
        if (file == null) {
            return;
        }
        int n3 = 0;
        Header header = dm4jSpreadTable.getRowHeader();
        n3 = header != null ? 1 : 0;
        TwoDModel twoDModel = dm4jSpreadTable.getGrid().getModel();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        ArrayList arrayList = null;
        if (twoDModel instanceof TreeNodeTableModel) {
            bl2 = true;
            n4 = 2;
            object = (TreeNodeTableModel)twoDModel;
            arrayList = ((TreeNodeTableModel)object).getNodes();
        } else if (twoDModel instanceof ClustersTableModel) {
            bl = true;
            n4 = 2;
            object = (ClustersTableModel)twoDModel;
            arrayList = ((ClustersTableModel)object).getClusters();
        }
        object = dm4jSpreadTable.getColModel();
        int n5 = ((ArrayOneDModel)object).getItemCount();
        Object[] objectArray = new Object[n3 + n5 + n4];
        if (n3 > 0) {
            objectArray[0] = DM4JResourceUtilities.getUIString("EXPORT_ROW");
        }
        int n6 = n3;
        objectArray[n6++] = ((ArrayOneDModel)object).getData(0);
        if (bl2) {
            objectArray[n6++] = DM4JResourceUtilities.getUIString("EXPORT_PARENT_NODE_ID");
            objectArray[n6++] = DM4JResourceUtilities.getUIString("EXPORT_NODE_LEVEL");
        } else if (bl) {
            objectArray[n6++] = DM4JResourceUtilities.getUIString("EXPORT_PARENT_CLUSTER_ID");
            objectArray[n6++] = DM4JResourceUtilities.getUIString("EXPORT_CLUSTER_LEVEL");
        }
        for (n = 1; n < n5; ++n) {
            objectArray[n6++] = ((ArrayOneDModel)object).getData(n);
        }
        n = twoDModel.getRowCount();
        int n7 = twoDModel.getColumnCount();
        Object[][] objectArray2 = new Object[n][n6];
        for (int i = 0; i < n; ++i) {
            if (n3 > 0) {
                objectArray2[i][0] = header.getModel().getData(i);
            }
            int n8 = n3;
            for (int j = 0; j < n7; ++j) {
                int n9 = 0;
                String string3 = "";
                if (twoDModel.getData(j, i) != null) {
                    string3 = twoDModel.getData(j, i).toString();
                }
                if (string3.startsWith("oracle.bali.ewt.grid.hGrid.HArrayTwoDModel")) {
                    Object object2;
                    int n10;
                    int n11;
                    n9 = 0;
                    string3 = "";
                    HArrayTwoDModel hArrayTwoDModel = (HArrayTwoDModel)twoDModel;
                    HDataObject hDataObject = (HDataObject)hArrayTwoDModel.getData(j, i);
                    Object object3 = null;
                    Object object4 = hDataObject.getData();
                    for (int k = 0; k < hDataObject.getDepth(); ++k) {
                        if (object4 == null) continue;
                        ++n9;
                    }
                    if (object4 != null) {
                        if (twoDModel instanceof DetailRulesTableModel) {
                            object3 = object4;
                        } else if (twoDModel instanceof ClustersTableModel) {
                            object3 = object4;
                        } else if (twoDModel instanceof NMFFeaturesTableModel) {
                            object3 = object4;
                        } else if (twoDModel instanceof SVMCoefficientTableModel) {
                            object3 = object4;
                        } else if (twoDModel instanceof SVMRegCoefficientTableModel) {
                            object3 = object4;
                        }
                    }
                    if (object3 != null) {
                        string3 = object3 instanceof String ? (String)object3 : (object3 instanceof Integer ? ((Integer)object3).toString() : object3.toString());
                    }
                    if (bl2) {
                        if (j != n3) continue;
                        TreeNode treeNode = null;
                        for (int k = 0; k < arrayList.size() && (n11 = ((Integer)object4).intValue()) != (n10 = (treeNode = (TreeNode)arrayList.get(k)).getIdentifier()); ++k) {
                        }
                        object2 = treeNode.getParent();
                        objectArray2[i][n8++] = object4;
                        objectArray2[i][n8++] = object2 != null ? String.valueOf(object2.getIdentifier()) : new String("");
                        objectArray2[i][n8++] = String.valueOf(n9) + string3;
                        continue;
                    }
                    if (!bl || j != n3) continue;
                    ODMrCluster oDMrCluster = null;
                    for (int k = 0; k < arrayList.size() && (n11 = ((Integer)object4).intValue()) != (n10 = (oDMrCluster = (ODMrCluster)arrayList.get(k)).getJDmCluster().getClusterId()); ++k) {
                    }
                    object2 = oDMrCluster.getJDmCluster().getParent();
                    objectArray2[i][n8++] = object4;
                    objectArray2[i][n8++] = object2 != null ? String.valueOf(object2.getClusterId()) : new String("");
                    objectArray2[i][n8++] = String.valueOf(n9);
                    continue;
                }
                objectArray2[i][n8++] = twoDModel.getData(j, i);
            }
        }
        JTable jTable = new JTable(objectArray2, objectArray);
        jTable.selectAll();
        if (this.m_format == 0) {
            this.m_delimiter = this.COMMA_VALUE;
            ExportTextAdapter exportTextAdapter = new ExportTextAdapter(jTable);
            exportTextAdapter.executeExport(file, this.m_delimiter, true);
        } else if (this.m_format == 1) {
            ExportTextAdapter exportTextAdapter = new ExportTextAdapter(jTable);
            exportTextAdapter.executeExport(file, this.m_delimiter, false);
        }
    }

    private void exportFormat_actionPerformed(ActionEvent actionEvent) {
        if (this.csvFormat.isSelected()) {
            this.m_format = 0;
            this.comboFieldDelimiter.setEnabled(false);
        } else if (this.textFormat.isSelected()) {
            this.m_format = 1;
            this.comboFieldDelimiter.setEnabled(true);
        }
    }

    private void comboFieldDelimiter_actionPerformed(ActionEvent actionEvent) {
        if (this.comboFieldDelimiter.getSelectedItem() != "") {
            String string = (String)this.comboFieldDelimiter.getSelectedItem();
            this.m_delimiter = string.equalsIgnoreCase(this.COMMA) ? this.COMMA_VALUE : (string.equalsIgnoreCase(this.VERTICAL_BAR) ? this.VERTICAL_BAR_VALUE : (string.equalsIgnoreCase(this.HYPHEN) ? this.HYPHEN_VALUE : (string.equalsIgnoreCase(this.PERIOD) ? this.PERIOD_VALUE : (string.equalsIgnoreCase(this.SPACE) ? this.SPACE_VALUE : (string.equalsIgnoreCase(this.TAB) ? this.TAB_VALUE : string)))));
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        String string = DM4JResourceUtilities.getUIString("EXPORT_DESCRIPTION");
        String string2 = ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_FIELD_DELIMITER");
        int n2 = ResourceUtilities.getUIMnemonic("FILEIMPORT_SETTINGS_FIELD_DELIMITER");
        this.mlblStepDescription.setText(string);
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.csvFormat.setSelected(true);
        this.csvFormat.setText(DM4JResourceUtilities.getUIString("EXPORT_CSV_FORMAT"));
        this.exportFormat.add(this.csvFormat);
        this.csvFormat.setMnemonic(DM4JResourceUtilities.getUIMnemonic("EXPORT_CSV_FORMAT"));
        this.csvFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPanel.this.exportFormat_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.csvFormat, COL1_INDENTED1_CONTROL, n++, 0, 2, 1);
        this.textFormat.setText(DM4JResourceUtilities.getUIString("EXPORT_TEXT_FORMAT"));
        this.exportFormat.add(this.textFormat);
        this.textFormat.setMnemonic(DM4JResourceUtilities.getUIMnemonic("EXPORT_TEXT_FORMAT"));
        this.textFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPanel.this.exportFormat_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.textFormat, COL1_INDENTED1_CONTROL, n++, 0, 2, 1);
        String[] stringArray = new String[]{this.COMMA, this.VERTICAL_BAR, this.HYPHEN, this.PERIOD, this.SPACE, this.TAB};
        this.comboFieldDelimiter = new JComboBox<String>(stringArray);
        this.comboFieldDelimiter.setEditable(true);
        this.comboFieldDelimiter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPanel.this.comboFieldDelimiter_actionPerformed(actionEvent);
            }
        });
        this.comboFieldDelimiter.setEnabled(false);
        this.lblFieldDelimiter.setText(string2);
        this.lblFieldDelimiter.setDisplayedMnemonic(n2);
        this.lblFieldDelimiter.setLabelFor(this.comboFieldDelimiter);
        this.addComponent(this.lblFieldDelimiter, COL1_INDENTED2_CONTROL, n, 0);
        this.addFilledComponent(this.comboFieldDelimiter, COL_VALUE, n++, 1);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 4, 2, 1);
        this.addOKHelpCancelListeners();
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() throws Exception {
    }

    protected void processUserInput() {
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            // empty if block
        }
    }
}

