/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.export;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.plaf.FileChooserUI;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.viewer.export.ExampleFileFilter;
import oracle.dmt.dm4j.browser.viewer.export.ExportChartDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dss.graph.Graph;

public class ExportChartPanel
extends GriddedPanel {
    ExportChartDialog m_parentDialog;
    static final int GIF_FORMAT = 0;
    static final int PNG_FORMAT = 1;
    static final int JPEG_FORMAT = 2;
    int m_format = 0;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JRadioButton gifFormat = new JRadioButton();
    JRadioButton pngFormat = new JRadioButton();
    JRadioButton jpegFormat = new JRadioButton();
    ButtonGroup exportFormat = new ButtonGroup();
    JLabel lblFiller = new JLabel(" ");

    public ExportChartPanel(ExportChartDialog exportChartDialog) throws Exception {
        this.m_parentDialog = exportChartDialog;
        this.jbInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Graph graph) throws Exception {
        Object object;
        JFileChooser jFileChooser = null;
        File file = null;
        String string = UserPreferences.getInstance().getWorkingDirectory();
        jFileChooser = string != null ? new JFileChooser(string) : new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        jFileChooser.setDialogTitle(DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        if (this.m_format == 0) {
            exampleFileFilter.addExtension("gif");
            exampleFileFilter.setDescription("GIF");
        } else if (this.m_format == 1) {
            exampleFileFilter.addExtension("png");
            exampleFileFilter.setDescription("PNG");
        } else if (this.m_format == 2) {
            exampleFileFilter.addExtension("jpg");
            exampleFileFilter.setDescription("JPG");
        }
        jFileChooser.setFileFilter(exampleFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            object = jFileChooser.getSelectedFile().getAbsolutePath();
            jFileChooser.getSelectedFile().delete();
            if (this.m_format == 0) {
                file = new File((String)object + ".gif");
            } else if (this.m_format == 1) {
                file = new File((String)object + ".png");
            } else if (this.m_format == 2) {
                file = new File((String)object + ".jpg");
            }
        }
        if (file == null) {
            return;
        }
        object = null;
        try {
            object = new FileOutputStream(file);
            if (this.m_format == 0) {
                graph.exportToGIF((OutputStream)object);
            } else if (this.m_format == 1) {
                graph.exportToPNG((OutputStream)object);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((FileOutputStream)object).close();
            throw throwable;
        }
        ((FileOutputStream)object).close();
    }

    private void exportFormat_actionPerformed(ActionEvent actionEvent) {
        if (this.gifFormat.isSelected()) {
            this.m_format = 0;
        } else if (this.pngFormat.isSelected()) {
            this.m_format = 1;
        } else if (this.jpegFormat.isSelected()) {
            this.m_format = 2;
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        String string = DM4JResourceUtilities.getUIString("EXPORT_DESCRIPTION");
        this.mlblStepDescription.setText(string);
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.gifFormat.setSelected(true);
        this.gifFormat.setText(DM4JResourceUtilities.getUIString("EXPORT_GIF_FORMAT"));
        this.exportFormat.add(this.gifFormat);
        this.gifFormat.setMnemonic(DM4JResourceUtilities.getUIMnemonic("EXPORT_GIF_FORMAT"));
        this.gifFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportChartPanel.this.exportFormat_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.gifFormat, COL1_INDENTED1_CONTROL, n++, 0, 2, 1);
        this.pngFormat.setText(DM4JResourceUtilities.getUIString("EXPORT_PNG_FORMAT"));
        this.exportFormat.add(this.pngFormat);
        this.pngFormat.setMnemonic(DM4JResourceUtilities.getUIMnemonic("EXPORT_PNG_FORMAT"));
        this.pngFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportChartPanel.this.exportFormat_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.pngFormat, COL1_INDENTED1_CONTROL, n++, 0, 2, 1);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 4, 2, 1);
        this.addOKHelpCancelListeners();
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() throws Exception {
    }

    protected void processUserInput() {
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportChartPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            // empty if block
        }
    }
}

