/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import javax.datamining.JDMException;
import javax.datamining.data.AttributeType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.CategorySet;
import javax.datamining.data.SignatureAttribute;
import javax.datamining.statistics.ContinuousStatistics;
import javax.datamining.statistics.DiscreteStatistics;
import javax.datamining.statistics.NumericalStatistics;
import javax.datamining.statistics.UnivariateStatistics;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.data.OraInterval;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class ODMrOraUnivariateStatistics
extends OraDMObject
implements UnivariateStatistics {
    private SignatureAttribute m_signatureAttribute;
    private String m_attributeName;
    private OraInterval[] m_ranges = null;
    private CategorySet m_categorySet = null;
    private long[] m_frequencies = null;
    private double[] m_probabilities;
    private boolean m_bUnbinned = false;

    public ODMrOraUnivariateStatistics(OraConnection oraConnection, String string, SignatureAttribute signatureAttribute, CategorySet categorySet, double[] dArray, boolean bl) throws JDMException {
        super(oraConnection, null);
        this.m_attributeName = string;
        this.m_signatureAttribute = signatureAttribute;
        this.m_categorySet = categorySet;
        this.m_probabilities = dArray;
        this.m_bUnbinned = bl;
    }

    public ODMrOraUnivariateStatistics(OraConnection oraConnection, String string, SignatureAttribute signatureAttribute, OraInterval[] oraIntervalArray, double[] dArray, boolean bl) throws JDMException {
        super(oraConnection, null);
        this.m_attributeName = string;
        this.m_signatureAttribute = signatureAttribute;
        this.m_ranges = oraIntervalArray;
        this.m_probabilities = dArray;
        this.m_bUnbinned = bl;
    }

    public Object[] getValues() {
        AttributeType attributeType = this.m_signatureAttribute.getAttributeType();
        if (attributeType.equals(AttributeType.categorical) || this.m_bUnbinned) {
            return this.m_categorySet.getValues();
        }
        if (attributeType.equals(AttributeType.numerical)) {
            return this.m_ranges;
        }
        return null;
    }

    public String getName() {
        return this.m_attributeName;
    }

    public long getFrequency(int n) throws JDMException {
        return this.m_frequencies[n];
    }

    public long[] getFrequencies() {
        if (this.m_frequencies == null && this.m_probabilities != null) {
            this.m_frequencies = new long[this.m_probabilities.length];
            for (int i = 0; i < this.m_probabilities.length; ++i) {
                this.m_frequencies[i] = (long)this.m_probabilities[i];
            }
        }
        return this.m_frequencies;
    }

    public double[] getProbabilities() {
        return this.m_probabilities;
    }

    public long getFrequency(CategoryProperty categoryProperty) {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"getFrequency", ""}, null);
        return 0L;
    }

    public DiscreteStatistics getDiscreteStatistics() {
        return null;
    }

    public NumericalStatistics getNumericalStatistics() {
        return null;
    }

    public ContinuousStatistics getContinuousStatistics() {
        return null;
    }
}

