/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.ComparisonOperator;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.data.ModelSignature;
import javax.datamining.resource.Connection;
import javax.datamining.rule.BooleanOperator;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import javax.datamining.rule.SimplePredicate;
import javax.datamining.statistics.AttributeStatisticsSet;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrCluster;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrComplexAttributeName;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraAttributeStatisticsSet;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraClusterRule;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettings;
import oracle.dmt.jdm.clustering.OraClusteringModel;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraCompoundPredicate;
import oracle.dmt.jdm.rule.OraSimplePredicate;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODMrOraClusteringModel
extends OraClusteringModel {
    private static String QRY_ALL_RULES = "SELECT  a.id                            cluster_id,         a.rule.rule_id                  rule_id,         a.rule.rule_support             rule_support,         a.rule.rule_confidence          rule_confidence,         a.record_count                  record_count FROM (SELECT *  {0} ";
    private static String QRY_RULE_ID = "SELECT  a.id                            cluster_id,         a.rule.rule_support             rule_support,         a.rule.rule_confidence          rule_confidence,         a.record_count                  record_count FROM (SELECT *  {0} where a.rule.rule_id=";
    private static String QRY_MOST_RELEVANT_RULES = "SELECT * FROM (\n  SELECT b.*,\n         DENSE_RANK() OVER (PARTITION BY b.rule_id ORDER BY b.attribute_confidence DESC, b.attribute_name ASC) drank\n  FROM (\n     SELECT\n          a.rule.rule_id         rule_id,\n          min(a.rule.rule_support)    rule_support,\n          min(a.rule.rule_confidence) rule_confidence,\n          min(a.record_count)               record_count,\n          min(rl_ant.attribute_confidence)  attribute_confidence,\n          rl_ant.attribute_name         attribute_name\n      FROM (\n        SELECT * FROM\n        TABLE(dbms_data_mining.get_model_details_{0}(?, null, null, 0, 0, 2) )\n       ) a,\n       TABLE(a.rule.antecedent) rl_ant\n       GROUP BY a.rule.rule_id, rl_ant.attribute_name\n    ) b\n)\nWHERE drank <= {1}\norder by rule_id, drank, attribute_name\n";
    private static String QRY_MOST_RELEVANT_RULES_11G = "SELECT * FROM (\n  SELECT b.*,\n         DENSE_RANK() OVER (PARTITION BY b.rule_id ORDER BY b.attribute_confidence DESC, b.attribute_name ASC) drank\n  FROM (\n     SELECT\n          a.rule.rule_id         rule_id,\n          min(a.rule.rule_support)    rule_support,\n          min(a.rule.rule_confidence) rule_confidence,\n          min(a.record_count)               record_count,\n          min(rl_ant.attribute_confidence)  attribute_confidence,\n          rl_ant.attribute_name         attribute_name,\n          rl_ant.attribute_subname         attribute_subname\n      FROM (\n        SELECT * FROM\n        TABLE(dbms_data_mining.get_model_details_{0}(?, null, null, 0, 0, 2) )\n       ) a,\n       TABLE(a.rule.antecedent) rl_ant\n       GROUP BY a.rule.rule_id, rl_ant.attribute_name, rl_ant.attribute_subname\n    ) b\n)\nWHERE drank <= {1}\norder by rule_id, drank, attribute_name\n";
    private static String OCLUSTER_DETAILS = "  FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?)) {0} ) a ";
    public static String DECODE_VIEW = "WITH label_view as (   SELECT col, bin,    Decode(bin,'1','[','(') || lv || ',' || val || ']' label     FROM (SELECT col, bin, last_value(val) over ( PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val ";
    public static String DECODE_VIEW_ROUNDED = "WITH label_view as (   SELECT col, bin,    Decode(bin,''1'',''['',''('') || lv || '','' || val || '']'' label     FROM (SELECT col, bin, ROUND(last_value(val) over ( PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding),{0}) lv, ROUND(val,{0}) val ";
    private static String QRY_DECODE_GET_CENTROID_OC_VIEW = "WITH label_view as  ( SELECT col, bin, Decode(bin,'1','[','(') || lv || ',' || val || ']' label  ";
    private static String QRY_DECODE_GET_CENTROID_OC = "\nFROM \n(SELECT col, bin, last_value(val) over (PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val  FROM {0}) ), \nmodel_detail as \n ( SELECT * FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?) ) a  , \n  TABLE(a.centroid) ) \nSELECT NVL(label, cd.mean) as centroid_mean, \n\t   cd.attribute_name      attribute_name, \n\tnull                      centroid_mode_value \nFROM model_detail cd, label_view l \nWHERE cd.attribute_name = l.col  AND cd.mean=l.bin \nUNION ALL \nSELECT \n\tnull                   as centroid_mean, \n\tcd.attribute_name      attribute_name, \n\tNVL(val, cd.mode_value) centroid_mode_value \nFROM model_detail cd,  {1} lcat \nWHERE cd.attribute_name = lcat.col  AND cd.mode_value = lcat.bin";
    private static String QRY_DECODE_GET_CENTROID_OC_NUM = "\nFROM \n(SELECT col, bin, last_value(val) over (PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val  FROM {0}) ), \nmodel_detail as \n ( SELECT * FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?) ) a  , \n  TABLE(a.centroid) ) \nSELECT NVL(label, cd.mean) as centroid_mean, \n\t   cd.attribute_name      attribute_name, \n\tnull                      centroid_mode_value \nFROM model_detail cd, label_view l \nWHERE cd.attribute_name = l.col  AND cd.mean=l.bin \nUNION ALL \nSELECT \n\tnull                   as centroid_mean, \n\tcd.attribute_name      attribute_name, \n\tcd.mode_value          centroid_mode_value \nFROM model_detail cd \nWHERE cd.mode_value is not null";
    private static String QRY_DECODE_GET_CENTROID_OC_CAT = "\nWITH model_detail as \n ( SELECT * FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?) ) a  , \n  TABLE(a.centroid) ) \nSELECT cd.mean              centroid_mean, \n\tcd.attribute_name         attribute_name, \n\tnull                      centroid_mode_value \nFROM model_detail cd  \nWHERE cd.mean is not null \nUNION ALL \nSELECT \n\tnull                   as centroid_mean, \n\tcd.attribute_name      attribute_name, \n\tNVL(val, cd.mode_value) centroid_mode_value \nFROM model_detail cd,  {0} lcat \nWHERE cd.attribute_name = lcat.col  AND cd.mode_value = lcat.bin";
    private static String QRY_GET_SPLIT_PREDICATE = "SELECT                a.id                             cluster_id,                split.attribute_name          attribute_name,                split.conditional_operator       conditional_operator,                split.attribute_num_value     attribute_num_value,                split.attribute_str_value     attribute_str_value FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a,        TABLE(a.split_predicate) split";
    private static String QRY_DECODE_GET_SPLIT_PREDICATE_BOTH = "WITH \n    model_detail as \n    ( SELECT * FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?) ) a  , \n    TABLE(a.split_predicate) \n    ) \nSELECT \nmodel_detail.id                         cluster_id, \nmodel_detail.attribute_name             attribute_name, \nmodel_detail.conditional_operator       conditional_operator, \nNVL(val, model_detail.attribute_num_value )  \n                                     as attribute_num_value, \nnull                                  attribute_str_value \nFROM model_detail, {0} lnum \nWHERE model_detail.attribute_num_value=lnum.bin and lnum.col= model_detail.attribute_name \nUNION ALL \nSELECT \n  model_detail.id                         cluster_id, \n  model_detail.attribute_name             attribute_name, \n  model_detail.conditional_operator       conditional_operator, \n  null                                    attribute_num_value, \n  NVL(val, model_detail.attribute_str_value ) \n                                        as attribute_str_value \nFROM model_detail, {1} lcat \nWHERE model_detail.attribute_str_value=lcat.bin and lcat.col= model_detail.attribute_name";
    private static String QRY_DECODE_GET_SPLIT_PREDICATE_NUM = "WITH \n    model_detail as \n    ( SELECT * FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?) ) a  , \n    TABLE(a.split_predicate) \n    ) \nSELECT \nmodel_detail.id                         cluster_id, \nmodel_detail.attribute_name             attribute_name, \nmodel_detail.conditional_operator       conditional_operator, \nNVL(val, model_detail.attribute_num_value )  \n                                     as attribute_num_value, \nnull                                  attribute_str_value \nFROM model_detail, {0} lnum \nWHERE model_detail.attribute_num_value=lnum.bin and lnum.col= model_detail.attribute_name \nUNION ALL \nSELECT \n  model_detail.id                         cluster_id, \n  model_detail.attribute_name             attribute_name, \n  model_detail.conditional_operator       conditional_operator, \n  null                                    attribute_num_value, \n  model_detail.attribute_str_value        attribute_str_value \nFROM model_detail";
    private static String QRY_DECODE_GET_SPLIT_PREDICATE_CAT = "WITH \n    model_detail as \n    ( SELECT * FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?) ) a  , \n    TABLE(a.split_predicate) \n    ) \nSELECT \nmodel_detail.id                       cluster_id, \nmodel_detail.attribute_name           attribute_name, \nmodel_detail.conditional_operator     conditional_operator, \nmodel_detail.attribute_num_value      as attribute_num_value, \nnull                                  attribute_str_value \nFROM model_detail \nwhere model_detail.attribute_num_value is not null \nUNION ALL \nSELECT \n  model_detail.id                         cluster_id, \n  model_detail.attribute_name             attribute_name, \n  model_detail.conditional_operator       conditional_operator, \n  null                                    attribute_num_value, \n  NVL(val, model_detail.attribute_str_value ) \n                                        as attribute_str_value \nFROM model_detail, {0} lcat \nWHERE model_detail.attribute_str_value=lcat.bin and lcat.col= model_detail.attribute_name";
    private static String ORDER_BY_ID = "ORDER BY id";
    private static final String cluster_id = "cluster_id";
    private static final String record_count = "record_count";
    private static final String rule_id = "rule_id";
    private static final String rule_support = "rule_support";
    private static final String rule_confidence = "rule_confidence";
    private static final String attribute_name = "attribute_name";
    private static final String attribute_subname = "attribute_subname";
    private static final String centroid_mean = "centroid_mean";
    private static final String centroid_mode_value = "centroid_mode_value";
    private static final String conditional_operator = "conditional_operator";
    private static final String attribute_num_value = "attribute_num_value";
    private static final String attribute_str_value = "attribute_str_value";
    private static final String dense_rank = "drank";
    private MiningFunction m_function = null;
    private MiningAlgorithm m_algorithm = null;
    private Integer m_buildDuration = null;
    private TreeMap m_clusters = null;
    private TreeMap m_leafs = null;
    private Hashtable m_splitRules = new Hashtable();
    private Hashtable m_lookupTableMap = null;

    public ODMrOraClusteringModel(OraConnection oraConnection, String string) throws JDMException {
        super(oraConnection, string);
    }

    public ODMrOraClusteringModel(Connection connection, OraClusteringModel oraClusteringModel) throws JDMException {
        this((OraConnection)connection, oraClusteringModel.getName());
        this.m_algorithm = oraClusteringModel.getMiningAlgorithm();
        this.m_function = oraClusteringModel.getMiningFunction();
        this.setObjectIdentifier(oraClusteringModel.getObjectIdentifier());
        this.setCreationDate(oraClusteringModel.getCreationDate());
        this.setCreatorInfo(oraClusteringModel.getCreatorInfo());
        this.m_buildDuration = oraClusteringModel.getBuildDuration();
    }

    @Override
    public MiningAlgorithm getMiningAlgorithm() {
        return this.m_algorithm;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.m_function;
    }

    @Override
    public Integer getBuildDuration() {
        return this.m_buildDuration;
    }

    /*
     * Loose catch block
     */
    public Rule getRule(int n) throws JDMException {
        ODMrOraClusterRule oDMrOraClusterRule;
        block20: {
            oDMrOraClusterRule = null;
            String string = this.getName();
            OraConnection oraConnection = this.getConnection();
            boolean bl = oraConnection.is102();
            java.sql.Connection connection = oraConnection.getDatabaseConnection();
            MiningAlgorithm miningAlgorithm = this.getMiningAlgorithm();
            int n2 = 1;
            if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
                n2 = 0;
            }
            ClusteringDistanceFunction clusteringDistanceFunction = null;
            ClusteringSettings clusteringSettings = (ClusteringSettings)this.getBuildSettings();
            AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
            if (algorithmSettings instanceof OraKMeansSettings) {
                OraKMeansSettings oraKMeansSettings = (OraKMeansSettings)algorithmSettings;
                clusteringDistanceFunction = oraKMeansSettings.getDistanceFunction();
            }
            boolean bl2 = true == miningAlgorithm.equals(MiningAlgorithm.kMeans);
            Statement statement = null;
            ResultSet resultSet = null;
            int n3 = 1;
            statement = connection.prepareStatement(this.getQuery(QRY_RULE_ID, null, bl) + n);
            statement.setString(n3++, string);
            statement.setNull(n3++, 4);
            statement.setNull(n3++, 12);
            statement.setInt(n3++, 0);
            statement.setInt(n3++, 0);
            statement.setInt(n3++, 1);
            if (!bl && bl2) {
                statement.setNull(n3, 12);
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int n4 = resultSet.getInt(cluster_id);
                if (resultSet.wasNull()) {
                    System.out.println("Rule id is null");
                    continue;
                }
                double d = resultSet.getDouble(rule_support);
                double d2 = resultSet.getDouble(rule_confidence);
                long l = resultSet.getInt(record_count);
                oDMrOraClusterRule = new ODMrOraClusterRule(this.getConnection(), string, n2, n4, n, d / (double)l, d2, this.m_buildTransform, clusteringDistanceFunction);
            }
            Object var24_22 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block20;
            }
            catch (SQLException sQLException) {}
            break block20;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new JDMException();
                }
            }
            catch (Throwable throwable) {
                Object var24_23 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return oDMrOraClusterRule;
    }

    @Override
    public Collection getRules() throws JDMException {
        return this.internalGetRules();
    }

    /*
     * Loose catch block
     */
    private synchronized Collection internalGetRules() throws JDMException {
        TreeMap<Integer, ODMrOraClusterRule> treeMap;
        block22: {
            treeMap = null;
            String string = this.getName();
            OraConnection oraConnection = this.getConnection();
            boolean bl = oraConnection.is102();
            java.sql.Connection connection = oraConnection.getDatabaseConnection();
            MiningAlgorithm miningAlgorithm = this.getMiningAlgorithm();
            int n = 1;
            if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
                n = 0;
            }
            ClusteringDistanceFunction clusteringDistanceFunction = null;
            ClusteringSettings clusteringSettings = (ClusteringSettings)this.getBuildSettings();
            AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
            if (algorithmSettings instanceof OraKMeansSettings) {
                OraKMeansSettings oraKMeansSettings = (OraKMeansSettings)algorithmSettings;
                clusteringDistanceFunction = oraKMeansSettings.getDistanceFunction();
            }
            boolean bl2 = true == miningAlgorithm.equals(MiningAlgorithm.kMeans);
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            int n2 = 1;
            preparedStatement = connection.prepareStatement(this.getQuery(QRY_ALL_RULES, ORDER_BY_ID, bl));
            preparedStatement.setString(n2++, string);
            preparedStatement.setNull(n2++, 4);
            preparedStatement.setNull(n2++, 12);
            preparedStatement.setInt(n2++, 0);
            preparedStatement.setInt(n2++, 0);
            preparedStatement.setInt(n2++, 1);
            if (!bl && bl2) {
                preparedStatement.setNull(n2, 12);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                int n3 = resultSet.getInt(cluster_id);
                int n4 = resultSet.getInt(rule_id);
                if (resultSet.wasNull()) {
                    System.out.println("Rule id is null");
                    continue;
                }
                double d = resultSet.getDouble(rule_support);
                double d2 = resultSet.getDouble(rule_confidence);
                long l = resultSet.getInt(record_count);
                ODMrOraClusterRule oDMrOraClusterRule = new ODMrOraClusterRule(this.getConnection(), string, n, n3, n4, d / (double)l, d2, this.m_buildTransform, clusteringDistanceFunction);
                if (treeMap == null) {
                    treeMap = new TreeMap<Integer, ODMrOraClusterRule>();
                }
                treeMap.put(new Integer(n4), oDMrOraClusterRule);
            }
            Object var25_23 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block22;
            }
            catch (SQLException sQLException) {}
            break block22;
            {
                catch (SQLException sQLException) {
                    if (treeMap != null) {
                        treeMap.clear();
                    }
                    throw new JDMException();
                }
            }
            catch (Throwable throwable) {
                Object var25_24 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return treeMap.values();
    }

    AttributeStatisticsSet getAttributeStatisticsSet(int n) throws JDMException {
        String string = this.getName();
        ModelSignature modelSignature = this.getSignature();
        ODMrOraAttributeStatisticsSet oDMrOraAttributeStatisticsSet = new ODMrOraAttributeStatisticsSet(this.getConnection(), this, modelSignature, string, n, this.m_buildTransform);
        return oDMrOraAttributeStatisticsSet;
    }

    @Override
    public Collection getClusters() {
        if (this.m_clusters == null) {
            Collection collection = super.getClusters();
            this.m_clusters = new TreeMap();
            for (Cluster cluster : collection) {
                ODMrCluster oDMrCluster = new ODMrCluster(this, cluster);
                oDMrCluster.isLeaf();
                this.m_clusters.put(new Integer(cluster.getClusterId()), oDMrCluster);
            }
        }
        return this.m_clusters.values();
    }

    @Override
    public Collection getLeafClusters() {
        if (this.m_leafs == null) {
            Collection collection = super.getLeafClusters();
            this.m_leafs = new TreeMap();
            for (Cluster cluster : collection) {
                ODMrCluster oDMrCluster = (ODMrCluster)this.m_clusters.get(new Integer(cluster.getClusterId()));
                this.m_leafs.put(new Integer(cluster.getClusterId()), oDMrCluster);
            }
        }
        return this.m_leafs.values();
    }

    public ODMrCluster getODMrCluster(int n) throws JDMException {
        if (this.m_clusters != null && !this.m_clusters.isEmpty()) {
            return (ODMrCluster)this.m_clusters.get(new Integer(n));
        }
        Cluster cluster = super.getCluster(n);
        return new ODMrCluster(this, cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TreeMap<ODMrComplexAttributeName, Object> getCentroids(int n) throws JDMException {
        TreeMap<ODMrComplexAttributeName, Object> treeMap;
        block39: {
            String string = this.getName();
            OraConnection oraConnection = this.getConnection();
            boolean bl = oraConnection.is102();
            java.sql.Connection connection = oraConnection.getDatabaseConnection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            int n2 = 1;
            treeMap = new TreeMap<ODMrComplexAttributeName, Object>();
            String string2 = "";
            if (this.m_lookupTableMap == null) {
                this.m_lookupTableMap = DatabaseMetadata.getODMrTextLookupTable(string);
            }
            string2 = this.m_buildTransform != null ? this.getCentroidQueryDecode(connection, GetCentroidAll.getCentroidAll(bl), null) : this.getQuery(GetCentroidAll.getCentroidAll(bl), null, bl);
            ClusteringSettings clusteringSettings = (ClusteringSettings)this.getBuildSettings();
            AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
            boolean bl2 = true == this.getMiningAlgorithm().equals(MiningAlgorithm.kMeans);
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(n2++, string);
            preparedStatement.setInt(n2++, n);
            preparedStatement.setNull(n2++, 12);
            preparedStatement.setInt(n2++, 1);
            preparedStatement.setInt(n2++, 0);
            preparedStatement.setInt(n2++, 0);
            if (!bl && bl2) {
                preparedStatement.setNull(n2, 12);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object;
                String string3;
                String string4 = resultSet.getString(attribute_name);
                String string5 = null;
                if (!bl && bl2) {
                    string5 = resultSet.getString(attribute_subname);
                }
                Double d = null;
                String string6 = resultSet.getString(centroid_mean);
                if (string6 != null) {
                    Object var29_37;
                    try {
                        try {
                            double d2 = Double.parseDouble(string6);
                            d = new Double(d2);
                        }
                        catch (Exception exception) {
                            double d3;
                            int n3 = string6.indexOf("(");
                            if (n3 != -1) {
                                int n4;
                                int n5 = string6.indexOf(",");
                                if (n5 != -1 && (n4 = string6.indexOf("]")) != -1) {
                                    string3 = string6.substring(n3 + 1, n5);
                                    object = string6.substring(n5 + 1, n4);
                                    try {
                                        double d4 = Double.parseDouble(string3);
                                        d3 = Double.parseDouble((String)object);
                                        d = new Double((d4 + d3) / 2.0);
                                    }
                                    catch (Exception exception2) {}
                                }
                            } else {
                                int n6;
                                int n7;
                                n3 = string6.indexOf("[");
                                if (n3 != -1 && (n7 = string6.indexOf(",")) != -1 && (n6 = string6.indexOf("]")) != -1) {
                                    string3 = string6.substring(n3 + 1, n7);
                                    object = string6.substring(n7 + 1, n6);
                                    try {
                                        double d5 = Double.parseDouble(string3);
                                        d3 = Double.parseDouble((String)object);
                                        d = new Double((d5 + d3) / 2.0);
                                    }
                                    catch (Exception exception3) {
                                    }
                                }
                            }
                            var29_37 = null;
                        }
                        var29_37 = null;
                    }
                    catch (Throwable throwable) {
                        var29_37 = null;
                        throw throwable;
                    }
                }
                String string7 = resultSet.getString(centroid_mode_value);
                Object object2 = null;
                object2 = string7 != null ? string7 : d;
                ODMrComplexAttributeName oDMrComplexAttributeName = new ODMrComplexAttributeName(this, string4, string5);
                if (this.m_lookupTableMap == null) {
                    treeMap.put(oDMrComplexAttributeName, object2);
                    continue;
                }
                String string8 = string4;
                string3 = (String)this.m_lookupTableMap.get(string8);
                if (string3 != null) {
                    object = new ODMrComplexAttributeName(this, string3, string5);
                    treeMap.put((ODMrComplexAttributeName)object, object2);
                    continue;
                }
                treeMap.put(oDMrComplexAttributeName, object2);
            }
            Object var31_39 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block39;
            }
            catch (SQLException sQLException) {}
            break block39;
            {
                catch (SQLException sQLException) {
                    treeMap = null;
                    this.getConnection().createRuntimeException("2002", new Object[]{string}, null);
                    Object var31_40 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        break block39;
                    }
                    catch (SQLException sQLException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var31_41 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return treeMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCentroidQueryDecode(java.sql.Connection connection, String string, String string2) {
        OraConnection oraConnection = this.getConnection();
        boolean bl = oraConnection.is102();
        String string3 = null;
        MiningAlgorithm miningAlgorithm = this.getMiningAlgorithm();
        if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
            if (!this.isEucledian()) return this.getQuery(string, string2, bl);
            return MessageFormat.format(GetCentroidKmeans.getCentroidKmeans(bl), ((OraNormalizeTransform)this.m_buildTransform).getNormalizationDefinitionTable());
        }
        String string4 = ((OraBinningTransform)this.m_buildTransform).getNumericalBinTable();
        String string5 = ((OraBinningTransform)this.m_buildTransform).getCategoricalBinTable();
        boolean bl2 = DMEMetadata.isTableEmpty(connection, string4);
        boolean bl3 = DMEMetadata.isTableEmpty(connection, string5);
        if (!bl3 && !bl2) {
            string3 = QRY_DECODE_GET_CENTROID_OC_VIEW + MessageFormat.format(QRY_DECODE_GET_CENTROID_OC, ((OraBinningTransform)this.m_buildTransform).getNumericalBinTable(), ((OraBinningTransform)this.m_buildTransform).getCategoricalBinTable());
        }
        if (bl3 && bl2) {
            return this.getQuery(GetCentroidAll.getCentroidAll(bl), null, bl);
        }
        if (bl3) {
            return QRY_DECODE_GET_CENTROID_OC_VIEW + MessageFormat.format(QRY_DECODE_GET_CENTROID_OC_NUM, ((OraBinningTransform)this.m_buildTransform).getNumericalBinTable());
        }
        if (!bl2) return string3;
        return MessageFormat.format(QRY_DECODE_GET_CENTROID_OC_CAT, ((OraBinningTransform)this.m_buildTransform).getCategoricalBinTable());
    }

    private boolean isEucledian() {
        OraKMeansSettings oraKMeansSettings;
        ClusteringDistanceFunction clusteringDistanceFunction = null;
        ClusteringSettings clusteringSettings = (ClusteringSettings)this.getBuildSettings();
        AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
        return algorithmSettings instanceof OraKMeansSettings && (clusteringDistanceFunction = (oraKMeansSettings = (OraKMeansSettings)algorithmSettings).getDistanceFunction()).equals(ClusteringDistanceFunction.euclidean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Predicate getSplitPredicate(int n) throws JDMException {
        OraCompoundPredicate oraCompoundPredicate;
        block30: {
            Object object;
            TreeMap treeMap;
            Object object2;
            Iterator iterator;
            Set set;
            Object object3;
            if (!this.m_splitRules.isEmpty()) {
                return (OraCompoundPredicate)this.m_splitRules.get(new Integer(n));
            }
            String string = this.getName();
            java.sql.Connection connection = this.getDatabaseConnection();
            oraCompoundPredicate = null;
            String string2 = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            int n2 = 1;
            String string3 = "";
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
            boolean bl = false;
            boolean bl2 = false;
            if (this.m_buildTransform != null) {
                String string4 = ((OraBinningTransform)this.m_buildTransform).getNumericalBinTable();
                object3 = ((OraBinningTransform)this.m_buildTransform).getCategoricalBinTable();
                bl = DMEMetadata.isTableEmpty(connection, string4);
                bl2 = DMEMetadata.isTableEmpty(connection, (String)object3);
                string3 = bl2 && bl ? QRY_GET_SPLIT_PREDICATE : (bl2 ? MessageFormat.format(QRY_DECODE_GET_SPLIT_PREDICATE_NUM, string4) : (bl ? MessageFormat.format(QRY_DECODE_GET_SPLIT_PREDICATE_CAT, object3) : MessageFormat.format(QRY_DECODE_GET_SPLIT_PREDICATE_BOTH, string4, object3)));
            } else {
                string3 = QRY_GET_SPLIT_PREDICATE;
            }
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(n2++, string);
            preparedStatement.setNull(n2++, 4);
            preparedStatement.setNull(n2++, 12);
            preparedStatement.setInt(n2++, 0);
            preparedStatement.setInt(n2++, 0);
            preparedStatement.setInt(n2++, 1);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                int n3 = resultSet.getInt(cluster_id);
                string2 = resultSet.getString(attribute_name);
                object3 = resultSet.getString(conditional_operator);
                double d = resultSet.getDouble(attribute_num_value);
                set = resultSet.wasNull() ? null : new Double(d);
                iterator = resultSet.getString(attribute_str_value);
                object2 = new Integer(n3);
                treeMap = (TreeMap)hashtable.get(object2);
                if (treeMap == null) {
                    treeMap = new TreeMap();
                    hashtable.put(object2, treeMap);
                }
                if ((object = (InternalData)treeMap.get(string2)) == null) {
                    if (this.m_buildTransform == null) {
                        treeMap.put(string2, new InternalData(OraPLSQLMappings.getComparisonOperator((String)object3), (Double)((Object)set), (String)((Object)iterator)));
                        continue;
                    }
                    if (!bl) {
                        treeMap.put(string2, new InternalData(OraPLSQLMappings.getComparisonOperator((String)object3), (Double)((Object)set), (String)((Object)iterator)));
                        continue;
                    }
                    treeMap.put(string2, new InternalData(OraPLSQLMappings.getComparisonOperator((String)object3), null, (String)((Object)iterator)));
                    continue;
                }
                ((InternalData)object).addCatValue((String)((Object)iterator));
            }
            if (!hashtable.isEmpty()) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    object3 = (Integer)enumeration.nextElement();
                    TreeMap treeMap2 = (TreeMap)hashtable.get(object3);
                    if (treeMap2.isEmpty()) continue;
                    Vector<Object> vector = new Vector<Object>();
                    set = treeMap2.keySet();
                    iterator = set.iterator();
                    if (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        treeMap = (InternalData)treeMap2.get(object2);
                        if (((InternalData)((Object)treeMap)).numericalValue == null && null == ((InternalData)((Object)treeMap)).getCategories()) continue;
                        object = new OraSimplePredicate(this.getConnection(), (String)object2, ((InternalData)((Object)treeMap)).compOperator, ((InternalData)((Object)treeMap)).numericalValue, ((InternalData)((Object)treeMap)).getCategories());
                        vector.add(object);
                    }
                    oraCompoundPredicate = new OraCompoundPredicate(this.getConnection(), vector.toArray(new SimplePredicate[vector.size()]), BooleanOperator.and);
                    this.m_splitRules.put(object3, oraCompoundPredicate);
                }
            }
            oraCompoundPredicate = (OraCompoundPredicate)this.m_splitRules.get(new Integer(n));
            Object var23_26 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block30;
            }
            catch (SQLException sQLException) {}
            break block30;
            {
                catch (SQLException sQLException) {
                    System.out.println("Failed Operation: OraClusteringModel.getSplitPredicate: cluster id:" + n + ": Attribute name:" + string2 + " reason: " + sQLException.toString());
                    oraCompoundPredicate = null;
                    this.getConnection().createRuntimeException("2002", new Object[]{string}, null);
                    Object var23_27 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        break block30;
                    }
                    catch (SQLException sQLException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var23_28 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return oraCompoundPredicate;
    }

    public void clearRules() {
    }

    public Collection getMostRelevantRules(int n) throws JDMException {
        return this.internalGetMostRelevantRules(n);
    }

    /*
     * Loose catch block
     */
    private synchronized Collection internalGetMostRelevantRules(int n) throws JDMException {
        TreeMap<Integer, ODMrOraClusterRule> treeMap;
        block23: {
            Object object;
            treeMap = null;
            String string = this.getName();
            OraConnection oraConnection = this.getConnection();
            boolean bl = oraConnection.is102();
            java.sql.Connection connection = oraConnection.getDatabaseConnection();
            MiningAlgorithm miningAlgorithm = this.getMiningAlgorithm();
            int n2 = 1;
            if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
                n2 = 0;
            }
            ClusteringDistanceFunction clusteringDistanceFunction = null;
            ClusteringSettings clusteringSettings = (ClusteringSettings)this.getBuildSettings();
            AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
            String string2 = null;
            if (algorithmSettings instanceof OraKMeansSettings) {
                object = (OraKMeansSettings)algorithmSettings;
                clusteringDistanceFunction = ((OraKMeansSettings)object).getDistanceFunction();
                string2 = "km";
            } else {
                string2 = "oc";
            }
            object = null;
            ResultSet resultSet = null;
            int n3 = 1;
            String string3 = MessageFormat.format(bl ? QRY_MOST_RELEVANT_RULES : QRY_MOST_RELEVANT_RULES_11G, string2, String.valueOf(n));
            object = connection.prepareStatement(string3);
            object.setString(n3++, string);
            resultSet = object.executeQuery();
            while (resultSet.next()) {
                ODMrOraClusterRule oDMrOraClusterRule;
                int n4 = resultSet.getInt(rule_id);
                double d = resultSet.getDouble(rule_support);
                double d2 = resultSet.getDouble(rule_confidence);
                long l = resultSet.getInt(record_count);
                String string4 = resultSet.getString(attribute_name);
                String string5 = null;
                if (!bl && (string5 = resultSet.getString(attribute_subname)) != null) {
                    string4 = string4 + "." + string5;
                }
                int n5 = resultSet.getInt(dense_rank);
                if (treeMap == null) {
                    treeMap = new TreeMap<Integer, ODMrOraClusterRule>();
                }
                if ((oDMrOraClusterRule = (ODMrOraClusterRule)treeMap.get(new Integer(n4))) != null) {
                    oDMrOraClusterRule.addAttributeName(string4, n5);
                    continue;
                }
                ODMrOraClusterRule oDMrOraClusterRule2 = new ODMrOraClusterRule(this.getConnection(), string, n2, n4, n4, d / (double)l, d2, this.m_buildTransform, clusteringDistanceFunction);
                oDMrOraClusterRule2.addAttributeName(string4, n5);
                treeMap.put(new Integer(n4), oDMrOraClusterRule2);
            }
            Object var30_27 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (object != null) {
                    object.close();
                }
                break block23;
            }
            catch (SQLException sQLException) {}
            break block23;
            {
                catch (SQLException sQLException) {
                    if (treeMap != null) {
                        treeMap.clear();
                    }
                    throw new JDMException();
                }
            }
            catch (Throwable throwable) {
                Object var30_28 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return treeMap.values();
    }

    public String getQuery(String string, String string2, boolean bl) {
        String string3 = null;
        MiningAlgorithm miningAlgorithm = this.getMiningAlgorithm();
        string3 = true == miningAlgorithm.equals(MiningAlgorithm.kMeans) ? MessageFormat.format(string.replaceAll("'", "''"), KMeansDetails.getKmeansDetails(bl)) : MessageFormat.format(string.replaceAll("'", "''"), OCLUSTER_DETAILS);
        String string4 = null;
        string4 = string2 != null ? MessageFormat.format(string3.replaceAll("'", "''"), string2) : MessageFormat.format(string3.replaceAll("'", "''"), "");
        return string4;
    }

    String getMappedvalue(String string) {
        if (this.m_lookupTableMap == null) {
            return string;
        }
        String string2 = (String)this.m_lookupTableMap.get(string);
        return string2 != null ? string2 : string;
    }

    private class InternalData {
        ComparisonOperator compOperator;
        Double numericalValue;
        Vector catValues = new Vector();

        InternalData(ComparisonOperator comparisonOperator, Double d, String string) {
            this.compOperator = comparisonOperator;
            this.numericalValue = d;
            this.addCatValue(string);
        }

        void addCatValue(String string) {
            if (string != null) {
                this.catValues.add(string);
            }
        }

        Object[] getCategories() {
            if (this.catValues.isEmpty()) {
                return null;
            }
            return this.catValues.toArray(new Object[this.catValues.size()]);
        }
    }

    private static class GetCentroidKmeans {
        private static String _QRY_DECODE_GET_CENTROID_KM = "WITH label_view as ( \n SELECT col, shift, scale FROM {0} )\nSELECT \n  cd.attribute_name               attribute_name,\n  (cd.mean*l.scale)+l.shift centroid_mean,\n  cd.mode_value                   centroid_mode_value \nFROM (SELECT * \n FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?))) a \n ,TABLE(a.centroid) cd, label_view l \nWHERE cd.attribute_name = l.col (+)  ";
        private static String _QRY_DECODE_GET_CENTROID_KM_11G = "WITH label_view as ( SELECT col, shift, scale FROM {0} ) \nSELECT \n    cd.attribute_name               attribute_name,\n    cd.attribute_subname            attribute_subname,\n    (cd.mean*l.scale)+l.shift centroid_mean,\n    cd.mode_value                   centroid_mode_value \nFROM (SELECT * \n    FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?, ?))) a \n ,TABLE(a.centroid) cd, label_view l \nWHERE NVL(cd.attribute_subname,cd.attribute_name) = l.col (+)";

        private GetCentroidKmeans() {
        }

        private static String getCentroidKmeans(boolean bl) {
            return bl ? _QRY_DECODE_GET_CENTROID_KM : _QRY_DECODE_GET_CENTROID_KM_11G;
        }
    }

    private static class KMeansDetails {
        private static String _KMEANS_DETAILS = "  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?)) {0} ) a ";
        private static String _KMEANS_DETAILS_11G = "  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?, ?)) {0} ) a ";

        private KMeansDetails() {
        }

        private static String getKmeansDetails(boolean bl) {
            return bl ? _KMEANS_DETAILS : _KMEANS_DETAILS_11G;
        }
    }

    private static class GetCentroidAll {
        private static String _QRY_GET_CENTROID_ALL = "SELECT     cd.attribute_name               attribute_name,    cd.mean                         centroid_mean,    cd.mode_value                   centroid_mode_value FROM (SELECT *  {0}  ,TABLE(a.centroid) cd ";
        private static String _QRY_GET_CENTROID_ALL_11G = "SELECT     cd.attribute_name               attribute_name,    cd.attribute_subname            attribute_subname,    cd.mean                         centroid_mean,    cd.mode_value                   centroid_mode_value FROM (SELECT *  {0}  ,TABLE(a.centroid) cd ";

        private GetCentroidAll() {
        }

        private static String getCentroidAll(boolean bl) {
            return bl ? _QRY_GET_CENTROID_ALL : _QRY_GET_CENTROID_ALL_11G;
        }
    }
}

