/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.data.AttributeType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.IntervalClosure;
import javax.datamining.data.ModelSignature;
import javax.datamining.data.SignatureAttribute;
import javax.datamining.statistics.AttributeStatisticsSet;
import javax.datamining.statistics.AttributeStatisticsSetCapability;
import javax.datamining.statistics.UnivariateStatistics;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrComplexAttributeName;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraClusteringModel;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraUnivariateStatistics;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettings;
import oracle.dmt.jdm.clustering.OraClusteringSignatureAttribute;
import oracle.dmt.jdm.data.OraCategorySet;
import oracle.dmt.jdm.data.OraInterval;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;

public class ODMrOraAttributeStatisticsSet
extends OraDMObject
implements AttributeStatisticsSet {
    private static String QRY_CLUSTER_HISTOGRAM_ATTRIBUTE = "SELECT          hg.bin_id                       hist_bin_id,         hg.lower_bound                  hist_lower_bound,         hg.upper_bound                  hist_upper_bound,         hg.label                        hist_label,         hg.count                        hist_frequency FROM (SELECT *  {0}   ,TABLE(a.histogram) hg   ORDER by hist_bin_id";
    private static String ORDER_BY_ID = "ORDER BY id";
    private static String QRY_DECODE_CLUSTER_HISTOGRAM_OC_NUM = "    FROM {0} ) ) SELECT  hg.attribute_name               hist_attribute_name,  hg.bin_id                       hist_bin_id,  hg.lower_bound                  hist_lower_bound,  hg.upper_bound                  hist_upper_bound,   NVL((select label from label_view l where hg.bin_id=l.bin and   l.col=hg.attribute_name), hg.label ) hist_label,  hg.count                        hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col AND hg.bin_id = l.bin order by hist_attribute_name, hist_bin_id ";
    private static String QRY_DECODE_CLUSTER_HISTOGRAM_OC_CAT = " WITH label_view as ( SELECT col, bin, val FROM {0} ) SELECT  hg.attribute_name               hist_attribute_name,  hg.bin_id                       hist_bin_id,  hg.lower_bound                  hist_lower_bound,  hg.upper_bound                  hist_upper_bound,  NVL( val,                        hg.label) hist_label,  hg.count                        hist_frequency   FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_oc(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col AND hg.label = l.bin  ORDER BY hg.label, hist_bin_id ";
    private static final String hist_bin_id = "hist_bin_id";
    private static final String hist_lower_bound = "hist_lower_bound";
    private static final String hist_upper_bound = "hist_upper_bound";
    private static final String hist_label = "hist_label";
    private static final String hist_frequency = "hist_frequency";
    private OraTransformation m_buildTransform;
    private Hashtable m_attrStatisticsMap = new Hashtable();
    private ModelSignature m_modelSignature;
    private int m_clusterId;
    private String m_modelName;
    private ODMrOraClusteringModel m_model;
    private Hashtable m_numAttributeMap;
    private Hashtable m_catAttributeMap;
    private TreeMap m_signMap = new TreeMap();
    private static String QRY_MODEL_SIGNATURE = "SELECT attribute_name, attribute_type  FROM USER_MINING_MODEL_ATTRIBUTES WHERE MODEL_NAME = ? ORDER BY ATTRIBUTE_NAME ASC";
    private static final String attribute_name = "attribute_name";
    private static final String attribute_type = "attribute_type";

    public ODMrOraAttributeStatisticsSet(OraConnection oraConnection, ODMrOraClusteringModel oDMrOraClusteringModel, ModelSignature modelSignature, String string, int n, OraTransformation oraTransformation) {
        super(oraConnection, null);
        this.m_modelSignature = modelSignature;
        this.m_modelName = string;
        this.m_clusterId = n;
        this.m_buildTransform = oraTransformation;
        this.m_model = oDMrOraClusteringModel;
    }

    private boolean isCategoricallyBinned(Connection connection, String string) {
        if (this.m_catAttributeMap != null) {
            return null != this.m_catAttributeMap.get(string);
        }
        this.m_catAttributeMap = this.isBinned(connection, string, false);
        if (this.m_catAttributeMap == null) {
            return false;
        }
        return null != this.m_catAttributeMap.get(string);
    }

    private boolean isNumericallyBinned(Connection connection, String string) {
        if (this.m_numAttributeMap != null) {
            return null != this.m_numAttributeMap.get(string);
        }
        this.m_numAttributeMap = this.isBinned(connection, string, true);
        if (this.m_numAttributeMap == null) {
            return false;
        }
        return null != this.m_numAttributeMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Hashtable isBinned(Connection connection, String string, boolean bl) {
        Hashtable<String, String> hashtable;
        block11: {
            hashtable = null;
            String string2 = "SELECT distinct COL FROM " + this.getXformTableName(bl);
            Statement statement = null;
            ResultSet resultSet = null;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>();
                }
                hashtable.put(string3, string3);
            }
            Object var10_10 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    System.out.println(exception);
                    if (hashtable != null) {
                        hashtable.clear();
                        hashtable = null;
                    }
                    Object var10_11 = null;
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return hashtable;
    }

    public UnivariateStatistics getStatistics(String string) throws JDMException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UnivariateStatistics getStatistics(ODMrComplexAttributeName oDMrComplexAttributeName) throws JDMException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        UnivariateStatistics univariateStatistics;
        block38: {
            int n;
            boolean bl;
            AttributeType attributeType;
            SignatureAttribute signatureAttribute;
            Vector<HistogramPoint> vector;
            String string;
            block36: {
                Comparable<Double> comparable;
                string = oDMrComplexAttributeName.getAttributeName();
                univariateStatistics = (UnivariateStatistics)this.m_attrStatisticsMap.get(oDMrComplexAttributeName.toString());
                if (univariateStatistics != null) {
                    return univariateStatistics;
                }
                vector = new Vector<HistogramPoint>();
                OraConnection oraConnection = this.getConnection();
                boolean bl2 = oraConnection.is102();
                Connection connection = this.getDatabaseConnection();
                signatureAttribute = this.m_modelSignature.getAttribute(string);
                attributeType = signatureAttribute.getAttributeType();
                bl = false;
                String string2 = "";
                if (this.m_buildTransform != null) {
                    if (this.m_buildTransform instanceof OraNormalizeTransform) {
                        comparable = this.getScale(connection, string);
                        string2 = comparable != null && (Double)comparable != 0.0 ? this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, true) : this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID, bl2);
                    } else {
                        if (!(this.m_buildTransform instanceof OraBinningTransform)) throw new JDMException();
                        if (this.isNumericallyBinned(connection, string)) {
                            string2 = this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, true);
                            bl = true;
                        } else if (this.isCategoricallyBinned(connection, string)) {
                            string2 = this.getHistogramQueryDecode(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, null, false);
                            bl = true;
                        } else {
                            string2 = this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID, bl2);
                        }
                    }
                } else {
                    string2 = this.m_model.getQuery(QRY_CLUSTER_HISTOGRAM_ATTRIBUTE, ORDER_BY_ID);
                }
                comparable = this.m_model.getMiningAlgorithm();
                boolean bl3 = true == ((Enum)comparable).equals(MiningAlgorithm.kMeans);
                preparedStatement = null;
                resultSet = null;
                int n2 = 1;
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(n2++, this.m_modelName);
                preparedStatement.setInt(n2++, this.m_clusterId);
                preparedStatement.setString(n2++, string);
                preparedStatement.setInt(n2++, 0);
                preparedStatement.setInt(n2++, 1);
                preparedStatement.setInt(n2++, 0);
                if (!bl2 && bl3) {
                    if (oDMrComplexAttributeName.getAttributeSubName() != null) {
                        preparedStatement.setString(n2, oDMrComplexAttributeName.getAttributeSubName());
                    } else {
                        preparedStatement.setNull(n2, 12);
                    }
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = resultSet.getInt(hist_bin_id);
                    double d = resultSet.getDouble(hist_lower_bound);
                    Double d2 = resultSet.wasNull() ? null : new Double(d);
                    double d3 = resultSet.getDouble(hist_upper_bound);
                    Double d4 = resultSet.wasNull() ? null : new Double(d3);
                    String string3 = resultSet.getString(hist_label);
                    double d5 = resultSet.getDouble(hist_frequency);
                    HistogramPoint histogramPoint = new HistogramPoint(n, d2, d4, string3, d5);
                    vector.add(histogramPoint);
                }
                if (!vector.isEmpty()) break block36;
                UnivariateStatistics univariateStatistics2 = univariateStatistics;
                Object var29_32 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (preparedStatement == null) return univariateStatistics2;
                    preparedStatement.close();
                    return univariateStatistics2;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return univariateStatistics2;
            }
            n = vector.size();
            double[] dArray = new double[n];
            if (attributeType.equals(AttributeType.numerical) && !bl) {
                OraInterval[] oraIntervalArray = new OraInterval[n];
                for (int i = 0; i < n; ++i) {
                    HistogramPoint histogramPoint = (HistogramPoint)vector.elementAt(i);
                    oraIntervalArray[i] = new OraInterval(this.getConnection(), histogramPoint.dLowerBound != null ? histogramPoint.dLowerBound : 0.0, histogramPoint.dUpperBound != null ? histogramPoint.dUpperBound : 0.0, IntervalClosure.closedClosed);
                    dArray[i] = histogramPoint.value;
                }
                univariateStatistics = new ODMrOraUnivariateStatistics(this.getConnection(), string, signatureAttribute, oraIntervalArray, dArray, bl);
            } else {
                OraCategorySet oraCategorySet = new OraCategorySet(this.getConnection(), signatureAttribute.getDataType());
                for (int i = 0; i < n; ++i) {
                    HistogramPoint histogramPoint = (HistogramPoint)vector.elementAt(i);
                    oraCategorySet.addCategory(histogramPoint.label, CategoryProperty.valid);
                    dArray[i] = histogramPoint.value;
                }
                univariateStatistics = new ODMrOraUnivariateStatistics(this.getConnection(), string, signatureAttribute, oraCategorySet, dArray, bl);
            }
            if (univariateStatistics == null) break block38;
            this.addAttributeStatistics(string, univariateStatistics);
        }
        Object var29_33 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (preparedStatement == null) return univariateStatistics;
            preparedStatement.close();
            return univariateStatistics;
        }
        catch (SQLException sQLException) {}
        return univariateStatistics;
        {
            catch (SQLException sQLException) {
                System.out.println(sQLException);
                sQLException.printStackTrace();
                Object var29_34 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                try {
                    if (preparedStatement == null) return univariateStatistics;
                    preparedStatement.close();
                    return univariateStatistics;
                }
                catch (SQLException sQLException2) {}
                return univariateStatistics;
            }
        }
        catch (Throwable throwable) {
            Object var29_35 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (preparedStatement == null) throw throwable;
                preparedStatement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void addAttributeStatistics(String string, UnivariateStatistics univariateStatistics) {
        this.m_attrStatisticsMap.put(string, univariateStatistics);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getHistogramQueryDecode(String string, String string2, boolean bl) {
        OraConnection oraConnection = this.getConnection();
        boolean bl2 = oraConnection.is102();
        String string3 = null;
        MiningAlgorithm miningAlgorithm = this.m_model.getMiningAlgorithm();
        UserPreferences userPreferences = UserPreferences.getInstance();
        boolean bl3 = true;
        int n = 4;
        if (userPreferences.getClusterDetailsPrecisionOption()) {
            bl3 = true;
            n = userPreferences.getClusterDetailsPrecisionDegree();
        } else {
            bl3 = false;
        }
        if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
            if (!this.isEucledian()) return this.m_model.getQuery(string, string2, bl2);
            return MessageFormat.format(DecodeHistogramKmeans.getDecodeHistogramKmeans(bl2), this.getNormTableName());
        }
        if (!bl3) return (bl ? ODMrOraClusteringModel.DECODE_VIEW : "") + MessageFormat.format(bl ? QRY_DECODE_CLUSTER_HISTOGRAM_OC_NUM : QRY_DECODE_CLUSTER_HISTOGRAM_OC_CAT, this.getXformTableName(bl));
        return (bl ? MessageFormat.format(ODMrOraClusteringModel.DECODE_VIEW_ROUNDED, String.valueOf(n)) : "") + MessageFormat.format(bl ? QRY_DECODE_CLUSTER_HISTOGRAM_OC_NUM : QRY_DECODE_CLUSTER_HISTOGRAM_OC_CAT, this.getXformTableName(bl));
    }

    private boolean isEucledian() {
        OraKMeansSettings oraKMeansSettings;
        ClusteringDistanceFunction clusteringDistanceFunction = null;
        ClusteringSettings clusteringSettings = (ClusteringSettings)this.m_model.getBuildSettings();
        AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
        return algorithmSettings instanceof OraKMeansSettings && (clusteringDistanceFunction = (oraKMeansSettings = (OraKMeansSettings)algorithmSettings).getDistanceFunction()).equals(ClusteringDistanceFunction.euclidean);
    }

    private String getNormTableName() {
        if (this.m_buildTransform instanceof OraNormalizeTransform) {
            return ((OraNormalizeTransform)this.m_buildTransform).getNormalizationDefinitionTable();
        }
        return "";
    }

    private String getXformTableName(boolean bl) {
        if (!(this.m_buildTransform instanceof OraBinningTransform)) {
            return "";
        }
        return bl ? ((OraBinningTransform)this.m_buildTransform).getNumericalBinTable() : ((OraBinningTransform)this.m_buildTransform).getCategoricalBinTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Double getScale(Connection connection, String string) throws JDMException {
        BigDecimal bigDecimal;
        block20: {
            ResultSet resultSet;
            Statement statement;
            block18: {
                statement = null;
                resultSet = null;
                bigDecimal = null;
                String string2 = "select SCALE from " + ((OraNormalizeTransform)this.m_buildTransform).getNormalizationDefinitionTable() + " where COL = ?";
                statement = connection.prepareCall(string2);
                statement.setString(1, string.toUpperCase());
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block18;
                bigDecimal = resultSet.getBigDecimal(1);
            }
            Object var8_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block20;
            }
            catch (SQLException sQLException) {}
            break block20;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var8_9 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block20;
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bigDecimal != null ? new Double(bigDecimal.doubleValue()) : null;
    }

    private SignatureAttribute getAttribute(String string) throws JDMException {
        if (this.m_signMap.isEmpty()) {
            this.getAttributes();
        }
        return (SignatureAttribute)this.m_signMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getAttributes() {
        block20: {
            Connection connection = this.getDatabaseConnection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            int n = 1;
            preparedStatement = connection.prepareStatement(QRY_MODEL_SIGNATURE);
            preparedStatement.setString(n++, this.m_modelName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(attribute_name);
                String string2 = resultSet.getString(attribute_type);
                OraClusteringSignatureAttribute oraClusteringSignatureAttribute = new OraClusteringSignatureAttribute(this.getConnection(), string, OraPLSQLMappings.getAttributeType(string2), OraPLSQLMappings.getAttributeDataType(string2), this.m_model.getMiningAlgorithm());
                this.m_signMap.put(oraClusteringSignatureAttribute.getName(), oraClusteringSignatureAttribute);
            }
            Object var9_9 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block20;
            }
            catch (SQLException sQLException) {}
            break block20;
            {
                catch (Exception exception) {
                    this.getConnection().createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, exception, "3517", new Object[]{this.m_modelName});
                    Object var9_10 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        break block20;
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public Date getStatisticsTimestamp() {
        return null;
    }

    public boolean supportsCapabiltiy(AttributeStatisticsSetCapability attributeStatisticsSetCapability) throws JDMException {
        return true;
    }

    public long getNumberOfCases() {
        return 0L;
    }

    public Collection getStatistics() throws JDMException {
        Vector vector = new Vector();
        Enumeration enumeration = this.m_attrStatisticsMap.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    class HistogramPoint {
        int binId;
        Double dLowerBound;
        Double dUpperBound;
        String label;
        double value;

        HistogramPoint(int n, Double d, Double d2, String string, double d3) {
            this.binId = n;
            this.dLowerBound = d;
            this.dUpperBound = d2;
            this.label = string;
            this.value = d3;
        }
    }

    private static class DecodeHistogramKmeans {
        private static String _QRY_DECODE_CLUSTER_HISTOGRAM_KM = "WITH label_view as (  SELECT col, shift, scale     FROM {0} ) SELECT  hg.attribute_name                hist_attribute_name,  hg.bin_id                        hist_bin_id,  (hg.lower_bound*l.scale)+l.shift hist_lower_bound, (hg.upper_bound*l.scale)+l.shift hist_upper_bound, (TO_NCHAR( ((hg.lower_bound*l.scale)+l.shift), '''9.99EEEE''' ) || ''':''' || TO_NCHAR( ((hg.upper_bound*l.scale)+l.shift), '''9.99EEEE''' ) ) hist_label,  hg.count                         hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col (+)   ORDER by hist_bin_id";
        private static String _QRY_DECODE_CLUSTER_HISTOGRAM_KM_11G = "WITH label_view as (  SELECT col, shift, scale     FROM {0} ) SELECT  hg.attribute_name                hist_attribute_name,  hg.bin_id                        hist_bin_id,  (hg.lower_bound*l.scale)+l.shift hist_lower_bound, (hg.upper_bound*l.scale)+l.shift hist_upper_bound, (TO_NCHAR( ((hg.lower_bound*l.scale)+l.shift), '''9.99EEEE''' ) || ''':''' || TO_NCHAR( ((hg.upper_bound*l.scale)+l.shift), '''9.99EEEE''' ) ) hist_label,  hg.count                         hist_frequency  FROM (SELECT *  FROM TABLE(dbms_data_mining.get_model_details_km(?, ?, ?, ?, ?, ?, ?))) a  ,TABLE(a.histogram) hg  ,label_view l  WHERE hg.attribute_name = l.col (+)   ORDER by hist_bin_id";

        private DecodeHistogramKmeans() {
        }

        private static String getDecodeHistogramKmeans(boolean bl) {
            return bl ? _QRY_DECODE_CLUSTER_HISTOGRAM_KM : _QRY_DECODE_CLUSTER_HISTOGRAM_KM_11G;
        }
    }
}

