/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.util.TreeMap;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.rule.Predicate;
import javax.datamining.statistics.AttributeStatisticsSet;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraClusteringModel;
import oracle.dmt.jdm.clustering.OraCluster;

public class ODMrCluster {
    OraCluster m_jdmCluster;
    ODMrOraClusteringModel m_model;
    private Boolean m_bLeaf = null;
    private TreeMap m_centroids;
    private Predicate m_splitPredicate;

    public ODMrCluster(ClusteringModel clusteringModel, Cluster cluster) {
        this.m_model = (ODMrOraClusteringModel)clusteringModel;
        this.m_jdmCluster = (OraCluster)cluster;
    }

    public AttributeStatisticsSet getStatistics() throws JDMException {
        return this.m_model.getAttributeStatisticsSet(this.m_jdmCluster.getClusterId());
    }

    public Cluster getJDmCluster() {
        return this.m_jdmCluster;
    }

    public boolean isLeaf() {
        if (this.m_bLeaf == null) {
            this.m_bLeaf = new Boolean(this.m_jdmCluster.isLeaf());
        }
        return this.m_bLeaf;
    }

    public long getCaseCount() {
        return this.m_jdmCluster.getCaseCount();
    }

    public TreeMap getCentroids() throws JDMException {
        if (this.m_centroids == null) {
            this.m_centroids = this.m_model.getCentroids(this.m_jdmCluster.getClusterId());
        }
        return this.m_centroids;
    }

    public Predicate getSplitPredicate() {
        if (this.m_splitPredicate != null) {
            return this.m_splitPredicate;
        }
        MiningAlgorithm miningAlgorithm = this.m_model.getMiningAlgorithm();
        if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
            return null;
        }
        Predicate predicate = null;
        try {
            predicate = this.m_model.getSplitPredicate(this.m_jdmCluster.getClusterId());
        }
        catch (Exception exception) {
            predicate = null;
            exception.printStackTrace();
        }
        this.m_splitPredicate = predicate;
        return this.m_splitPredicate;
    }
}

