/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import javax.datamining.JDMException;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.rule.CompoundPredicate;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import javax.datamining.rule.SimplePredicate;

public class MiningClusteringRule {
    protected Rule m_src;
    protected ClusteringModel m_model;

    protected MiningClusteringRule() {
    }

    public MiningClusteringRule(ClusteringModel clusteringModel, Rule rule) {
        this.m_src = rule;
        this.m_model = clusteringModel;
    }

    public double getConfidence() {
        return this.m_src.getConfidence();
    }

    public int getRuleId() {
        return this.m_src.getRuleIdentifier();
    }

    public double getSupport() {
        Cluster cluster = null;
        long l = 1L;
        try {
            cluster = this.m_model.getCluster(this.m_src.getRuleIdentifier());
            l = cluster.getCaseCount();
        }
        catch (JDMException jDMException) {
            System.out.println(jDMException);
        }
        double d = (double)l * this.m_src.getSupport();
        return d;
    }

    public Predicate getAntecedent() {
        return this.m_src.getAntecedent();
    }

    public Predicate getConsequent() {
        return this.m_src.getConsequent();
    }

    public int getRuleLength() {
        Predicate predicate = this.m_src.getAntecedent();
        int n = 0;
        if (predicate instanceof CompoundPredicate) {
            Predicate[] predicateArray = ((CompoundPredicate)predicate).getPredicates();
            n = predicateArray != null ? predicateArray.length : 0;
        } else if (predicate instanceof SimplePredicate) {
            n = 1;
        }
        return n;
    }

    public Rule getRule() {
        return this.m_src;
    }
}

