/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.util.EventObject;
import java.util.Vector;
import javax.datamining.clustering.ClusteringModel;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringModelViewer;
import oracle.dmt.dm4j.browser.viewer.clustering.ClustersLoadedListener;
import oracle.dmt.dm4j.browser.viewer.clustering.ClustersTableModel;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class LoadClustersWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private ClusteringModel m_miningModel = null;
    private ClustersTableModel m_tableModel = null;
    private int m_columnCount = 0;
    private boolean m_leavesOnly = false;
    private ClusteringModelViewer m_viewer = null;
    private JLabel m_labelCountLeafs;

    public LoadClustersWorker(WorkerThreadManager workerThreadManager, ClusteringModelViewer clusteringModelViewer, JLabel jLabel, int n, boolean bl) {
        super(workerThreadManager);
        this.m_miningModel = clusteringModelViewer.getMiningModel();
        this.m_columnCount = n;
        this.m_leavesOnly = bl;
        this.m_viewer = clusteringModelViewer;
        this.m_labelCountLeafs = jLabel;
    }

    public void addClustersLoadedListener(ClustersLoadedListener clustersLoadedListener) {
        this.listenerList.add(ClustersLoadedListener.class, clustersLoadedListener);
    }

    public void removeClustersLoadedListener(ClustersLoadedListener clustersLoadedListener) {
        this.listenerList.remove(ClustersLoadedListener.class, clustersLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            Vector vector = this.m_viewer.getClusters();
            this.m_tableModel = new ClustersTableModel(this.m_columnCount, 0);
            this.m_tableModel.load(vector, this.m_miningModel, this.m_leavesOnly);
            this.m_labelCountLeafs.setText(DM4JNumericFormat.format(this.m_miningModel.getLeafClusters().size()));
        }
        catch (Exception exception) {
            this.m_tableModel = null;
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ClustersLoadedListener.class) continue;
            ((ClustersLoadedListener)objectArray[i + 1]).clustersLoaded(new EventObject(this.getValue()));
        }
    }
}

