/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.datamining.ComparisonOperator;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.SimplePredicate;
import oracle.bali.ewt.grid.hGrid.HArrayTwoDModel;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrCluster;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraClusteringModel;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings;

public class ClustersTableModel
extends HArrayTwoDModel {
    private ArrayList m_visibleClusters = new ArrayList();
    private Vector m_allClusters = null;
    private ClusteringModel m_miningModel = null;
    private long m_recordCount = 0L;
    private boolean m_displaySplitRules = false;
    private ResourceBundle m_res = BrowserUtils.getBundleInstance();
    static final int ROOT = 0;
    static final int SIBLING = 1;
    static final int CHILD = 2;

    public ClustersTableModel(int n, int n2) {
        super(n, n2);
    }

    public ArrayList getClusters() {
        return this.m_visibleClusters;
    }

    public long getCaseCount() {
        return this.m_recordCount;
    }

    public void load(Vector vector, ClusteringModel clusteringModel, boolean bl) throws Exception {
        this.m_allClusters = vector;
        this.m_miningModel = clusteringModel;
        ClusteringSettings clusteringSettings = (ClusteringSettings)this.m_miningModel.getBuildSettings();
        AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
        this.m_displaySplitRules = algorithmSettings instanceof OraOClusterSettings && !bl;
        this.m_visibleClusters = new ArrayList();
        if (bl) {
            this.populateLeavesOnly();
        } else {
            this.populateAll();
        }
    }

    private void populateAll() throws Exception {
        ODMrCluster oDMrCluster = ((ODMrOraClusteringModel)this.m_miningModel).getODMrCluster(1);
        this.m_recordCount = oDMrCluster.getCaseCount();
        if (null != oDMrCluster) {
            this.addRow(oDMrCluster, 0, 0);
        }
    }

    private void populateLeavesOnly() throws Exception {
        int n = 0;
        ODMrCluster oDMrCluster = ((ODMrOraClusteringModel)this.m_miningModel).getODMrCluster(1);
        this.m_recordCount = oDMrCluster.getCaseCount();
        Collection collection = this.m_miningModel.getLeafClusters();
        Iterator iterator = collection.iterator();
        int n2 = collection.size();
        this.addRootRows(0, n2);
        while (iterator.hasNext()) {
            ODMrCluster oDMrCluster2 = (ODMrCluster)iterator.next();
            this.setRowData(oDMrCluster2, n++, this.m_displaySplitRules);
        }
    }

    private void addRow(ODMrCluster oDMrCluster, int n, int n2) {
        if (2 == n2) {
            this.addChildrenRows(n++, 1);
        } else if (0 == n2) {
            this.addRootRows(n, 1);
        } else if (1 == n2) {
            n = this.addSiblingRows(n, 1);
        }
        this.setRowData(oDMrCluster, n, this.m_displaySplitRules);
        try {
            Cluster[] clusterArray = null;
            if (!oDMrCluster.isLeaf()) {
                clusterArray = oDMrCluster.getJDmCluster().getChildren();
            }
            if (null != clusterArray && 0 != clusterArray.length) {
                int n3 = n;
                for (int i = 0; i < clusterArray.length; ++i) {
                    ODMrCluster oDMrCluster2 = ((ODMrOraClusteringModel)this.m_miningModel).getODMrCluster(clusterArray[i].getClusterId());
                    if (0 == i) {
                        this.addRow(oDMrCluster2, n3++, 2);
                        continue;
                    }
                    this.addRow(oDMrCluster2, n3++, 1);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void setRowData(ODMrCluster oDMrCluster, int n, boolean bl) {
        this.setExpandedData(0, n, new Integer(oDMrCluster.getJDmCluster().getClusterId()));
        this.setExpandedData(1, n, new Long(oDMrCluster.getCaseCount()));
        if (bl) {
            Predicate predicate = oDMrCluster.getSplitPredicate();
            String string = null;
            if (null != predicate) {
                try {
                    string = BrowserUtils.getPredicateString(predicate, 0, null);
                }
                catch (Exception exception) {
                    string = this.m_res.getString("COMMON_UNKNOWN");
                }
            } else {
                string = "";
            }
            this.setExpandedData(2, n, string);
        }
        this.expandExpandedRow(n);
        this.m_visibleClusters.add(n, oDMrCluster);
    }

    private String getPredicateString(SimplePredicate simplePredicate) throws Exception {
        String string = null;
        ComparisonOperator comparisonOperator = simplePredicate.getComparisonOperator();
        String string2 = simplePredicate.getAttributeName();
        if (null == string2) {
            throw new Exception("Null attribute name encountered");
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = simplePredicate.getCategoryValues();
        if (objectArray != null && objectArray.length != 0) {
            stringBuffer.append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i].toString());
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(simplePredicate.getNumericalValue().toString());
        }
        string = string2 + " " + comparisonOperator.name() + " " + stringBuffer.toString();
        return string;
    }
}

