/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.datamining.algorithm.kmeans.KMeansSettings;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.clustering.ClusteringSettings;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.AttributeTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringModelViewer;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettings;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings;
import oracle.dmt.jdm.base.OraBuildSettings;

public class ClusteringSettingsPanel
extends GriddedPanel {
    JLabel m_modelType = new JLabel();
    JLabel m_algorithmType = new JLabel();
    JLabel m_sensitivity = new JLabel();
    JLabel m_iterations = new JLabel();
    JLabel m_tolerance = new JLabel();
    JLabel m_numOfClusters = new JLabel();
    JLabel m_distanceFunction = new JLabel();
    JLabel m_splitCriterion = new JLabel();
    JLabel m_numberOfBins = new JLabel();
    JLabel m_minimumSupport = new JLabel();
    JLabel m_blockGrowth = new JLabel();
    JLabel m_maximumBufferSize = new JLabel();
    JLabel m_automaticDataPreparation = new JLabel();
    JScrollPane m_attribPanel = new JScrollPane();
    AttributeTable m_attribTable = null;
    ClusteringModel m_model;
    ClusteringSettings m_settings = null;
    AlgorithmSettings m_algSetting;

    public ClusteringSettingsPanel(ClusteringModel clusteringModel) {
        this.m_model = clusteringModel;
        this.m_settings = (ClusteringSettings)this.m_model.getBuildSettings();
        this.m_algSetting = this.m_settings.getAlgorithmSettings();
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        Container container = this.getParent();
        if (container instanceof ClusteringModelViewer) {
            if (this.m_algSetting instanceof KMeansSettings) {
                return "CLUSTERING_KMEANS_MODEL";
            }
            return "CLUSTERING_OCLUSTER_MODEL";
        }
        if (this.m_algSetting instanceof KMeansSettings) {
            return "CLUSTERING_KMEANS_SETTING";
        }
        return "CLUSTERING_OCLUSTER_SETTING";
    }

    private void jbInit() throws Exception {
        Object object;
        Object object2;
        JComponent jComponent;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        int n = 0;
        this.m_modelType.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL"));
        this.addComponent(jLabel4, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_modelType, TOPVALUEITEMINSETS, n++, 1);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITHM_TYPE"));
        this.addComponent(jLabel5, MIDLABELITEMINSETS, n, 0);
        if (this.m_algSetting instanceof OraOClusterSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_TYPE_OCLUSTER"));
        } else if (this.m_algSetting instanceof KMeansSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_TYPE_KMEANS"));
        } else {
            throw new Exception("Unexpected algorithm setting type");
        }
        this.addComponent(this.m_algorithmType, MIDVALUEITEMINSETS, n++, 1);
        if (BrowserFrame.is11Server()) {
            jLabel3 = new JLabel();
            jLabel3.setText(DM4JResourceUtilities.getUIString("AUTOMATIC_DATA_PREPARATION"));
            this.addComponent(jLabel3, MIDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_automaticDataPreparation, MIDVALUEITEMINSETS, n++, 1);
        }
        jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
        this.addComponent(jLabel3, TOPLABELITEMINSETS, n++, 0);
        if (this.m_algSetting instanceof OraOClusterSettings) {
            jLabel2 = new JLabel();
            jLabel2.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_SENSITIVITY"));
            this.addComponent(jLabel2, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_sensitivity, MIDVALUEITEMINSETS, n++, 1);
            jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_OCLUSTER_MAXIMUM_BUFFER_SIZE"));
            this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_maximumBufferSize, MIDVALUEITEMINSETS, n++, 1);
        } else if (this.m_algSetting instanceof KMeansSettings) {
            jLabel2 = new JLabel();
            jLabel2.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_KMEANS_DISTANCE_FUNCTION"));
            this.addComponent(jLabel2, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_distanceFunction, MIDVALUEITEMINSETS, n++, 1);
            jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_KMEANS_SPLIT_CRITERION"));
            this.addComponent(jLabel, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_splitCriterion, MIDVALUEITEMINSETS, n++, 1);
            jComponent = new JLabel();
            ((JLabel)jComponent).setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_MAX_ITERATIONS"));
            this.addComponent(jComponent, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_iterations, MIDVALUEITEMINSETS, n++, 1);
            object2 = new JLabel();
            ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_MIN_ERR_TOLERANCE"));
            this.addComponent((JComponent)object2, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_tolerance, MIDVALUEITEMINSETS, n++, 1);
            object = new JLabel();
            ((JLabel)object).setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_KMEANS_NO_OF_BINS"));
            this.addComponent((JComponent)object, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_numberOfBins, MIDVALUEITEMINSETS, n++, 1);
            JLabel jLabel6 = new JLabel();
            jLabel6.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_KMEANS_MINIMUM_SUPPORT_PERCENTAGE"));
            this.addComponent(jLabel6, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_minimumSupport, MIDVALUEITEMINSETS, n++, 1);
            JLabel jLabel7 = new JLabel();
            jLabel7.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_KMEANS_BLOCK_GROWTH"));
            this.addComponent(jLabel7, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_blockGrowth, MIDVALUEITEMINSETS, n++, 1);
        }
        jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("CLUST_MODEL_MAX_NUMBER_CLUSTERS"));
        this.addComponent(jLabel2, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_numOfClusters, MIDVALUEITEMINSETS, n++, 1);
        jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_ATTRIBUTES"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_ATTRIBUTES"));
        this.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        this.m_attribTable = new AttributeTable(this.m_model);
        jComponent = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jComponent.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jComponent, MIDLABELITEMINSETS, n++, 1, 1, 1, 14);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(ClusteringSettingsPanel.this.m_attribTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_attribPanel.getViewport().add(this.m_attribTable);
        this.m_attribPanel.setPreferredSize(null);
        this.addFilledComponent(this.m_attribPanel, MIDLABELITEMINSETS, n, 0, 2, 2, 1);
        jLabel.setLabelFor(this.m_attribTable);
        object2 = new GeneralGridSelectionManager(0, 2, 0);
        this.m_attribTable.getGrid().setGridSelectionManager((GridSelectionManager)object2);
        object = new Dm4jSpreadTableExcelAdapter(this.m_attribTable);
    }

    private void runTimePanelLoad() throws Exception {
        Object object;
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(false, 10, 10);
        this.m_attribTable.load();
        if (BrowserFrame.is11Server()) {
            object = ((OraBuildSettings)((Object)this.m_settings)).useAutomatedDataPreparations() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
            this.m_automaticDataPreparation.setText((String)object);
        }
        if (this.m_algSetting instanceof OraOClusterSettings) {
            object = (OraOClusterSettings)this.m_algSetting;
            this.m_sensitivity.setText(numberFormat.format(object.getSensitivity()));
            this.m_maximumBufferSize.setText(DM4JNumericFormat.format(object.getBufferSize()));
        } else if (this.m_algSetting instanceof KMeansSettings) {
            object = (OraKMeansSettings)this.m_algSetting;
            this.m_iterations.setText(DM4JNumericFormat.format(((OraKMeansSettings)object).getMaxNumberOfIterations()));
            this.m_tolerance.setText(numberFormat.format(((OraKMeansSettings)object).getMinErrorTolerance()));
            this.m_distanceFunction.setText(((OraKMeansSettings)object).getDistanceFunction().name());
            this.m_splitCriterion.setText(((OraKMeansSettings)object).getSplitCriterion().name());
            this.m_numberOfBins.setText(DM4JNumericFormat.format(((OraKMeansSettings)object).getNumberOfBins()));
            this.m_minimumSupport.setText(numberFormat.format(((OraKMeansSettings)object).getMinPercentageAtrrSupport()));
            this.m_blockGrowth.setText(DM4JNumericFormat.format(((OraKMeansSettings)object).getBlockGrowth()));
        }
        this.m_numOfClusters.setText(DM4JNumericFormat.format(this.m_settings.getMaxNumberOfClusters()));
    }
}

