/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.datamining.JDMException;
import javax.datamining.algorithm.kmeans.KMeansSettings;
import javax.datamining.association.RuleProperty;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.resource.Connection;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.Rule;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JAccessibilityUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringModelViewer;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraClusteringModel;
import oracle.dmt.dm4j.browser.viewer.clustering.RulesTable;
import oracle.dmt.dm4j.browser.viewer.clustering.RulesTableModel;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.sort.SortDialog;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.sqlworksheet.SwingWorker;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.transform.binning.OraBinningTransformFactory;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformFactory;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformImpl;

public class ClusteringRulesPanel
extends GriddedPanel
implements VetoableChangeListener {
    private ClusteringModel m_model = null;
    private NumberTextField m_topAttributes = new NumberTextField();
    private JButton m_refreshButton = new JButton();
    private JButton m_sortButton = new JButton();
    private JCheckBox m_leafsOnlyChk = null;
    private JCheckBox m_limitTopAttrChk = null;
    private RulesTable m_rulesTable = null;
    private JTextArea m_ruleDetail = new JTextArea();
    private JScrollPane m_rulesScrollPane = new JScrollPane();
    private JButton m_exportButton;
    private boolean m_useTopAttr;
    private int m_minRelRank;
    private ClusteringModelViewer m_parent = null;
    static final int MAXNUMRULE = 10;
    static final Insets RIGHT_ANCHORED_BUTTON = new Insets(0, 0, 0, 5);
    static final Insets SORT_BUTTON = new Insets(0, 10, 5, 5);
    JButton m_transformButton = new JButton();
    boolean m_isTransformed = false;
    Hashtable m_xformTables = null;
    AlgorithmSettings m_algSetting;
    Hashtable m_lookupTableMap = null;

    public ClusteringRulesPanel(ClusteringModelViewer clusteringModelViewer, LeafNodeData leafNodeData) {
        this.m_parent = clusteringModelViewer;
        this.m_model = this.m_parent.getMiningModel();
        ClusteringSettings clusteringSettings = (ClusteringSettings)this.m_model.getBuildSettings();
        this.m_algSetting = clusteringSettings.getAlgorithmSettings();
        try {
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        ClusteringSettings clusteringSettings = (ClusteringSettings)this.m_model.getBuildSettings();
        AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
        if (algorithmSettings instanceof KMeansSettings) {
            return "CLUSTERING_KMEANS_MODEL";
        }
        return "CLUSTERING_OCLUSTER_MODEL";
    }

    private void jbInit() throws Exception {
        int n = 1;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_CRITERIA"));
        this.m_refreshButton.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_REFRESH"));
        this.m_refreshButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTER_RULES_REFRESH"));
        this.m_refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringRulesPanel.this.btnRefresh_actionPerformed(actionEvent);
            }
        });
        this.m_leafsOnlyChk = new JCheckBox(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_LEAFONLY"));
        this.m_leafsOnlyChk.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTER_RULES_LEAFONLY"));
        this.m_leafsOnlyChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringRulesPanel.this.chkLeafsOnly_actionPerformed();
            }
        });
        this.m_limitTopAttrChk = new JCheckBox(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_ATTRIBSBYRANK"));
        this.m_limitTopAttrChk.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTER_RULES_ATTRIBSBYRANK"));
        this.m_useTopAttr = this.m_limitTopAttrChk.isSelected();
        this.m_topAttributes.setDataType(Integer.TYPE);
        this.m_topAttributes.setSigned(false);
        this.m_topAttributes.setToolTipText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_MIN_RANK"));
        this.m_topAttributes.setNumber(new Integer(10));
        this.m_topAttributes.setMaximumSize(new Dimension(100, 20));
        this.m_topAttributes.setColumns(5);
        this.m_minRelRank = 10;
        this.m_rulesTable = new RulesTable(this.m_model);
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES"));
        jLabel2.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTER_RULES"));
        this.m_sortButton.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_SORT"));
        this.m_sortButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTER_RULES_SORT"));
        this.m_sortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringRulesPanel.this.btnSort_actionPerformed(actionEvent);
            }
        });
        this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(ClusteringRulesPanel.this.m_rulesTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        if (this.m_algSetting instanceof KMeansSettings) {
            this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
            this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
        } else {
            this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
            this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
        }
        this.m_rulesScrollPane.getViewport().add(this.m_rulesTable);
        this.m_rulesScrollPane.setPreferredSize(null);
        JLabel jLabel3 = new JLabel(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_DETAIL"));
        jLabel3.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTER_RULES_DETAIL"));
        this.m_ruleDetail.setEditable(false);
        this.m_ruleDetail.setLineWrap(true);
        this.m_ruleDetail.setWrapStyleWord(true);
        DM4JAccessibilityUtils.setAccessibleName(this.m_ruleDetail, DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RULES_DETAIL"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_ruleDetail);
        jLabel3.setLabelFor(jScrollPane);
        this.addAnchoredComponent(this.m_refreshButton, TOPLABELITEMINSETS, n, 0, 4, 1, 12);
        GriddedPanel griddedPanel = new GriddedPanel();
        griddedPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        griddedPanel.addFilledComponent(this.m_limitTopAttrChk, MIDLABELITEMINSETS, 0, 0, 1, 1, 2);
        griddedPanel.addFilledComponent(this.m_topAttributes, MIDLABELITEMINSETS, 0, 1, 1, 1, 0);
        griddedPanel.addFilledComponent(new JLabel(" "), MIDLABELITEMINSETS, 0, 2, 2, 1, 2);
        this.addFilledComponent(griddedPanel, TOPLABELITEMINSETS, n++, 0, 4, 1, 2);
        GriddedPanel griddedPanel2 = new GriddedPanel();
        griddedPanel2.addComponent(jLabel2, MIDLABELITEMINSETS, 0, 0, 1, 1, 16, 2);
        griddedPanel2.addComponent(this.m_leafsOnlyChk, MIDLABELITEMINSETS, 0, 1, 2, 1, 16, 2);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.m_sortButton);
        jPanel.add(this.m_transformButton);
        jPanel.add(this.m_exportButton);
        griddedPanel2.addComponent(jPanel, MIDLABELITEMINSETS, 0, 4, 3, 1, 14, 2);
        this.addFilledComponent(griddedPanel2, new Insets(5, 0, 0, 0), n++, 0, 4, 1, 2);
        this.addFilledComponent(this.m_rulesScrollPane, MIDLABELITEMINSETS, n, 0, 4, 2, 1);
        n += 2;
        this.addFilledComponent(jLabel3, TOPLABELITEMINSETS, n++, 0, 1, 1, 2);
        this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n, 0, 4, 2, 1);
        jLabel2.setLabelFor(this.m_rulesTable);
    }

    private void chkLeafsOnly_actionPerformed() {
        this.setCursor(new Cursor(3));
        this.enableUI(false);
        RulesTableModel rulesTableModel = this.m_rulesTable.getRulesTableModel();
        if (rulesTableModel == null) {
            return;
        }
        TwoDSelection twoDSelection = this.m_rulesTable.getSelection();
        int n = twoDSelection.getSingleRow();
        Rule rule = this.m_rulesTable.getMiningRule(n);
        rulesTableModel.loadCachedRules(this.m_leafsOnlyChk.isSelected());
        int n2 = this.m_rulesTable.findRule(rule);
        try {
            this.m_rulesTable.setSelection(new TwoDSelection(n2 > 0 ? n2 : 0, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.enableUI(true);
        this.setCursor(new Cursor(0));
    }

    private void m_transformButton_actionPerformed(ActionEvent actionEvent) {
        String string = this.m_transformButton.getText();
        try {
            if (this.m_algSetting instanceof KMeansSettings) {
                if (string.equals(DM4JResourceUtilities.getUIString("COMMON_SCALE"))) {
                    this.m_isTransformed = true;
                    this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
                    this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
                } else {
                    this.m_isTransformed = false;
                    this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
                    this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
                }
            } else if (string.equals(DM4JResourceUtilities.getUIString("COMMON_UNBIN"))) {
                this.m_isTransformed = true;
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_BIN"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_BIN"));
            } else {
                this.m_isTransformed = false;
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
            }
            this.updateMiningModelBuildTransformation(this.m_isTransformed);
            TwoDSelection twoDSelection = this.m_rulesTable.getSelection();
            int n = twoDSelection.getSingleRow();
            Rule rule = this.m_rulesTable.getMiningRule(n);
            this.m_rulesTable.setPrevSelectedRule(rule);
            this.m_rulesTable.load(this.m_leafsOnlyChk.isSelected(), this.m_limitTopAttrChk.isSelected(), this.m_topAttributes.getNumber().intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMiningModelBuildTransformation(boolean bl) {
        Connection connection;
        block11: {
            try {
                ((OraModel)((Object)this.m_model)).setBuildTransformation(null);
                ((ODMrOraClusteringModel)this.m_model).clearRules();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl || this.m_xformTables == null) return;
            connection = null;
            connection = DM4JConnectionManager.getConnection();
            if (this.m_algSetting instanceof KMeansSettings) {
                String string = (String)this.m_xformTables.get("XNORM");
                OraNormalizeTransformFactory oraNormalizeTransformFactory = (OraNormalizeTransformFactory)connection.getFactory("oracle.dmt.jdm.transform.normalize.OraNormalizeTransform");
                OraNormalizeTransformImpl oraNormalizeTransformImpl = (OraNormalizeTransformImpl)oraNormalizeTransformFactory.create(null, null, false, string);
                ((OraModel)((Object)this.m_model)).setBuildTransformation(oraNormalizeTransformImpl);
                break block11;
            }
            String string = (String)this.m_xformTables.get("XBINC");
            String string2 = (String)this.m_xformTables.get("XBINN");
            OraBinningTransformFactory oraBinningTransformFactory = (OraBinningTransformFactory)connection.getFactory("oracle.dmt.jdm.transform.binning.OraBinningTransform");
            OraBinningTransformImpl oraBinningTransformImpl = (OraBinningTransformImpl)oraBinningTransformFactory.create(null, null, false, string, string2);
            ((OraModel)((Object)this.m_model)).setBuildTransformation(oraBinningTransformImpl);
        }
        Object var8_12 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                Object var8_13 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runTimePanelLoad(LeafNodeData var1_1) throws Exception {
        block17: {
            this.m_xformTables = null;
            var2_2 = null;
            try {
                var2_2 = DM4JConnectionManager.getDbConnection();
                var3_3 = DMEMetadata.getInstance();
                this.m_xformTables = var3_3.getTransparencyTables(var2_2, null, this.m_model.getName());
                var5_5 = null;
                ** if (null == var2_2) goto lbl-1000
            }
            catch (Throwable var4_10) {
                var5_6 = null;
                if (null != var2_2) {
                    try {
                        var2_2.close();
                    }
                    catch (Exception var6_9) {
                        // empty catch block
                    }
                }
                throw var4_10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (Exception var6_7) {}
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (Exception var3_4) {
                    var5_5 = null;
                    if (null != var2_2) {
                        try {
                            var2_2.close();
                        }
                        catch (Exception var6_8) {}
                    }
                }
            }
        }
        if (this.m_xformTables != null) {
            this.m_isTransformed = true;
            this.m_transformButton.setEnabled(true);
            if (this.m_algSetting instanceof KMeansSettings) {
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNSCALE"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNSCALE"));
            } else {
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_BIN"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_BIN"));
            }
        } else {
            this.m_isTransformed = false;
            this.m_transformButton.setEnabled(false);
            if (this.m_algSetting instanceof KMeansSettings) {
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_SCALE"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_SCALE"));
            } else {
                this.m_transformButton.setText(DM4JResourceUtilities.getUIString("COMMON_UNBIN"));
                this.m_transformButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_UNBIN"));
            }
        }
        this.updateMiningModelBuildTransformation(this.m_isTransformed);
        this.m_transformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringRulesPanel.this.m_transformButton_actionPerformed(actionEvent);
            }
        });
        this.m_rulesTable.load(this.m_leafsOnlyChk.isSelected(), this.m_limitTopAttrChk.isSelected(), this.m_topAttributes.getNumber().intValue());
        var3_3 = this.m_rulesTable.getGrid();
        var4_11 = new GeneralGridSelectionManager(0, 1, 0);
        var3_3.setGridSelectionManager(var4_11);
        var5_5 = new Dm4jSpreadTableExcelAdapter(this.m_rulesTable);
        var4_11.addVetoableChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void btnRefresh_actionPerformed(ActionEvent actionEvent) {
        block15: {
            block14: {
                this.enableUI(false);
                try {
                    try {
                        this.setCursor(new Cursor(3));
                        int n = -1;
                        try {
                            Integer n2 = (Integer)this.m_topAttributes.getNumber();
                            if (n2 != null) {
                                n = n2;
                            }
                            if (n <= 0) {
                                throw new Exception("Negative, or blank values not allowed");
                            }
                        }
                        catch (Exception exception) {
                            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                            String string = DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER");
                            JOptionPane.showMessageDialog(this, string, DM4JVersion.getFullBrowserName(), 0);
                            this.m_topAttributes.requestFocus();
                            Object var12_12 = null;
                            this.enableUI(true);
                            this.setCursor(new Cursor(0));
                            return;
                        }
                        this.m_ruleDetail.setText("");
                        boolean bl = this.m_limitTopAttrChk.isSelected();
                        int n3 = this.m_topAttributes.getNumber().intValue();
                        if (bl == this.m_useTopAttr && n3 == this.m_minRelRank) {
                            RulesTableModel rulesTableModel = this.m_rulesTable.getRulesTableModel();
                            if (rulesTableModel == null) {
                                Object var12_13 = null;
                                this.enableUI(true);
                                break block14;
                            }
                            TwoDSelection twoDSelection = this.m_rulesTable.getSelection();
                            int n4 = twoDSelection.getSingleRow();
                            Rule rule = this.m_rulesTable.getMiningRule(n4);
                            rulesTableModel.loadCachedRules(this.m_leafsOnlyChk.isSelected());
                            int n5 = this.m_rulesTable.findRule(rule);
                            try {
                                this.m_rulesTable.setSelection(new TwoDSelection(n5 > 0 ? n5 : 0, true));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else {
                            Grid grid = this.m_rulesTable.getGrid();
                            GeneralGridSelectionManager generalGridSelectionManager = (GeneralGridSelectionManager)grid.getGridSelectionManager();
                            this.m_rulesTable = new RulesTable(this.m_model);
                            this.m_rulesScrollPane.getViewport().add(this.m_rulesTable);
                            grid = this.m_rulesTable.getGrid();
                            grid.setGridSelectionManager(generalGridSelectionManager);
                            Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_rulesTable);
                            this.m_rulesTable.displayLoadingStatus();
                            this.m_rulesTable.load(this.m_leafsOnlyChk.isSelected(), this.m_limitTopAttrChk.isSelected(), this.m_topAttributes.getNumber().intValue());
                        }
                        this.m_useTopAttr = bl;
                        this.m_minRelRank = n3;
                        break block15;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var12_15 = null;
                        this.enableUI(true);
                        this.setCursor(new Cursor(0));
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    this.enableUI(true);
                    this.setCursor(new Cursor(0));
                    throw throwable;
                }
            }
            this.setCursor(new Cursor(0));
            return;
        }
        Object var12_14 = null;
        this.enableUI(true);
        this.setCursor(new Cursor(0));
    }

    private void setDetailText(final int n) {
        final Rule rule = this.m_rulesTable.getMiningRule(n);
        if (rule != null) {
            this.m_ruleDetail.setText(DM4JResourceUtilities.getUIString("COMMON_LOADING"));
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Predicate predicate = rule.getAntecedent();
                    Predicate predicate2 = rule.getConsequent();
                    if (ClusteringRulesPanel.this.m_lookupTableMap == null) {
                        ClusteringRulesPanel.this.m_lookupTableMap = DatabaseMetadata.getODMrTextLookupTable(ClusteringRulesPanel.this.m_model.getName());
                    }
                    String string = DM4JResourceUtilities.getUIString("COMMON_RULES_IF") + "\n";
                    string = string + BrowserUtils.getAntecedentString(predicate, ClusteringRulesPanel.this.m_lookupTableMap);
                    string = string + "\n\n";
                    string = string + DM4JResourceUtilities.getUIString("COMMON_RULES_THEN") + "\n";
                    string = string + BrowserUtils.getConsequentString(predicate2, ClusteringRulesPanel.this.m_lookupTableMap);
                    string = string + "\n\n";
                    string = string + DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE") + "=" + this.toPercent(rule.getConfidence());
                    string = string + "\n";
                    Cluster cluster = null;
                    double d = 1.0;
                    try {
                        cluster = ClusteringRulesPanel.this.m_model.getCluster(rule.getRuleIdentifier());
                        d = cluster.getCaseCount();
                    }
                    catch (JDMException jDMException) {
                        System.out.println(jDMException);
                    }
                    string = string + DM4JResourceUtilities.getUIString("CLUSTER_RULES_SUPPORT") + "=" + (int)(d * rule.getSupport());
                    return string;
                }

                private String toPercent(double d) {
                    NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 2, 2);
                    BigDecimal bigDecimal = new BigDecimal(d);
                    bigDecimal = bigDecimal.setScale(2, 4);
                    String string = numberFormat.format(bigDecimal.doubleValue());
                    return string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished() {
                    try {
                        TwoDSelection twoDSelection;
                        int n2;
                        String string = (String)this.get();
                        if (string != null && (n2 = (twoDSelection = ClusteringRulesPanel.this.m_rulesTable.getSelection()).getSingleRow()) == n) {
                            ClusteringRulesPanel.this.m_ruleDetail.setText(string);
                            ClusteringRulesPanel.this.m_ruleDetail.setCaretPosition(0);
                        }
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        throw throwable;
                    }
                }
            };
            swingWorker.start();
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n2 = twoDSelection2.getSingleRow();
        int n3 = twoDSelection.getSingleRow();
        if (n2 >= 0 && n2 != n3) {
            this.setDetailText(n2);
        }
        if ((n = twoDSelection2.getRowSelection().getSelectedItemCount()) > 1) {
            this.m_ruleDetail.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void btnSort_actionPerformed(ActionEvent actionEvent) {
        block10: {
            this.enableUI(false);
            try {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    RuleProperty[] rulePropertyArray = this.m_rulesTable.getSortCriteria();
                    Boolean[] booleanArray = this.m_rulesTable.getSortOrder();
                    SortDialog sortDialog = new SortDialog(this.m_parent.getParentFrame(), SortDialog.CLUSTER, DM4JResourceUtilities.getUIString("SORT_DIALOG_TITLE"), rulePropertyArray, booleanArray);
                    if (sortDialog.isCancelled()) break block10;
                    RulesTableModel rulesTableModel = this.m_rulesTable.getRulesTableModel();
                    if (rulesTableModel == null) {
                        Object var16_8 = null;
                        this.enableUI(true);
                        return;
                    }
                    try {
                        try {
                            this.setCursor(new Cursor(3));
                            RuleProperty[] rulePropertyArray2 = sortDialog.getSortCriteria();
                            Boolean[] booleanArray2 = sortDialog.getSortCriteriaOrder();
                            TwoDSelection twoDSelection = this.m_rulesTable.getSelection();
                            int n = twoDSelection.getSingleRow();
                            Rule rule = this.m_rulesTable.getMiningRule(n);
                            rulesTableModel.sort(rulePropertyArray2, booleanArray2);
                            int n2 = this.m_rulesTable.findRule(rule);
                            this.m_rulesTable.setSelection(new TwoDSelection(n2, true));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var14_20 = null;
                            this.setCursor(new Cursor(0));
                            break block10;
                        }
                        Object var14_19 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_21 = null;
                        this.setCursor(new Cursor(0));
                        throw throwable;
                    }
                    this.setCursor(new Cursor(0));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var16_10 = null;
                    this.enableUI(true);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var16_11 = null;
                this.enableUI(true);
                throw throwable;
            }
        }
        Object var16_9 = null;
        this.enableUI(true);
    }

    private void enableUI(boolean bl) {
    }
}

