/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.Vector;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.resource.Connection;
import javax.swing.JFrame;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.BrowseResultsListPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.ModelViewer;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringClustersPanel;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringRulesPanel;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringSettingsPanel;
import oracle.dmt.dm4j.browser.viewer.results.build.BuildTaskPanel;
import oracle.dmt.jdm.clustering.OraClusteringModel;

public class ClusteringModelViewer
extends ModelViewer {
    private static int SETTING_TAB = 0;
    private static int CLUSTER_TAB = 1;
    private static int RULE_TAB = 2;
    private static int RESULT_TAB = 3;
    private static int TASK_TAB = 4;
    private int[] m_tabIndex;
    private ClusteringSettingsPanel m_clusteringSettingsPanel;
    private ClusteringClustersPanel m_clusteringClustersPanel;
    private ClusteringRulesPanel m_clusteringRulesPanel;
    private BrowseResultsListPanel m_browseResultsListPanel;
    private BuildTaskPanel m_buildTaskPanel;
    private JFrame m_parentFrame;
    private Vector m_clustersCache = null;

    public ClusteringModelViewer(JFrame jFrame, LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        super(leafNodeData, connection, n);
        this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
        this.m_parentFrame = jFrame;
    }

    public void removeNotify() {
        super.removeNotify();
        this.m_clustersCache = null;
    }

    public Vector getClusters() throws Exception {
        if (this.m_clustersCache != null) {
            return this.m_clustersCache;
        }
        OraClusteringModel oraClusteringModel = (OraClusteringModel)this.getMiningModel();
        Collection collection = oraClusteringModel.getClusters();
        this.m_clustersCache = new Vector(collection);
        return this.m_clustersCache;
    }

    public ClusteringModel getMiningModel() {
        OraClusteringModel oraClusteringModel = (OraClusteringModel)this.getNode().getOdmObject();
        return oraClusteringModel;
    }

    protected String getHelpId() {
        int n = this.getSelectedIndex();
        GriddedPanel griddedPanel = (GriddedPanel)this.getComponentAt(n);
        return griddedPanel.getHelpId();
    }

    protected void loadViewer(LeafNodeData leafNodeData, int n) throws Exception {
        ClusteringModel clusteringModel = (ClusteringModel)leafNodeData.getOdmObject();
        int n2 = 0;
        this.m_tabIndex = new int[5];
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_CLUSTERS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_CLUSTERS"));
        this.m_tabIndex[n2++] = CLUSTER_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_RULES"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_RULES"));
        this.m_tabIndex[n2++] = RULE_TAB;
        this.setEnabledAt(n2 - 1, false);
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_RESULTS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_RESULTS"));
        this.m_tabIndex[n2++] = RESULT_TAB;
        this.setEnabledAt(n2 - 1, false);
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_SETTINGS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_SETTINGS"));
        this.m_tabIndex[n2++] = SETTING_TAB;
        this.setEnabledAt(n2 - 1, false);
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        this.m_tabIndex[n2++] = TASK_TAB;
        this.setEnabledAt(n2 - 1, false);
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n, this));
        thread.setPriority(5);
        thread.start();
    }

    public JFrame getParentFrame() {
        return this.m_parentFrame;
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        GriddedPanel panel;
        ClusteringModelViewer m_parent;

        public LoadTab(int n, ClusteringModelViewer clusteringModelViewer2) {
            this.tabIndex = n;
            this.m_parent = clusteringModelViewer2;
        }

        public void run() {
            try {
                ClusteringModel clusteringModel = (ClusteringModel)ClusteringModelViewer.this.m_node.getOdmObject();
                this.panel = null;
                if (ClusteringModelViewer.this.m_tabIndex[this.tabIndex] == SETTING_TAB) {
                    if (ClusteringModelViewer.this.m_clusteringSettingsPanel == null) {
                        ClusteringModelViewer.this.m_clusteringSettingsPanel = new ClusteringSettingsPanel(clusteringModel);
                    }
                    this.panel = ClusteringModelViewer.this.m_clusteringSettingsPanel;
                } else if (ClusteringModelViewer.this.m_tabIndex[this.tabIndex] == CLUSTER_TAB) {
                    if (ClusteringModelViewer.this.m_clusteringClustersPanel == null) {
                        ClusteringModelViewer.this.m_clusteringClustersPanel = new ClusteringClustersPanel(this.m_parent, clusteringModel);
                    }
                    this.panel = ClusteringModelViewer.this.m_clusteringClustersPanel;
                } else if (ClusteringModelViewer.this.m_tabIndex[this.tabIndex] == RULE_TAB) {
                    if (ClusteringModelViewer.this.m_clusteringRulesPanel == null) {
                        ClusteringModelViewer.this.m_clusteringRulesPanel = new ClusteringRulesPanel(this.m_parent, ClusteringModelViewer.this.m_node);
                    }
                    this.panel = ClusteringModelViewer.this.m_clusteringRulesPanel;
                } else if (ClusteringModelViewer.this.m_tabIndex[this.tabIndex] == RESULT_TAB) {
                    if (ClusteringModelViewer.this.m_browseResultsListPanel == null) {
                        ClusteringModelViewer.this.m_browseResultsListPanel = new BrowseResultsListPanel(ClusteringModelViewer.this.m_node);
                    }
                    this.panel = ClusteringModelViewer.this.m_browseResultsListPanel;
                } else if (ClusteringModelViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB) {
                    if (ClusteringModelViewer.this.m_buildTaskPanel == null) {
                        ClusteringModelViewer.this.m_buildTaskPanel = new BuildTaskPanel(clusteringModel.getName());
                    }
                    this.panel = ClusteringModelViewer.this.m_buildTaskPanel;
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        ClusteringModelViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                    }
                };
                EventQueue.invokeLater(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

