/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.algorithm.kmeans.KMeansSettings;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.statistics.UnivariateStatistics;
import javax.swing.JButton;
import javax.swing.JFrame;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.LocalXMLDataSource;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.viewer.export.ExportChartDialog;
import oracle.dmt.jdm.data.OraInterval;
import oracle.dss.graph.Graph;

public class ClusteringHistogramPanel
extends GriddedPanel {
    private UnivariateStatistics m_stats;
    private boolean m_bKmeans;
    private Cluster m_cluster = null;
    private String m_attributeName = null;
    private Graph m_graph = null;

    public ClusteringHistogramPanel(ClusteringModel clusteringModel, UnivariateStatistics univariateStatistics, Cluster cluster, String string, Graph graph) {
        ClusteringSettings clusteringSettings = (ClusteringSettings)clusteringModel.getBuildSettings();
        AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
        this.m_bKmeans = algorithmSettings instanceof KMeansSettings;
        this.m_stats = univariateStatistics;
        this.m_cluster = cluster;
        this.m_attributeName = string;
        this.m_graph = graph;
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "CLUSTERING_HISTOGRAM";
    }

    private void jbInit() throws Exception {
        int n = 0;
        final ClusteringHistogramPanel clusteringHistogramPanel = this;
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jButton, new Insets(7, 0, 0, 10), n++, 2, 2, 1, 14);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    JFrame jFrame = (JFrame)DM4JCommonUIUtils.getParentWindow(clusteringHistogramPanel);
                    ExportChartDialog exportChartDialog = new ExportChartDialog(jFrame, DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportChartDialog.isCancelled()) {
                        exportChartDialog.export(ClusteringHistogramPanel.this.m_graph);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.addComponent(this.m_graph, MIDLABELITEMINSETS, n, 2, 2, 2, 18, 1);
    }

    private void runTimePanelLoad() throws Exception {
        Object[][] objectArray = null;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        UserPreferences userPreferences = UserPreferences.getInstance();
        boolean bl = true;
        int n = 4;
        if (userPreferences.getClusterDetailsPrecisionOption()) {
            bl = true;
            n = userPreferences.getClusterDetailsPrecisionDegree();
        } else {
            bl = false;
        }
        double d = 0.0;
        double[] dArray = this.m_stats.getProbabilities();
        if (dArray != null && 0 != dArray.length) {
            int n2;
            if (this.m_bKmeans) {
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    d += dArray[n2];
                }
            }
            n2 = dArray.length;
            objectArray = new Object[n2][1];
            objectArray2 = new Object[n2];
            objectArray3 = new Object[]{DM4JResourceUtilities.getUIString("CLUST_HIST_FREQ")};
            Object[] objectArray4 = this.m_stats.getValues();
            if (objectArray4 != null && objectArray4.length == n2) {
                if (objectArray4[0] instanceof OraInterval) {
                    OraInterval[] oraIntervalArray = (OraInterval[])objectArray4;
                    for (int i = 0; i < n2; ++i) {
                        objectArray2[i] = this.m_bKmeans ? (bl ? "" + DM4JNumericFormat.format(oraIntervalArray[i].getStartPoint(), false, n) + "-" + DM4JNumericFormat.format(oraIntervalArray[i].getEndPoint(), false, n) : "" + oraIntervalArray[i].getStartPoint() + "-" + oraIntervalArray[i].getEndPoint()) : String.valueOf(i);
                        double d2 = 100.0 * dArray[i];
                        if (this.m_bKmeans) {
                            d2 /= d;
                        }
                        objectArray[i][0] = new Long((long)d2);
                    }
                } else if (objectArray4[0] instanceof String) {
                    for (int i = 0; i < n2; ++i) {
                        objectArray2[i] = objectArray4[i].toString();
                        double d3 = 100.0 * dArray[i];
                        if (this.m_bKmeans) {
                            d3 /= d;
                        }
                        objectArray[i][0] = new Long((long)d3);
                    }
                }
            }
        }
        this.m_graph.getTitle().setText(DM4JResourceUtilities.getUIString("CLUST_HIST_FOR") + this.m_attributeName);
        this.m_graph.getO1Title().setText(DM4JResourceUtilities.getUIString("CLUST_HIST_VALUES"));
        this.m_graph.getY1Title().setText(DM4JResourceUtilities.getUIString("CLUST_HIST_FREQ"));
        this.m_graph.getPFJ().setDisplay(this.m_graph.getPFJ().getLegendArea(), false);
        this.m_graph.setScrollbarPresenceGroups(1);
        this.m_graph.setDataRowShownAsASeries(true);
        this.m_graph.setDataSource(new LocalXMLDataSource(objectArray2, objectArray3, objectArray));
    }
}

