/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.clustering;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.datamining.algorithm.kmeans.KMeansSettings;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.Cluster;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.statistics.UnivariateStatistics;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.ExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.clustering.CentroidAttributesTableModel;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringHistogramPanel;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrComplexAttributeName;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraClusteringModel;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;
import oracle.dss.graph.Graph;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public class CentroidAttributesPanel
extends GriddedPanel
implements ListSelectionListener {
    private JTable m_attributeTable = null;
    private CentroidAttributesTableModel m_tableModel = null;
    private JScrollPane m_attributesPanel = new JScrollPane();
    private ClusteringModel m_miningModel = null;
    private Cluster m_cluster = null;
    private JSplitPane m_splitPane = null;
    private Graph m_graph = null;
    private JFrame m_parent = null;
    private Hashtable m_lookupTableMap = null;
    private TableSorter m_sorter;

    public CentroidAttributesPanel(ClusteringModel clusteringModel, Cluster cluster, JSplitPane jSplitPane, JFrame jFrame) {
        this.m_miningModel = clusteringModel;
        this.m_cluster = cluster;
        this.m_splitPane = jSplitPane;
        this.m_parent = jFrame;
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        ClusteringSettings clusteringSettings = (ClusteringSettings)this.m_miningModel.getBuildSettings();
        AlgorithmSettings algorithmSettings = clusteringSettings.getAlgorithmSettings();
        if (algorithmSettings instanceof KMeansSettings) {
            return "CLUSTERING_KMEANS_MODEL";
        }
        return "CLUSTERING_OCLUSTER_MODEL";
    }

    private void jbInit() throws Exception {
        final CentroidAttributesPanel centroidAttributesPanel = this;
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_DETAILS_TITLE"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n++, 0, 1, 1, 18, 0);
        JButton jButton = new JButton(DM4JResourceUtilities.getUIString("COMMON_CLOSE"));
        this.addComponent(jButton, TOPLABELITEMINSETS, 0, 4, 1, 3, 12, 0);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CentroidAttributesPanel.this.btnClose_actionPerformed(actionEvent);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getInputMap(1).put(keyStroke, "CancelAction");
        this.getActionMap().put("CancelAction", abstractAction);
        jButton.addActionListener(abstractAction);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_ID"));
        this.addComponent(jLabel2, MIDINDENTEDLABELITEMINSETS, n, 0, 1, 1, 18, 0);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JNumericFormat.format(this.m_cluster.getClusterId(), false, 0));
        this.addComponent(jLabel3, MIDINDENTEDLABELITEMINSETS, n++, 1, 1, 1, 18, 0);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_LEVEL"));
        this.addComponent(jLabel4, MIDINDENTEDLABELITEMINSETS, n, 0, 1, 1, 18, 0);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(DM4JNumericFormat.format(this.m_cluster.getLevel(), false, 0));
        this.addComponent(jLabel5, MIDINDENTEDLABELITEMINSETS, n++, 1, 1, 1, 18, 0);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_RECORD_COUNT"));
        this.addComponent(jLabel6, MIDINDENTEDLABELITEMINSETS, n, 0, 1, 1, 18, 0);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(DM4JNumericFormat.format(this.m_cluster.getCaseCount()));
        this.addComponent(jLabel7, MIDINDENTEDLABELITEMINSETS, n++, 1, 1, 1, 18, 0);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(DM4JResourceUtilities.getUIString("CLUST_CLUSTER_CENTROID_ATTRIBS"));
        jLabel8.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLUST_CLUSTER_CENTROID_ATTRIBS"));
        this.addAnchoredComponent(jLabel8, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        JButton jButton2 = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton2.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jButton2, MIDLABELITEMINSETS, n++, 4, 1, 1, 14);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    JFrame jFrame = (JFrame)DM4JCommonUIUtils.getParentWindow(centroidAttributesPanel);
                    ExportDialog exportDialog = new ExportDialog(jFrame, DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        CentroidAttributesPanel.this.m_attributeTable.selectAll();
                        exportDialog.export(CentroidAttributesPanel.this.m_attributeTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.addFilledComponent(this.m_attributesPanel, MIDLABELITEMINSETS, n++, 0, 5, 2, 1);
        this.m_attributeTable = new JTable();
        this.m_attributeTable.setAutoCreateColumnsFromModel(false);
        jLabel8.setLabelFor(this.m_attributeTable);
    }

    private void runTimePanelLoad() throws Exception {
        this.m_tableModel = new CentroidAttributesTableModel(this.m_miningModel, this.m_cluster);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_attributeTable.setModel(this.m_sorter);
        this.m_sorter.setTableHeader(this.m_attributeTable.getTableHeader());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        TableColumn tableColumn = new TableColumn(0, 80, defaultTableCellRenderer, null);
        this.m_attributeTable.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 70, defaultTableCellRenderer, null);
        this.m_attributeTable.addColumn(tableColumn);
        this.m_attributesPanel.getViewport().add(this.m_attributeTable);
        this.m_attributeTable.changeSelection(0, 0, false, false);
        this.loadHistogramViewer(0);
        ListSelectionModel listSelectionModel = this.m_attributeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(2);
        listSelectionModel.addListSelectionListener(this);
        ExcelAdapter excelAdapter = new ExcelAdapter(this.m_attributeTable);
    }

    public void btnClose_actionPerformed(ActionEvent actionEvent) {
        this.m_parent.dispose();
        this.m_parent.setVisible(false);
        this.m_parent = null;
        if (null != this.m_graph) {
            this.m_graph.cleanUp();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            this.loadHistogramViewer(n);
        }
    }

    public void loadHistogramViewer(int n) {
        Object object;
        Object object2;
        this.setCursor(new Cursor(3));
        if (null == this.m_graph) {
            object2 = new DefaultErrorHandler();
            ((DefaultErrorHandler)object2).setDebugMode(0);
            this.m_graph = new Graph((ErrorHandler)object2);
            this.m_graph.setLocale(Locale.getDefault());
            this.m_graph.setGraphType(17);
            this.m_graph.setAutoLayout(2);
            this.m_graph.getPFJ().setDisplay(this.m_graph.getPFJ().getLegendArea(), false);
        }
        object2 = (ODMrComplexAttributeName)this.m_sorter.getValueAt(n, 0);
        UnivariateStatistics univariateStatistics = this.m_tableModel.getUniVarStatsEntry((ODMrComplexAttributeName)object2);
        String string = null;
        if (univariateStatistics == null) {
            if (this.m_lookupTableMap == null) {
                this.m_lookupTableMap = DatabaseMetadata.getODMrTextLookupTable(this.m_miningModel.getName());
            }
            if (this.m_lookupTableMap != null) {
                object = this.m_lookupTableMap.keys();
                String string2 = null;
                String string3 = null;
                String string4 = ((ODMrComplexAttributeName)this.m_sorter.getValueAt(n, 0)).getAttributeName();
                while (object.hasMoreElements()) {
                    string3 = (String)object.nextElement();
                    if (this.m_lookupTableMap.get(string3) == null || !string4.equalsIgnoreCase((String)this.m_lookupTableMap.get(string3))) continue;
                    string2 = string3;
                    break;
                }
                if (string2 != null) {
                    ODMrComplexAttributeName oDMrComplexAttributeName = new ODMrComplexAttributeName((ODMrOraClusteringModel)this.m_miningModel, string2, ((ODMrComplexAttributeName)object2).getAttributeSubName());
                    univariateStatistics = this.m_tableModel.getUniVarStatsEntry(oDMrComplexAttributeName);
                    string = oDMrComplexAttributeName.toString();
                } else {
                    string = ((ODMrComplexAttributeName)object2).toString();
                }
            }
        } else {
            string = ((ODMrComplexAttributeName)object2).toString();
        }
        object = new ClusteringHistogramPanel(this.m_miningModel, univariateStatistics, this.m_cluster, string, this.m_graph);
        ((JComponent)object).setMinimumSize(new Dimension(50, 50));
        int n2 = this.m_splitPane.getDividerLocation();
        this.m_splitPane.add((Component)object, "bottom");
        this.m_splitPane.setDividerLocation(n2);
        this.setCursor(new Cursor(0));
    }
}

