/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Cursor;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodePredicatePanel;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodeTargetValuesPanel;
import oracle.dss.graph.Graph;

public class TreeNodeDetailPane
extends JTabbedPane {
    private Graph m_graph = null;
    private static int PREDICATE_TAB = 0;
    private static int TARGET_VALUES_TAB = 1;
    private int[] m_tabIndex;
    private ClassificationModel m_model = null;
    private TreeNode m_treeNode = null;
    private TreeNodePredicatePanel m_predicatePanel = null;
    private TreeNodeTargetValuesPanel m_valuePanel = null;
    private static boolean showSimplifiedRule = true;
    private static boolean showSurrogates = false;
    private static boolean showFullRule = false;
    private static boolean reverseFullRule = false;
    private static int tabIndex = 0;

    public TreeNodeDetailPane(ClassificationModel classificationModel, TreeNode treeNode, Graph graph) {
        this.m_model = classificationModel;
        this.m_graph = graph;
        this.m_treeNode = treeNode;
        this.jbInit();
    }

    private void jbInit() {
        this.setOpaque(false);
        try {
            this.setTabPlacement(3);
            this.loadViewer(this.getTabIndex());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addChangeListener(new tabChangeListener());
    }

    protected void loadViewer(int n) throws Exception {
        int n2 = 0;
        this.m_tabIndex = new int[2];
        this.addTab(DM4JResourceUtilities.getUIString("TREE_NODE_PREDICATE_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("TREE_NODE_PREDICATE_TAB"));
        this.m_tabIndex[n2++] = PREDICATE_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("TREE_NODE_TARGET_VALUES_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("TREE_NODE_TARGET_VALUES_TAB"));
        this.m_tabIndex[n2++] = TARGET_VALUES_TAB;
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        GriddedPanel griddedPanel = null;
        if (this.m_tabIndex[n] == PREDICATE_TAB) {
            if (this.m_predicatePanel == null) {
                this.m_predicatePanel = new TreeNodePredicatePanel(this, this.m_model, this.m_treeNode);
            }
            griddedPanel = this.m_predicatePanel;
        } else if (this.m_tabIndex[n] == TARGET_VALUES_TAB) {
            BrowserFrame browserFrame = BrowserFrame.getMainFrame();
            browserFrame.setCursor(new Cursor(3));
            if (this.m_valuePanel == null) {
                this.m_valuePanel = new TreeNodeTargetValuesPanel(this, this.m_model, this.m_treeNode);
            }
            griddedPanel = this.m_valuePanel;
            browserFrame.setCursor(new Cursor(0));
        }
        this.setComponentAt(n, griddedPanel);
    }

    public boolean isShowSimplifiedRule() {
        return showSimplifiedRule;
    }

    public void setShowSimplifiedRule() {
        showSimplifiedRule = true;
        showSurrogates = false;
        showFullRule = false;
        reverseFullRule = false;
    }

    public boolean isShowSurrogates() {
        return showSurrogates;
    }

    public void setShowSurrogates() {
        showSimplifiedRule = false;
        showSurrogates = true;
        showFullRule = false;
        reverseFullRule = false;
    }

    public boolean isShowFullRule() {
        return showFullRule;
    }

    public void setShowFullRule(boolean bl) {
        showSimplifiedRule = false;
        showSurrogates = false;
        showFullRule = true;
        reverseFullRule = bl;
    }

    public boolean isReverseFullRule() {
        return reverseFullRule;
    }

    public int getTabIndex() {
        return tabIndex;
    }

    public void setTabIndex(int n) {
        tabIndex = n;
    }

    public Graph getGraph() {
        return this.m_graph;
    }

    class tabChangeListener
    implements ChangeListener {
        tabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = ((JTabbedPane)changeEvent.getSource()).getSelectedIndex();
            TreeNodeDetailPane.this.showTab(n);
            TreeNodeDetailPane.this.setTabIndex(n);
        }
    }
}

