/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.text.Collator;
import java.util.EventObject;
import java.util.HashMap;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.classification.AbsoluteNumberComparator;
import oracle.dmt.dm4j.browser.viewer.classification.LoadSVMCoefficientWorker;
import oracle.dmt.dm4j.browser.viewer.classification.SVMCoefficientLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.SVMCoefficientTableModel;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;
import oracle.dmt.jdm.data.OraAttributeCoefficient;

public final class SVMCoefficientTable
extends Dm4jSpreadTable
implements SVMCoefficientLoadedListener {
    private LoadSVMCoefficientWorker m_worker = null;
    private SVMCoefficientTableModel m_tableModel;
    private boolean loaded = false;
    HashMap m_condition = new HashMap();
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_NAME"), DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_VALUE"), DM4JResourceUtilities.getUIString("CLASS_SVM_COEFFICIENT")};
    int[] m_colWidths = new int[]{40, 40, 20};

    public SVMCoefficientTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(Object object, HashMap hashMap) throws Exception {
        this.m_condition = hashMap;
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setColumnWidths(this.m_colWidths, true);
        ClassificationModel classificationModel = (ClassificationModel)this.getDataItem();
        if (null == classificationModel) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        this.m_worker = (LoadSVMCoefficientWorker)workerThreadManager.getLoadSVMCoefficientWorker(classificationModel, object, hashMap);
        this.m_worker.addSVMCoefficientLoadedListener(this);
        this.m_worker.start();
    }

    public void setSortAbsoluteCoefficient(boolean bl) {
        if (this.m_tableModel != null) {
            Class clazz;
            Comparator comparator = this.m_tableModel.getColumnComparator(2);
            if (bl) {
                clazz = AbsoluteNumberComparator.class;
                this.m_tableModel.setColumnComparator(2, AbsoluteNumberComparator.getComparator());
            } else {
                clazz = NumberComparator.class;
                this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
            }
            if (!comparator.getClass().equals(clazz)) {
                this.m_tableModel.sort(2, false);
            }
        }
    }

    public void svmCoefficientLoaded(EventObject eventObject) {
        Object object;
        SVMCoefficientTableModel sVMCoefficientTableModel;
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = sVMCoefficientTableModel = (SVMCoefficientTableModel)eventObject.getSource();
        this.setModels((TwoDModel)sVMCoefficientTableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        this.m_worker = null;
        header.setItemInputHandler(new SortInputHandler(this.m_tableModel));
        this.m_tableModel.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_tableModel.getRowCount() > 0) {
            try {
                object = new TwoDSelection(0, true);
                this.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.getGrid();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 10));
        ((Grid)object).setColumnPainter(2, dM4JTruncatingNumberFormatPainter);
        Boolean bl = Boolean.FALSE;
        if (this.m_condition != null && (bl = (Boolean)this.m_condition.get("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT")) != null) {
            this.setSortAbsoluteCoefficient(bl);
        }
        this.loaded = true;
    }

    public OraAttributeCoefficient getAttributeCoefficient(int n) {
        return this.m_tableModel.getAttributeCoefficient(n);
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

