/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.text.Collator;
import java.util.EventObject;
import java.util.HashMap;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.classification.LoadNBPairProbabilitiesWorker;
import oracle.dmt.dm4j.browser.viewer.classification.NBPairProbabilitiesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.NBPairProbabilitiesTableModel;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;
import oracle.dmt.jdm.data.OraPairProbability;

public final class NBPairProbabilitiesTable
extends Dm4jSpreadTable
implements NBPairProbabilitiesLoadedListener {
    private LoadNBPairProbabilitiesWorker m_worker = null;
    private NBPairProbabilitiesTableModel m_tableModel;
    int[] m_colSortOrders = null;
    int m_curSortOrder = 2;
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TBL_PAIR_PROBABILITIES_ATTRIBUTE"), DM4JResourceUtilities.getUIString("CLASS_TBL_PAIR_PROBABILITIES_VALUE"), DM4JResourceUtilities.getUIString("CLASS_TBL_PAIR_PROBABILITIES_PROBABILITY")};
    int[] m_colWidths = new int[]{40, 40, 15};

    public NBPairProbabilitiesTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_colSortOrders = new int[this.m_columnNames.length];
        this.m_colSortOrders[0] = 0;
        this.m_colSortOrders[1] = 0;
        this.m_colSortOrders[2] = 0;
    }

    public void load(Object object, HashMap hashMap) throws Exception {
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setColumnWidths(this.m_colWidths, true);
        ClassificationModel classificationModel = (ClassificationModel)this.getDataItem();
        if (null == classificationModel) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        this.m_worker = (LoadNBPairProbabilitiesWorker)workerThreadManager.getLoadNBPairProbabilitiesWorker(classificationModel, object, hashMap);
        this.m_worker.addNBPairProbabilitiesLoadedListener(this);
        this.m_worker.start();
    }

    public void pairProbabilitiesLoaded(EventObject eventObject) {
        Object object;
        NBPairProbabilitiesTableModel nBPairProbabilitiesTableModel;
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = nBPairProbabilitiesTableModel = (NBPairProbabilitiesTableModel)eventObject.getSource();
        try {
            this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModels((TwoDModel)nBPairProbabilitiesTableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        this.m_worker = null;
        header.setItemInputHandler(new SortInputHandler(this.m_tableModel));
        this.m_tableModel.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_tableModel.getRowCount() > 0) {
            try {
                object = new TwoDSelection(0, true);
                this.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.getGrid();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 10));
        ((Grid)object).setColumnPainter(2, dM4JTruncatingNumberFormatPainter);
    }

    public OraPairProbability getPairProbabilities(int n) {
        return this.m_tableModel.getPairProbabilities(n);
    }
}

