/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.util.EventObject;
import javax.datamining.modeldetail.tree.TreeNode;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodeTableModel;
import oracle.dmt.dm4j.browser.viewer.classification.TreeNodesLoadedListener;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class LoadTreeNodesWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private ClassificationModel m_miningModel = null;
    private TreeNodeTableModel m_tableModel = null;
    private boolean m_leavesOnly = false;
    private TreeNode m_rootNode = null;

    public LoadTreeNodesWorker(WorkerThreadManager workerThreadManager, TreeNode treeNode, ClassificationModel classificationModel, boolean bl) {
        super(workerThreadManager);
        this.m_rootNode = treeNode;
        this.m_miningModel = classificationModel;
        this.m_leavesOnly = bl;
    }

    public void addTreeNodesLoadedListener(TreeNodesLoadedListener treeNodesLoadedListener) {
        this.listenerList.add(TreeNodesLoadedListener.class, treeNodesLoadedListener);
    }

    public void removeClustersLoadedListener(TreeNodesLoadedListener treeNodesLoadedListener) {
        this.listenerList.remove(TreeNodesLoadedListener.class, treeNodesLoadedListener);
    }

    public Object construct() {
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            this.m_tableModel = new TreeNodeTableModel(0);
            this.m_tableModel.load(this.m_rootNode, this.m_miningModel, this.m_leavesOnly);
        }
        catch (Exception exception) {
            this.m_tableModel = null;
            exception.printStackTrace();
        }
        return this.m_tableModel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeNodesLoadedListener.class) continue;
            ((TreeNodesLoadedListener)objectArray[i + 1]).nodesLoaded(new EventObject(this.getValue()));
        }
    }
}

