/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.datamining.base.BuildSettings;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.regression.RegressionModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.classification.GLMCRowDiagnosticsTable;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.regression.GLMRRowDiagnosticsTable;
import oracle.dmt.jdm.algorithm.glm.OraGLMClassificationSettings;
import oracle.dmt.jdm.algorithm.glm.OraGLMRegressionSettings;
import oracle.dmt.jdm.algorithm.glm.OraGLMSettings;

public class GLMRowDiagnosticsPanel
extends GriddedPanel {
    private JPanel m_grdPanel = null;
    private NumberTextField m_fetchSize = null;
    private JScrollPane m_rowDetailsPanel = new JScrollPane();
    private BuildSettings m_buildSettings = null;
    private SupervisedModel m_model = null;
    private String m_diagTableName = null;
    private GLMCRowDiagnosticsTable m_glmcRowDiagTable = null;
    private GLMRRowDiagnosticsTable m_glmrRowDiagTable = null;
    private JLabel lblSortColumn = new JLabel();
    private JComboBox cboSortColumn = new JComboBox();
    private DefaultComboBoxModel sortColumnModel = null;
    private JLabel lblSortOrder = new JLabel();
    private JComboBox cboSortOrder = new JComboBox();
    private DefaultComboBoxModel sortOrderModel = null;
    boolean m_isClassification = true;
    static final int MAXNUMROW = 1000;
    private final int ASCENDING = 0;
    private final int DECENDING = 1;
    private String[] m_sortOptions = new String[]{DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_ASC"), DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC")};
    private LeafNodeData m_nd = null;

    public GLMRowDiagnosticsPanel(LeafNodeData leafNodeData) {
        try {
            this.m_model = (SupervisedModel)leafNodeData.getOdmObject();
            this.m_nd = leafNodeData;
            this.m_buildSettings = this.m_model.getBuildSettings();
            OraGLMSettings oraGLMSettings = (OraGLMSettings)this.m_buildSettings.getAlgorithmSettings();
            if (this.m_model instanceof ClassificationModel) {
                this.m_isClassification = true;
                OraGLMClassificationSettings oraGLMClassificationSettings = (OraGLMClassificationSettings)oraGLMSettings;
                this.m_diagTableName = oraGLMClassificationSettings.getDiagnosticsTableName();
            } else if (this.m_model instanceof RegressionModel) {
                this.m_isClassification = false;
                OraGLMRegressionSettings oraGLMRegressionSettings = (OraGLMRegressionSettings)oraGLMSettings;
                this.m_diagTableName = oraGLMRegressionSettings.getDiagnosticsTableName();
            } else {
                throw new Exception("Node selected for display is not a GLM Model so no row diagnostics are available.");
            }
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        if (this.m_isClassification) {
            return "GLM_MODEL";
        }
        return "GLM_REGRESSION_MODEL";
    }

    private void jbInit() throws Exception {
        int n = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 0));
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("COMMON_FETCH_SIZE"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FETCH_SIZE"));
        this.m_fetchSize = new NumberTextField(new Integer(1000), 5);
        this.m_fetchSize.setLocale(Locale.getDefault());
        this.m_fetchSize.setSigned(false);
        jLabel.setLabelFor(this.m_fetchSize);
        this.m_fetchSize.setToolTipText(DM4JResourceUtilities.getUIString("GLM_FETCH_SIZE_MUST_BE_POS"));
        JButton jButton = new JButton(DM4JResourceUtilities.getUIString("APPLY_RESULT_REFRESH"));
        jButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("APPLY_RESULT_REFRESH"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GLMRowDiagnosticsPanel.this.btnRefresh_actionPerformed(actionEvent);
            }
        });
        jPanel.add(jLabel);
        jPanel.add(this.m_fetchSize);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 5, 0));
        JButton jButton2 = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton2.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.lblSortColumn.setText(DM4JResourceUtilities.getUIString("GLM_SORT_COLUMN"));
        this.lblSortColumn.setLabelFor(this.cboSortColumn);
        this.lblSortOrder.setText(DM4JResourceUtilities.getUIString("GLM_SORT_ORDER"));
        this.lblSortOrder.setLabelFor(this.cboSortOrder);
        this.sortOrderModel = new DefaultComboBoxModel<String>(this.m_sortOptions);
        this.cboSortOrder.setModel(this.sortOrderModel);
        jPanel3.add(this.lblSortColumn);
        jPanel3.add(this.cboSortColumn);
        jPanel3.add(this.lblSortOrder);
        jPanel3.add(this.cboSortOrder);
        jPanel3.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_SAVE_FILE_AS"));
                    if (!exportDialog.isCancelled()) {
                        if (GLMRowDiagnosticsPanel.this.m_isClassification) {
                            exportDialog.export(GLMRowDiagnosticsPanel.this.m_glmcRowDiagTable);
                        } else {
                            exportDialog.export(GLMRowDiagnosticsPanel.this.m_glmrRowDiagTable);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jPanel2.add((Component)jPanel3, "East");
        ++n;
        this.m_grdPanel = new JPanel(new BorderLayout());
        this.m_grdPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.m_grdPanel, "Center");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("GLM_ROW_DIAGNOSTICS_TABLE_NAME"));
        JTextField jTextField = new JTextField();
        jTextField.setText(this.m_diagTableName);
        jTextField.setEditable(false);
        jTextField.setBorder(new EmptyBorder(0, 0, 0, 0));
        jLabel2.setLabelFor(jTextField);
        Insets insets = new Insets(0, 10, 10, 0);
        Insets insets2 = new Insets(0, 5, 10, 10);
        this.addComponent(jLabel2, insets, n, 1);
        this.addFilledComponent(jTextField, insets2, n, 2, 1, 1, 2);
        this.addFilledComponent(jPanel4, MIDLABELITEMINSETS, ++n, 1, 2, 2, 1);
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        if (this.m_isClassification) {
            this.m_glmcRowDiagTable = new GLMCRowDiagnosticsTable(this.m_diagTableName);
            this.m_glmcRowDiagTable.setResize(false);
            this.m_rowDetailsPanel.getViewport().add(this.m_glmcRowDiagTable);
            this.m_glmcRowDiagTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
            this.sortColumnModel = new DefaultComboBoxModel<String>(this.m_glmcRowDiagTable.getColumnHeaderArray());
            this.cboSortColumn.setModel(this.sortColumnModel);
            this.cboSortColumn.setSelectedItem(this.m_sortOptions[0]);
            this.cboSortColumn.setSelectedItem(this.m_glmcRowDiagTable.getColumnHeaderArray()[0]);
            Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_glmcRowDiagTable);
        } else {
            this.m_glmrRowDiagTable = new GLMRRowDiagnosticsTable(this.m_diagTableName);
            this.m_glmrRowDiagTable.setResize(false);
            this.m_rowDetailsPanel.getViewport().add(this.m_glmrRowDiagTable);
            this.m_glmrRowDiagTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
            this.sortColumnModel = new DefaultComboBoxModel<String>(this.m_glmrRowDiagTable.getColumnHeaderArray());
            this.cboSortColumn.setModel(this.sortColumnModel);
            this.cboSortColumn.setSelectedItem(this.m_sortOptions[0]);
            this.cboSortColumn.setSelectedItem(this.m_glmrRowDiagTable.getColumnHeaderArray()[0]);
            Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_glmrRowDiagTable);
        }
        this.m_grdPanel.add((Component)this.m_rowDetailsPanel, "Center");
    }

    private void formatAndSizeClassColumns() {
        this.m_glmcRowDiagTable.setColumnWidths(100);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance();
        NumberFormat numberFormat2 = DM4JNumericFormat.getInstance(false, 6);
        FormatPainter formatPainter = new FormatPainter(numberFormat2);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(7, formatPainter);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(8, formatPainter);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(6, formatPainter);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(10, formatPainter);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(9, formatPainter);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(2, formatPainter);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(5, formatPainter);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(3, formatPainter);
        this.m_glmcRowDiagTable.getGrid().setColumnPainter(4, formatPainter);
    }

    private void formatAndSizeRegresColumns() {
        this.m_glmrRowDiagTable.setColumnWidths(100);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance();
        NumberFormat numberFormat2 = DM4JNumericFormat.getInstance(false, 6);
        FormatPainter formatPainter = new FormatPainter(numberFormat2);
        this.m_glmrRowDiagTable.getGrid().setColumnPainter(1, formatPainter);
        this.m_glmrRowDiagTable.getGrid().setColumnPainter(2, formatPainter);
        this.m_glmrRowDiagTable.getGrid().setColumnPainter(4, formatPainter);
        this.m_glmrRowDiagTable.getGrid().setColumnPainter(5, formatPainter);
        this.m_glmrRowDiagTable.getGrid().setColumnPainter(6, formatPainter);
        this.m_glmrRowDiagTable.getGrid().setColumnPainter(3, formatPainter);
        this.m_glmrRowDiagTable.getGrid().setColumnPainter(7, formatPainter);
        this.m_glmrRowDiagTable.getGrid().setColumnPainter(8, formatPainter);
    }

    private void refreshValueError(ActionEvent actionEvent) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        String string = DM4JResourceUtilities.getUIString("COMMON_FETCH_SIZE");
        String string2 = DM4JResourceUtilities.getUIString("ERROR_TITLE");
        String string3 = DM4JResourceUtilities.getUIString("ERROR_VALUE_INTEGER_ONLY");
        Object[] objectArray = new Object[]{string, "1", "2147483647"};
        String string4 = MessageFormat.format(string3, objectArray);
        JFrame jFrame = BrowserUtils.getParentFrame((Component)actionEvent.getSource());
        JOptionPane.showMessageDialog(jFrame, string4, string2, 0);
        this.m_fetchSize.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void btnRefresh_actionPerformed(ActionEvent actionEvent) {
        block10: {
            block9: {
                block8: {
                    try {
                        try {
                            this.setCursor(new Cursor(3));
                            int n = 0;
                            boolean bl = true;
                            Number number = this.m_fetchSize.getNumber();
                            if (number == null) {
                                this.refreshValueError(actionEvent);
                                this.m_fetchSize.requestFocus();
                                Object var7_6 = null;
                                break block8;
                            }
                            n = number.intValue();
                            boolean bl2 = true;
                            if (bl && (n <= 0 || n > Integer.MAX_VALUE)) {
                                bl2 = false;
                            }
                            if (!bl || !bl2) {
                                this.refreshValueError(actionEvent);
                                this.m_fetchSize.requestFocus();
                                break block9;
                            }
                            this.runTimePanelLoad(null);
                            break block10;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var7_9 = null;
                            this.setCursor(new Cursor(0));
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        this.setCursor(new Cursor(0));
                        throw throwable;
                    }
                }
                this.setCursor(new Cursor(0));
                return;
            }
            Object var7_7 = null;
            this.setCursor(new Cursor(0));
            return;
        }
        Object var7_8 = null;
        this.setCursor(new Cursor(0));
    }

    private int getSortColumnID() {
        return this.cboSortColumn.getSelectedIndex();
    }

    private boolean isAscending() {
        return this.cboSortOrder.getSelectedIndex() == 0;
    }

    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        if (this.m_isClassification) {
            this.m_glmcRowDiagTable.displayLoadingStatus();
            this.m_glmcRowDiagTable.load(this.m_fetchSize.getNumber().intValue(), this.getSortColumnID(), this.isAscending());
            this.formatAndSizeClassColumns();
        } else {
            this.m_glmrRowDiagTable.displayLoadingStatus();
            this.m_glmrRowDiagTable.load(this.m_fetchSize.getNumber().intValue(), this.getSortColumnID(), this.isAscending());
            this.formatAndSizeRegresColumns();
        }
    }
}

