/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.MiningFunction;
import javax.datamining.base.Model;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.FilterAttributesDialog;
import oracle.dmt.dm4j.browser.viewer.classification.ClassificationModelViewer;
import oracle.dmt.dm4j.browser.viewer.classification.GLMCoefficientTable;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.regression.RegressionModelViewer;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.algorithm.glm.OraGLMClassificationSettings;
import oracle.dmt.jdm.modeldetail.glm.OraGLMModelDetail;

public class GLMModelContentPanel
extends GriddedPanel
implements VetoableChangeListener {
    Model m_model = null;
    private JLabel m_targetAttribName = new JLabel();
    JLabel lblTarget = new JLabel();
    JLabel lblTargetValue = new JLabel();
    Object nonRefCategory = null;
    HashMap m_targetMap = new HashMap();
    boolean _isClassification = true;
    boolean _isCovarianceMatrix = true;
    JButton m_filter = new JButton();
    boolean m_isScaled = false;
    JButton m_exportButton = new JButton();
    JCheckBox m_sortAbsoluteCoefficientValue = new JCheckBox();
    NumberTextField m_tfSize = new NumberTextField();
    JLabel m_lblSize = new JLabel();
    JButton m_btnRefresh = new JButton();
    Integer m_defaultFectchSize = new Integer(100);
    String m_defaultSortBy = null;
    String m_defaultSortOrder = null;
    Hashtable m_xformTables = null;
    JCheckBox m_showIntercept = new JCheckBox();
    GLMCoefficientTable m_coefficientTable = null;
    JScrollPane m_coefficientScrollPane = new JScrollPane();
    HashMap m_condition = new HashMap();
    Hashtable m_lookupTableMap = null;

    public GLMModelContentPanel(LeafNodeData leafNodeData) {
        this.m_model = (Model)leafNodeData.getOdmObject();
        this._isClassification = MiningFunction.classification.equals(this.m_model.getMiningFunction());
        Number number = (Number)((OraGLMModelDetail)this.m_model.getModelDetail()).getGlobalDetails().get("VALID_COVARIANCE_MATRIX");
        this._isCovarianceMatrix = number == null || 1 == number.intValue();
        try {
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        Container container = this.getParent();
        if (container instanceof RegressionModelViewer) {
            return "GLM_REGRESSION_MODEL";
        }
        if (container instanceof ClassificationModelViewer) {
            return "GLM_MODEL";
        }
        return "";
    }

    private void jbInit() throws Exception {
        Object object;
        Object object2;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_targetAttribName, TOPVALUEITEMINSETS, n++, 1);
        if (this._isClassification) {
            this.lblTarget.setText(DM4JResourceUtilities.getUIString("CLASS_TARGET_CLASS") + ":");
            this.lblTarget.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_TARGET_CLASS"));
            this.lblTarget.setLabelFor(this.lblTargetValue);
            object2 = ((ClassificationModel)this.m_model).getTargetCategorySet();
            object = ((OraGLMClassificationSettings)this.m_model.getBuildSettings().getAlgorithmSettings()).getReferenceCategory();
            for (int i = 0; i < object2.getSize(); ++i) {
                if (object.equals(object2.getValue(i))) continue;
                this.nonRefCategory = object2.getValue(i);
                this.lblTargetValue.setText(this.nonRefCategory.toString());
                break;
            }
            this.addComponent(this.lblTarget, TOPLABELITEMINSETS, n, 0);
            this.addComponent(this.lblTargetValue, TOPLABELITEMINSETS, n++, 1);
        }
        this.m_coefficientTable = new GLMCoefficientTable(this.m_model, this._isClassification, this._isCovarianceMatrix);
        object2 = new JLabel();
        ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("COMMON_COEFFICIENTS"));
        this.m_sortAbsoluteCoefficientValue.setText(DM4JResourceUtilities.getUIString("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT"));
        this.m_sortAbsoluteCoefficientValue.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT"));
        this.m_sortAbsoluteCoefficientValue.setSelected(false);
        this.m_showIntercept.setText(DM4JResourceUtilities.getUIString("GLM_SHOW_INTERCEPT"));
        this.m_showIntercept.setMnemonic(DM4JResourceUtilities.getUIMnemonic("GLM_SHOW_INTERCEPT"));
        this.m_showIntercept.setSelected(false);
        this.m_showIntercept.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (GLMModelContentPanel.this.m_showIntercept.isSelected()) {
                        GLMModelContentPanel.this.m_coefficientTable.addInterceptRow();
                    } else {
                        GLMModelContentPanel.this.m_coefficientTable.removeInterceptRow();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.addComponent(this.m_showIntercept, TOPLABELITEMINSETS, n++, 0);
        this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(GLMModelContentPanel.this.m_coefficientTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_filter.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER"));
        this.m_filter.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER"));
        this.m_coefficientTable.setResize(false);
        this.m_coefficientScrollPane.getViewport().add(this.m_coefficientTable);
        this.m_defaultSortBy = DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_COEFFICIENT");
        this.m_defaultSortOrder = DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC");
        object = new JPanel();
        this.m_tfSize.setDataType(Integer.TYPE);
        this.m_tfSize.setNumber(this.m_defaultFectchSize);
        this.m_tfSize.setSigned(false);
        this.m_tfSize.setColumns(5);
        this.m_tfSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this.m_lblSize.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setLabelFor(this.m_tfSize);
        this.m_btnRefresh.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setEnabled(true);
        this.m_btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GLMModelContentPanel.this.m_btnRefresh_actionPerformed(actionEvent);
            }
        });
        ((Container)object).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        ((Container)object).add((Component)object2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        ((Container)object).add((Component)new JLabel(), gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel.add((Component)object, "West");
        jPanel2.add(this.m_lblSize);
        jPanel2.add(this.m_tfSize);
        jPanel2.add(this.m_btnRefresh);
        jPanel2.add(this.m_filter);
        jPanel2.add(this.m_exportButton);
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel3.add((Component)jPanel4, "West");
        jPanel4.add(this.m_sortAbsoluteCoefficientValue);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "North");
        jPanel5.add((Component)this.m_coefficientScrollPane, "Center");
        jPanel5.add((Component)jPanel3, "South");
        this.addFilledComponent(jPanel5, MIDLABELITEMINSETS, n++, 0, 2, 2, 1);
        this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
    }

    protected void m_sortAbsoluteCoefficientValue_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            boolean bl = this.m_sortAbsoluteCoefficientValue.isSelected();
            this.m_condition.put("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT", bl);
            int n = 2;
            if (bl) {
                this.m_coefficientTable.setSortAbsoluteCoefficient(true);
            } else {
                this.m_coefficientTable.setSortAbsoluteCoefficient(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void m_btnRefresh_actionPerformed(ActionEvent actionEvent) {
        block7: {
            block6: {
                this.setCursor(new Cursor(3));
                try {
                    try {
                        Number number = this.m_tfSize.getNumber();
                        if (number == null) {
                            DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                            this.setCursor(new Cursor(0));
                            Object var4_4 = null;
                            break block6;
                        }
                        this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
                        this.m_coefficientTable.load(this.nonRefCategory, this.m_condition);
                        this.m_coefficientTable.repaint();
                        break block7;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var4_6 = null;
                        this.setCursor(new Cursor(0));
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    this.setCursor(new Cursor(0));
                    throw throwable;
                }
            }
            this.setCursor(new Cursor(0));
            return;
        }
        Object var4_5 = null;
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runTimePanelLoad(LeafNodeData var1_1) throws Exception {
        block11: {
            this.m_model = (Model)var1_1.getOdmObject();
            this.m_targetAttribName.setText(((SupervisedModel)this.m_model).getTargetAttributeName());
            var2_2 = this.nonRefCategory;
            this.m_condition.put("COMMON_FETCH_SIZE", this.m_defaultFectchSize);
            this.m_condition.put("COMMON_FILTER_SORT_VALUE", this.m_defaultSortBy);
            this.m_condition.put("COMMON_FILTER_SORT_ORDER", this.m_defaultSortOrder);
            this.m_lookupTableMap = DatabaseMetadata.getODMrTextLookupTable(this.m_model.getName());
            this.m_condition.put("COMMON_TEXT_LOOKUP", this.m_lookupTableMap);
            this.m_xformTables = null;
            var3_3 = null;
            try {
                var3_3 = DM4JConnectionManager.getDbConnection();
                var4_4 = DMEMetadata.getInstance();
                this.m_xformTables = var4_4.getTransparencyTables(var3_3, null, this.m_model.getName());
                var6_6 = null;
                ** if (null == var3_3) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_7 = null;
                if (null != var3_3) {
                    try {
                        var3_3.close();
                    }
                    catch (Exception var7_10) {
                        var7_10.printStackTrace();
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (Exception var7_8) {
                    var7_8.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (Exception var4_5) {
                    var4_5.printStackTrace();
                    var6_6 = null;
                    if (null != var3_3) {
                        try {
                            var3_3.close();
                        }
                        catch (Exception var7_9) {
                            var7_9.printStackTrace();
                        }
                    }
                }
            }
        }
        this.m_coefficientTable.load(var2_2, this.m_condition);
        var4_4 = this.m_coefficientTable.getGrid();
        var5_12 = new GeneralGridSelectionManager(0, 2, 0);
        var4_4.setGridSelectionManager(var5_12);
        var5_12.addVetoableChangeListener(this);
        var6_6 = new Dm4jSpreadTableExcelAdapter(this.m_coefficientTable);
        this.m_filter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GLMModelContentPanel.this.m_filter_actionPerformed(actionEvent);
            }
        });
        this.m_sortAbsoluteCoefficientValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GLMModelContentPanel.this.m_sortAbsoluteCoefficientValue_actionPerformed(actionEvent);
            }
        });
        this.formatAndSizeColumns();
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n2 = twoDSelection2.getSingleRow();
        if (n2 != (n = twoDSelection.getSingleRow())) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            String string = DM4JResourceUtilities.getUIString("CLASS_SVM_NO_COEFFICIENT");
            String string2 = DM4JResourceUtilities.getUIString("COMMON_GET_COEFFICIENT_FAILED");
            String string3 = "";
            if (n2 >= 0) {
                string3 = (String)this.m_coefficientTable.getGrid().getModel().getData(0, n2);
            }
            if (string3 != null) {
                if (string3.equals(string) || string3.equals(string2)) {
                    this.m_sortAbsoluteCoefficientValue.setEnabled(false);
                    this.m_exportButton.setEnabled(false);
                } else {
                    this.m_sortAbsoluteCoefficientValue.setEnabled(true);
                    this.m_exportButton.setEnabled(true);
                    this.m_filter.setEnabled(true);
                }
                return;
            }
            this.m_sortAbsoluteCoefficientValue.setEnabled(true);
            this.m_exportButton.setEnabled(true);
            this.m_filter.setEnabled(true);
        }
    }

    protected void m_filter_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setCursor(new Cursor(3));
            this.m_showIntercept.setSelected(false);
            FilterAttributesDialog filterAttributesDialog = new FilterAttributesDialog(null, this.m_model, this.m_condition, DM4JResourceUtilities.getUIString("COMMON_FILTER_ATTRIBUTES_DIALOG"), true);
            this.setCursor(new Cursor(0));
            filterAttributesDialog.display();
            if (!filterAttributesDialog.isCancelled()) {
                Vector vector = filterAttributesDialog.getSelectedAttributes();
                Double d = filterAttributesDialog.getTopValue();
                Double d2 = filterAttributesDialog.getBottomValue();
                Boolean bl = filterAttributesDialog.isFilterByAbsoluteValue();
                Boolean bl2 = filterAttributesDialog.isIncludedAttributes();
                String string = filterAttributesDialog.getSortByValue();
                String string2 = filterAttributesDialog.getSortOrderValue();
                this.m_condition.put("COMMON_FILTER_ATTRIBUTES", vector);
                this.m_condition.put("COMMON_FILTER_TOP", d);
                this.m_condition.put("COMMON_FILTER_BOTTOM", d2);
                this.m_condition.put("COMMON_FILTER_BY_ABSOULTE_VALUES", bl);
                this.m_condition.put("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES", bl2);
                Number number = this.m_tfSize.getNumber();
                if (number == null) {
                    DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.m_condition.put("COMMON_FETCH_SIZE", new Integer(number.intValue()));
                this.m_condition.put("COMMON_FILTER_SORT_VALUE", string);
                this.m_condition.put("COMMON_FILTER_SORT_ORDER", string2);
                this.m_condition.put("COMMON_TEXT_LOOKUP", this.m_lookupTableMap);
                this.m_coefficientTable.load(this.nonRefCategory, this.m_condition);
                this.m_coefficientTable.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void formatAndSizeColumns() {
        this.m_coefficientTable.setResize(true);
        this.m_coefficientTable.setColumnWidths(100);
        this.m_coefficientTable.setResize(false);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance();
        NumberFormat numberFormat2 = DM4JNumericFormat.getInstance(false, 6);
        FormatPainter formatPainter = new FormatPainter(numberFormat2);
        this.m_coefficientTable.getGrid().setColumnPainter(2, formatPainter);
        if (this._isCovarianceMatrix) {
            this.m_coefficientTable.getGrid().setColumnPainter(3, formatPainter);
            this.m_coefficientTable.getGrid().setColumnPainter(4, formatPainter);
            this.m_coefficientTable.getGrid().setColumnPainter(5, formatPainter);
            this.m_coefficientTable.getGrid().setColumnPainter(6, formatPainter);
            this.m_coefficientTable.getGrid().setColumnPainter(7, formatPainter);
            this.m_coefficientTable.getGrid().setColumnPainter(8, formatPainter);
            this.m_coefficientTable.getGrid().setColumnPainter(9, formatPainter);
            this.m_coefficientTable.getGrid().setColumnPainter(10, formatPainter);
            this.m_coefficientTable.getGrid().setColumnPainter(11, formatPainter);
        }
        if (!this._isClassification) {
            if (this._isCovarianceMatrix) {
                this.m_coefficientTable.getGrid().setColumnPainter(12, formatPainter);
            } else {
                this.m_coefficientTable.getGrid().setColumnPainter(3, formatPainter);
            }
        }
    }
}

