/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.text.Collator;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.HashMap;
import javax.datamining.base.Model;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.classification.AbsoluteNumberComparator;
import oracle.dmt.dm4j.browser.viewer.classification.GLMCoefficientLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.GLMCoefficientTableModel;
import oracle.dmt.dm4j.browser.viewer.classification.LoadGLMCoefficientWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;
import oracle.dmt.jdm.data.OraAttributeCoefficient;

public final class GLMCoefficientTable
extends Dm4jSpreadTable
implements GLMCoefficientLoadedListener {
    private LoadGLMCoefficientWorker m_worker = null;
    private GLMCoefficientTableModel m_tableModel;
    private boolean loaded = false;
    private boolean _isClassification = true;
    private boolean _isCovarianceMatrixComputed = true;
    HashMap m_condition = new HashMap();
    private String[] m_glmc_columnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_NAME"), DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_VALUE"), DM4JResourceUtilities.getUIString("CLASS_SVM_COEFFICIENT"), DM4JResourceUtilities.getUIString("GLM_STD_ERROR"), DM4JResourceUtilities.getUIString("GLM_TEST_STATISTIC"), DM4JResourceUtilities.getUIString("GLM_P_VALUE"), DM4JResourceUtilities.getUIString("GLM_STD_COEFFICIENT"), DM4JResourceUtilities.getUIString("GLM_LOWER_COEFF_LIMIT"), DM4JResourceUtilities.getUIString("GLM_UPPER_COEFF_LIMIT"), DM4JResourceUtilities.getUIString("GLM_EXP_COEFFICIENT"), DM4JResourceUtilities.getUIString("GLM_EXP_LOWER_COEFF_LIMIT"), DM4JResourceUtilities.getUIString("GLM_EXP_UPPER_COEFF_LIMIT")};
    private String[] m_glmc_redColNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_NAME"), DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_VALUE"), DM4JResourceUtilities.getUIString("CLASS_SVM_COEFFICIENT")};
    private String[] m_glmr_columnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_NAME"), DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_VALUE"), DM4JResourceUtilities.getUIString("CLASS_SVM_COEFFICIENT"), DM4JResourceUtilities.getUIString("GLM_STD_ERROR"), DM4JResourceUtilities.getUIString("GLM_TEST_STATISTIC"), DM4JResourceUtilities.getUIString("GLM_P_VALUE"), DM4JResourceUtilities.getUIString("GLM_STD_COEFFICIENT"), DM4JResourceUtilities.getUIString("GLM_LOWER_COEFF_LIMIT"), DM4JResourceUtilities.getUIString("GLM_UPPER_COEFF_LIMIT"), DM4JResourceUtilities.getUIString("GLM_EXP_COEFFICIENT"), DM4JResourceUtilities.getUIString("GLM_EXP_LOWER_COEFF_LIMIT"), DM4JResourceUtilities.getUIString("GLM_EXP_UPPER_COEFF_LIMIT"), DM4JResourceUtilities.getUIString("GLM_VIF")};
    private String[] m_glmr_redColNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_NAME"), DM4JResourceUtilities.getUIString("CLASS_SVM_ATTRIBUTE_VALUE"), DM4JResourceUtilities.getUIString("CLASS_SVM_COEFFICIENT"), DM4JResourceUtilities.getUIString("GLM_VIF")};

    public GLMCoefficientTable(Object object, boolean bl, boolean bl2) {
        super(object);
        this._isClassification = bl;
        this._isCovarianceMatrixComputed = bl2;
        if (bl) {
            if (this._isCovarianceMatrixComputed) {
                this.setColumnNames(this.m_glmc_columnNames);
            } else {
                this.setColumnNames(this.m_glmc_redColNames);
            }
        } else if (this._isCovarianceMatrixComputed) {
            this.setColumnNames(this.m_glmr_columnNames);
        } else {
            this.setColumnNames(this.m_glmr_redColNames);
        }
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(Object object, HashMap hashMap) throws Exception {
        this.m_condition = hashMap;
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setVerticalSeparatorsVisible(true);
        Model model = (Model)this.getDataItem();
        if (null == model) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        this.m_worker = (LoadGLMCoefficientWorker)workerThreadManager.getLoadGLMCoefficientWorker(model, object, hashMap);
        this.m_worker.addGLMCoefficientLoadedListener(this);
        this.m_worker.start();
    }

    public void setSortAbsoluteCoefficient(boolean bl) {
        if (this.m_tableModel != null) {
            Class clazz;
            Comparator comparator = this.m_tableModel.getColumnComparator(2);
            if (bl) {
                clazz = AbsoluteNumberComparator.class;
                this.m_tableModel.setColumnComparator(2, AbsoluteNumberComparator.getComparator());
            } else {
                clazz = NumberComparator.class;
                this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
            }
            if (!comparator.getClass().equals(clazz)) {
                this.m_tableModel.sort(2, false);
            }
        }
    }

    public void addInterceptRow() {
        this.m_tableModel.addInterceptRow();
        this.setFirstRowOnScreen(0);
        this.setFirstColumnOnScreen(0);
    }

    public void removeInterceptRow() {
        this.m_tableModel.removeInterceptRow();
        this.setFirstRowOnScreen(0);
        this.setFirstColumnOnScreen(0);
    }

    public void glmCoefficientLoaded(EventObject eventObject) {
        Object object;
        GLMCoefficientTableModel gLMCoefficientTableModel;
        this.setVerticalSeparatorsVisible(true);
        this.m_tableModel = gLMCoefficientTableModel = (GLMCoefficientTableModel)eventObject.getSource();
        this.setModels((TwoDModel)gLMCoefficientTableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        this.m_worker = null;
        header.setItemInputHandler(new SortInputHandler(this.m_tableModel));
        this.m_tableModel.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(2, NumberComparator.getComparator());
        this.setColumnWidths(100);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance();
        NumberFormat numberFormat2 = DM4JNumericFormat.getInstance(false, 6);
        FormatPainter formatPainter = new FormatPainter(numberFormat2);
        this.getGrid().setColumnPainter(2, formatPainter);
        if (this._isCovarianceMatrixComputed) {
            this.getGrid().setColumnPainter(3, formatPainter);
            this.getGrid().setColumnPainter(4, formatPainter);
            this.getGrid().setColumnPainter(5, formatPainter);
            this.getGrid().setColumnPainter(6, formatPainter);
            this.getGrid().setColumnPainter(7, formatPainter);
            this.getGrid().setColumnPainter(8, formatPainter);
            this.getGrid().setColumnPainter(9, formatPainter);
            this.getGrid().setColumnPainter(10, formatPainter);
            this.getGrid().setColumnPainter(11, formatPainter);
            if (!this._isClassification) {
                this.getGrid().setColumnPainter(12, formatPainter);
            }
        } else if (!this._isClassification) {
            this.getGrid().setColumnPainter(3, formatPainter);
        }
        if (this.m_tableModel.getRowCount() > 0) {
            try {
                object = new TwoDSelection(0, true);
                this.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.getGrid();
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 10));
        ((Grid)object).setColumnPainter(2, dM4JTruncatingNumberFormatPainter);
        Boolean bl = Boolean.FALSE;
        if (this.m_condition != null && (bl = (Boolean)this.m_condition.get("CLASS_SVM_SORT_ABSOLUTE_COEFFICIENT")) != null) {
            this.setSortAbsoluteCoefficient(bl);
        }
        this.loaded = true;
    }

    public OraAttributeCoefficient getAttributeCoefficient(int n) {
        return this.m_tableModel.getAttributeCoefficient(n);
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

