/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;

public class DTRulesExportTableModel
extends AbstractTableModel {
    String m_type = null;
    Vector m_rows = null;
    public static final int PROFILE_ID_COLUMN = 0;
    public static final int PREDICTED_VALUE_COLUMN = 1;
    public static final int SUPPORT_COLUMN = 2;
    public static final int CONFIDENCE_COLUMN = 3;
    public static final int DESCRIPTION_COLUMN = 4;
    private static String[] columns = new String[]{"PROFILE_ID", "PREDICTED_VALUE", "SUPPORT", "CONFIDENCE", "DESCRIPTION"};
    private int COLUMN_COUNT = columns.length;
    private String m_modelName;
    static String RULES_QUERY_WITH = "with \"{0}\" as ";
    static String RULES_QUERY_SELECT = "(SELECT * FROM\nXMLTABLE('\ndeclare function local:parent_node($e as element()*) as element()*\n{\n  for $n in $e\n    return\n    <dummy id=\"{$n/@id}\">\n      {local:parent_node($n/../../Node[@id=$n/../@id])}\n      {$n/SimplePredicate}\n      {$n/SimpleSetPredicate}\n      {\n        if ($n/CompoundPredicate/@booleanOperator=\"surrogate\") then\n          $n/CompoundPredicate/*[1]\n        else\n          $n/CompoundPredicate\n      }\n    </dummy>/*\n}; declare function local:eliminate_duplicate_SimplePredicates($e as\nelement()*) as element()*\n{\n  for $all in $e/*\n  return\n    <dummy>\n    {\n   if (count($e/SimplePredicate[@field=$all/@field and\n@operator=$all/@operator]) > 1) then\n      if ($all/@value = $e/SimplePredicate[@field=$all/@field and\n@operator=$all/@operator][last()]/@value) then\n        $all\n      else ()\n    else\n      $all\n    }\n    </dummy>/*\n}; declare function local:eliminate_duplicate_SimpleSetPredicates($e as\nelement()*) as element()*\n{\n  for $all in $e/*\n  return\n    <dummy>\n    {\n    if (count($e/SimpleSetPredicate[@field=$all/@field and\n@booleanOperator=$all/@booleanOperator]) > 1) then\n      if ($all/Array is $e/SimpleSetPredicate[@field=$all/@field and\n@booleanOperator=$all/@booleanOperator][last()]/Array) then\n        $all\n      else ()\n    else\n      $all\n    }\n    </dummy>/*\n}; for $a at $i in /PMML/TreeModel//Node[not(Node)]\n      where count($a/../../Node) > 0\n    return\n      if (count($a/../../../Node) > 0) then\n        <SimpleRule id=\"{$i}\" score=\"{$a/@score}\"\nrecordCount=\"{$a/@recordCount}\">\n          <CompoundPredicate booleanOperator=\"and\">\n          {local:eliminate_duplicate_SimpleSetPredicates(\n            <dummy>\n              {local:eliminate_duplicate_SimplePredicates(\n                <dummy>\n                  {local:parent_node($a)}\n                </dummy>\n              )}\n            </dummy>\n          )}\n          </CompoundPredicate>\n          {$a/ScoreDistribution}\n        </SimpleRule>\n      else\n    <SimpleRule id=\"{$i}\" score=\"{$a/@score}\"\nrecordCount=\"{$a/@recordCount}\">\n      {$a/SimplePredicate}\n      {$a/SimpleSetPredicate}\n      {\n        if ($a/CompoundPredicate/@booleanOperator=\"surrogate\") then\n          $a/CompoundPredicate/*[1]\n        else\n          $a/CompoundPredicate\n      }\n      {$a/ScoreDistribution}\n    </SimpleRule>\n' PASSING dbms_data_mining.get_model_details_xml(?)\nCOLUMNS\n    \"PROFILE_ID\" FOR ORDINALITY,\n    \"RECORD_COUNT\" NUMBER PATH '/SimpleRule/@recordCount',\n    \"DESCRIPTION\" XMLType PATH '.'\n))\n\nselect profile_id, predicted_value, support, confidence, \nreplace(replace(replace(rtrim(extractvalue(description, '/text()'), \n'DMandDM ' || chr(10)), 'DMandDM ', 'and '), 'greaterThan', '>'), \n'lessOrEqual', '<=') description \nfrom (\nselect\n  profile_id,\n  extractvalue(description, '/SimpleRule/@score') predicted_value,\n  record_count/tot.sum_rec_count support,\n  extractvalue(description, '/SimpleRule/ScoreDistribution[@value=\"' ||\nextractvalue(description, '/SimpleRule/@score') ||\n'\"]/@recordCount')/record_count confidence,\n  xmlquery('\n  for $n in /SimpleRule/child::node() return\n    if ($n instance of element(CompoundPredicate)) then\n      for $i in $n/* return\n        if ($i instance of element(SimplePredicate)) then\n          concat(\n            string($i/@field),string('' ''),\n            string($i/@operator),string('' ''),\n            string($i/@value),string('' DMandDM '')\n          )\n        else if ($i instance of element(SimpleSetPredicate)) then\n          concat(\n            string($i/@field),string('' ''),\n            string($i/@booleanOperator),string('' (''),\n            string($i/Array/text()),string('') DMandDM '')\n          )\n        else\n          string('''')\n    else if ($n instance of element(SimplePredicate)) then\n      concat(\n        string($n/@field),string('' ''),\n        string($n/@operator),string('' ''),\n        string($n/@value),string('' DMandDM '')\n      )\n    else if ($n instance of element(SimpleSetPredicate)) then\n      concat(\n        string($n/@field),string('' ''),\n        string($n/@booleanOperator),string('' (''),\n        string($n/Array/text()),string('') DMandDM '')\n      )\n    else\n      string('''')\n  ' PASSING description RETURNING CONTENT\n) description \n";
    static String RULES_QUERY_FROM = "from\n  \"{0}\",\n  (select sum(record_count) sum_rec_count from \"{0}\") tot)";

    public DTRulesExportTableModel(String string) {
        this.m_modelName = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() throws Exception {
        Connection connection = null;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.m_rows = new Vector(100, 500);
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("DMS_CONNECTION_NOCREATE"), DM4JVersion.getFullBrowserName(), 0);
            return;
        }
        try {
            try {
                string = MessageFormat.format(RULES_QUERY_WITH, this.m_modelName) + RULES_QUERY_SELECT + MessageFormat.format(RULES_QUERY_FROM, this.m_modelName);
                statement = connection.prepareStatement(string);
                statement.setString(1, this.m_modelName);
                statement.setFetchSize(100);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Object[] objectArray = new Object[]{new Integer(resultSet.getInt(columns[0])), resultSet.getString(columns[1]), new Double(resultSet.getDouble(columns[2])), new Double(resultSet.getDouble(columns[3])), resultSet.getString(columns[4])};
                    this.m_rows.add(objectArray);
                }
                Object var9_9 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                resultSet = null;
                statement = null;
                connection = null;
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (connection != null) {
            connection.close();
        }
        resultSet = null;
        statement = null;
        connection = null;
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return this.COLUMN_COUNT;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Number.class;
        }
        if (n == 2 || n == 3) {
            return Double.class;
        }
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        Object[] objectArray = (Object[])this.m_rows.get(n);
        if (objectArray != null) {
            return objectArray[n2];
        }
        return null;
    }
}

