/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.datamining.NamedObject;
import javax.datamining.data.CategoryMatrix;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.results.test.ConfusionMatrixTable;
import oracle.dmt.jdm.resource.OraConnection;

public class CostMatrixPanel
extends GriddedPanel {
    private String m_panelDescriptionResourceKey = null;
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private CategoryMatrix m_costMatrix = null;
    private ConfusionMatrixTable m_cmTable = null;
    private String m_cmTableName = null;
    private GriddedPanel m_loadingPanel = new GriddedPanel();

    public CostMatrixPanel(String string, CategoryMatrix categoryMatrix) throws Exception {
        this.m_panelDescriptionResourceKey = string;
        this.m_costMatrix = categoryMatrix;
        this.jbInit();
        this.runTimePanelLoad();
    }

    public CostMatrixPanel(String string, String string2) throws Exception {
        this.m_panelDescriptionResourceKey = string;
        this.m_cmTableName = string2;
        if (this.m_cmTableName == null) {
            throw new Exception("No Cost Matrix Table Name available.");
        }
        this.addComponent(this.createLoadingPanel(), GriddedPanel.TOPLABELITEMINSETS, 0, 0, 0, 0, 12, 1);
        LoadCostMatrix loadCostMatrix = new LoadCostMatrix();
        loadCostMatrix.start();
    }

    public JPanel createLoadingPanel() {
        int n = 0;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_LOADING"));
        this.m_loadingPanel.addAnchoredComponent(jLabel, GriddedPanel.TOPLABELITEMINSETS, n, 0, 1, 1, 18);
        JLabel jLabel2 = new JLabel();
        this.m_loadingPanel.addComponent(jLabel2, GriddedPanel.TOPLABELITEMINSETS, n, 0, 2, 2, 18, 1);
        this.m_loadingPanel.setPreferredSize(new Dimension(640, 500));
        return this.m_loadingPanel;
    }

    private void validatePanel() {
        this.validate();
        this.repaint();
    }

    private void runTimePanelLoad() throws Exception {
        this.m_cmTable.load();
        this.m_cmTable.setResize(false);
        this.m_cmTable.setAutoResize(false);
        this.m_cmTable.setColumnWidths(75);
        this.m_cmTable.setDefaultColumnWidth(75);
    }

    private void removeLoadingPanel() {
        this.remove(this.m_loadingPanel);
    }

    private void jbInit() throws Exception {
        int n = 0;
        if (null != this.m_costMatrix) {
            JLabel jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.getUIString("CLASS_COST_MATRIX_DESC"));
            this.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
            JScrollPane jScrollPane = new JScrollPane();
            JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
            jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
            this.addAnchoredComponent(jButton, TOPLABELITEMINSETS, n++, 2, 1, 1, 14);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                        ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                        if (!exportDialog.isCancelled()) {
                            exportDialog.export(CostMatrixPanel.this.m_cmTable);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            this.m_cmTable = new ConfusionMatrixTable(this.m_costMatrix);
            this.m_cmTable.setShowFloats(true);
            jScrollPane.getViewport().add(this.m_cmTable);
            jScrollPane.setPreferredSize(null);
            this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n, 0, 3, 2, 1);
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
            Grid grid = this.m_cmTable.getGrid();
            grid.setGridSelectionManager(generalGridSelectionManager);
            Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_cmTable);
        }
    }

    class LoadCostMatrix
    extends Thread {
        GriddedPanel panel;
        Exception exception = null;

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block11: {
                OraConnection oraConnection = null;
                this.panel = null;
                oraConnection = (OraConnection)DM4JConnectionManager.getConnection();
                CostMatrixPanel.this.m_costMatrix = (CategoryMatrix)((Object)oraConnection.retrieveObject(CostMatrixPanel.this.m_cmTableName, NamedObject.costMatrix));
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            try {
                                CostMatrixPanel.this.removeLoadingPanel();
                                CostMatrixPanel.this.jbInit();
                                CostMatrixPanel.this.runTimePanelLoad();
                                CostMatrixPanel.this.validatePanel();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var3_2 = null;
                            }
                            Object var3_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            throw throwable;
                        }
                    }
                };
                EventQueue.invokeLater(runnable);
                Object var4_4 = null;
                try {
                    if (oraConnection != null) {
                        oraConnection.close();
                    }
                    break block11;
                }
                catch (Exception exception) {}
                break block11;
                {
                    catch (Exception exception) {
                        this.exception = exception;
                        exception.printStackTrace();
                        Object var4_5 = null;
                        try {
                            if (oraConnection != null) {
                                oraConnection.close();
                            }
                            break block11;
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    try {
                        if (oraConnection != null) {
                            oraConnection.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }
}

