/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.datamining.NamedObject;
import javax.datamining.SizeUnit;
import javax.datamining.algorithm.naivebayes.NaiveBayesSettings;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.classification.SVMClassificationSettings;
import javax.datamining.algorithm.tree.TreeSettings;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.data.CategoryMatrix;
import javax.datamining.data.PhysicalDataSet;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.classification.ClassificationSettings;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.AttributeTable;
import oracle.dmt.dm4j.browser.table.Dm4jSortableTwoDModel;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.classification.ClassificationModelViewer;
import oracle.dmt.dm4j.browser.viewer.classification.CostMatrixPanel;
import oracle.dmt.dm4j.browser.viewer.classification.PriorProbabilityPanel;
import oracle.dmt.dm4j.browser.viewer.classification.TargetWeightsPanel;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;
import oracle.dmt.jdm.algorithm.abn.OraABNSettings;
import oracle.dmt.jdm.algorithm.glm.OraGLMClassificationSettings;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettings;
import oracle.dmt.jdm.algorithm.tree.OraTreeSettings;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.resource.OraConnection;

public class ClassificationSettingsPanel
extends GriddedPanel {
    JLabel m_modelType = new JLabel();
    JLabel m_algorithmType = new JLabel();
    JLabel m_targetAttribName = new JLabel();
    JLabel m_sequenceID = new JLabel();
    JLabel m_runTimeLimit = new JLabel();
    JLabel m_featureDepth = new JLabel();
    JLabel m_numPrunedFeatures = new JLabel();
    JLabel m_maxPredictors = new JLabel();
    JLabel m_numNBPredictors = new JLabel();
    JLabel m_modelBuildType = new JLabel();
    JLabel m_pairwiseThreshold = new JLabel();
    JLabel m_singletonThreshold = new JLabel();
    JLabel m_kernelFunction = new JLabel();
    JLabel m_standardDeviation = new JLabel();
    JLabel m_kernelCacheSize = new JLabel();
    JLabel m_complexityFactor = new JLabel();
    JLabel m_tolerance = new JLabel();
    JLabel m_autoNormalization = new JLabel();
    JLabel m_learningEnabled = new JLabel();
    JLabel m_outlierRate = new JLabel();
    JLabel m_confidenceLevel = new JLabel();
    JLabel m_diagnosticsTableName = new JLabel();
    JLabel m_missingValueTreatment = new JLabel();
    JLabel m_referenceCategory = new JLabel();
    JLabel m_ridgeValue = new JLabel();
    JLabel m_automaticDataPreparation = new JLabel();
    JLabel m_hm = new JLabel();
    JLabel m_maxDepth = new JLabel();
    JLabel m_minNodeSize = new JLabel();
    JLabel m_minPercentNode = new JLabel();
    JLabel m_minRecsForSplit = new JLabel();
    JLabel m_minPercentForSplit = new JLabel();
    JComboBox m_comboAlgorithmSelection = new JComboBox();
    JScrollPane m_attribPanel = new JScrollPane();
    JScrollPane m_settingPanel = new JScrollPane();
    SettingTable m_settingTable = null;
    AttributeTable m_attribTable = null;
    Map m_priorProb = null;
    Map m_targetWeight = null;
    CategoryMatrix m_costMatrix = null;
    ClassificationSettings m_settings = null;
    SupervisedModel m_model = null;
    PhysicalDataSet m_pds = null;
    AlgorithmSettings[] m_masArray = null;
    LeafNodeData m_leafNodeData = null;
    JButton ppButton = new JButton();
    JButton twButton = new JButton();
    JButton cmButton = new JButton();
    CategoryMatrix costMatrix = null;
    Map priorProb = null;

    public ClassificationSettingsPanel(SupervisedModel supervisedModel, LeafNodeData leafNodeData) {
        this.m_model = supervisedModel;
        try {
            this.m_settings = (ClassificationSettings)this.m_model.getBuildSettings();
        }
        catch (Exception exception) {
            System.out.print("Failure retrieving model settings, probably due to missing priors, weights or cost matrix.");
            exception.printStackTrace();
        }
        this.m_leafNodeData = leafNodeData;
        try {
            if (this.m_settings == null) {
                this.loadNotFoundPanel();
            } else {
                this.jbInit();
                this.runTimePanelLoad();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ClassificationSettingsPanel(SupervisedModel supervisedModel, PhysicalDataSet physicalDataSet, LeafNodeData leafNodeData) {
        this.m_model = supervisedModel;
        try {
            this.m_settings = (ClassificationSettings)this.m_model.getBuildSettings();
        }
        catch (Exception exception) {
            System.out.print("Failure retrieving model settings, probably due to missing priors, weights or cost matrix.");
            exception.printStackTrace();
        }
        this.m_pds = physicalDataSet;
        this.m_leafNodeData = leafNodeData;
        try {
            if (this.m_settings == null) {
                this.loadNotFoundPanel();
            } else {
                this.jbInit();
                this.runTimePanelLoad();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        Container container = this.getParent();
        if (container instanceof ClassificationModelViewer) {
            if (this.m_settings.getAlgorithmSettings() instanceof OraABNSettings) {
                return "ABN_MODEL";
            }
            if (this.m_settings.getAlgorithmSettings() instanceof SVMClassificationSettings) {
                return "SVM_CLASSIFICATION_MODEL";
            }
            if (this.m_settings.getAlgorithmSettings() instanceof NaiveBayesSettings) {
                return "NB_MODEL";
            }
            if (this.m_settings.getAlgorithmSettings() instanceof OraGLMClassificationSettings) {
                return "GLM_MODEL";
            }
            return "";
        }
        if (this.m_settings.getAlgorithmSettings() instanceof OraABNSettings) {
            return "CLASSIFICATION_ABN_SETTING";
        }
        if (this.m_settings.getAlgorithmSettings() instanceof NaiveBayesSettings) {
            return "CLASSIFICATION_NB_SETTING";
        }
        if (this.m_settings.getAlgorithmSettings() instanceof SVMClassificationSettings) {
            return "CLASSIFICATION_SVM_SETTING";
        }
        if (this.m_settings.getAlgorithmSettings() instanceof OraGLMClassificationSettings) {
            return "GLM_MODEL";
        }
        return "CLASSIFICATION_MS_SETTING";
    }

    private void loadNotFoundPanel() {
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 0, 0, 4, 1, 2);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 1, 0, 1, 1, 2);
        this.addFilledComponent(new JLabel(DM4JResourceUtilities.getUIString("COMMON_SETTINGS_NOT_FOUND")), TOPLABELITEMINSETS, 1, 1, 2, 1, 2);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 2, 0, 4, 3, 1);
        this.setPreferredSize(new Dimension(0, 0));
    }

    private void jbInit() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n, 0);
        if (!this.m_leafNodeData.getNodeType().equals("SVM_ONE_CLASS_MODEL")) {
            this.m_modelType.setText(DM4JResourceUtilities.getUIString("CLASS_MODEL_TYPE"));
        } else {
            this.m_modelType.setText(DM4JResourceUtilities.getUIString("ANOMALY_MODEL_TYPE"));
        }
        this.addComponent(this.m_modelType, TOPVALUEITEMINSETS, n++, 1);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITHM_TYPE"));
        this.addComponent(jLabel2, MIDLABELITEMINSETS, n, 0);
        if (this.m_settings.getAlgorithmSettings() instanceof OraABNSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("CLASS_MODEL_TYPE_ABN"));
        } else if (this.m_settings.getAlgorithmSettings() instanceof NaiveBayesSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("CLASS_MODEL_TYPE_NB"));
        } else if (this.m_settings.getAlgorithmSettings() instanceof SVMClassificationSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("CLASS_MODEL_TYPE_SVM"));
        } else if (this.m_settings.getAlgorithmSettings() instanceof TreeSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("TREE_MODEL"));
        } else if (this.m_settings.getAlgorithmSettings() instanceof OraGLMClassificationSettings) {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("CLASS_MODEL_TYPE_GLM"));
        } else {
            this.m_algorithmType.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
        }
        this.addComponent(this.m_algorithmType, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        this.addComponent(jLabel3, MIDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_targetAttribName, MIDVALUEITEMINSETS, n++, 1);
        if (BrowserFrame.is11Server()) {
            object7 = new JLabel();
            ((JLabel)object7).setText(DM4JResourceUtilities.getUIString("AUTOMATIC_DATA_PREPARATION"));
            this.addComponent((JComponent)object7, MIDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_automaticDataPreparation, MIDVALUEITEMINSETS, n++, 1);
        }
        if (this.m_modelType.getText().equalsIgnoreCase(DM4JResourceUtilities.getUIString("ANOMALY_MODEL_TYPE"))) {
            jLabel3.setVisible(false);
            this.m_targetAttribName.setVisible(false);
        }
        if (this.m_settings.getAlgorithmSettings() instanceof OraABNSettings) {
            object7 = new JLabel();
            ((JLabel)object7).setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
            this.addComponent((JComponent)object7, TOPLABELITEMINSETS, n++, 0);
            object6 = (OraABNSettings)this.m_settings.getAlgorithmSettings();
            object5 = object6.getModelType().name();
            if (object6.getModelType().equals(OraABNModelType.naiveBayes)) {
                object4 = new JLabel();
                ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("CLASS_NUM_NB_PREDICTORS"));
                this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
                this.addComponent(this.m_numNBPredictors, MIDVALUEITEMINSETS, n++, 1);
            } else if (object6.getModelType().equals(OraABNModelType.multiFeature)) {
                object4 = new JLabel();
                ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("CLASS_RUN_TIME_LIMIT"));
                this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
                this.addComponent(this.m_runTimeLimit, MIDVALUEITEMINSETS, n++, 1);
                object3 = new JLabel();
                ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("CLASS_MAX_PREDICTORS"));
                this.addComponent((JComponent)object3, MIDINDENTEDLABELITEMINSETS, n, 0);
                this.addComponent(this.m_maxPredictors, MIDVALUEITEMINSETS, n++, 1);
                object2 = new JLabel();
                ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("CLASS_NUM_NB_PREDICTORS"));
                this.addComponent((JComponent)object2, MIDINDENTEDLABELITEMINSETS, n, 0);
                this.addComponent(this.m_numNBPredictors, MIDVALUEITEMINSETS, n++, 1);
            } else {
                object4 = new JLabel();
                ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("CLASS_RUN_TIME_LIMIT"));
                this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
                this.addComponent(this.m_runTimeLimit, MIDVALUEITEMINSETS, n++, 1);
                object3 = new JLabel();
                ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("CLASS_MAX_PREDICTORS"));
                this.addComponent((JComponent)object3, MIDINDENTEDLABELITEMINSETS, n, 0);
                this.addComponent(this.m_maxPredictors, MIDVALUEITEMINSETS, n++, 1);
            }
            object4 = new JLabel();
            ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("CLASS_MODEL_BUILD_TYPE"));
            this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_modelBuildType, MIDVALUEITEMINSETS, n++, 1);
        } else if (this.m_settings.getAlgorithmSettings() instanceof NaiveBayesSettings) {
            object7 = new JLabel();
            ((JLabel)object7).setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
            this.addComponent((JComponent)object7, TOPLABELITEMINSETS, n++, 0);
            object6 = new JLabel();
            ((JLabel)object6).setText(DM4JResourceUtilities.getUIString("CLASS_PAIRWISE_THRESHOLD"));
            this.addComponent((JComponent)object6, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_pairwiseThreshold, MIDVALUEITEMINSETS, n++, 1);
            object5 = new JLabel();
            ((JLabel)object5).setText(DM4JResourceUtilities.getUIString("CLASS_SINGLETON_THRESHOLD"));
            this.addComponent((JComponent)object5, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_singletonThreshold, MIDVALUEITEMINSETS, n++, 1);
        } else if (this.m_settings.getAlgorithmSettings() instanceof SVMClassificationSettings) {
            object7 = (SVMClassificationSettings)this.m_settings.getAlgorithmSettings();
            object6 = new JLabel();
            ((JLabel)object6).setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
            this.addComponent((JComponent)object6, TOPLABELITEMINSETS, n++, 0);
            object5 = new JLabel();
            ((JLabel)object5).setText(DM4JResourceUtilities.getUIString("CLASS_KERNEL_FUNCTION"));
            this.addComponent((JComponent)object5, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_kernelFunction, MIDVALUEITEMINSETS, n++, 1);
            if (object7.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                object4 = new Insets(0, 30, 0, 5);
                object3 = new Insets(0, 0, 0, 5);
                object2 = new JLabel();
                ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("CLASS_STANDARD_DEVIATION"));
                this.addComponent((JComponent)object2, (Insets)object4, n, 0);
                this.addComponent(this.m_standardDeviation, (Insets)object3, n++, 1);
                object = new JLabel();
                ((JLabel)object).setText(DM4JResourceUtilities.getUIString("CLASS_KERNEL_CACHE_SIZE"));
                this.addComponent((JComponent)object, (Insets)object4, n, 0);
                this.addComponent(this.m_kernelCacheSize, (Insets)object3, n++, 1);
            }
            if (!this.m_leafNodeData.getNodeType().equals("SVM_ONE_CLASS_MODEL")) {
                object4 = new JLabel();
                ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("CLASS_COMPLEXITY_FACTOR"));
                this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
                this.addComponent(this.m_complexityFactor, MIDVALUEITEMINSETS, n++, 1);
            }
            if (this.m_leafNodeData.getNodeType().equals("SVM_ONE_CLASS_MODEL")) {
                object4 = new JLabel();
                ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("CLASS_SVM_OUTLIER_RATE"));
                this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
                this.addComponent(this.m_outlierRate, MIDVALUEITEMINSETS, n++, 1);
            }
            object4 = new JLabel();
            ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("CLASS_TOLERANCE"));
            this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_tolerance, MIDVALUEITEMINSETS, n++, 1);
            object3 = new JLabel();
            ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("CLASS_SVM_ACTIVE_LEARNING"));
            this.addComponent((JComponent)object3, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_learningEnabled, MIDVALUEITEMINSETS, n++, 1);
        } else if (this.m_settings.getAlgorithmSettings() instanceof TreeSettings) {
            object7 = new JLabel();
            ((JLabel)object7).setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
            this.addComponent((JComponent)object7, TOPLABELITEMINSETS, n++, 0);
            object6 = new JLabel();
            ((JLabel)object6).setText(DM4JResourceUtilities.getUIString("TREE_HOMOGENEITY_METRIC"));
            this.addComponent((JComponent)object6, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_hm, MIDVALUEITEMINSETS, n++, 1);
            object5 = new JLabel();
            ((JLabel)object5).setText(DM4JResourceUtilities.getUIString("TREE_MAX_DEPTH"));
            this.addComponent((JComponent)object5, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_maxDepth, MIDVALUEITEMINSETS, n++, 1);
            object4 = new JLabel();
            ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("TREE_MIN_NODE_SIZE"));
            this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_minNodeSize, MIDVALUEITEMINSETS, n++, 1);
            object3 = new JLabel();
            ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("TREE_MIN_NODE_SIZE_P"));
            this.addComponent((JComponent)object3, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_minPercentNode, MIDVALUEITEMINSETS, n++, 1);
            object2 = new JLabel();
            ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("TREE_MIN_RECS_SPLIT"));
            this.addComponent((JComponent)object2, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_minRecsForSplit, MIDVALUEITEMINSETS, n++, 1);
            object = new JLabel();
            ((JLabel)object).setText(DM4JResourceUtilities.getUIString("TREE_MIN_PERCENT_SPLIT"));
            this.addComponent((JComponent)object, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_minPercentForSplit, MIDVALUEITEMINSETS, n++, 1);
        } else if (this.m_settings.getAlgorithmSettings() instanceof OraGLMClassificationSettings) {
            object7 = new JLabel();
            ((JLabel)object7).setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
            this.addComponent((JComponent)object7, TOPLABELITEMINSETS, n++, 0);
            object6 = new JLabel();
            ((JLabel)object6).setText(DM4JResourceUtilities.getUIString("GLM_CONFIDENCE_LEVEL"));
            this.addComponent((JComponent)object6, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_confidenceLevel, MIDVALUEITEMINSETS, n++, 1);
            object5 = new JLabel();
            ((JLabel)object5).setText(DM4JResourceUtilities.getUIString("GLM_DIAGNOSTICS_TABLE"));
            this.addComponent((JComponent)object5, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_diagnosticsTableName, MIDVALUEITEMINSETS, n++, 1);
            object4 = new JLabel();
            ((JLabel)object4).setText(DM4JResourceUtilities.getUIString("GLM_MISSING_VAL_TREAT"));
            this.addComponent((JComponent)object4, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_missingValueTreatment, MIDVALUEITEMINSETS, n++, 1);
            object3 = new JLabel();
            ((JLabel)object3).setText(DM4JResourceUtilities.getUIString("GLM_REFERENCE_TARGET_CLASS"));
            this.addComponent((JComponent)object3, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_referenceCategory, MIDVALUEITEMINSETS, n++, 1);
            object2 = new JLabel();
            ((JLabel)object2).setText(DM4JResourceUtilities.getUIString("GLM_RIDGE_REGRESSION_VALUE"));
            this.addComponent((JComponent)object2, MIDINDENTEDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_ridgeValue, MIDVALUEITEMINSETS, n++, 1);
        } else {
            throw new Exception("Unexpected functions settings object type" + this.m_settings.getClass().getName());
        }
        object7 = new JLabel();
        ((JLabel)object7).setText(DM4JResourceUtilities.getUIString("COMMON_ATTRIBUTES"));
        ((JLabel)object7).setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_ATTRIBUTES"));
        this.addAnchoredComponent((JComponent)object7, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        this.m_attribTable = new AttributeTable(this.m_model);
        object6 = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        ((JComponent)object6).setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent((JComponent)object6, MIDLABELITEMINSETS, n++, 2, 1, 1, 14);
        ((AbstractButton)object6).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(ClassificationSettingsPanel.this.m_attribTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_attribPanel.getViewport().add(this.m_attribTable);
        ((JLabel)object7).setLabelFor(this.m_attribTable);
        this.m_attribPanel.setPreferredSize(null);
        this.addFilledComponent(this.m_attribPanel, MIDLABELITEMINSETS, n, 0, 3, 6, 1);
        object5 = new GeneralGridSelectionManager(0, 2, 0);
        this.m_attribTable.getGrid().setGridSelectionManager((GridSelectionManager)object5);
        object4 = new Dm4jSpreadTableExcelAdapter(this.m_attribTable);
        n += 6;
        if (this.m_settings.getAlgorithmSettings() instanceof SVMClassificationSettings || this.m_settings.getAlgorithmSettings() instanceof OraGLMClassificationSettings) {
            object3 = this.m_settings.getTargetAttributeName();
            if (object3 != null) {
                this.m_targetWeight = this.m_settings.getPriorProbabilitiesMap((String)object3);
                this.twButton.setText(DM4JResourceUtilities.getUIString("CLASS_SVM_WEIGHTS"));
                this.twButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_SVM_WEIGHTS"));
                this.addAnchoredComponent(this.twButton, new Insets(10, 5, 5, 5), n, 2, 1, 1, 12);
                this.twButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClassificationSettingsPanel.this.twButton_actionPerformed(actionEvent);
                    }
                });
                this.twButton.setEnabled(this.m_targetWeight != null);
            }
        } else {
            try {
                this.m_priorProb = this.m_settings.getPriorProbabilitiesMap(this.m_settings.getTargetAttributeName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ppButton.setText(DM4JResourceUtilities.getUIString("CLASS_PRIOR_PROBABILITY"));
            this.ppButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_PRIOR_PROBABILITY"));
            this.addAnchoredComponent(this.ppButton, new Insets(10, 5, 5, 100), n, 2, 1, 1, 12);
            this.ppButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassificationSettingsPanel.this.ppButton_actionPerformed(actionEvent);
                }
            });
            this.ppButton.setEnabled(this.m_priorProb != null);
        }
        if (!(this.m_settings.getAlgorithmSettings() instanceof SVMClassificationSettings) && !(this.m_settings.getAlgorithmSettings() instanceof OraGLMClassificationSettings)) {
            this.cmButton.setText(DM4JResourceUtilities.getUIString("CLASS_COST_MATRIX"));
            this.cmButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_COST_MATRIX"));
            this.cmButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassificationSettingsPanel.this.cmButton_actionPerformed(actionEvent);
                }
            });
            this.addAnchoredComponent(this.cmButton, new Insets(10, 5, 5, 5), n, 2, 1, 1, 12);
            this.cmButton.setEnabled(false);
            object3 = new Runnable(){

                public void run() {
                    ClassificationSettingsPanel.this.cmButton.setEnabled(ClassificationSettingsPanel.this.m_costMatrix != null);
                    ClassificationSettingsPanel.this.setCursor(new Cursor(0));
                }
            };
            object2 = new Runnable((Runnable)object3){
                final /* synthetic */ Runnable val$setButton;
                {
                    this.val$setButton = runnable;
                }

                public void run() {
                    try {
                        OraConnection oraConnection = (OraConnection)DM4JConnectionManager.getConnection();
                        ClassificationSettingsPanel.this.m_costMatrix = (CategoryMatrix)((Object)oraConnection.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(ClassificationSettingsPanel.this.m_settings.getCostMatrixName()), NamedObject.costMatrix));
                        SwingUtilities.invokeLater(this.val$setButton);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        SwingUtilities.invokeLater(this.val$setButton);
                    }
                }
            };
            object = this.m_settings.getCostMatrixName();
            if (this.m_settings.getCostMatrixName() != null && this.m_settings.getCostMatrixName().length() != 0) {
                this.setCursor(new Cursor(3));
                Thread thread = new Thread((Runnable)object2);
                thread.start();
            }
        }
    }

    private void cmButton_actionPerformed(ActionEvent actionEvent) {
        try {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            CostMatrixPanel costMatrixPanel = new CostMatrixPanel("", this.m_costMatrix);
            DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)BrowserUtils.getParentFrame(this), (JPanel)costMatrixPanel, DM4JResourceUtilities.getUIString("CLASS_COST_MATRIX"), null);
            dM4JSimpleDialog.setCloseDialog();
            dM4JSimpleDialog.setNoHelp();
            dM4JSimpleDialog.setSize(new Dimension(500, 400));
            dM4JSimpleDialog.setVisible(true);
            if (!dM4JSimpleDialog.isOk()) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void ppButton_actionPerformed(ActionEvent actionEvent) {
        try {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            PriorProbabilityPanel priorProbabilityPanel = new PriorProbabilityPanel("", this.m_priorProb);
            DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)BrowserUtils.getParentFrame(this), (JPanel)priorProbabilityPanel, DM4JResourceUtilities.getUIString("CLASS_PRIOR_PROBABILITY"), null);
            dM4JSimpleDialog.setCloseDialog();
            dM4JSimpleDialog.setNoHelp();
            dM4JSimpleDialog.setSize(new Dimension(500, 300));
            dM4JSimpleDialog.setVisible(true);
            if (!dM4JSimpleDialog.isOk()) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void twButton_actionPerformed(ActionEvent actionEvent) {
        try {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            TargetWeightsPanel targetWeightsPanel = new TargetWeightsPanel("", this.m_targetWeight);
            DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)BrowserUtils.getParentFrame(this), (JPanel)targetWeightsPanel, DM4JResourceUtilities.getUIString("CLASS_SVM_WEIGHTS"), null);
            dM4JSimpleDialog.setCloseDialog();
            dM4JSimpleDialog.setNoHelp();
            dM4JSimpleDialog.setSize(new Dimension(500, 300));
            dM4JSimpleDialog.setVisible(true);
            if (!dM4JSimpleDialog.isOk()) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void runTimePanelLoad() throws Exception {
        Object object;
        NumberFormat numberFormat = DM4JNumericFormat.getInstance();
        NumberFormat numberFormat2 = DM4JNumericFormat.getInstance(false, 10);
        this.m_attribTable.load();
        String string = this.m_settings.getTargetAttributeName();
        if (string == null) {
            string = this.m_model.getTargetAttributeName();
        }
        this.m_targetAttribName.setText(string);
        if (BrowserFrame.is11Server()) {
            object = ((OraBuildSettings)((Object)this.m_settings)).useAutomatedDataPreparations() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
            this.m_automaticDataPreparation.setText((String)object);
        }
        if (this.m_settings.getAlgorithmSettings() instanceof OraABNSettings) {
            object = (OraABNSettings)this.m_settings.getAlgorithmSettings();
            int n = this.m_settings.getDesiredExecutionTimeInMinutes();
            this.m_runTimeLimit.setText(numberFormat.format(n));
            this.m_maxPredictors.setText(numberFormat.format(object.getMaximumNumberOfPredictors()));
            this.m_numNBPredictors.setText(numberFormat.format(object.getNaiveBayesNumberOfPredictors()));
            String string2 = object.getModelType().name();
            this.m_modelBuildType.setText(string2);
        } else if (this.m_settings.getAlgorithmSettings() instanceof NaiveBayesSettings) {
            object = (NaiveBayesSettings)this.m_settings.getAlgorithmSettings();
            this.m_pairwiseThreshold.setText(numberFormat2.format(object.getPairwiseThreshold()));
            this.m_singletonThreshold.setText(numberFormat2.format(object.getSingletonThreshold()));
        } else if (this.m_settings.getAlgorithmSettings() instanceof SVMClassificationSettings) {
            double d;
            object = (OraSVMClassificationSettings)this.m_settings.getAlgorithmSettings();
            if (((OraSVMClassificationSettings)object).getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                this.m_kernelFunction.setText("Gaussian");
            } else if (((OraSVMClassificationSettings)object).getKernelFunction().name().equalsIgnoreCase(KernelFunction.kLinear.name())) {
                this.m_kernelFunction.setText("Linear");
            } else if (((OraSVMClassificationSettings)object).getKernelFunction().name().equalsIgnoreCase(KernelFunction.systemDetermined.name())) {
                this.m_kernelFunction.setText("System Determined");
            } else {
                this.m_kernelFunction.setText(((OraSVMClassificationSettings)object).getKernelFunction().name());
            }
            if (((OraSVMClassificationSettings)object).getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                d = 0.0;
                try {
                    d = ((OraSVMClassificationSettings)object).getStandardDeviation();
                    if (d > 0.0) {
                        this.m_standardDeviation.setText(numberFormat2.format(d));
                    } else {
                        this.m_standardDeviation.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.m_standardDeviation.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                }
                int n = 0;
                try {
                    n = ((OraSVMClassificationSettings)object).getKernelCacheSize();
                    this.m_kernelCacheSize.setText(numberFormat.format(n));
                }
                catch (RuntimeException runtimeException) {
                    this.m_kernelCacheSize.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                }
            }
            if (!this.m_leafNodeData.getNodeType().equals("SVM_ONE_CLASS_MODEL")) {
                d = 0.0;
                try {
                    d = ((OraSVMClassificationSettings)object).getComplexityFactor();
                    if (d > 0.0) {
                        this.m_complexityFactor.setText(numberFormat2.format(d));
                    } else {
                        this.m_complexityFactor.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.m_complexityFactor.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                }
            }
            if (this.m_leafNodeData.getNodeType().equals("SVM_ONE_CLASS_MODEL")) {
                d = 0.0;
                try {
                    d = ((OraSVMClassificationSettings)object).getOutlierRate();
                    this.m_outlierRate.setText(numberFormat2.format(d));
                }
                catch (RuntimeException runtimeException) {
                    this.m_outlierRate.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
                }
            }
            d = 0.0;
            try {
                d = ((OraSVMClassificationSettings)object).getTolerance();
                this.m_tolerance.setText(numberFormat2.format(d));
            }
            catch (RuntimeException runtimeException) {
                this.m_tolerance.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
            }
            String string3 = "";
            try {
                string3 = ((OraSVMClassificationSettings)object).getActiveLearning() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
                this.m_learningEnabled.setText(string3);
            }
            catch (RuntimeException runtimeException) {
                this.m_learningEnabled.setText(DM4JResourceUtilities.getUIString("COMMON_NOT_AVAILABLE"));
            }
        } else if (this.m_settings.getAlgorithmSettings() instanceof TreeSettings) {
            object = (OraTreeSettings)this.m_settings.getAlgorithmSettings();
            this.m_hm.setText(((OraTreeSettings)object).getBuildHomogeneityMetric().name());
            this.m_maxDepth.setText(new Integer(((OraTreeSettings)object).getMaxDepth()).toString());
            long l = new Double(((OraTreeSettings)object).getMinNodeSize(SizeUnit.count)).longValue();
            this.m_minNodeSize.setText(Long.toString(l));
            this.m_minPercentNode.setText(Double.toString(((OraTreeSettings)object).getMinNodeSize(SizeUnit.percentage)));
            long l2 = new Double(((OraTreeSettings)object).getMinNodeSizeForSplit(SizeUnit.count)).longValue();
            this.m_minRecsForSplit.setText(Long.toString(l2));
            this.m_minPercentForSplit.setText(Double.toString(((OraTreeSettings)object).getMinNodeSizeForSplit(SizeUnit.percentage)));
        } else if (this.m_settings.getAlgorithmSettings() instanceof OraGLMClassificationSettings) {
            object = (OraGLMClassificationSettings)this.m_settings.getAlgorithmSettings();
            this.m_confidenceLevel.setText(numberFormat2.format(object.getConfidenceLevel()));
            this.m_diagnosticsTableName.setText(object.getDiagnosticsTableName());
            String string4 = object.getMissingValueTreatmentType();
            if (string4.equals("ODMS_MISSING_VALUE_MEAN_MODE")) {
                this.m_missingValueTreatment.setText(DM4JResourceUtilities.getUIString("GLM_MISSING_VAL_MIN_MEAN"));
            } else if (string4.equals("ODMS_MISSING_VALUE_DELETE_ROW")) {
                this.m_missingValueTreatment.setText(DM4JResourceUtilities.getUIString("GLM_MISSING_DROP_REC"));
            } else {
                this.m_missingValueTreatment.setText("Unknown");
            }
            this.m_referenceCategory.setText(object.getReferenceCategory().toString());
            Double d = object.getRidgeValue();
            if (d != null) {
                this.m_ridgeValue.setText(numberFormat2.format(d));
            }
        } else {
            throw new Exception("Unexpected functions settings object type" + this.m_settings.getClass().getName());
        }
    }

    private void cbSelection_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            int n = this.m_comboAlgorithmSelection.getSelectedIndex();
            Grid grid = this.m_settingTable.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = (GeneralGridSelectionManager)grid.getGridSelectionManager();
            this.m_settingTable = new SettingTable(this.m_masArray[n]);
            this.m_settingPanel.getViewport().add(this.m_settingTable);
            grid = this.m_settingTable.getGrid();
            grid.setGridSelectionManager(generalGridSelectionManager);
            this.m_settingTable.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    class SettingTable
    extends Dm4jSpreadTable {
        ResourceBundle res;
        String[] m_NBColumnNames;
        int[] m_NBColWidths;
        String[] m_SVMLinearColumnNames;
        int[] m_SVMLinearColWidths;
        String[] m_SVMGaussianColumnNames;
        int[] m_SVMGaussianColWidths;
        String[] m_ABNColumnNames;
        int[] m_ABNColWidths;
        String[] m_CNBColumnNames;
        int[] m_CNBColWidths;
        String[] m_CABNColumnNames;
        int[] m_CABNColWidths;

        SettingTable(Object object) {
            Object object2;
            super(object);
            this.res = BrowserUtils.getBundleInstance();
            this.m_NBColumnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TBL_SINGLETON_THRESHOLD"), DM4JResourceUtilities.getUIString("CLASS_TBL_PAIRWISE_THRESHOLD")};
            this.m_NBColWidths = new int[]{50, 50};
            this.m_SVMLinearColumnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TBL_KERNEL_FUNCTION"), DM4JResourceUtilities.getUIString("CLASS_TBL_COMPLEXITY_FACTOR"), DM4JResourceUtilities.getUIString("CLASS_TBL_TOLERANCE"), DM4JResourceUtilities.getUIString("CLASS_TBL_AUTO_NORMALIZATION")};
            this.m_SVMLinearColWidths = new int[]{50, 50, 50, 50};
            this.m_SVMGaussianColumnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TBL_KERNEL_FUNCTION"), DM4JResourceUtilities.getUIString("CLASS_TBL_STANDARD_DEVIATION"), DM4JResourceUtilities.getUIString("CLASS_TBL_KERNEL_CACHE_SIZE"), DM4JResourceUtilities.getUIString("CLASS_TBL_COMPLEXITY_FACTOR"), DM4JResourceUtilities.getUIString("CLASS_TBL_TOLERANCE"), DM4JResourceUtilities.getUIString("CLASS_TBL_AUTO_NORMALIZATION")};
            this.m_SVMGaussianColWidths = new int[]{50, 50, 50, 50, 50, 50};
            this.m_ABNColumnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_RUN_TIME_LIMIT"), DM4JResourceUtilities.getUIString("CLASS_TBL_NETWORK_FEATURE_DEPTH"), DM4JResourceUtilities.getUIString("CLASS_TBL_NETWORK_FEATURES_COUNT"), DM4JResourceUtilities.getUIString("CLASS_TBL_PRUNED_NETWORK_FEATURES")};
            this.m_ABNColWidths = new int[]{25, 25, 25, 25};
            this.m_CNBColumnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TBL_SINGLETON_THRESHOLD"), DM4JResourceUtilities.getUIString("CLASS_TBL_PAIRWISE_THRESHOLD")};
            this.m_CNBColWidths = new int[]{50, 50};
            this.m_CABNColumnNames = new String[]{DM4JResourceUtilities.getUIString("CLASS_TBL_MAX_NETWORK_FEATURE_DEPTH")};
            this.m_CABNColWidths = new int[]{100};
            if ((AlgorithmSettings)object instanceof NaiveBayesSettings) {
                this.setColumnNames(this.m_NBColumnNames);
            } else if ((AlgorithmSettings)object instanceof SVMClassificationSettings) {
                object2 = (SVMClassificationSettings)object;
                if (object2.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                    this.setColumnNames(this.m_SVMGaussianColumnNames);
                } else {
                    this.setColumnNames(this.m_SVMLinearColumnNames);
                }
            } else if ((AlgorithmSettings)object instanceof OraABNSettings) {
                this.setColumnNames(this.m_ABNColumnNames);
            }
            object2 = this.getGrid();
            GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
            ((Grid)object2).setGridSelectionManager(generalGridSelectionManager);
            try {
                this.displayLoadingStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void load() throws Exception {
            AlgorithmSettings algorithmSettings = (AlgorithmSettings)this.getDataItem();
            if (null == algorithmSettings) {
                throw new Exception("Cannot load data. AlgorithmSettings not supplied");
            }
            if (algorithmSettings instanceof NaiveBayesSettings) {
                this.setColumnWidths(this.m_NBColWidths, true);
            } else if (algorithmSettings instanceof SVMClassificationSettings) {
                SVMClassificationSettings sVMClassificationSettings = (SVMClassificationSettings)algorithmSettings;
                if (sVMClassificationSettings.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                    this.setColumnWidths(this.m_SVMGaussianColWidths, true);
                } else {
                    this.setColumnWidths(this.m_SVMLinearColWidths, true);
                }
            } else if (algorithmSettings instanceof OraABNSettings) {
                this.setColumnWidths(this.m_ABNColWidths, true);
            }
            final int n = this.getColModel().getItemCount();
            Dm4jSortableTwoDModel dm4jSortableTwoDModel = new Dm4jSortableTwoDModel(){

                public void load(Object object) {
                    AlgorithmSettings algorithmSettings = (AlgorithmSettings)object;
                    this.addColumns(0, n);
                    if (algorithmSettings instanceof NaiveBayesSettings) {
                        NaiveBayesSettings naiveBayesSettings = (NaiveBayesSettings)algorithmSettings;
                        this.addRows(0, 1);
                        this.setData(0, 0, naiveBayesSettings.getSingletonThreshold() + "");
                        this.setData(1, 0, naiveBayesSettings.getPairwiseThreshold() + "");
                    } else if (algorithmSettings instanceof SVMClassificationSettings) {
                        SVMClassificationSettings sVMClassificationSettings = (SVMClassificationSettings)algorithmSettings;
                        this.addRows(0, 1);
                        this.setData(0, 0, sVMClassificationSettings.getKernelFunction().name() + "");
                        this.setData(1, 0, sVMClassificationSettings.getComplexityFactor() + "");
                        this.setData(2, 0, sVMClassificationSettings.getTolerance() + "");
                    } else if (algorithmSettings instanceof OraABNSettings) {
                        OraABNSettings oraABNSettings = (OraABNSettings)algorithmSettings;
                        this.addRows(0, 1);
                    }
                }
            };
            dm4jSortableTwoDModel.load(algorithmSettings);
            this.setVerticalSeparatorsVisible(true);
            this.setModels((TwoDModel)dm4jSortableTwoDModel, this.getColModel(), null);
            Header header = this.getColumnHeader();
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setItemInputHandler(null);
            header.setCanMoveItems(false);
            try {
                if (algorithmSettings instanceof NaiveBayesSettings) {
                    this.setColumnWidths(this.m_NBColWidths, true);
                } else if (algorithmSettings instanceof SVMClassificationSettings) {
                    SVMClassificationSettings sVMClassificationSettings = (SVMClassificationSettings)algorithmSettings;
                    if (sVMClassificationSettings.getKernelFunction().name().equalsIgnoreCase(KernelFunction.kGaussian.name())) {
                        this.setColumnWidths(this.m_SVMGaussianColWidths, true);
                    } else {
                        this.setColumnWidths(this.m_SVMLinearColWidths, true);
                    }
                } else if (algorithmSettings instanceof OraABNSettings) {
                    this.setColumnWidths(this.m_ABNColWidths, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

