/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.EventQueue;
import javax.datamining.MiningAlgorithm;
import javax.datamining.algorithm.naivebayes.NaiveBayesSettings;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.classification.SVMClassificationSettings;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.classification.ClassificationSettings;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.BrowseResultsListPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.ModelGlobalDetailsPanel;
import oracle.dmt.dm4j.browser.viewer.ModelViewer;
import oracle.dmt.dm4j.browser.viewer.classification.ABNDetailRulesPanel;
import oracle.dmt.dm4j.browser.viewer.classification.ABNRulesPanel;
import oracle.dmt.dm4j.browser.viewer.classification.ClassificationSettingsPanel;
import oracle.dmt.dm4j.browser.viewer.classification.GLMModelContentPanel;
import oracle.dmt.dm4j.browser.viewer.classification.GLMRowDiagnosticsPanel;
import oracle.dmt.dm4j.browser.viewer.classification.NBPairProbabilitiesPanel;
import oracle.dmt.dm4j.browser.viewer.classification.SVMClassificationModelContentPanel;
import oracle.dmt.dm4j.browser.viewer.results.build.BuildTaskPanel;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;
import oracle.dmt.jdm.algorithm.abn.OraABNSettings;
import oracle.dmt.jdm.algorithm.glm.OraGLMClassificationSettings;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.jdmresult.OraMiningBuildResult;
import oracle.dmt.jdm.modeldetail.abn.OraABNModelDetail;
import oracle.dmt.jdm.supervised.classification.OraClassificationSettings;

public class ClassificationModelViewer
extends ModelViewer {
    static int SETTING_TAB = 0;
    static int RULE_TAB = 1;
    static int CONTENT_TAB = 2;
    static int RESULT_TAB = 3;
    static int PAIR_PROBABILITIES_TAB = 4;
    static int TASK_TAB = 5;
    static int GLM_ROW_DIAGNOSTICS_TAB = 6;
    static int GLOBAL_DETAILS_TAB = 7;
    static int GLM_CONTENT_TAB = 8;
    int[] m_tabIndex;
    ClassificationSettingsPanel m_classificationSettingsPanel;
    NBPairProbabilitiesPanel m_NBPairProbabilitiesPanel;
    ABNDetailRulesPanel m_ABNDetailRulesPanel;
    ABNRulesPanel m_ABNRulesPanel;
    SVMClassificationModelContentPanel m_SVMClassificationModelContentPanel;
    BrowseResultsListPanel m_browseResultsListPanel;
    BuildTaskPanel m_buildTaskPanel;
    OraMiningBuildResult m_buldTask;
    GLMRowDiagnosticsPanel m_rowDiagnosticsPanel;
    ModelGlobalDetailsPanel m_globalDetailsPanel;
    GLMModelContentPanel m_GLMClassificationModelContentPanel;

    public ClassificationModelViewer(LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        super(leafNodeData, connection, n);
        this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
    }

    protected String getHelpId() {
        int n = this.getSelectedIndex();
        GriddedPanel griddedPanel = (GriddedPanel)this.getComponentAt(n);
        return griddedPanel.getHelpId();
    }

    protected void loadViewer(LeafNodeData leafNodeData, int n) throws Exception {
        OraModel oraModel = (OraModel)leafNodeData.getOdmObject();
        int n2 = 0;
        this.m_tabIndex = new int[4];
        MiningAlgorithm miningAlgorithm = oraModel.getMiningAlgorithm();
        if (miningAlgorithm.equals(MiningAlgorithm.naiveBayes)) {
            try {
                ClassificationSettings classificationSettings = (ClassificationSettings)oraModel.getBuildSettings();
                NaiveBayesSettings naiveBayesSettings = (NaiveBayesSettings)classificationSettings.getAlgorithmSettings();
            }
            catch (Exception exception) {
                System.out.print("Failure retrieving model settings, probably due to missing priors, weights or cost matrix.");
                exception.printStackTrace();
            }
            this.addTab(DM4JResourceUtilities.getUIString("CLASS_PAIR_PROBABILITIES_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("CLASS_PAIR_PROBABILITIES_TAB"));
            this.m_tabIndex[n2++] = PAIR_PROBABILITIES_TAB;
        } else if (miningAlgorithm.equals(OraMiningAlgorithm.adaptiveBayesNetwork)) {
            boolean bl = false;
            try {
                ClassificationSettings classificationSettings = (ClassificationSettings)oraModel.getBuildSettings();
                OraABNSettings oraABNSettings = (OraABNSettings)classificationSettings.getAlgorithmSettings();
                OraABNModelType oraABNModelType = oraABNSettings.getModelType();
                bl = oraABNModelType.equals(OraABNModelType.singleFeature);
            }
            catch (Exception exception) {
                System.out.print("Failure retrieving model settings, probably due to missing priors, weights or cost matrix.");
                exception.printStackTrace();
                bl = DMEMetadata.isABNModelSingleFeature(oraModel.getName());
            }
            if (bl) {
                OraABNModelDetail oraABNModelDetail = (OraABNModelDetail)oraModel.getModelDetail();
                this.addTab(DM4JResourceUtilities.getUIString("COMMON_RULES"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_RULES"));
                this.m_tabIndex[n2++] = RULE_TAB;
            }
        } else if (miningAlgorithm.equals(MiningAlgorithm.svmClassification)) {
            ClassificationModel classificationModel = (ClassificationModel)leafNodeData.getOdmObject();
            String string = null;
            boolean bl = false;
            try {
                OraClassificationSettings oraClassificationSettings = (OraClassificationSettings)classificationModel.getBuildSettings();
                SVMClassificationSettings sVMClassificationSettings = (SVMClassificationSettings)classificationModel.getBuildSettings().getAlgorithmSettings();
                bl = sVMClassificationSettings.getKernelFunction().equals(KernelFunction.kLinear);
            }
            catch (Exception exception) {
                System.out.print("Failure retrieving model settings, probably due to missing priors, weights or cost matrix.");
                exception.printStackTrace();
                bl = DMEMetadata.isSVMModelLinear(oraModel.getName());
            }
            if (bl) {
                string = DM4JResourceUtilities.getUIString("COMMON_COEFFICIENTS");
                this.addTab(string, null, new LoadingStatusPanel(), string);
                this.m_tabIndex[n2++] = CONTENT_TAB;
            } else {
                string = DM4JResourceUtilities.getUIString("CLASS_SVM_GAUSSIAN_TAB");
            }
        } else if (miningAlgorithm.equals(OraMiningAlgorithm.generalizedLinearModel)) {
            this.m_tabIndex = new int[6];
            ClassificationModel classificationModel = (ClassificationModel)leafNodeData.getOdmObject();
            String string = DM4JResourceUtilities.getUIString("GLM_ROW_DIAG_TAB_NAME");
            String string2 = DM4JResourceUtilities.getUIString("GLM_GLOBAL_STATISTICS");
            String string3 = DM4JResourceUtilities.getUIString("COMMON_COEFFICIENTS");
            try {
                OraClassificationSettings oraClassificationSettings = (OraClassificationSettings)classificationModel.getBuildSettings();
                OraGLMClassificationSettings oraGLMClassificationSettings = (OraGLMClassificationSettings)classificationModel.getBuildSettings().getAlgorithmSettings();
                this.addTab(string2, null, new LoadingStatusPanel(), string2);
                this.m_tabIndex[n2++] = GLOBAL_DETAILS_TAB;
                this.addTab(string3, null, new LoadingStatusPanel(), string3);
                this.m_tabIndex[n2++] = GLM_CONTENT_TAB;
                if (oraGLMClassificationSettings.getDiagnosticsTableName() != null) {
                    if (oraGLMClassificationSettings.getDiagnosticsTableName().length() != 0) {
                        this.addTab(string, null, new LoadingStatusPanel(), string);
                    }
                    this.m_tabIndex[n2++] = GLM_ROW_DIAGNOSTICS_TAB;
                }
            }
            catch (Exception exception) {
                System.out.print("Failure retrieving model settings, probably due to missing priors, weights or cost matrix.");
                exception.printStackTrace();
            }
        }
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_RESULTS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_RESULTS"));
        this.m_tabIndex[n2++] = RESULT_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_SETTINGS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_SETTINGS"));
        this.m_tabIndex[n2++] = SETTING_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        this.m_tabIndex[n2++] = TASK_TAB;
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n));
        thread.setPriority(5);
        thread.start();
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        GriddedPanel panel;
        Exception exception = null;

        public LoadTab(int n) {
            this.tabIndex = n;
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object var1_1 = null;
            try {
                try {
                    SupervisedModel supervisedModel = (SupervisedModel)ClassificationModelViewer.this.m_node.getOdmObject();
                    this.panel = null;
                    if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == SETTING_TAB) {
                        if (ClassificationModelViewer.this.m_classificationSettingsPanel == null) {
                            ClassificationModelViewer.this.m_classificationSettingsPanel = new ClassificationSettingsPanel(supervisedModel, ClassificationModelViewer.this.getNode());
                        }
                        this.panel = ClassificationModelViewer.this.m_classificationSettingsPanel;
                    } else if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == PAIR_PROBABILITIES_TAB) {
                        if (ClassificationModelViewer.this.m_NBPairProbabilitiesPanel == null) {
                            ClassificationModelViewer.this.m_NBPairProbabilitiesPanel = new NBPairProbabilitiesPanel(ClassificationModelViewer.this.m_node);
                        }
                        this.panel = ClassificationModelViewer.this.m_NBPairProbabilitiesPanel;
                    } else if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == RULE_TAB) {
                        if (ClassificationModelViewer.this.m_ABNRulesPanel == null) {
                            ClassificationModelViewer.this.m_ABNRulesPanel = new ABNRulesPanel(ClassificationModelViewer.this.m_node);
                        }
                        this.panel = ClassificationModelViewer.this.m_ABNRulesPanel;
                    } else if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == CONTENT_TAB) {
                        if (ClassificationModelViewer.this.m_SVMClassificationModelContentPanel == null) {
                            ClassificationModelViewer.this.m_SVMClassificationModelContentPanel = new SVMClassificationModelContentPanel(ClassificationModelViewer.this.m_node);
                        }
                        this.panel = ClassificationModelViewer.this.m_SVMClassificationModelContentPanel;
                    } else if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == GLM_CONTENT_TAB) {
                        if (ClassificationModelViewer.this.m_GLMClassificationModelContentPanel == null) {
                            ClassificationModelViewer.this.m_GLMClassificationModelContentPanel = new GLMModelContentPanel(ClassificationModelViewer.this.m_node);
                        }
                        this.panel = ClassificationModelViewer.this.m_GLMClassificationModelContentPanel;
                    } else if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == RESULT_TAB) {
                        if (ClassificationModelViewer.this.m_browseResultsListPanel == null) {
                            ClassificationModelViewer.this.m_browseResultsListPanel = new BrowseResultsListPanel(ClassificationModelViewer.this.m_node);
                        }
                        this.panel = ClassificationModelViewer.this.m_browseResultsListPanel;
                    } else if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == GLM_ROW_DIAGNOSTICS_TAB) {
                        if (ClassificationModelViewer.this.m_rowDiagnosticsPanel == null) {
                            ClassificationModelViewer.this.m_rowDiagnosticsPanel = new GLMRowDiagnosticsPanel(ClassificationModelViewer.this.m_node);
                        }
                        this.panel = ClassificationModelViewer.this.m_rowDiagnosticsPanel;
                    } else if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == GLOBAL_DETAILS_TAB) {
                        if (ClassificationModelViewer.this.m_globalDetailsPanel == null) {
                            ClassificationModelViewer.this.m_globalDetailsPanel = new ModelGlobalDetailsPanel(ClassificationModelViewer.this.m_node);
                        }
                        ClassificationModelViewer.this.m_globalDetailsPanel.resize();
                        this.panel = ClassificationModelViewer.this.m_globalDetailsPanel;
                    } else if (ClassificationModelViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB) {
                        if (ClassificationModelViewer.this.m_buildTaskPanel == null) {
                            ClassificationModelViewer.this.m_buildTaskPanel = new BuildTaskPanel(supervisedModel.getName());
                        }
                        this.panel = ClassificationModelViewer.this.m_buildTaskPanel;
                    }
                    Runnable runnable = new Runnable(){

                        public void run() {
                            ClassificationModelViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                        }
                    };
                    EventQueue.invokeLater(runnable);
                }
                catch (Exception exception) {
                    this.exception = exception;
                    exception.printStackTrace();
                    Object var5_6 = null;
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }
}

