/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.resource.Connection;
import javax.datamining.rule.CompoundPredicate;
import javax.datamining.rule.Rule;
import javax.datamining.rule.SimplePredicate;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.classification.ClassificationSettings;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.classification.RulesTable;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.transform.binning.OraBinningTransformFactory;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;

public class ABNRulesPanel
extends GriddedPanel
implements VetoableChangeListener {
    ClassificationModel m_model = null;
    RulesTable m_rulesTable = null;
    JTextArea m_ruleDetail = null;
    JScrollPane m_rulesScrollPane = new JScrollPane();
    boolean m_isTransformed = false;
    Hashtable m_xformTables = null;
    AlgorithmSettings m_algSetting;

    public ABNRulesPanel(LeafNodeData leafNodeData) {
        this.m_model = (ClassificationModel)leafNodeData.getOdmObject();
        boolean bl = false;
        try {
            ClassificationSettings classificationSettings = (ClassificationSettings)this.m_model.getBuildSettings();
            this.m_algSetting = classificationSettings.getAlgorithmSettings();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                bl = DMEMetadata.isABNModelSingleFeature(this.m_model.getName());
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                bl = false;
            }
        }
        try {
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "ABN_MODEL";
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("CLASS_RULES_RULES"));
        this.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 0, 1, 1, 18);
        this.m_rulesTable = new RulesTable(this.m_model);
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(null, DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(ABNRulesPanel.this.m_rulesTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        this.addAnchoredComponent(jPanel, MIDLABELITEMINSETS, n++, 1, 1, 1, 14);
        this.m_rulesScrollPane.getViewport().add(this.m_rulesTable);
        this.m_rulesScrollPane.setPreferredSize(null);
        this.addFilledComponent(this.m_rulesScrollPane, MIDLABELITEMINSETS, n++, 0, 2, 2, 1);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_RULE_DETAIL"));
        int n2 = ++n;
        this.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n2, 0, 1, 1, 2);
        this.m_ruleDetail = new JTextArea();
        this.m_ruleDetail.setEditable(false);
        this.m_ruleDetail.setLineWrap(true);
        this.m_ruleDetail.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_ruleDetail);
        int n3 = ++n;
        ++n;
        this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n3, 0, 2, 2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMiningModelBuildTransformation(boolean bl) {
        try {
            ((OraModel)((Object)this.m_model)).setBuildTransformation(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl || this.m_xformTables == null) return;
        Connection connection = null;
        connection = DM4JConnectionManager.getConnection();
        String string = (String)this.m_xformTables.get("XBINC");
        String string2 = (String)this.m_xformTables.get("XBINN");
        OraBinningTransformFactory oraBinningTransformFactory = (OraBinningTransformFactory)connection.getFactory("oracle.dmt.jdm.transform.binning.OraBinningTransform");
        OraBinningTransformImpl oraBinningTransformImpl = (OraBinningTransformImpl)oraBinningTransformFactory.create(null, null, false, string, string2);
        ((OraModel)((Object)this.m_model)).setBuildTransformation(oraBinningTransformImpl);
        Object var8_9 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                Object var8_10 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runTimePanelLoad(LeafNodeData var1_1) throws Exception {
        block11: {
            this.m_model = (ClassificationModel)var1_1.getOdmObject();
            this.m_xformTables = null;
            var2_2 = null;
            try {
                var2_2 = DM4JConnectionManager.getDbConnection();
                var3_3 = DMEMetadata.getInstance();
                this.m_xformTables = var3_3.getTransparencyTables(var2_2, null, this.m_model.getName());
                var5_5 = null;
                ** if (null == var2_2) goto lbl-1000
            }
            catch (Throwable var4_9) {
                var5_6 = null;
                if (null != var2_2) {
                    try {
                        var2_2.close();
                    }
                    catch (Exception var6_8) {
                        // empty catch block
                    }
                }
                throw var4_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (Exception var6_7) {}
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (Exception var3_4) {
                    var5_5 = null;
                    if (null != var2_2) {
                        try {
                            var2_2.close();
                        }
                        catch (Exception var6_7) {}
                    }
                }
            }
        }
        this.m_isTransformed = this.m_xformTables != null;
        this.updateMiningModelBuildTransformation(this.m_isTransformed);
        this.m_rulesTable.load();
        var3_3 = this.m_rulesTable.getGrid();
        var4_10 = new GeneralGridSelectionManager(0, 1, 0);
        var5_5 = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 4));
        var6_7 = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 4));
        var3_3.setColumnPainter(3, var5_5);
        var3_3.setColumnPainter(4, (Painter)var6_7);
        var3_3.setGridSelectionManager(var4_10);
        var4_10.addVetoableChangeListener(this);
        var7_11 = new Dm4jSpreadTableExcelAdapter(this.m_rulesTable);
    }

    private void setDetailText(int n) {
        Rule rule = this.m_rulesTable.getMiningRule(n);
        if (rule != null) {
            CharSequence charSequence;
            SimplePredicate[] simplePredicateArray;
            Object object;
            Object object2;
            String string = DM4JResourceUtilities.getUIString("COMMON_RULES_IF");
            String string2 = DM4JResourceUtilities.getUIString("COMMON_RULES_THEN");
            String string3 = string + "\n";
            StringBuffer stringBuffer = new StringBuffer();
            try {
                CharSequence charSequence2;
                object2 = (CompoundPredicate)rule.getAntecedent();
                object = (SimplePredicate[])object2.getPredicates();
                if (object == null) {
                    return;
                }
                simplePredicateArray = new Hashtable();
                for (int i = 0; i < ((SimplePredicate[])object).length; ++i) {
                    charSequence = ABNRulesPanel.getSimplePredicateString(object[i]);
                    charSequence2 = object[i].getAttributeName();
                    StringBuffer stringBuffer2 = (StringBuffer)simplePredicateArray.get(charSequence2);
                    if (stringBuffer2 == null) {
                        simplePredicateArray.put(charSequence2, charSequence);
                        continue;
                    }
                    stringBuffer2.append(" AND " + charSequence);
                }
                Enumeration enumeration = simplePredicateArray.keys();
                while (enumeration.hasMoreElements()) {
                    charSequence = (String)enumeration.nextElement();
                    charSequence2 = (StringBuffer)simplePredicateArray.get(charSequence);
                    if (0 == stringBuffer.length()) {
                        stringBuffer.append(((StringBuffer)charSequence2).toString());
                        continue;
                    }
                    stringBuffer.append(" AND ");
                    stringBuffer.append(((StringBuffer)charSequence2).toString());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string3 = string3 + stringBuffer.toString();
            string3 = string3 + "\n\n";
            string3 = string3 + string2 + "\n";
            object2 = "";
            try {
                object = (CompoundPredicate)rule.getConsequent();
                simplePredicateArray = (SimplePredicate[])object.getPredicates();
                if (simplePredicateArray == null) {
                    return;
                }
                for (int i = 0; i < simplePredicateArray.length; ++i) {
                    charSequence = ABNRulesPanel.getSimplePredicateString(simplePredicateArray[i]);
                    if (i < simplePredicateArray.length - 1) {
                        ((StringBuffer)charSequence).append(" AND ");
                    }
                    object2 = (String)object2 + ((StringBuffer)charSequence).toString();
                }
            }
            catch (Exception exception) {
                System.out.println("Error printing Consequent");
            }
            string3 = string3 + (String)object2;
            this.m_ruleDetail.setText(string3);
        }
    }

    public static StringBuffer getSimplePredicateString(SimplePredicate simplePredicate) {
        StringBuffer stringBuffer = new StringBuffer();
        if (simplePredicate.isNumericalValue()) {
            stringBuffer.append(simplePredicate.getAttributeName() + " " + simplePredicate.getComparisonOperator().name() + " " + simplePredicate.getNumericalValue());
        } else {
            stringBuffer = new StringBuffer(simplePredicate.getAttributeName() + " " + simplePredicate.getComparisonOperator().name() + " ");
            Object[] objectArray = simplePredicate.getCategoryValues();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(objectArray[i]);
                    if (i == objectArray.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
        }
        return stringBuffer;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n2 = twoDSelection2.getSingleRow();
        if (n2 != (n = twoDSelection.getSingleRow())) {
            this.setDetailText(n2);
        }
    }
}

