/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.classification;

import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.EventObject;
import javax.datamining.rule.BooleanOperator;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.hGrid.HCellHandler;
import oracle.bali.ewt.grid.hGrid.HGridKeyHandler;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.sort.NumberComparator;
import oracle.dmt.dm4j.DM4JAccessibilityUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.DefaultDm4jSpreadTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.classification.ABNRulesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.DetailRulesLoadedListener;
import oracle.dmt.dm4j.browser.viewer.classification.DetailRulesTableModel;
import oracle.dmt.dm4j.browser.viewer.classification.LoadABNDetailRulesWorker;
import oracle.dmt.dm4j.browser.viewer.classification.LoadABNRulesWorker;
import oracle.dmt.dm4j.browser.viewer.classification.RulesTableModel;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class ABNDetailRulesPanel
extends GriddedPanel
implements VetoableChangeListener,
DetailRulesLoadedListener,
ABNRulesLoadedListener {
    private JLabel m_title = new JLabel();
    private JButton m_expand = new JButton();
    private JButton m_collapse = new JButton();
    private JButton m_sortButton = new JButton();
    private JCheckBox m_hierView = new JCheckBox();
    private JButton m_exportButton;
    private JTextArea m_ruleDetail = new JTextArea();
    private JScrollPane m_rulesScrollPane = new JScrollPane();
    private ClassificationModel m_miningModel = null;
    private RulesTableModel m_rulesTableModel = null;
    private DetailRulesTableModel m_detailRulesTableModel = null;
    private DefaultDm4jSpreadTable m_ruleTable = null;
    int[] m_colSortOrders = null;
    int m_curSortOrder = 2;

    public ABNDetailRulesPanel(LeafNodeData leafNodeData) {
        this.m_miningModel = (ClassificationModel)leafNodeData.getOdmObject();
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "ABN_MODEL";
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.m_title.setText(DM4JResourceUtilities.getUIString("CLASS_RULES_RULES"));
        this.m_title.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_RULES_RULES"));
        this.m_hierView.setText(DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_TREE_VIEW"));
        this.m_hierView.setMnemonic(DM4JResourceUtilities.getUIMnemonic("CLASS_ABN_RULE_TREE_VIEW"));
        this.m_hierView.setSelected(true);
        this.m_sortButton.setText(DM4JResourceUtilities.getUIString("ASSOC_RULE_SORT"));
        this.m_sortButton.setMnemonic(DM4JResourceUtilities.getUIMnemonic("ASSOC_RULE_SORT"));
        this.m_sortButton.setEnabled(false);
        this.m_exportButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        this.m_exportButton.setEnabled(false);
        this.m_exportButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.m_exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        int n = ABNDetailRulesPanel.this.m_detailRulesTableModel.getExpandedRowCount();
                        for (int i = 0; i < n; ++i) {
                            ABNDetailRulesPanel.this.m_detailRulesTableModel.expandExpandedRow(i);
                        }
                        exportDialog.export(ABNDetailRulesPanel.this.m_ruleTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton[] jButtonArray = new JButton[]{this.m_sortButton};
        DM4JResourceUtilities.setPreferredSize(jButtonArray);
        GriddedPanel griddedPanel = new GriddedPanel();
        griddedPanel.addComponent(this.m_title, MIDLABELITEMINSETS, 0, 0, 1, 1, 16, 2);
        griddedPanel.addComponent(this.m_hierView, MIDLABELITEMINSETS, 0, 1, 2, 1, 14, 2);
        griddedPanel.addFilledComponent(this.m_sortButton, MIDLABELITEMINSETS, 0, 3, 1, 1, 0);
        griddedPanel.addFilledComponent(this.m_exportButton, MIDLABELITEMINSETS, 0, 4, 1, 1, 0);
        this.addFilledComponent(griddedPanel, new Insets(5, 0, 0, 0), n++, 0, 4, 1, 2);
        this.m_ruleTable = this.createTable();
        this.m_rulesScrollPane.getViewport().add(this.m_ruleTable);
        this.m_title.setLabelFor(this.m_ruleTable);
        this.m_rulesScrollPane.setPreferredSize(null);
        this.addFilledComponent(this.m_rulesScrollPane, MIDLABELITEMINSETS, n, 0, 4, 4, 1);
        this.m_expand.setText(DM4JResourceUtilities.getUIString("COMMON_EXPAND_ALL"));
        this.m_expand.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_EXPAND_ALL"));
        this.m_expand.setEnabled(false);
        this.addComponent(this.m_expand, TOPLABELITEMINSETS, n++, 4, 1, 1, 12, 2);
        this.m_collapse.setText(DM4JResourceUtilities.getUIString("COMMON_COLLAPSE_ALL"));
        this.m_collapse.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_COLLAPSE_ALL"));
        this.m_collapse.setEnabled(false);
        this.addComponent(this.m_collapse, TOPLABELITEMINSETS, n, 4, 1, 1, 12, 2);
        n += 3;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_RULE_DETAIL"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_RULE_DETAIL"));
        this.addFilledComponent(jLabel, TOPLABELITEMINSETS, n++, 0, 1, 1, 2);
        this.m_ruleDetail.setEditable(false);
        this.m_ruleDetail.setLineWrap(true);
        this.m_ruleDetail.setWrapStyleWord(true);
        DM4JAccessibilityUtils.setAccessibleName(this.m_ruleDetail, DM4JResourceUtilities.getUIString("COMMON_RULE_DETAIL"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_ruleDetail);
        jLabel.setLabelFor(jScrollPane);
        this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n++, 0, 4, 2, 1);
    }

    private void runTimePanelLoad() throws Exception {
        this.m_hierView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ABNDetailRulesPanel.this.chkHierView_actionPerformed(actionEvent);
            }
        });
        this.m_expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ABNDetailRulesPanel.this.m_detailRulesTableModel.getExpandedRowCount();
                for (int i = 0; i < n; ++i) {
                    ABNDetailRulesPanel.this.m_detailRulesTableModel.expandExpandedRow(i);
                }
            }
        });
        this.m_collapse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ABNDetailRulesPanel.this.m_detailRulesTableModel.getExpandedRowCount();
                for (int i = 0; i < n; ++i) {
                    ABNDetailRulesPanel.this.m_detailRulesTableModel.collapseExpandedRow(i);
                }
            }
        });
        this.m_sortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ABNDetailRulesPanel.this.btnSort_actionPerformed(actionEvent);
            }
        });
        this.loadHierRules();
        int[] nArray = new int[]{100};
        this.m_ruleTable.setColumnWidths(nArray, true);
    }

    private void loadHierRules() {
        int n = 5;
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadABNDetailRulesWorker loadABNDetailRulesWorker = (LoadABNDetailRulesWorker)workerThreadManager.getLoadABNDetailRulesWorker(this.m_miningModel, n);
        loadABNDetailRulesWorker.addDetailRulesLoadedListener(this);
        loadABNDetailRulesWorker.start();
    }

    private void loadFlatRules() {
        int n = 5;
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadABNRulesWorker loadABNRulesWorker = (LoadABNRulesWorker)workerThreadManager.getLoadABNRulesWorker(this.m_miningModel);
        loadABNRulesWorker.addABNRulesLoadedListener(this);
        loadABNRulesWorker.start();
    }

    public void detailRulesLoaded(EventObject eventObject) {
        Object object;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.m_detailRulesTableModel = (DetailRulesTableModel)eventObject.getSource();
        int n = 5;
        Object[] objectArray = new String[n];
        objectArray[0] = DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_RULE_ID");
        objectArray[1] = DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_IF_STMT");
        objectArray[2] = DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_THEN_STMT");
        objectArray[3] = DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE");
        objectArray[4] = DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT");
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        this.m_ruleTable.setModels((TwoDModel)this.m_detailRulesTableModel, arrayOneDModel, null);
        Grid grid = this.m_ruleTable.getGrid();
        grid.setGridKeyHandler(new HGridKeyHandler(grid));
        grid.setGridSelectionManager(new GeneralGridSelectionManager(0, 2, 0));
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 4));
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter2 = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 4));
        grid.setColumnPainter(3, dM4JTruncatingNumberFormatPainter);
        grid.setColumnPainter(4, dM4JTruncatingNumberFormatPainter2);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_ruleTable);
        grid.addVetoableChangeListener(this);
        Painter painter = grid.getColumnPainter(0);
        HCellHandler hCellHandler = new HCellHandler(painter);
        grid.setColumnPainter(0, hCellHandler);
        grid.setColumnCellInputHandler(0, hCellHandler);
        this.m_detailRulesTableModel.expandExpandedRow(0);
        if (this.m_detailRulesTableModel.getRowCount() > 0) {
            object = new TwoDSelection(0, true);
            try {
                this.m_ruleTable.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = null;
        object = new int[]{15, 40, 15, 15, 15};
        try {
            this.m_ruleTable.setColumnWidths((int[])object, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_hierView.setEnabled(true);
        this.m_exportButton.setEnabled(true);
        int n2 = this.m_detailRulesTableModel.getExpandedRowCount();
        if (n2 > 1) {
            this.m_expand.setEnabled(true);
            this.m_collapse.setEnabled(true);
            this.m_sortButton.setEnabled(false);
        }
        this.m_title.setLabelFor(this.m_ruleTable);
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        browserFrame.setCursor(new Cursor(0));
    }

    public void rulesLoaded(EventObject eventObject) {
        Object object;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.m_rulesTableModel = (RulesTableModel)eventObject.getSource();
        int n = 5;
        Object[] objectArray = new String[n];
        objectArray[0] = DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_RULE_ID");
        objectArray[1] = DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_IF_STMT");
        objectArray[2] = DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_THEN_STMT");
        objectArray[3] = DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE");
        objectArray[4] = DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT");
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        this.m_colSortOrders = new int[n];
        this.m_colSortOrders[0] = 0;
        this.m_colSortOrders[1] = -1;
        this.m_colSortOrders[2] = 0;
        this.m_colSortOrders[3] = 0;
        this.m_colSortOrders[4] = 0;
        this.m_ruleTable.setVerticalSeparatorsVisible(true);
        this.m_rulesTableModel.setColumnComparator(0, NumberComparator.getComparator());
        this.m_rulesTableModel.setColumnComparator(3, NumberComparator.getComparator());
        this.m_rulesTableModel.setColumnComparator(4, NumberComparator.getComparator());
        this.m_ruleTable.setModels((TwoDModel)this.m_rulesTableModel, arrayOneDModel, null);
        Header header = this.m_ruleTable.getColumnHeader();
        header.setItemInputHandler(new SortHandler(this.m_rulesTableModel));
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        this.m_rulesTableModel.sort(3, true);
        Grid grid = this.m_ruleTable.getGrid();
        grid.setGridSelectionManager(new GeneralGridSelectionManager(0, 2, 0));
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 4));
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter2 = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 10, 4));
        grid.setColumnPainter(3, dM4JTruncatingNumberFormatPainter);
        grid.setColumnPainter(4, dM4JTruncatingNumberFormatPainter2);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_ruleTable);
        grid.addVetoableChangeListener(this);
        int[] nArray = null;
        nArray = new int[]{15, 40, 15, 15, 15};
        try {
            this.m_ruleTable.setColumnWidths(nArray, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.m_rulesTableModel.getRowCount() != 0) {
            object = new TwoDSelection(0, true);
            try {
                this.m_ruleTable.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.m_hierView.setEnabled(true);
        this.m_expand.setEnabled(false);
        this.m_collapse.setEnabled(false);
        this.m_sortButton.setEnabled(true);
        this.m_exportButton.setEnabled(true);
        this.m_title.setLabelFor(this.m_ruleTable);
        object = BrowserFrame.getMainFrame();
        ((Window)object).setCursor(new Cursor(0));
    }

    private DefaultDm4jSpreadTable createTable() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        Object[] objectArray = new String[]{DM4JResourceUtilities.getUIString("COMMON_RULES")};
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(1, 1);
        arrayTwoDModel.setData(0, 0, DM4JResourceUtilities.getUIString("COMMON_LOADING"));
        DefaultDm4jSpreadTable defaultDm4jSpreadTable = new DefaultDm4jSpreadTable(null);
        defaultDm4jSpreadTable.setModels((TwoDModel)arrayTwoDModel, arrayOneDModel, null);
        return defaultDm4jSpreadTable;
    }

    private void chkHierView_actionPerformed(ActionEvent actionEvent) {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        browserFrame.setCursor(new Cursor(3));
        this.m_hierView.setEnabled(false);
        this.m_expand.setEnabled(false);
        this.m_collapse.setEnabled(false);
        this.m_sortButton.setEnabled(false);
        this.m_exportButton.setEnabled(false);
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        this.m_rulesScrollPane.getViewport().remove(this.m_ruleTable);
        boolean bl = jCheckBox.isSelected();
        try {
            this.m_ruleTable = this.createTable();
            if (bl) {
                this.loadHierRules();
            } else {
                this.loadFlatRules();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_rulesScrollPane.getViewport().add(this.m_ruleTable);
        try {
            int[] nArray = new int[]{100};
            this.m_ruleTable.setColumnWidths(nArray, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        if (!(object instanceof TwoDSelection)) {
            return;
        }
        object = propertyChangeEvent.getNewValue();
        if (!(object instanceof TwoDSelection)) {
            return;
        }
        TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
        TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
        int n = twoDSelection2.getSingleRow();
        int n2 = twoDSelection.getSingleRow();
        if (n >= 0 && n != n2) {
            CharSequence charSequence;
            String string = null;
            String string2 = null;
            Float f = null;
            Float f2 = null;
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            String string3 = DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_NO_RULE");
            String string4 = DM4JResourceUtilities.getUIString("CLASS_ABN_RULE_ROOT");
            if (this.m_hierView.isSelected()) {
                string = (String)this.m_detailRulesTableModel.getData(1, n);
                string2 = (String)this.m_detailRulesTableModel.getData(2, n);
                f = (Float)this.m_detailRulesTableModel.getData(3, n);
                f2 = (Float)this.m_detailRulesTableModel.getData(4, n);
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(string);
                int n3 = this.m_detailRulesTableModel.getExpandedIndex(n);
                int n4 = this.m_detailRulesTableModel.getParentRow(n3);
                String string5 = BooleanOperator.and.name();
                while (n4 > 0) {
                    int n5 = this.m_detailRulesTableModel.getVisibleIndex(n4);
                    string = (String)this.m_detailRulesTableModel.getData(1, n5);
                    ((StringBuffer)charSequence).insert(0, string + " " + string5 + " ");
                    n = n4;
                    n4 = this.m_detailRulesTableModel.getParentRow(n);
                }
                if (((StringBuffer)charSequence).length() > 0) {
                    string = ((StringBuffer)charSequence).toString();
                }
            } else {
                string = (String)this.m_rulesTableModel.getData(1, n);
                string2 = (String)this.m_rulesTableModel.getData(2, n);
                f = (Float)this.m_rulesTableModel.getData(3, n);
                f2 = (Float)this.m_rulesTableModel.getData(4, n);
            }
            this.m_ruleDetail.setText("");
            if (string.equals(string3) || string.equals(string4)) {
                if (string.equals(string3)) {
                    this.m_exportButton.setEnabled(false);
                } else {
                    this.m_exportButton.setEnabled(true);
                }
                return;
            }
            this.m_exportButton.setEnabled(true);
            charSequence = DM4JResourceUtilities.getUIString("COMMON_RULES_IF");
            String string6 = DM4JResourceUtilities.getUIString("COMMON_RULES_THEN");
            String string7 = (String)charSequence + "\n";
            string7 = string7 + string;
            string7 = string7 + "\n\n";
            string7 = string7 + string6 + "\n";
            string7 = string7 + string2;
            string7 = string7 + "\n\n";
            string7 = string7 + DM4JResourceUtilities.getUIString("COMMON_RULES_CONFIDENCE") + "=" + f.floatValue() + "";
            string7 = string7 + "\n";
            string7 = string7 + DM4JResourceUtilities.getUIString("COMMON_RULES_SUPPORT") + "=" + f2.floatValue() + "";
            this.m_ruleDetail.setText(string7);
        }
    }

    private void btnSort_actionPerformed(ActionEvent actionEvent) {
    }

    private class SortHandler
    implements HeaderItemInputHandler {
        public SortHandler(SortableTwoDModel sortableTwoDModel) {
        }

        public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
            try {
                int n2 = ABNDetailRulesPanel.this.m_colSortOrders[n];
                if (n2 == -1) {
                    return;
                }
                if (n2 == 0) {
                    n2 = ABNDetailRulesPanel.this.m_curSortOrder;
                } else if (n2 == 1) {
                    n2 = 2;
                } else if (n2 == 2) {
                    n2 = 1;
                }
                ABNDetailRulesPanel.this.m_colSortOrders[n] = n2;
                ABNDetailRulesPanel.this.m_curSortOrder = n2;
                ABNDetailRulesPanel.this.m_rulesTableModel.sort(n, n2 == 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        }
    }
}

