/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.attributeImportance;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import javax.datamining.attributeimportance.AttributeImportanceModel;
import javax.datamining.attributeimportance.AttributeImportanceSettings;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JCommonUIUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.attributeImportance.RankTable;
import oracle.dmt.dm4j.browser.viewer.export.ExportChartDialog;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dss.graph.Graph;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public class AttributeImportanceRankingPanel
extends GriddedPanel {
    private JLabel m_targetAttribName = new JLabel();
    NumberTextField m_tfSize = new NumberTextField();
    JLabel m_lblSize = new JLabel();
    JButton m_btnRefresh = new JButton();
    Integer m_defaultFectchSize = new Integer(100);
    AttributeImportanceModel m_model = null;
    RankTable m_rankTable = null;
    JScrollPane m_rankScrollPane = new JScrollPane();
    Graph m_histogram = null;
    JButton m_exportButton = null;
    JButton m_exportChartButton = null;

    public AttributeImportanceRankingPanel(LeafNodeData leafNodeData) {
        this.m_model = (AttributeImportanceModel)leafNodeData.getOdmObject();
        try {
            this.jbInit();
            this.runTimePanelLoad(leafNodeData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "ATTRIBUTE_IMPORTANCE_MODEL";
    }

    private void jbInit() throws Exception {
        Cloneable cloneable;
        Serializable serializable;
        GriddedPanel griddedPanel = new GriddedPanel();
        GriddedPanel griddedPanel2 = new GriddedPanel();
        JSplitPane jSplitPane = new JSplitPane(0, griddedPanel, griddedPanel2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(350);
        Dimension dimension = new Dimension(100, 50);
        griddedPanel.setMinimumSize(dimension);
        griddedPanel2.setMinimumSize(dimension);
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("AI_SETTING_RANKS"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("AI_SETTING_RANKS"));
        griddedPanel2.addAnchoredComponent(jLabel, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        griddedPanel2.addAnchoredComponent(jButton, MIDLABELITEMINSETS, n++, 2, 1, 1, 14);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(AttributeImportanceRankingPanel.this.m_rankTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_rankTable = new RankTable(this.m_model);
        this.m_rankScrollPane.getViewport().add(this.m_rankTable);
        jLabel.setLabelFor(this.m_rankTable);
        this.m_rankScrollPane.setPreferredSize(null);
        griddedPanel2.addFilledComponent(this.m_rankScrollPane, MIDLABELITEMINSETS, n, 0, 3, 3, 1);
        JPanel jPanel = new JPanel();
        this.m_tfSize.setDataType(Integer.TYPE);
        this.m_tfSize.setNumber(this.m_defaultFectchSize);
        this.m_tfSize.setSigned(false);
        this.m_tfSize.setColumns(5);
        this.m_tfSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this.m_lblSize.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHSIZE"));
        this.m_lblSize.setLabelFor(this.m_tfSize);
        this.m_btnRefresh.setText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_REFRESH"));
        this.m_btnRefresh.setEnabled(true);
        this.m_btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeImportanceRankingPanel.this.m_btnRefresh_actionPerformed(actionEvent);
            }
        });
        JLabel jLabel2 = new JLabel();
        if (BrowserFrame.is11Server()) {
            jLabel2.setText("");
        } else {
            jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_TARGET"));
        }
        griddedPanel.addComponent(jLabel2, TOPLABELITEMINSETS, n, 0);
        griddedPanel.addComponent(this.m_targetAttribName, TOPVALUEITEMINSETS, n++, 1);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.add(this.m_lblSize);
        jPanel2.add(this.m_tfSize);
        jPanel2.add(this.m_btnRefresh);
        griddedPanel.addFilledComponent(jPanel2, TOPLABELITEMINSETS, n++, 0, 3, 1, 2);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("AI_HIST"));
        jLabel3.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("AI_HIST"));
        griddedPanel.addAnchoredComponent(jLabel3, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        JButton jButton2 = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton2.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        griddedPanel.addAnchoredComponent(jButton2, MIDLABELITEMINSETS, n++, 2, 1, 1, 14);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportChartDialog exportChartDialog = new ExportChartDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("EXPORT_TITLE"));
                    if (!exportChartDialog.isCancelled()) {
                        exportChartDialog.export(AttributeImportanceRankingPanel.this.m_histogram);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        if (null == this.m_histogram) {
            serializable = new DefaultErrorHandler();
            ((DefaultErrorHandler)serializable).setDebugMode(0);
            this.m_histogram = new Graph((ErrorHandler)((Object)serializable));
            this.m_histogram.setLocale(Locale.getDefault());
            this.m_histogram.setGraphType(24);
            this.m_histogram.setAutoLayout(2);
            this.m_histogram.getLegendArea().setVisible(false);
            this.m_histogram.setScrollbarPresenceGroups(2);
            cloneable = this.m_histogram.getImageSize();
            this.m_histogram.setImageSize((Dimension)cloneable);
            this.m_histogram.setVisible(false);
        }
        serializable = new JPanel(new GridBagLayout());
        ((JComponent)serializable).setBackground(Color.WHITE);
        cloneable = new GridBagConstraints();
        cloneable.anchor = 18;
        cloneable.fill = 1;
        cloneable.weightx = 1.0;
        cloneable.weighty = 1.0;
        ((JComponent)serializable).setBackground(Color.WHITE);
        ((Container)serializable).add(this.m_histogram, cloneable);
        griddedPanel.addFilledComponent((JComponent)serializable, MIDLABELITEMINSETS, n, 0, 3, 3, 1);
        this.addFilledComponent(jSplitPane, TOPLABELITEMINSETS, 0, 0, 5, 5, 1);
    }

    private void m_btnRefresh_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            Number number = this.m_tfSize.getNumber();
            if (number == null) {
                DM4JCommonUIUtils.showErrorMessage(this, "Please enter a fetch size.");
                this.setCursor(new Cursor(0));
                return;
            }
            int n = number.intValue();
            this.m_rankTable.load(this.m_histogram, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        this.m_model = (AttributeImportanceModel)leafNodeData.getOdmObject();
        AttributeImportanceSettings attributeImportanceSettings = (AttributeImportanceSettings)this.m_model.getBuildSettings();
        if (BrowserFrame.is11Server()) {
            this.m_targetAttribName.setText("");
        } else {
            this.m_targetAttribName.setText(attributeImportanceSettings.getTargetAttributeName());
        }
        this.m_rankTable.load(this.m_histogram, this.m_defaultFectchSize);
        Grid grid = this.m_rankTable.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_rankTable);
    }
}

