/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.association;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.NumberFormat;
import javax.datamining.association.AssociationModel;
import javax.datamining.association.AssociationSettings;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.table.AttributeTable;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.association.AssociationModelViewer;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.jdm.base.OraBuildSettings;

public class AssociationSettingsPanel
extends GriddedPanel {
    JLabel m_modelType = new JLabel();
    JLabel m_maxRuleLength = new JLabel();
    JLabel m_minSupport = new JLabel();
    JLabel m_minConfidence = new JLabel();
    JLabel m_automaticDataPreparation = new JLabel();
    JScrollPane m_attribPanel = new JScrollPane();
    AttributeTable m_attribTable = null;
    AssociationSettings m_settings = null;
    AssociationModel m_model = null;

    public AssociationSettingsPanel(AssociationModel associationModel) {
        this.m_model = associationModel;
        this.m_settings = (AssociationSettings)this.m_model.getBuildSettings();
        try {
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        Container container = this.getParent();
        if (container instanceof AssociationModelViewer) {
            return "ASSOCIATION_RULES_MODEL";
        }
        return "ASSOCIATION_RULES_SETTING";
    }

    private void jbInit() throws Exception {
        JLabel jLabel;
        int n = 0;
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DM4JResourceUtilities.getUIString("COMMON_TYPE"));
        this.m_modelType.setText(DM4JResourceUtilities.getUIString("ASSOC_SETTING_ASSOC"));
        this.addComponent(jLabel2, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.m_modelType, TOPVALUEITEMINSETS, n++, 1);
        if (BrowserFrame.is11Server()) {
            jLabel = new JLabel();
            jLabel.setText(DM4JResourceUtilities.getUIString("AUTOMATIC_DATA_PREPARATION"));
            this.addComponent(jLabel, MIDLABELITEMINSETS, n, 0);
            this.addComponent(this.m_automaticDataPreparation, MIDVALUEITEMINSETS, n++, 1);
        }
        jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_ALGORITM_SETTINGS"));
        this.addComponent(jLabel, TOPLABELITEMINSETS, n++, 0);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("ASSOC_SETTING_SUPPORT"));
        this.addComponent(jLabel3, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_minSupport, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DM4JResourceUtilities.getUIString("ASSOC_SETTING_CONFIDENCE"));
        this.addComponent(jLabel4, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_minConfidence, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(DM4JResourceUtilities.getUIString("ASSOC_SETTING_RULE_LIMIT"));
        this.addComponent(jLabel5, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.m_maxRuleLength, MIDVALUEITEMINSETS, n++, 1);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(DM4JResourceUtilities.getUIString("COMMON_ATTRIBUTES"));
        jLabel6.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_ATTRIBUTES"));
        this.addAnchoredComponent(jLabel6, TOPLABELITEMINSETS, n, 0, 1, 1, 16);
        this.m_attribTable = new AttributeTable(this.m_model);
        JButton jButton = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));
        jButton.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this.addAnchoredComponent(jButton, MIDLABELITEMINSETS, n++, 1, 1, 1, 14);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
                    ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
                    if (!exportDialog.isCancelled()) {
                        exportDialog.export(AssociationSettingsPanel.this.m_attribTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_attribPanel.getViewport().add(this.m_attribTable);
        jLabel6.setLabelFor(this.m_attribTable);
        this.m_attribPanel.setPreferredSize(null);
        this.addFilledComponent(this.m_attribPanel, MIDLABELITEMINSETS, n, 0, 2, 2, 1);
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        this.m_attribTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_attribTable);
    }

    private void runTimePanelLoad() throws Exception {
        Object object;
        this.m_attribTable.load();
        if (BrowserFrame.is11Server()) {
            object = ((OraBuildSettings)((Object)this.m_settings)).useAutomatedDataPreparations() ? DM4JResourceUtilities.getUIString("COMMON_YES") : DM4JResourceUtilities.getUIString("COMMON_NO");
            this.m_automaticDataPreparation.setText((String)object);
        }
        this.m_maxRuleLength.setText(DM4JNumericFormat.format(this.m_settings.getMaxRuleLength()));
        object = DM4JNumericFormat.getInstance(false, 10, 4);
        this.m_minSupport.setText(((Format)object).format(this.m_settings.getMinSupport()));
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(false, 10, 4);
        this.m_minConfidence.setText(numberFormat.format(this.m_settings.getMinConfidence()));
    }
}

