/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.association;

import java.awt.EventQueue;
import javax.datamining.association.AssociationModel;
import javax.datamining.resource.Connection;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.BrowseResultsListPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.ModelViewer;
import oracle.dmt.dm4j.browser.viewer.association.AssociationRulesPanel;
import oracle.dmt.dm4j.browser.viewer.association.AssociationSettingsPanel;
import oracle.dmt.dm4j.browser.viewer.results.build.BuildTaskPanel;
import oracle.dmt.jdm.jdmresult.OraMiningBuildResult;

public class AssociationModelViewer
extends ModelViewer {
    static int SETTING_TAB = 0;
    static int RULE_TAB = 1;
    static int RESULT_TAB = 2;
    static int TASK_TAB = 3;
    int[] m_tabIndex;
    AssociationSettingsPanel m_associationSettingsPanel;
    AssociationRulesPanel m_associationRulesPanel;
    BrowseResultsListPanel m_browseResultsListPanel;
    BuildTaskPanel m_buildTaskPanel;
    OraMiningBuildResult m_buldTask;

    public AssociationModelViewer(LeafNodeData leafNodeData, Connection connection, int n) throws Exception {
        super(leafNodeData, connection, n);
        this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
    }

    protected String getHelpId() {
        int n = this.getSelectedIndex();
        GriddedPanel griddedPanel = (GriddedPanel)this.getComponentAt(n);
        return griddedPanel.getHelpId();
    }

    protected void loadViewer(LeafNodeData leafNodeData, int n) throws Exception {
        AssociationModel associationModel = (AssociationModel)leafNodeData.getOdmObject();
        int n2 = 0;
        this.m_tabIndex = new int[4];
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_RULES"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_RULES"));
        this.m_tabIndex[n2++] = RULE_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("COMMON_SETTINGS"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("COMMON_SETTINGS"));
        this.m_tabIndex[n2++] = SETTING_TAB;
        this.addTab(DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"), null, new LoadingStatusPanel(), DM4JResourceUtilities.getUIString("RESULT_TASK_TAB"));
        this.m_tabIndex[n2++] = TASK_TAB;
        this.showTab(n);
        this.setSelectedIndex(n);
    }

    protected void showTab(int n) {
        Thread thread = new Thread(new LoadTab(n));
        thread.setPriority(5);
        thread.start();
    }

    class LoadTab
    implements Runnable {
        int tabIndex;
        GriddedPanel panel;

        public LoadTab(int n) {
            this.tabIndex = n;
        }

        public void run() {
            try {
                AssociationModel associationModel = (AssociationModel)AssociationModelViewer.this.m_node.getOdmObject();
                this.panel = null;
                if (AssociationModelViewer.this.m_tabIndex[this.tabIndex] == SETTING_TAB) {
                    if (AssociationModelViewer.this.m_associationSettingsPanel == null) {
                        AssociationModelViewer.this.m_associationSettingsPanel = new AssociationSettingsPanel(associationModel);
                    }
                    this.panel = AssociationModelViewer.this.m_associationSettingsPanel;
                } else if (AssociationModelViewer.this.m_tabIndex[this.tabIndex] == RULE_TAB) {
                    if (AssociationModelViewer.this.m_associationRulesPanel == null) {
                        AssociationModelViewer.this.m_associationRulesPanel = new AssociationRulesPanel(AssociationModelViewer.this.m_node);
                    }
                    this.panel = AssociationModelViewer.this.m_associationRulesPanel;
                } else if (AssociationModelViewer.this.m_tabIndex[this.tabIndex] == TASK_TAB) {
                    if (AssociationModelViewer.this.m_buildTaskPanel == null) {
                        AssociationModelViewer.this.m_buildTaskPanel = new BuildTaskPanel(associationModel.getName());
                    }
                    this.panel = AssociationModelViewer.this.m_buildTaskPanel;
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        AssociationModelViewer.this.setComponentAt(LoadTab.this.tabIndex, LoadTab.this.panel);
                    }
                };
                EventQueue.invokeLater(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

