/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.activity.steps.ROCThresholdSelectionStepOptions;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class ROCThresholdOptionPanel
extends JPanel {
    private static int WIDTH = 450;
    private static int HEIGHT = 400;
    int tInd = 5;
    int lInd = 10;
    int bInd = 0;
    int rInd = 10;
    int wPad = 0;
    int hPad = 0;
    int l2Ind = 24;
    int bInstInd = 10;
    int tGroupInd = 10;
    int rowLength = 60;
    ROCThresholdSelectionStepOptions m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JButton butRestore = new JButton();
    JLabel lblTotalNumberOfCases = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    JLabel lblThreshold = new JLabel();
    DM4JNumberTextField fldThreshold = new DM4JNumberTextField();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreModelBuildTypeEvent = false;
    ROCThresholdSelectionStepOptions m_copyState = null;

    public ROCThresholdOptionPanel(DM4JDialog dM4JDialog, ROCThresholdSelectionStepOptions rOCThresholdSelectionStepOptions) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = rOCThresholdSelectionStepOptions;
        this.m_copyState = new ROCThresholdSelectionStepOptions(rOCThresholdSelectionStepOptions);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("CLASSIFICATION_TM_THRESHOLD_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(this.rowLength);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
        this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
        this.butRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ROCThresholdOptionPanel.this.butRestore_actionPerformed(actionEvent);
            }
        });
        this.m_parentDialog.addCustomButton(this.butRestore);
        ++n;
        n2 = 0;
        this.lblTotalNumberOfCases.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_TOTAL_NUMBER_OF_CASES"));
        this.lblTotalNumberOfCases.setLabelFor(this.lblTotalCaseCountValue);
        this.add((Component)this.lblTotalNumberOfCases, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.lblTotalCaseCountValue.setLocale(Locale.getDefault());
        this.add((Component)this.lblTotalCaseCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblThreshold = new JLabel(ResourceUtilities.getUILabel("CLASSIFICATION_TM_THRESHOLD"));
        this.lblThreshold.setLabelFor(this.fldThreshold);
        this.lblThreshold.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CLASSIFICATION_TM_THRESHOLD"));
        this.add((Component)this.lblThreshold, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.fldThreshold.setLocale(Locale.getDefault());
        this.fldThreshold.setDataType(Double.TYPE);
        this.fldThreshold.setSigned(false);
        this.add((Component)this.fldThreshold, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        JComponent[] jComponentArray = new JComponent[]{this.fldThreshold};
        ResourceUtilities.setTextBoxSize(jComponentArray, 70, 20);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() {
        this.setROCThresholdOptionSettings();
    }

    protected void setROCThresholdOptionSettings() {
        this.lblTotalCaseCountValue.setText(this.m_state.getCaseCount() + "");
        this.fldThreshold.setNumber(this.m_state.getThresholdValue());
    }

    protected void processUserInput() {
        this.m_state.setThresholdValue((Double)this.fldThreshold.getNumber());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ROCThresholdOptionPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.restoreSettings(this.m_copyState);
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.init(this.m_copyState.getActivityType());
        this.setROCThresholdOptionSettings();
    }
}

