/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.browser.BrowserAboutBoxPanel;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.table.TableViewer;
import oracle.dmt.dm4j.browser.worker.LoadSchemaObjectDetailWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.SchemaObjectDetailLoadedListener;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class OutputDataViewerFrame
extends JFrame
implements SchemaObjectDetailLoadedListener {
    private GriddedPanel m_loadingPanel = new GriddedPanel();
    private AbstractActivity m_activity = null;
    private AbstractStep m_step = null;

    public OutputDataViewerFrame(HyperlinkButtonDataSource hyperlinkButtonDataSource, AbstractActivity abstractActivity, AbstractStep abstractStep) {
        this.m_activity = abstractActivity;
        this.m_step = abstractStep;
        this.commonConstructorImpl(hyperlinkButtonDataSource);
    }

    public OutputDataViewerFrame(HyperlinkButtonDataSource hyperlinkButtonDataSource, AbstractActivity abstractActivity) {
        this.m_activity = abstractActivity;
        this.commonConstructorImpl(hyperlinkButtonDataSource);
    }

    public OutputDataViewerFrame(HyperlinkButtonDataSource hyperlinkButtonDataSource) {
        this.commonConstructorImpl(hyperlinkButtonDataSource);
    }

    private void commonConstructorImpl(HyperlinkButtonDataSource hyperlinkButtonDataSource) {
        this.createMenuBar();
        try {
            ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
            this.setIconImage(imageIcon.getImage());
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(this.createLoadingPanel());
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_activity != null) {
                stringBuffer.append(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_TITLE_ACTIVITY") + " " + this.m_activity.getName() + ": ");
                if (this.m_step != null) {
                    stringBuffer.append(this.m_step.getTitle() + ": ");
                }
                stringBuffer.append(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_VIEWER_TITLE") + " " + hyperlinkButtonDataSource.getSchemaName() + "." + hyperlinkButtonDataSource.getTableName());
            } else {
                stringBuffer.append(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_VIEWER_TITLE") + " " + hyperlinkButtonDataSource.getText());
            }
            this.setTitle(stringBuffer.toString());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Window window = windowEvent.getWindow();
                    window.setVisible(false);
                    window.dispose();
                }
            });
            KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, true);
            this.getRootPane().getInputMap(1).put(keyStroke, "HelpAction");
            this.getRootPane().getActionMap().put("HelpAction", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutputDataViewerFrame.this.help_actionPerformed(actionEvent);
                }
            });
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, true);
            this.getRootPane().getInputMap(2).put(keyStroke2, "EscAction");
            this.getRootPane().getActionMap().put("EscAction", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutputDataViewerFrame.this.esc_actionPerformed(actionEvent);
                }
            });
            this.pack();
            WindowUtils.centerWindow(this);
            this.setVisible(true);
            String string = this.isTable(hyperlinkButtonDataSource) ? "TABLE" : "VIEW";
            LeafNodeData leafNodeData = new LeafNodeData(hyperlinkButtonDataSource.getTableName(), string);
            leafNodeData.setSchemaName(hyperlinkButtonDataSource.getSchemaName());
            WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(leafNodeData);
            LoadSchemaObjectDetailWorker loadSchemaObjectDetailWorker = (LoadSchemaObjectDetailWorker)workerThreadManager.getLoadSchemaObjectDetailWorker(defaultMutableTreeNode, 0);
            loadSchemaObjectDetailWorker.addSchemaObjectDetailLoadedListener(this);
            loadSchemaObjectDetailWorker.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isTable(HyperlinkButtonDataSource hyperlinkButtonDataSource) {
        boolean bl;
        block8: {
            bl = false;
            BrowserFrame browserFrame = BrowserFrame.getMainFrame();
            Connection connection = null;
            connection = DM4JConnectionManager.getDbConnection();
            String string = hyperlinkButtonDataSource.getSchemaName();
            String string2 = hyperlinkButtonDataSource.getTableName();
            bl = DatabaseMetadata.isTable(connection, string, string2);
            Object var8_8 = null;
            try {
                connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block8;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var8_9 = null;
                    try {
                        connection.close();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return bl;
    }

    private void createMenuBar() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        this.setJMenuBar(jMenuBar);
        jMenu.setText(DM4JResourceUtilities.getUIString("MENU_FILE"));
        jMenu.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_FILE"));
        jMenuItem.setText(DM4JResourceUtilities.getUIString("MENU_FILE_EXIT"));
        jMenuItem.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_FILE_EXIT"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputDataViewerFrame.this.esc_actionPerformed(actionEvent);
            }
        });
        jMenu2.setText(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        jMenu2.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_HELP"));
        jMenuItem2.setText(DM4JResourceUtilities.getUIString("MENU_HELP_CONTENTS"));
        jMenuItem2.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_HELP_CONTENTS"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputDataViewerFrame.this.help_actionPerformed(actionEvent);
            }
        });
        jMenuItem3.setText(DM4JResourceUtilities.getUIString("MENU_HELP_ABOUT"));
        jMenuItem3.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_HELP_ABOUT"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputDataViewerFrame.this.helpAbout_ActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.addSeparator();
        jMenu2.add(jMenuItem3);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
    }

    private void helpAbout_ActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, new BrowserAboutBoxPanel(), DM4JVersion.getFullBrowserName(), -1);
    }

    public void esc_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public void help_actionPerformed(ActionEvent actionEvent) {
        try {
            BrowserFrame.getCSHManager().showTopic("VIEW");
        }
        catch (Exception exception) {
            BrowserFrame.showHelpError(this);
        }
    }

    public JPanel createLoadingPanel() {
        int n = 0;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_LOADING"));
        this.m_loadingPanel.addAnchoredComponent(jLabel, GriddedPanel.TOPLABELITEMINSETS, n, 0, 1, 1, 18);
        JLabel jLabel2 = new JLabel();
        this.m_loadingPanel.addComponent(jLabel2, GriddedPanel.TOPLABELITEMINSETS, n, 0, 2, 2, 18, 1);
        this.m_loadingPanel.setPreferredSize(new Dimension(500, 500));
        return this.m_loadingPanel;
    }

    public void schemaObjectDetailLoaded(EventObject eventObject) {
        ArrayList arrayList = (ArrayList)eventObject.getSource();
        final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(0);
        final TableViewer tableViewer = (TableViewer)arrayList.get(1);
        Integer n = (Integer)arrayList.get(2);
        if (defaultMutableTreeNode != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    LeafNodeData leafNodeData = (LeafNodeData)defaultMutableTreeNode.getUserObject();
                    OutputDataViewerFrame.this.getContentPane().remove(OutputDataViewerFrame.this.m_loadingPanel);
                    OutputDataViewerFrame.this.getContentPane().add(tableViewer);
                    tableViewer.setPreferredSize(new Dimension(500, 500));
                    OutputDataViewerFrame.this.pack();
                    tableViewer.requestFocus();
                }
            };
            EventQueue.invokeLater(runnable);
        }
    }
}

