/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.ODMrTextStep;
import oracle.dmt.dm4j.activity.steps.SplitStep;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButtonDataSource;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataPickerFrame;
import oracle.dmt.dm4j.browser.viewer.activity.OutputDataViewerFrame;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TXColumn;

public class OutputDataPickerPanel
extends JScrollPane {
    private AbstractStep m_step = null;
    private AbstractActivity m_activity = null;
    private OutputDataPickerFrame m_frame;

    public OutputDataPickerPanel(AbstractActivity abstractActivity, AbstractStep abstractStep, OutputDataPickerFrame outputDataPickerFrame) {
        this.m_step = abstractStep;
        this.m_activity = abstractActivity;
        this.m_frame = outputDataPickerFrame;
        this.jbinit();
    }

    public OutputDataPickerPanel(AbstractStep abstractStep, OutputDataPickerFrame outputDataPickerFrame) {
        this.m_step = abstractStep;
        this.m_frame = outputDataPickerFrame;
        this.jbinit();
    }

    public OutputDataPickerPanel(AbstractActivity abstractActivity, OutputDataPickerFrame outputDataPickerFrame) {
        this.m_frame = outputDataPickerFrame;
        this.m_activity = abstractActivity;
        this.jbinit();
    }

    private void jbinit() {
        OutputDataPickerPanelInternal outputDataPickerPanelInternal = new OutputDataPickerPanelInternal(this.m_frame);
        this.getViewport().add(outputDataPickerPanelInternal);
    }

    class OutputDataPickerPanelInternal
    extends GriddedPanel {
        JLabel m_instructionslbl = new JLabel();
        JLabel m_stepNamelbl = new JLabel();
        JLabel m_stepValuelbl = new JLabel();
        JLabel m_activityNamelbl = new JLabel();
        JLabel m_activityValuelbl = new JLabel();
        JLabel m_caseTableNamelbl = new JLabel();
        JLabel m_caseTestTableNamelbl = new JLabel();
        JLabel m_caseExplainTableNamelbl = new JLabel();
        JLabel m_caseMappingTableNamelbl = new JLabel();
        JLabel m_filler = new JLabel();
        OutputDataPickerFrame m_frame;
        static final String DOUBLE_QUOTE = "\"";

        public OutputDataPickerPanelInternal(OutputDataPickerFrame outputDataPickerFrame) {
            try {
                this.m_frame = outputDataPickerFrame;
                if (OutputDataPickerPanel.this.m_step != null) {
                    this.jbInit();
                } else {
                    this.jbInitActivity();
                }
                this.runTimePanelLoad();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            HyperlinkButtonDataSource hyperlinkButtonDataSource;
            int n = 1;
            ComplexDataStructure complexDataStructure = null;
            ComplexDataStructure complexDataStructure2 = null;
            Object var7_4 = null;
            ComplexDataStructure complexDataStructure3 = null;
            if (OutputDataPickerPanel.this.m_step instanceof AbstractMiningStep) {
                AbstractMiningStep abstractMiningStep = (AbstractMiningStep)OutputDataPickerPanel.this.m_step;
                Table table = abstractMiningStep.getOutputDataUsageView();
                if (table != null) {
                    hyperlinkButtonDataSource = this.createHyperlinkButtonDataSource(table.getSchema(), table.getName());
                } else {
                    complexDataStructure = OutputDataPickerPanel.this.m_step.getOutputDataDescriptor();
                    hyperlinkButtonDataSource = this.createHyperlinkButtonDataSource(complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable());
                }
            } else {
                complexDataStructure = OutputDataPickerPanel.this.m_step.getOutputDataDescriptor();
                hyperlinkButtonDataSource = this.createHyperlinkButtonDataSource(complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable());
            }
            if (OutputDataPickerPanel.this.m_step instanceof SplitStep) {
                this.m_caseTableNamelbl.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_PICKER_BUILD_CASE"));
                this.addAnchoredComponent(this.m_caseTableNamelbl, TOPLABELITEMINSETS, n, 1, 16);
                this.addAnchoredComponent(hyperlinkButtonDataSource, TOPVALUEITEMINSETS, n++, 2, 16);
                this.m_caseTableNamelbl.setLabelFor(hyperlinkButtonDataSource);
                n = this.addTransactionComponents(complexDataStructure, n);
                complexDataStructure2 = ((SplitStep)OutputDataPickerPanel.this.m_step).getTestOutputDataDescriptor();
                HyperlinkButtonDataSource hyperlinkButtonDataSource2 = this.createHyperlinkButtonDataSource(complexDataStructure2.getCaseSchema(), complexDataStructure2.getCaseTable());
                this.m_caseTestTableNamelbl.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_PICKER_TEST_CASE"));
                this.addAnchoredComponent(this.m_caseTestTableNamelbl, TOPLABELITEMINSETS, n, 1, 16);
                this.addAnchoredComponent(hyperlinkButtonDataSource2, TOPVALUEITEMINSETS, n++, 2, 16);
                this.m_caseTableNamelbl.setLabelFor(hyperlinkButtonDataSource);
                n = this.addTransactionComponents(complexDataStructure2, n);
            } else if (OutputDataPickerPanel.this.m_step instanceof ODMrTextStep) {
                this.m_caseTableNamelbl.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_PICKER_CASE"));
                this.addAnchoredComponent(this.m_caseTableNamelbl, TOPLABELITEMINSETS, n, 1, 16);
                this.addAnchoredComponent(hyperlinkButtonDataSource, TOPVALUEITEMINSETS, n++, 2, 16);
                this.m_caseTableNamelbl.setLabelFor(hyperlinkButtonDataSource);
                n = this.addTransactionComponents(complexDataStructure, n);
                complexDataStructure3 = ((ODMrTextStep)OutputDataPickerPanel.this.m_step).getMappingOutputDataDescriptor();
                HyperlinkButtonDataSource hyperlinkButtonDataSource3 = this.createHyperlinkButtonDataSource(complexDataStructure3.getCaseSchema(), complexDataStructure3.getCaseTable());
                this.m_caseMappingTableNamelbl.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_PICKER_MAPPING"));
                this.addAnchoredComponent(this.m_caseMappingTableNamelbl, TOPLABELITEMINSETS, n, 1, 16);
                this.addAnchoredComponent(hyperlinkButtonDataSource3, TOPVALUEITEMINSETS, n++, 2, 16);
                this.m_caseTableNamelbl.setLabelFor(hyperlinkButtonDataSource);
                n = this.addTransactionComponents(complexDataStructure3, n);
            } else {
                this.m_caseTableNamelbl.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_PICKER_CASE"));
                this.addAnchoredComponent(this.m_caseTableNamelbl, TOPLABELITEMINSETS, n, 1, 16);
                this.addAnchoredComponent(hyperlinkButtonDataSource, TOPVALUEITEMINSETS, n++, 2, 16);
                this.m_caseTableNamelbl.setLabelFor(hyperlinkButtonDataSource);
                n = this.addTransactionComponents(complexDataStructure, n);
            }
            this.addFilledComponent(this.m_filler, TOPLABELITEMINSETS, n, 1, 2, 2, 1);
        }

        private void jbInitActivity() throws Exception {
            int n = 1;
            ComplexDataStructure complexDataStructure = null;
            Object var5_3 = null;
            complexDataStructure = OutputDataPickerPanel.this.m_activity.getInputDataDescriptor();
            HyperlinkButtonDataSource hyperlinkButtonDataSource = this.createHyperlinkButtonDataSource(complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable());
            this.m_caseTableNamelbl.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_PICKER_CASE"));
            this.addAnchoredComponent(this.m_caseTableNamelbl, TOPLABELITEMINSETS, n, 1, 16);
            this.addAnchoredComponent(hyperlinkButtonDataSource, TOPVALUEITEMINSETS, n++, 2, 16);
            this.m_caseTableNamelbl.setLabelFor(hyperlinkButtonDataSource);
            n = this.addTransactionComponents(complexDataStructure, n);
            this.addFilledComponent(this.m_filler, TOPLABELITEMINSETS, n, 1, 2, 2, 1);
        }

        private int addTransactionComponents(ComplexDataStructure complexDataStructure, int n) {
            Collection collection;
            if (complexDataStructure != null && (collection = complexDataStructure.getColumnMap().values()).size() > 0) {
                JLabel jLabel = new JLabel();
                jLabel.setText(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_PICKER_TRANS"));
                this.addComponent(jLabel, TOPLABELITEMINSETS, n++, 1, 2, 1);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    JLabel jLabel2 = new JLabel();
                    TXColumn tXColumn = (TXColumn)iterator.next();
                    jLabel2.setText(tXColumn.getUniqueName() + ":");
                    this.addAnchoredComponent(jLabel2, MIDINDENTEDLABELITEMINSETS, n, 1, 16);
                    HyperlinkButtonDataSource hyperlinkButtonDataSource = this.createHyperlinkButtonDataSource(tXColumn.getTxSchemaName(), tXColumn.getTxTableName());
                    this.addAnchoredComponent(hyperlinkButtonDataSource, MIDVALUEITEMINSETS, n++, 2, 16);
                    jLabel2.setLabelFor(hyperlinkButtonDataSource);
                }
            }
            return n;
        }

        private HyperlinkButtonDataSource createHyperlinkButtonDataSource(String string, String string2) {
            HyperlinkButtonDataSource hyperlinkButtonDataSource = new HyperlinkButtonDataSource(string, string2);
            hyperlinkButtonDataSource.setText(DOUBLE_QUOTE + string + "\".\"" + string2 + DOUBLE_QUOTE);
            hyperlinkButtonDataSource.setActive(true);
            hyperlinkButtonDataSource.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutputDataPickerPanelInternal.this.selectOutputData_actionPerformed(actionEvent);
                }
            });
            return hyperlinkButtonDataSource;
        }

        private void runTimePanelLoad() throws Exception {
        }

        private void selectOutputData_actionPerformed(ActionEvent actionEvent) {
            try {
                final HyperlinkButtonDataSource hyperlinkButtonDataSource = (HyperlinkButtonDataSource)actionEvent.getSource();
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    public void run() {
                        block10: {
                            Connection connection = null;
                            connection = DM4JConnectionManager.getDbConnection();
                            if (DatabaseMetadata.isTable(connection, hyperlinkButtonDataSource.getSchemaName(), hyperlinkButtonDataSource.getTableName())) {
                                hyperlinkButtonDataSource.setIsView(false);
                            } else {
                                hyperlinkButtonDataSource.setIsView(true);
                            }
                            OutputDataViewerFrame outputDataViewerFrame = new OutputDataViewerFrame(hyperlinkButtonDataSource, OutputDataPickerPanel.this.m_activity, OutputDataPickerPanel.this.m_step);
                            Object var4_4 = null;
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break block10;
                            {
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Object var4_5 = null;
                                    try {
                                        connection.close();
                                    }
                                    catch (Exception exception2) {
                                        exception2.printStackTrace();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                try {
                                    connection.close();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                throw throwable;
                            }
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(5);
                thread.start();
                this.m_frame.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

