/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.activity.steps.OutlierTreatmentStepOptions;
import oracle.dmt.dm4j.activity.wizard.AdvancedSettingsDialog;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.uicontrols.CustomNumberTextField;
import oracle.dmt.dm4j.wizard.uicontrols.UpdatableTextField;

public class OutlierPanel
extends JPanel
implements UpdatableTextField {
    int tInd = 5;
    int lInd = 10;
    int bInd = 0;
    int rInd = 10;
    int wPad = 0;
    int hPad = 0;
    int l2Ind = 24;
    int bInstInd = 10;
    int tGroupInd = 10;
    int rowLength = 60;
    OutlierTreatmentStepOptions m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JButton butRestore = new JButton();
    JLabel lblTotalNumberOfCases = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    static String MEAN = ResourceUtilities.getUILabel("MEAN");
    static String MIN = ResourceUtilities.getUILabel("MIN");
    static String MAX = ResourceUtilities.getUILabel("MAX");
    static String MODE = ResourceUtilities.getUILabel("MODE");
    static String NONE = ResourceUtilities.getUILabel("NONE");
    protected GriddedPanel m_TopPanel;
    protected GriddedPanel m_BottomPanel;
    protected static Insets TEXT_OFFSET = new Insets(5, 0, 0, 0);
    protected static double DEFAULT_PERCENT = 5.0;
    protected static Double ZERO = new Double(0.0);
    protected static double SIGMA_MULTIPLE = 3.0;
    protected EmptyBorder border5 = new EmptyBorder(5, 5, 5, 5);
    protected static final Insets COL1_LABEL = new Insets(5, 10, 0, 0);
    protected static int LOWER_TAIL_PERCENT = 0;
    protected static int UPPER_TAIL_PERCENT = 1;
    protected static int LOWER_TAIL_VALUE = 2;
    protected static int UPPER_TAIL_VALUE = 3;
    protected static int LOWER_TAIL_VALUE_CUSTOM = 4;
    protected static int UPPER_TAIL_VALUE_CUSTOM = 5;
    protected static int SIGMA_CUSTOM = 6;
    protected static int TEXT_FIELD_WIDTH = 15;
    protected static final Insets COL1_INDENTED2_CONTROL = new Insets(5, 53, 0, 0);
    protected JLabel lblSigmaValue;
    protected CustomNumberTextField txtSigmaValue;
    public static char PLUS_MINUS = (char)177;
    public static char SIGMA_SIGN = (char)963;
    protected JLabel lblLowerPercent;
    protected JLabel lblUpperPercent;
    protected CustomNumberTextField txtLowerPercent;
    protected CustomNumberTextField txtUpperPercent;
    protected JLabel lblLowerValue;
    protected JLabel lblUpperValue;
    protected CustomNumberTextField txtLowerValue;
    protected CustomNumberTextField txtUpperValue;
    protected JRadioButton m_chkBoxStdev;
    protected JRadioButton m_chkBoxPercent;
    protected JRadioButton m_chkBoxValue;
    protected ButtonGroup m_TopPanelGroup;
    protected JRadioButton m_nulls = new JRadioButton();
    protected JRadioButton m_edges = new JRadioButton();
    protected ButtonGroup m_BottomPanelGroup = new ButtonGroup();
    JLabel lblFiller = new JLabel();
    boolean m_disable = false;
    OutlierTreatmentStepOptions m_copyState = null;

    public OutlierPanel(DM4JDialog dM4JDialog, OutlierTreatmentStepOptions outlierTreatmentStepOptions) throws Exception {
        this(dM4JDialog, outlierTreatmentStepOptions, false);
    }

    public OutlierPanel(DM4JDialog dM4JDialog, OutlierTreatmentStepOptions outlierTreatmentStepOptions, boolean bl) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = outlierTreatmentStepOptions;
        this.m_disable = bl;
        this.m_copyState = new OutlierTreatmentStepOptions(outlierTreatmentStepOptions);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(this.rowLength);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        if (!this.m_disable) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutlierPanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
            this.m_parentDialog.addCustomButton(this.butRestore);
        }
        ++n;
        n2 = 0;
        this.createTopPanel();
        this.add((Component)this.m_TopPanel, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.createBottomPanel();
        this.add((Component)this.m_BottomPanel, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        JComponent[] jComponentArray = new JComponent[]{this.txtSigmaValue, this.txtLowerPercent, this.txtUpperPercent, this.txtLowerValue, this.txtUpperValue};
        ResourceUtilities.setTextBoxSize(jComponentArray, 70, 20);
        this.m_chkBoxStdev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierPanel.this.enableStdev();
                OutlierPanel.this.m_state.setValidationType(2);
            }
        });
        this.m_chkBoxValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierPanel.this.enableValue();
                OutlierPanel.this.m_state.setValidationType(1);
            }
        });
        this.m_chkBoxPercent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierPanel.this.enablePercent();
                OutlierPanel.this.m_state.setValidationType(0);
            }
        });
        if (!(this.m_parentDialog instanceof AdvancedSettingsDialog)) {
            this.addOKHelpCancelListeners();
        }
        this.loadState();
    }

    private void createTopPanel() {
        this.m_TopPanel = new GriddedPanel();
        this.m_TopPanel.setBorder(new CompoundBorder(new TitledBorder(null, ResourceUtilities.getUILabel("OUTLIER_STRATEGY_CUSTOM_CUTOFF_POINTS"), 1, 2), this.border5));
        int n = 0;
        this.m_chkBoxStdev = new JRadioButton();
        this.m_chkBoxPercent = new JRadioButton();
        this.m_chkBoxValue = new JRadioButton();
        this.m_TopPanelGroup = new ButtonGroup();
        this.m_chkBoxStdev.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_STDEV"));
        this.m_TopPanelGroup.add(this.m_chkBoxStdev);
        this.m_chkBoxStdev.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_STDEV"));
        this.m_TopPanel.addComponent(this.m_chkBoxStdev, COL1_LABEL, n++, 0, 1, 1);
        this.lblSigmaValue = new JLabel();
        this.txtSigmaValue = new CustomNumberTextField(this, SIGMA_CUSTOM);
        this.lblSigmaValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_SIGMA"));
        this.txtSigmaValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtSigmaValue.setDataType(Double.TYPE);
        this.txtSigmaValue.setSigned(false);
        this.lblSigmaValue.setLabelFor(this.txtSigmaValue);
        this.m_TopPanel.addComponent(this.lblSigmaValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtSigmaValue, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.m_chkBoxPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT"));
        this.m_chkBoxPercent.setSelected(false);
        this.m_TopPanelGroup.add(this.m_chkBoxPercent);
        this.m_chkBoxPercent.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_PERCENT"));
        this.m_TopPanel.addComponent(this.m_chkBoxPercent, COL1_LABEL, n++, 0, 1, 1);
        this.lblLowerPercent = new JLabel();
        this.txtLowerPercent = new CustomNumberTextField(this, LOWER_TAIL_PERCENT);
        this.lblLowerPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT_LOWER_TAIL"));
        this.txtLowerPercent.setColumns(TEXT_FIELD_WIDTH);
        this.txtLowerPercent.setDataType(Double.TYPE);
        this.txtLowerPercent.setSigned(false);
        this.lblLowerPercent.setLabelFor(this.txtLowerPercent);
        this.m_TopPanel.addComponent(this.lblLowerPercent, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtLowerPercent, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.lblUpperPercent = new JLabel();
        this.txtUpperPercent = new CustomNumberTextField(this, UPPER_TAIL_PERCENT);
        this.lblUpperPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT_UPPER_TAIL"));
        this.txtUpperPercent.setColumns(TEXT_FIELD_WIDTH);
        this.txtUpperPercent.setDataType(Double.TYPE);
        this.txtUpperPercent.setSigned(false);
        this.lblUpperPercent.setLabelFor(this.txtUpperPercent);
        this.m_TopPanel.addComponent(this.lblUpperPercent, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtUpperPercent, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.m_chkBoxValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE"));
        this.m_chkBoxValue.setSelected(false);
        this.m_TopPanelGroup.add(this.m_chkBoxValue);
        this.m_chkBoxValue.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_VALUE"));
        this.m_TopPanel.addComponent(this.m_chkBoxValue, COL1_LABEL, n++, 0, 1, 1);
        this.lblLowerValue = new JLabel();
        this.txtLowerValue = new CustomNumberTextField(this, LOWER_TAIL_VALUE);
        this.lblLowerValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_LOWER_TAIL"));
        this.txtLowerValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtLowerValue.setDataType(Double.TYPE);
        this.lblLowerValue.setLabelFor(this.txtLowerValue);
        this.m_TopPanel.addComponent(this.lblLowerValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtLowerValue, TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.lblUpperValue = new JLabel();
        this.txtUpperValue = new CustomNumberTextField(this, UPPER_TAIL_VALUE);
        this.lblUpperValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_UPPER_TAIL"));
        this.txtUpperValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtUpperValue.setDataType(Double.TYPE);
        this.lblUpperValue.setLabelFor(this.txtUpperValue);
        this.m_TopPanel.addComponent(this.lblUpperValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent(this.txtUpperValue, TEXT_OFFSET, n++, 2, 2, 1, 1);
    }

    protected void createBottomPanel() {
        this.m_BottomPanel = new GriddedPanel();
        this.m_BottomPanel.setBorder(new CompoundBorder(new TitledBorder(null, ResourceUtilities.getUILabel("OUTLIER_STRATEGY_CUSTOM_REPLACE_WITH"), 1, 2), this.border5));
        int n = 0;
        n = this.createRadioButtons(n, this.m_BottomPanel, COL1_LABEL);
        this.m_BottomPanel.addFilledComponent(new JLabel(), TEXT_OFFSET, n++, 2, 2, 1, 1);
    }

    protected int createRadioButtons(int n, GriddedPanel griddedPanel, Insets insets) {
        int n2 = n;
        this.m_nulls.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_STDEV_NULLS"));
        this.m_BottomPanelGroup.add(this.m_nulls);
        this.m_nulls.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_STDEV_NULLS"));
        griddedPanel.addComponent(this.m_nulls, insets, n2++, 0, 1, 1);
        this.m_edges.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_STDEV_EDGES"));
        this.m_BottomPanelGroup.add(this.m_edges);
        this.m_edges.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_STDEV_EDGES"));
        griddedPanel.addComponent(this.m_edges, insets, n2++, 0, 1, 1);
        return n2;
    }

    private void enableStdev() {
        this.m_chkBoxStdev.setSelected(true);
        this.m_chkBoxPercent.setSelected(false);
        this.m_chkBoxValue.setSelected(false);
        this.txtSigmaValue.setEnabled(true);
        this.txtLowerValue.setEnabled(false);
        this.txtUpperValue.setEnabled(false);
        this.txtLowerPercent.setEnabled(false);
        this.txtUpperPercent.setEnabled(false);
    }

    private void enablePercent() {
        this.m_chkBoxStdev.setSelected(false);
        this.m_chkBoxPercent.setSelected(true);
        this.m_chkBoxValue.setSelected(false);
        this.txtSigmaValue.setEnabled(false);
        this.txtLowerValue.setEnabled(false);
        this.txtUpperValue.setEnabled(false);
        this.txtLowerPercent.setEnabled(true);
        this.txtUpperPercent.setEnabled(true);
    }

    private void enableValue() {
        this.m_chkBoxStdev.setSelected(false);
        this.m_chkBoxPercent.setSelected(false);
        this.m_chkBoxValue.setSelected(true);
        this.txtSigmaValue.setEnabled(false);
        this.txtLowerValue.setEnabled(true);
        this.txtUpperValue.setEnabled(true);
        this.txtLowerPercent.setEnabled(false);
        this.txtUpperPercent.setEnabled(false);
    }

    protected void loadState() {
        this.setOutlierSettings();
    }

    protected void setOutlierSettings() {
        this.lblTotalCaseCountValue.setText(this.m_state.getCaseCount() + "");
        if (this.m_state.getValidationType() == 0) {
            this.m_chkBoxPercent.setSelected(true);
        } else if (this.m_state.getValidationType() == 1) {
            this.m_chkBoxValue.setSelected(true);
        } else if (this.m_state.getValidationType() == 2) {
            this.m_chkBoxStdev.setSelected(true);
        }
        this.txtLowerPercent.setNumber(new Double(this.m_state.getLowerPercent()));
        this.txtUpperPercent.setNumber(new Double(this.m_state.getUpperPercent()));
        this.txtLowerValue.setNumber(new Double(this.m_state.getLowerValue()));
        this.txtUpperValue.setNumber(new Double(this.m_state.getUpperValue()));
        this.txtSigmaValue.setNumber(new Double(this.m_state.getSigmaMultiple()));
        if (this.m_state.isUseEdges()) {
            this.m_edges.setSelected(true);
        } else {
            this.m_nulls.setSelected(true);
        }
        if (this.m_state.getValidationType() == 0) {
            this.enablePercent();
        } else if (this.m_state.getValidationType() == 1) {
            this.enableValue();
        } else if (this.m_state.getValidationType() == 2) {
            this.enableStdev();
        }
    }

    public void processUserInput() {
        if (this.m_chkBoxPercent.isSelected()) {
            this.m_state.setValidationType(0);
        } else if (this.m_chkBoxValue.isSelected()) {
            this.m_state.setValidationType(1);
        } else if (this.m_chkBoxStdev.isSelected()) {
            this.m_state.setValidationType(2);
        }
        if (this.txtLowerPercent.getNumber() != null) {
            this.m_state.setLowerPercent(this.txtLowerPercent.getNumber().doubleValue());
        } else {
            this.m_state.setLowerPercent(0.0);
        }
        if (this.txtUpperPercent.getNumber() != null) {
            this.m_state.setUpperPercent(this.txtUpperPercent.getNumber().doubleValue());
        } else {
            this.m_state.setUpperPercent(0.0);
        }
        if (this.txtLowerValue.getNumber() != null) {
            this.m_state.setLowerValue(this.txtLowerValue.getNumber().doubleValue());
        } else {
            this.m_state.setLowerValue(0.0);
        }
        if (this.txtUpperValue.getNumber() != null) {
            this.m_state.setUpperValue(this.txtUpperValue.getNumber().doubleValue());
        } else {
            this.m_state.setUpperValue(0.0);
        }
        if (this.txtSigmaValue.getNumber() != null) {
            this.m_state.setSigmaMultiple(this.txtSigmaValue.getNumber().doubleValue());
        } else {
            this.m_state.setSigmaMultiple(0.0);
        }
        if (this.m_edges.isSelected()) {
            this.m_state.setUseEdges(true);
        } else {
            this.m_state.setUseEdges(false);
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.restoreSettings(this.m_copyState);
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.init(this.m_copyState.getActivityType());
        this.setOutlierSettings();
    }

    public void updateNumber(Number number, int n) {
        if (n == LOWER_TAIL_PERCENT) {
            this.m_state.setLowerPercent(number.doubleValue());
        } else if (n == UPPER_TAIL_PERCENT) {
            this.m_state.setUpperPercent(number.doubleValue());
        } else if (n == LOWER_TAIL_VALUE) {
            this.m_state.setLowerValue(number.doubleValue());
        } else if (n == UPPER_TAIL_VALUE) {
            this.m_state.setUpperValue(number.doubleValue());
        } else if (n == SIGMA_CUSTOM) {
            this.m_state.setSigmaMultiple(number.doubleValue());
        }
    }
}

