/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer.activity;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.datamining.Enum;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.MiningObject;
import javax.datamining.association.AssociationModel;
import javax.datamining.base.Model;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.regression.RegressionTestMetrics;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.browser.BrowserAboutBoxPanel;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.HyperlinkButtonMiningResult;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.disco.DGWDialog;
import oracle.dmt.dm4j.browser.disco.DGWPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.RestoreFailedPanel;
import oracle.dmt.dm4j.browser.viewer.association.AssociationModelViewer;
import oracle.dmt.dm4j.browser.viewer.attributeImportance.AttributeImportanceViewer;
import oracle.dmt.dm4j.browser.viewer.classification.ClassificationModelViewer;
import oracle.dmt.dm4j.browser.viewer.classification.DTRulesExportTableModel;
import oracle.dmt.dm4j.browser.viewer.classification.DecisionTreeModelViewer;
import oracle.dmt.dm4j.browser.viewer.classification.DecisionTreeSplitterPanel;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringModelViewer;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.FeatureExtractionModelViewer;
import oracle.dmt.dm4j.browser.viewer.regression.RegressionModelViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.ApplyResultViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.ExplainResultViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.PredictResultViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.ResidualPlotResultViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.RegressionTestMetricsViewer;
import oracle.dmt.dm4j.browser.worker.LoadObjectDetailWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ObjectDetailLoadedListener;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.attributeimportance.OraAttributeImportanceModel;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.clustering.OraClusteringModel;
import oracle.dmt.jdm.jdmresult.OraMiningApplyResult;
import oracle.dmt.jdm.jdmresult.OraMiningExplainResult;
import oracle.dmt.jdm.jdmresult.OraMiningPredictResult;
import oracle.dmt.jdm.resource.OraConnection;

public class MiningResultViewerFrame
extends JFrame
implements ObjectDetailLoadedListener {
    HyperlinkButtonMiningResult m_hyperLink;
    private GriddedPanel m_loadingPanel = new GriddedPanel();
    private JComponent m_resultViewer = null;
    private AbstractActivity m_activity = null;
    private static Map discoGWNodeObjMap = new HashMap();

    public MiningResultViewerFrame(HyperlinkButtonMiningResult hyperlinkButtonMiningResult, AbstractActivity abstractActivity) {
        this.m_activity = abstractActivity;
        this.m_hyperLink = hyperlinkButtonMiningResult;
        this.commonConstructor();
    }

    public MiningResultViewerFrame(HyperlinkButtonMiningResult hyperlinkButtonMiningResult) {
        this.m_hyperLink = hyperlinkButtonMiningResult;
        this.commonConstructor();
    }

    private void commonConstructor() {
        this.createMenuBar();
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        this.setIconImage(imageIcon.getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createLoadingPanel());
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_activity != null) {
            stringBuffer.append(DM4JResourceUtilities.getActivityUIString("ACTIVITY_OUTPUT_DATA_TITLE_ACTIVITY") + " " + this.m_activity.getName() + ": ");
            stringBuffer.append(DM4JResourceUtilities.getActivityUIString("ACTIVITY_MINING_RESULT_VIEWER_TITLE") + " " + this.m_hyperLink.getLeafNodeData().getName());
        } else {
            stringBuffer.append(DM4JResourceUtilities.getActivityUIString("ACTIVITY_MINING_RESULT_VIEWER_TITLE") + " " + this.m_hyperLink.getLeafNodeData().getName());
        }
        this.setTitle(stringBuffer.toString());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, true);
        this.getRootPane().getInputMap(1).put(keyStroke, "HelpAction");
        this.getRootPane().getActionMap().put("HelpAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiningResultViewerFrame.this.help_actionPerformed(actionEvent);
            }
        });
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().getInputMap(2).put(keyStroke2, "EscAction");
        this.getRootPane().getActionMap().put("EscAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiningResultViewerFrame.this.esc_actionPerformed(actionEvent);
            }
        });
        this.pack();
        WindowUtils.centerWindow(this);
        this.setVisible(true);
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.m_hyperLink.getLeafNodeData());
        LoadObjectDetailWorker loadObjectDetailWorker = (LoadObjectDetailWorker)workerThreadManager.getLoadObjectDetailWorker(defaultMutableTreeNode, 0);
        loadObjectDetailWorker.addObjectDetailLoadedListener(this);
        loadObjectDetailWorker.start();
    }

    private void createMenuBar() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        this.setJMenuBar(jMenuBar);
        jMenu.setText(DM4JResourceUtilities.getUIString("MENU_FILE"));
        jMenu.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_FILE"));
        jMenuItem.setText(DM4JResourceUtilities.getUIString("MENU_FILE_EXIT"));
        jMenuItem.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_FILE_EXIT"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiningResultViewerFrame.this.esc_actionPerformed(actionEvent);
            }
        });
        Integer n = this.getPublishReportType();
        JMenu jMenu3 = null;
        if (n != null) {
            jMenu3 = new JMenu();
            jMenu3.setText(DM4JResourceUtilities.getUIString("RESULTS_MENU_PUBLISH"));
            jMenu3.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "RESULTS_MENU_PUBLISH"));
            JMenuItem jMenuItem4 = new JMenuItem();
            jMenuItem4.setText(DM4JResourceUtilities.getUIString("MENU_TOOLS_DISCO"));
            jMenuItem4.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_TOOLS_DISCO"));
            jMenuItem4.addActionListener(new ActionListener(){
                String selectedObjectName;
                Integer selectedReportType;
                String selectedSchemaName;
                {
                    this.selectedObjectName = MiningResultViewerFrame.this.m_hyperLink.getLeafNodeData().getName();
                    this.selectedReportType = MiningResultViewerFrame.this.getPublishReportType();
                    this.selectedSchemaName = null;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MiningResultViewerFrame.this.publish_ActionPerformed(actionEvent, this.selectedObjectName, this.selectedReportType, this.selectedSchemaName);
                }
            });
            jMenu3.add(jMenuItem4);
            if (n == 7) {
                JMenuItem jMenuItem5 = new JMenuItem();
                jMenuItem5.setText(DM4JResourceUtilities.getUIString("MENU_TOOLS_PUBLISH_FILE"));
                jMenuItem5.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_TOOLS_PUBLISH_FILE"));
                jMenuItem5.addActionListener(new ActionListener(){
                    String selectedObjectName;
                    Integer selectedReportType;
                    String selectedSchemaName;
                    {
                        this.selectedObjectName = MiningResultViewerFrame.this.m_hyperLink.getLeafNodeData().getName();
                        this.selectedReportType = MiningResultViewerFrame.this.getPublishReportType();
                        this.selectedSchemaName = null;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        MiningResultViewerFrame.this.publish_leaf_rules_to_file_ActionPerformed(actionEvent, this.selectedObjectName, this.selectedReportType, this.selectedSchemaName);
                    }
                });
                jMenu3.add(jMenuItem5);
            }
        }
        jMenu2.setText(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        jMenu2.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_HELP"));
        jMenuItem2.setText(DM4JResourceUtilities.getUIString("MENU_HELP_CONTENTS"));
        jMenuItem2.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_HELP_CONTENTS"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiningResultViewerFrame.this.help_actionPerformed(actionEvent);
            }
        });
        jMenuItem3.setText(DM4JResourceUtilities.getUIString("MENU_HELP_ABOUT"));
        jMenuItem3.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_HELP_ABOUT"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MiningResultViewerFrame.this.helpAbout_ActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.addSeparator();
        jMenu2.add(jMenuItem3);
        jMenuBar.add(jMenu);
        if (jMenu3 != null) {
            jMenuBar.add(jMenu3);
        }
        jMenuBar.add(jMenu2);
    }

    private void helpAbout_ActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, new BrowserAboutBoxPanel(), DM4JVersion.getFullBrowserName(), -1);
    }

    private void esc_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public void objectDetailLoaded(EventObject eventObject) {
        ArrayList arrayList = (ArrayList)eventObject.getSource();
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(n++);
        LeafNodeData leafNodeData = (LeafNodeData)defaultMutableTreeNode.getUserObject();
        Integer n2 = (Integer)arrayList.get(n++);
        Connection connection = (Connection)arrayList.get(n++);
        final Component component = this.loadLeafViewer(leafNodeData, connection, n2);
        this.m_resultViewer = (JComponent)component;
        this.m_resultViewer.setPreferredSize(new Dimension(640, 500));
        Runnable runnable = new Runnable(){

            public void run() {
                MiningResultViewerFrame.this.getContentPane().remove(MiningResultViewerFrame.this.m_loadingPanel);
                MiningResultViewerFrame.this.getContentPane().add(component);
                MiningResultViewerFrame.this.pack();
                component.requestFocus();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private void help_actionPerformed(ActionEvent actionEvent) {
        try {
            BrowserFrame.getCSHManager().showTopic(this.getHelpId());
        }
        catch (Exception exception) {
            BrowserFrame.showHelpError(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish_ActionPerformed(ActionEvent actionEvent, String string, Integer n, String string2) {
        block5: {
            DGWPanel dGWPanel = null;
            try {
                try {
                    this.setCursor(new Cursor(3));
                    dGWPanel = DGWDialog.getDGWPanel(string, n, string2);
                    DGWDialog dGWDialog = new DGWDialog(this, dGWPanel, DM4JResourceUtilities.getUIString("DISCOGW_DIALOG_TITLE"), "DISCOGW_DLG", n);
                    dGWDialog.setSize(dGWPanel.getPreferredSize());
                    WindowUtils.centerWindow(dGWDialog);
                    dGWDialog.setVisible(true);
                    if (dGWDialog.isOk()) break block5;
                    Object var8_8 = null;
                }
                catch (Exception exception) {
                    this.displaySystemError(exception);
                    Object var8_10 = null;
                    this.setCursor(new Cursor(0));
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.setCursor(new Cursor(0));
                throw throwable;
            }
            this.setCursor(new Cursor(0));
            return;
        }
        Object var8_9 = null;
        this.setCursor(new Cursor(0));
    }

    public void publish_leaf_rules_to_file_ActionPerformed(ActionEvent actionEvent, String string, Integer n, String string2) {
        try {
            final String string3 = string;
            final ExportDialog exportDialog = new ExportDialog((JFrame)BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"), false);
            Runnable runnable = new Runnable(){

                public void run() {
                    CreateRulesTable createRulesTable = new CreateRulesTable(string3, exportDialog);
                    ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("EXPORT_TREE_RULES_DIALOG_TITLE"), createRulesTable, true);
                    createRulesTable.setProgressBar(progressBar);
                    progressBar.start(ResourceUtilities.getUILabel("EXPORT_TREE_RULES_DIALOG_TITLE"), ResourceUtilities.getUILabel("EXPORT_TREE_RULES_DIALOG_DESCRIPTION"));
                    if (createRulesTable.getException() != null) {
                        createRulesTable.getException().printStackTrace();
                        DialogUtilities.createSystemErrorDialog(BrowserFrame.getMainFrame(), createRulesTable.getException());
                    } else if (progressBar.hasUserCancelled()) {
                        // empty if block
                    }
                }
            };
            if (!exportDialog.isCancelled() && exportDialog.specifyFileNameAndLocation()) {
                EventQueue.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void displaySystemError(Exception exception) {
        DialogUtilities.createSystemErrorDialog(this, exception);
        exception.printStackTrace();
    }

    private Component loadLeafViewer(LeafNodeData leafNodeData, Connection connection, int n) {
        Object object;
        MiningObject miningObject = leafNodeData.getOdmObject();
        String string = leafNodeData.getNodeType();
        JComponent jComponent = null;
        try {
            if (miningObject instanceof OraModel) {
                object = ((Model)miningObject).getMiningAlgorithm();
                MiningFunction miningFunction = ((Model)miningObject).getMiningFunction();
                if (object == null) {
                    if (miningObject instanceof OraAttributeImportanceModel) {
                        object = OraMiningAlgorithm.minimumDescriptionLength;
                    } else if (miningObject instanceof OraClusteringModel) {
                        object = ((OraClusteringModel)miningObject).getMiningAlgorithm();
                    } else if (miningObject instanceof AssociationModel) {
                        object = OraMiningAlgorithm.aprioriAssociationRules;
                    }
                }
                if (((Enum)object).equals(OraMiningAlgorithm.aprioriAssociationRules)) {
                    jComponent = new AssociationModelViewer(leafNodeData, connection, n);
                } else if (((Enum)object).equals(OraMiningAlgorithm.minimumDescriptionLength)) {
                    jComponent = new AttributeImportanceViewer(leafNodeData, connection, n);
                } else if (((Enum)object).equals(OraMiningAlgorithm.adaptiveBayesNetwork)) {
                    jComponent = new ClassificationModelViewer(leafNodeData, connection, n);
                } else if (((Enum)object).equals(MiningAlgorithm.naiveBayes)) {
                    jComponent = new ClassificationModelViewer(leafNodeData, connection, n);
                } else if (((Enum)object).equals(MiningAlgorithm.decisionTree)) {
                    jComponent = new DecisionTreeModelViewer(leafNodeData, connection, n);
                } else if (((Enum)object).equals(OraMiningAlgorithm.nonNegativeMatrixFactorization)) {
                    jComponent = new FeatureExtractionModelViewer(leafNodeData, connection, n);
                } else if (((Enum)object).equals(MiningAlgorithm.svmClassification)) {
                    jComponent = new ClassificationModelViewer(leafNodeData, connection, n);
                } else if (((Enum)object).equals(MiningAlgorithm.svmRegression)) {
                    jComponent = new RegressionModelViewer(leafNodeData, connection, n);
                } else if (miningFunction.equals(MiningFunction.classification) && ((Enum)object).equals(OraMiningAlgorithm.generalizedLinearModel)) {
                    jComponent = new ClassificationModelViewer(leafNodeData, connection, n);
                } else if (miningFunction.equals(MiningFunction.regression) && ((Enum)object).equals(OraMiningAlgorithm.generalizedLinearModel)) {
                    jComponent = new RegressionModelViewer(leafNodeData, connection, n);
                } else if (miningObject instanceof ClusteringModel) {
                    ClusteringModel clusteringModel = (ClusteringModel)miningObject;
                    jComponent = new ClusteringModelViewer(this, leafNodeData, connection, n);
                }
            } else if (miningObject instanceof OraMiningApplyResult) {
                jComponent = leafNodeData.getNodeType().endsWith("RESIDUAL_PLOT_RESULT") ? new ResidualPlotResultViewer(leafNodeData) : new ApplyResultViewer(leafNodeData);
            } else if (miningObject instanceof OraMiningPredictResult) {
                jComponent = new PredictResultViewer(leafNodeData);
            } else if (miningObject instanceof OraMiningExplainResult) {
                jComponent = new ExplainResultViewer(leafNodeData);
            } else if (miningObject instanceof ClassificationTestMetrics) {
                jComponent = new ClassificationTestMetricsViewer(leafNodeData, connection, n);
            } else if (miningObject instanceof RegressionTestMetrics) {
                object = DMEMetadata.getInstance();
                String string2 = ((DMEMetadata)object).getModelNameForResult(((OraConnection)connection).getDatabaseConnection(), "TEST", miningObject.getName());
                Hashtable hashtable = ((DMEMetadata)object).getSVModelShiftScale(((OraConnection)connection).getDatabaseConnection(), string2);
                Double d = (Double)hashtable.get("SHIFT");
                Double d2 = (Double)hashtable.get("SCALE");
                jComponent = new RegressionTestMetricsViewer(leafNodeData, d, d2);
            } else {
                jComponent = new RestoreFailedPanel();
            }
        }
        catch (Exception exception) {
            jComponent = new RestoreFailedPanel();
        }
        if (jComponent instanceof JTabbedPane) {
            object = (JTabbedPane)jComponent;
            ((JTabbedPane)object).setSelectedIndex(n);
        }
        return jComponent;
    }

    private Integer getPublishReportType() {
        String string = this.m_hyperLink.getLeafNodeData().getNodeType();
        return (Integer)discoGWNodeObjMap.get(string);
    }

    protected String getHelpId() {
        String string = "";
        if (this.m_resultViewer != null) {
            if (this.m_resultViewer instanceof JTabbedPane) {
                int n = ((JTabbedPane)this.m_resultViewer).getSelectedIndex();
                JComponent jComponent = (JComponent)((JTabbedPane)this.m_resultViewer).getComponentAt(n);
                if (jComponent instanceof GriddedPanel) {
                    GriddedPanel griddedPanel = (GriddedPanel)jComponent;
                    string = this.m_resultViewer instanceof RegressionTestMetricsViewer ? ((RegressionTestMetricsViewer)this.m_resultViewer).getHelpId() : griddedPanel.getHelpId();
                } else if (jComponent instanceof DecisionTreeSplitterPanel) {
                    DecisionTreeSplitterPanel decisionTreeSplitterPanel = (DecisionTreeSplitterPanel)jComponent;
                    string = decisionTreeSplitterPanel.getHelpId();
                }
            } else if (this.m_resultViewer instanceof GriddedPanel) {
                string = ((GriddedPanel)this.m_resultViewer).getHelpId();
            }
        }
        return string;
    }

    public JPanel createLoadingPanel() {
        int n = 0;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getActivityUIString("ERROR_DIALOG_LOADING"));
        this.m_loadingPanel.addAnchoredComponent(jLabel, GriddedPanel.TOPLABELITEMINSETS, n, 0, 1, 1, 18);
        JLabel jLabel2 = new JLabel();
        this.m_loadingPanel.addComponent(jLabel2, GriddedPanel.TOPLABELITEMINSETS, n, 0, 2, 2, 18, 1);
        this.m_loadingPanel.setPreferredSize(new Dimension(640, 500));
        return this.m_loadingPanel;
    }

    static {
        discoGWNodeObjMap.put("ATTRIBUTE_IMPORTANCE_MODEL", new Integer(1));
        discoGWNodeObjMap.put("ASSOCIATION_RULES_MODEL", new Integer(2));
        discoGWNodeObjMap.put("CLUSTERING_KMEANS_MODEL", new Integer(6));
        discoGWNodeObjMap.put("CLUSTERING_OCLUSTER_MODEL", new Integer(6));
        discoGWNodeObjMap.put("DT_MODEL", new Integer(7));
        discoGWNodeObjMap.put("APPLY_RESULT", new Integer(5));
        discoGWNodeObjMap.put("TEST_METRIC_RESULT", new Integer(3));
        discoGWNodeObjMap.put("TABLE", new Integer(9));
        discoGWNodeObjMap.put("VIEW", new Integer(9));
    }

    class CreateRulesTable
    extends LongRunningProcess
    implements Cancelable {
        private String m_modelName;
        private ExportDialog m_exportDialog;
        private boolean m_canceled = false;

        public CreateRulesTable(String string, ExportDialog exportDialog) {
            this.m_modelName = string;
            this.m_exportDialog = exportDialog;
        }

        public void run() {
            try {
                DTRulesExportTableModel dTRulesExportTableModel = new DTRulesExportTableModel(this.m_modelName);
                dTRulesExportTableModel.load();
                if (this.m_canceled) {
                    this.getProgressBar().setDoneStatus();
                    return;
                }
                if (this.getException() != null) {
                    this.getException().printStackTrace();
                    this.getProgressBar().setDoneStatus();
                }
                JTable jTable = new JTable(dTRulesExportTableModel);
                if (this.m_canceled) {
                    this.getProgressBar().setDoneStatus();
                    return;
                }
                this.m_exportDialog.exportWithExistingNameSpecification(jTable);
                this.getProgressBar().setDoneStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.setException(exception);
                this.getProgressBar().setDoneStatus();
            }
        }

        public void cancel() {
            this.m_canceled = true;
        }

        public boolean isCancelled() {
            return this.m_canceled;
        }
    }
}

