/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer;

import java.text.Collator;
import java.util.HashMap;
import java.util.Vector;
import javax.datamining.base.Model;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTable;
import oracle.dmt.dm4j.browser.viewer.FilterAttributesTableModel;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public final class FilterAttributesTable
extends Dm4jSpreadTable {
    private FilterAttributesTableModel m_tableModel;
    private String[] m_columnNames = new String[]{DM4JResourceUtilities.getUIString("COMMON_FILTER_INCLUDE"), DM4JResourceUtilities.getUIString("COMMON_FILTER_ATTRIBUTE_NAME")};
    int[] m_colWidths = new int[]{30, 70};

    public FilterAttributesTable(Object object) {
        super(object);
        this.setColumnNames(this.m_columnNames);
        Grid grid = this.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        try {
            this.displayLoadingStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(Object object, HashMap hashMap) throws Exception {
        this.setColumnWidths(this.m_colWidths, true);
        Model model = (Model)this.getDataItem();
        if (null == model) {
            throw new Exception("Cannot load data. MiningModel not supplied");
        }
        this.m_tableModel = new FilterAttributesTableModel();
        this.m_tableModel.setModel(this.getDataItem());
        this.m_tableModel.load(model, hashMap);
        this.setVerticalSeparatorsVisible(true);
        this.setModels((TwoDModel)this.m_tableModel, this.getColModel(), null);
        Header header = this.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        header.setItemInputHandler(new SortInputHandler(this.m_tableModel));
        this.m_tableModel.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        this.m_tableModel.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        try {
            this.setColumnWidths(this.m_colWidths, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_tableModel.getRowCount() > 0) {
            try {
                TwoDSelection twoDSelection = new TwoDSelection(0, true);
                this.setSelection(twoDSelection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Vector getSelectedAttributes() {
        return this.m_tableModel.getSelectedAttributes();
    }

    public void setSelectedAttributes(Vector vector) {
        this.m_tableModel.setSelectedAttributes(vector);
    }

    public void selectAll(boolean bl) {
        this.m_tableModel.selectAll(bl);
    }

    public boolean isSelectedAll() {
        return this.m_tableModel.isSelectedAll();
    }
}

