/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.Model;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.table.Dm4jSpreadTableExcelAdapter;
import oracle.dmt.dm4j.browser.viewer.FilterAttributesTable;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;

public class FilterAttributesPanel
extends GriddedPanel {
    JCheckBox m_attributesTableCheckBox = new JCheckBox();
    FilterAttributesTable m_attributesTable = null;
    JScrollPane m_attributesScrollPane = new JScrollPane();
    JButton m_exportButton = new JButton();
    JLabel lblBottom = new JLabel();
    NumberTextField txtBottomValue = new NumberTextField();
    JLabel lblTop = new JLabel();
    NumberTextField txtTopValue = new NumberTextField();
    JCheckBox filterByAbsoluteValue = new JCheckBox();
    JRadioButton filterIncludeAttributes = new JRadioButton();
    JRadioButton filterExcludeAttributes = new JRadioButton();
    JComboBox m_sortByComboBox = new JComboBox();
    JComboBox m_sortOrderComboBox = new JComboBox();
    HashMap m_condition = null;
    Vector m_selectedAttributes = null;
    Double m_topValue = null;
    Double m_bottomValue = null;
    Boolean m_isFilterByAbsoluteValue = Boolean.FALSE;
    Boolean m_isIncludedAttributes = Boolean.TRUE;
    String m_sortBy = null;
    String m_sortOrder = null;
    Model m_model;
    DM4JDialog m_parentDialog;

    public FilterAttributesPanel(DM4JDialog dM4JDialog, Model model, HashMap hashMap) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_model = model;
        this.m_condition = hashMap;
        this.jbInit();
        this.runTimePanelLoad();
    }

    protected void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = 0;
        GriddedPanel griddedPanel = new GriddedPanel();
        this.m_attributesTable = new FilterAttributesTable(this.m_model);
        JLabel jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_ATTRIBUTES"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_ATTRIBUTES"));
        griddedPanel.addAnchoredComponent(jLabel, MIDLABELITEMINSETS, n++, 0, 1, 1, 16);
        this.m_attributesTableCheckBox.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_CHECK_ALL"));
        this.m_attributesTableCheckBox.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_CHECK_ALL"));
        this.m_attributesTableCheckBox.setSelected(true);
        this.m_attributesTableCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterAttributesPanel.this.m_attributesTableCheckBox_actionPerformed();
            }
        });
        griddedPanel.addAnchoredComponent(this.m_attributesTableCheckBox, MIDLABELITEMINSETS, n++, 0, 1, 1, 16);
        this.m_attributesTable.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        this.m_attributesTable.getGrid().setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        this.m_attributesScrollPane.getViewport().add(this.m_attributesTable);
        this.m_attributesScrollPane.setPreferredSize(null);
        griddedPanel.addFilledComponent(this.m_attributesScrollPane, MIDLABELITEMINSETS, n, 0, 4, 4, 1);
        GriddedPanel griddedPanel2 = new GriddedPanel();
        jLabel = new JLabel();
        jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_BY_COEFFICIENT"));
        jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_BY_COEFFICIENT"));
        griddedPanel2.addComponent(jLabel, TOPLABELITEMINSETS, n++, 4, 1, 1, 12, 2);
        JPanel jPanel = new JPanel();
        this.lblBottom.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_BOTTOM"));
        this.lblBottom.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_BOTTOM"));
        this.lblBottom.setLabelFor(this.txtBottomValue);
        this.txtBottomValue.setDataType(Float.TYPE);
        this.txtBottomValue.setColumns(5);
        this.txtBottomValue.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_FLOAT"));
        jPanel.add(this.lblBottom);
        jPanel.add(this.txtBottomValue);
        griddedPanel2.addComponent(jPanel, TOPLABELITEMINSETS, n++, 4);
        JPanel jPanel2 = new JPanel();
        this.lblTop.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_TOP"));
        this.lblTop.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_TOP"));
        this.lblTop.setLabelFor(this.txtTopValue);
        jPanel2.add(this.lblTop);
        jPanel2.add(this.txtTopValue);
        this.txtTopValue.setDataType(Float.TYPE);
        this.txtTopValue.setColumns(5);
        this.txtTopValue.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_FLOAT"));
        griddedPanel2.addComponent(jPanel2, TOPLABELITEMINSETS, n++, 4);
        this.filterByAbsoluteValue.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_BY_ABSOULTE_VALUES"));
        this.filterByAbsoluteValue.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_BY_ABSOULTE_VALUES"));
        this.filterByAbsoluteValue.setSelected(false);
        griddedPanel2.addComponent(this.filterByAbsoluteValue, TOPLABELITEMINSETS, n++, 4);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("SORT_RULES_SORT_BY"));
        jLabel2.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "SORT_RULES_SORT_BY"));
        jLabel2.setLabelFor(this.m_sortByComboBox);
        jPanel3.add(jLabel2);
        this.m_sortByComboBox.addItem(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_ATTRIBUTE"));
        this.m_sortByComboBox.addItem(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_VALUE"));
        this.m_sortByComboBox.addItem(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_COEFFICIENT"));
        jPanel3.add(this.m_sortByComboBox);
        this.m_sortOrderComboBox.addItem(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_ASC"));
        this.m_sortOrderComboBox.addItem(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC"));
        jPanel3.add(this.m_sortOrderComboBox);
        griddedPanel2.addComponent(jPanel3, TOPLABELITEMINSETS, n++, 4);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.filterIncludeAttributes);
        buttonGroup.add(this.filterExcludeAttributes);
        this.filterIncludeAttributes.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES"));
        this.filterIncludeAttributes.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES"));
        this.filterIncludeAttributes.setSelected(true);
        this.filterExcludeAttributes.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_EXCLUDE_SELECTED_ATTRIBUTES"));
        this.filterExcludeAttributes.setMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_EXCLUDE_SELECTED_ATTRIBUTES"));
        this.filterExcludeAttributes.setSelected(false);
        GriddedPanel griddedPanel3 = new GriddedPanel();
        griddedPanel3.setBorder(new CompoundBorder(new TitledBorder(null, DM4JResourceUtilities.getUIString("COMMON_FILTER_SELECTED_ATTRIBUTES"), 1, 2), new EmptyBorder(5, 5, 5, 5)));
        griddedPanel3.addComponent(this.filterIncludeAttributes, new Insets(5, 10, 0, 0), 0, 0, 1, 1);
        griddedPanel3.addComponent(this.filterExcludeAttributes, new Insets(5, 10, 0, 0), 1, 0, 1, 1);
        griddedPanel2.addComponent(griddedPanel3, TOPLABELITEMINSETS, n++, 4);
        this.addOKHelpCancelListeners();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)griddedPanel2, "North");
        jPanel4.add((Component)griddedPanel, "Center");
        jPanel4.add((Component)jPanel5, "East");
        this.addFilledComponent(jPanel4, MIDLABELITEMINSETS, n++, 0, 2, 2, 1);
        this.addFilledComponent(new JLabel(" "), TOPLABELITEMINSETS, n, 1, 4, 2, 1);
        MiningAlgorithm miningAlgorithm = this.m_model.getBuildSettings().getAlgorithmSettings().getMiningAlgorithm();
        if (miningAlgorithm.name().equalsIgnoreCase(MiningAlgorithm.naiveBayes.name())) {
            jLabel.setText(DM4JResourceUtilities.getUIString("COMMON_FILTER_BY_PROBABILITY"));
            jLabel.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("COMMON_FILTER_BY_PROBABILITY"));
            this.filterByAbsoluteValue.setVisible(false);
            this.m_sortByComboBox.removeAllItems();
            this.m_sortByComboBox.addItem(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_ATTRIBUTE"));
            this.m_sortByComboBox.addItem(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_VALUE"));
            this.m_sortByComboBox.addItem(DM4JResourceUtilities.getUIString("COMMON_FILTER_SORT_PROBABILITY"));
        }
    }

    private void runTimePanelLoad() throws Exception {
        this.m_attributesTable.load(this.m_model, this.m_condition);
        this.m_selectedAttributes = this.m_attributesTable.getSelectedAttributes();
        Grid grid = this.m_attributesTable.getGrid();
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        this.m_attributesTable.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        this.m_attributesTable.getGrid().setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        Dm4jSpreadTableExcelAdapter dm4jSpreadTableExcelAdapter = new Dm4jSpreadTableExcelAdapter(this.m_attributesTable);
        if (this.m_condition != null) {
            this.m_selectedAttributes = (Vector)this.m_condition.get("COMMON_FILTER_ATTRIBUTES");
            this.m_topValue = (Double)this.m_condition.get("COMMON_FILTER_TOP");
            this.m_bottomValue = (Double)this.m_condition.get("COMMON_FILTER_BOTTOM");
            this.m_isFilterByAbsoluteValue = (Boolean)this.m_condition.get("COMMON_FILTER_BY_ABSOULTE_VALUES");
            this.m_isIncludedAttributes = (Boolean)this.m_condition.get("COMMON_FILTER_INCLUDE_SELECTED_ATTRIBUTES");
            this.m_sortBy = (String)this.m_condition.get("COMMON_FILTER_SORT_VALUE");
            this.m_sortOrder = (String)this.m_condition.get("COMMON_FILTER_SORT_ORDER");
            if (this.m_selectedAttributes != null) {
                this.m_attributesTable.setSelectedAttributes(this.m_selectedAttributes);
                if (this.m_attributesTable.isSelectedAll()) {
                    this.m_attributesTableCheckBox.setSelected(true);
                } else {
                    this.m_attributesTableCheckBox.setSelected(false);
                }
            }
            if (this.m_topValue != null) {
                this.txtTopValue.setNumber(this.m_topValue);
            }
            if (this.m_bottomValue != null) {
                this.txtBottomValue.setNumber(this.m_bottomValue);
            }
            this.filterByAbsoluteValue.setSelected(false);
            if (this.m_isFilterByAbsoluteValue != null & this.m_isFilterByAbsoluteValue == Boolean.TRUE) {
                this.filterByAbsoluteValue.setSelected(true);
            }
            this.filterIncludeAttributes.setSelected(true);
            this.filterExcludeAttributes.setSelected(false);
            if (this.m_isIncludedAttributes != null & this.m_isIncludedAttributes == Boolean.FALSE) {
                this.filterIncludeAttributes.setSelected(false);
                this.filterExcludeAttributes.setSelected(true);
            }
            this.m_sortOrderComboBox.setSelectedItem(DM4JResourceUtilities.getUIString("SORT_DIALOG_SORT_RULES_DESC"));
            if (this.m_sortBy != null) {
                this.m_sortByComboBox.setSelectedItem(this.m_sortBy);
            }
            if (this.m_sortOrder != null) {
                this.m_sortOrderComboBox.setSelectedItem(this.m_sortOrder);
            }
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterAttributesPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    private void m_attributesTableCheckBox_actionPerformed() {
        if (this.m_attributesTableCheckBox != null) {
            if (this.m_attributesTableCheckBox.isSelected()) {
                this.m_attributesTable.selectAll(true);
            } else {
                this.m_attributesTable.selectAll(false);
            }
        }
    }

    private void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            try {
                this.processUserInput();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        Double d;
        this.m_selectedAttributes = this.m_attributesTable.getSelectedAttributes();
        if (this.txtTopValue.getNumber() != null) {
            try {
                this.m_topValue = d = new Double(this.txtTopValue.getNumber().doubleValue());
            }
            catch (Exception exception) {
                this.m_topValue = null;
                this.txtTopValue.setNumber(null);
            }
        } else {
            this.m_topValue = null;
        }
        if (this.txtBottomValue.getNumber() != null) {
            try {
                this.m_bottomValue = d = new Double(this.txtBottomValue.getNumber().doubleValue());
            }
            catch (Exception exception) {
                this.m_bottomValue = null;
                this.txtBottomValue.setNumber(null);
            }
        } else {
            this.m_bottomValue = null;
        }
        this.m_isFilterByAbsoluteValue = this.filterByAbsoluteValue.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this.m_isIncludedAttributes = this.filterIncludeAttributes.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this.m_sortBy = (String)this.m_sortByComboBox.getSelectedItem();
        this.m_sortOrder = (String)this.m_sortOrderComboBox.getSelectedItem();
    }

    public FilterAttributesTable getAttributesTable() {
        return this.m_attributesTable;
    }

    public Vector getSelectedAttributes() {
        return this.m_selectedAttributes;
    }

    public Double getTopValue() {
        return this.m_topValue;
    }

    public Double getBottomValue() {
        return this.m_bottomValue;
    }

    public Boolean isFilterByAbsoluteValue() {
        return this.m_isFilterByAbsoluteValue;
    }

    public Boolean isIncludedAttributes() {
        return this.m_isIncludedAttributes;
    }

    public String getSortByValue() {
        return this.m_sortBy;
    }

    public String getSortOrderValue() {
        return this.m_sortOrder;
    }
}

