/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.MiningObject;
import javax.datamining.base.Model;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.regression.RegressionTestMetrics;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.DeleteObjectDialogPanel;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.resource.BrowserHelpTopics;
import oracle.dmt.dm4j.browser.tree.NavigatorTree;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.browser.viewer.results.apply.ApplyResultViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.ResidualPlotResultViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.RegressionTestMetricsViewer;
import oracle.dmt.dm4j.browser.worker.LoadObjectDetailWorker;
import oracle.dmt.dm4j.browser.worker.RemoveObjectsWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.ObjectDetailLoadedListener;
import oracle.dmt.jdm.jdmresult.OraMiningApplyResult;

public class BrowseResultsListPanel
extends GriddedPanel
implements ObjectDetailLoadedListener {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private JScrollPane scrollPanel = new JScrollPane();
    private Model m_miningModel = null;
    private static ProgressBar m_progressDlg;
    private JLabel lblResults = new JLabel();
    private NavigatorTree m_resultsTree = null;
    private JButton btnView = new JButton();
    private JButton btnDelete = new JButton();
    private String helpId = null;
    Hashtable m_resultViewers = new Hashtable();

    public BrowseResultsListPanel(LeafNodeData leafNodeData) {
        try {
            this.helpId = BrowserHelpTopics.getHelpTopicForNode(leafNodeData.getNodeType());
            this.m_miningModel = (Model)leafNodeData.getOdmObject();
            this.jbInit();
            this.runTimePanelLoad();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return this.helpId;
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.setLayout(this.gridBagLayout);
        this.lblResults.setText(DM4JResourceUtilities.getUIString("MODEL_RES_TABLE_TITLE"));
        this.lblResults.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MODEL_RES_TABLE_TITLE"));
        this.addFilledComponent(this.lblResults, TOPLABELITEMINSETS, 0, 1, 2);
        this.m_resultsTree = new NavigatorTree(this.m_miningModel);
        this.m_resultsTree.setMainFrame(BrowserFrame.getMainFrame());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object;
                int n = BrowseResultsListPanel.this.m_resultsTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = BrowseResultsListPanel.this.m_resultsTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 2 && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof LeafNodeData) {
                    BrowseResultsListPanel.this.btnView_actionPerformed();
                }
            }
        };
        this.m_resultsTree.addMouseListener(mouseAdapter);
        ToolTipManager.sharedInstance().registerComponent(this.m_resultsTree);
        this.scrollPanel.getViewport().add(this.m_resultsTree);
        this.scrollPanel.setPreferredSize(null);
        this.addFilledComponent(this.scrollPanel, MIDLABELITEMINSETS, 1, 1, 2, 3, 1);
        this.lblResults.setLabelFor(this.m_resultsTree);
        this.btnView.setText(DM4JResourceUtilities.getUIString("MODEL_RES_BTN_VIEW"));
        this.btnView.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MODEL_RES_BTN_VIEW"));
        this.addFilledComponent(this.btnView, TOPLABELITEMINSETS, 1, 3, 1, 1, 2);
        if (!BrowserFrame.isDisableDesignFeatures()) {
            this.btnDelete.setText(DM4JResourceUtilities.getUIString("MODEL_RES_BTN_DELETE"));
            this.btnDelete.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MODEL_RES_BTN_DELETE"));
            this.addFilledComponent(this.btnDelete, TOPLABELITEMINSETS, 2, 3, 1, 1, 2);
        }
    }

    private void runTimePanelLoad() throws Exception {
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowseResultsListPanel.this.btnDelete_actionPerformed();
            }
        });
        this.btnView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowseResultsListPanel.this.btnView_actionPerformed();
            }
        });
    }

    private void btnDelete_actionPerformed() {
        final BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        if (!browserFrame.checkThreadState(3) || !browserFrame.checkUIState(1)) {
            return;
        }
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_resultsTree.getLastSelectedPathComponent();
        NodeData nodeData = null;
        if (defaultMutableTreeNode != null && (nodeData = (NodeData)defaultMutableTreeNode.getUserObject()) instanceof LeafNodeData) {
            bl = true;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("MODEL_RES_NOSELECT_ERROR"), DM4JResourceUtilities.getUIString("ERROR"), 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        NodeData nodeData2 = (NodeData)defaultMutableTreeNode2.getUserObject();
        if (nodeData2.getNodeType().equals("BUILD_RESULTS")) {
            BrowserContext browserContext = new BrowserContext(browserFrame.getSelectedNode(), LaunchPoint.MENU);
            browserFrame.fileDelete_ActionPerformed(browserContext);
            return;
        }
        final LeafNodeData leafNodeData = (LeafNodeData)nodeData;
        String string = DM4JResourceUtilities.getUIString("COMMON_DELETE_OBJECT_QUESTION");
        if (leafNodeData.getNodeType().equals("VIEW")) {
            string = DM4JResourceUtilities.getUIString("COMMON_DELETE_VIEW_QUESTION");
        }
        if (leafNodeData.getNodeType().equals("TABLE")) {
            string = DM4JResourceUtilities.getUIString("COMMON_DELETE_TABLE_QUESTION");
        }
        Boolean bl2 = null;
        Boolean bl3 = null;
        if (leafNodeData.isObjectType("APPLY_RESULT")) {
            bl3 = true;
        }
        try {
            DeleteObjectDialogPanel deleteObjectDialogPanel = new DeleteObjectDialogPanel(string, bl2, bl3);
            DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)browserFrame, (JPanel)deleteObjectDialogPanel, DM4JResourceUtilities.getUIString("DELETE_OBJECT_TITLE"), "DELETE_OBJECT_DLG");
            dM4JSimpleDialog.setVisible(true);
            if (!dM4JSimpleDialog.isOk()) {
                return;
            }
            final boolean bl4 = deleteObjectDialogPanel.cascadeDelete();
            final boolean bl5 = deleteObjectDialogPanel.deleteOutput();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        block12: {
                            try {
                                BrowseResultsListPanel.this.setCursor(new Cursor(3));
                                BrowseResultsListPanel.this.doDelete(bl4, bl5);
                                m_progressDlg.updateProgress(DM4JResourceUtilities.getUIString("COMMON_DELETING"), DM4JResourceUtilities.getUIString("COMMON_REFRESHING_TREE"));
                                if (leafNodeData.isObjectType("APPLY_RESULT")) {
                                    FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "APPLY_RESULTS");
                                    if (bl5) {
                                        FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "TABLES_SCHEMA");
                                        FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "VIEWS_SCHEMA");
                                    }
                                    break block12;
                                }
                                if (leafNodeData.isObjectType("RESIDUAL_PLOT_RESULT")) {
                                    FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "RESIDUAL_PLOT_RESULTS");
                                    if (bl5) {
                                        FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "TABLES_SCHEMA");
                                        FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "VIEWS_SCHEMA");
                                    }
                                    break block12;
                                }
                                if (leafNodeData.isObjectType("PREDICT_RESULT")) {
                                    FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "PREDICT_RESULTS");
                                    if (bl5) {
                                        FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "TABLES_SCHEMA");
                                        FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "VIEWS_SCHEMA");
                                    }
                                    break block12;
                                }
                                if (leafNodeData.isObjectType("EXPLAIN_RESULT")) {
                                    FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "EXPLAIN_RESULTS");
                                    if (bl5) {
                                        FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "TABLES_SCHEMA");
                                        FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "VIEWS_SCHEMA");
                                    }
                                    break block12;
                                }
                                if (!leafNodeData.isObjectType("TEST_METRIC_RESULT")) break block12;
                                FolderNodeData.refresh(browserFrame.getNavigatorTree().getTreeModel(), "TEST_METRICS_RESULTS");
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var3_2 = null;
                                m_progressDlg.setDoneStatus();
                                BrowseResultsListPanel.this.setCursor(new Cursor(0));
                                return;
                            }
                        }
                        Object var3_1 = null;
                        m_progressDlg.setDoneStatus();
                        BrowseResultsListPanel.this.setCursor(new Cursor(0));
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        m_progressDlg.setDoneStatus();
                        BrowseResultsListPanel.this.setCursor(new Cursor(0));
                        throw throwable;
                    }
                }
            };
            m_progressDlg = new ProgressBar(browserFrame, DM4JResourceUtilities.getUIString("COMMON_DELETING"), runnable, true);
            m_progressDlg.setCancelable(false);
            m_progressDlg.start(DM4JResourceUtilities.getUIString("COMMON_DELETING"), "");
            m_progressDlg.waitUntilDone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doDelete(boolean bl, boolean bl2) {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        this.m_resultsTree.saveSelectedPaths();
        TreePath[] treePathArray = this.m_resultsTree.getSelectionPaths();
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        int n = treePathArray.length;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            vector.add(defaultMutableTreeNode);
        }
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        RemoveObjectsWorker removeObjectsWorker = (RemoveObjectsWorker)workerThreadManager.getRemoveObjectsWorker(vector, bl, bl2);
        removeObjectsWorker.addRemovedListener(this.m_resultsTree);
        browserFrame.getNavigatorTree().saveSelectedPaths();
        browserFrame.setUIState(4);
        browserFrame.setCursor(new Cursor(3));
        removeObjectsWorker.start();
        removeObjectsWorker.get();
    }

    private void btnView_actionPerformed() {
        Object object;
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_resultsTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null && (object = (NodeData)defaultMutableTreeNode.getUserObject()) instanceof LeafNodeData) {
            bl = true;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("MODEL_RES_NOSELECT_ERROR"), DM4JResourceUtilities.getUIString("WARNING"), 0);
            return;
        }
        this.setCursor(new Cursor(3));
        object = this.m_resultsTree.getSelectionPath();
        defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)object).getLastPathComponent();
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadObjectDetailWorker loadObjectDetailWorker = (LoadObjectDetailWorker)workerThreadManager.getLoadObjectDetailWorker(defaultMutableTreeNode, 0);
        loadObjectDetailWorker.addObjectDetailLoadedListener(this);
        loadObjectDetailWorker.start();
    }

    public void objectDetailLoaded(EventObject eventObject) {
        ArrayList arrayList = (ArrayList)eventObject.getSource();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(0);
        if (defaultMutableTreeNode != null) {
            String string;
            JComponent jComponent;
            String string2;
            block9: {
                LeafNodeData leafNodeData = (LeafNodeData)defaultMutableTreeNode.getUserObject();
                MiningObject miningObject = leafNodeData.getOdmObject();
                String string3 = miningObject.getName();
                string2 = string3;
                JFrame jFrame = (JFrame)this.m_resultViewers.get(string2);
                if (null != jFrame && jFrame.isVisible()) {
                    jFrame.toFront();
                    this.setCursor(new Cursor(0));
                    return;
                }
                jComponent = null;
                string = null;
                Connection connection = null;
                try {
                    connection = DM4JConnectionManager.getConnection();
                    if (miningObject instanceof ClassificationTestMetrics) {
                        jComponent = new ClassificationTestMetricsViewer(leafNodeData, connection, 0);
                        string = "TEST_RESULT";
                        break block9;
                    }
                    if (miningObject instanceof RegressionTestMetrics) {
                        jComponent = new RegressionTestMetricsViewer(leafNodeData);
                        string = "TEST_RESULT";
                        break block9;
                    }
                    if (miningObject instanceof OraMiningApplyResult) {
                        if (leafNodeData.getNodeType().endsWith("RESIDUAL_PLOT_RESULT")) {
                            jComponent = new ResidualPlotResultViewer(leafNodeData);
                            string = "REGRESS_RESIDUAL_PLOT_VIEWER";
                        } else {
                            jComponent = new ApplyResultViewer(leafNodeData);
                            string = "APPLY_RESULT";
                        }
                        break block9;
                    }
                    JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("MODEL_RES_CANNOT_VIEW"), DM4JResourceUtilities.getUIString("ERROR"), 0);
                    this.setCursor(new Cursor(0));
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            final String string4 = string;
            final JFrame jFrame = new JFrame(DM4JResourceUtilities.getUIString("MODEL_RES_FRAME_TITLE"));
            ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
            jFrame.setIconImage(imageIcon.getImage());
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.setSize(500, 500);
            jFrame.getContentPane().add((Component)jComponent, "Center");
            WindowUtils.centerWindow(jFrame);
            jFrame.setVisible(true);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Window window = windowEvent.getWindow();
                    window.setVisible(false);
                    window.dispose();
                }
            });
            jFrame.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 112) {
                        if (string4 != null) {
                            try {
                                BrowserFrame.getCSHManager().showTopic(string4);
                            }
                            catch (Exception exception) {
                                BrowserFrame.showHelpError(jFrame);
                            }
                        }
                        keyEvent.consume();
                    }
                }
            });
            this.m_resultViewers.put(string2, jFrame);
            this.setCursor(new Cursor(0));
        }
    }
}

