/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.tree.node;

import java.util.Date;
import javax.swing.Icon;
import oracle.dmt.dm4j.browser.tree.TreeIconManager;

public abstract class NodeData {
    private String m_name;
    private String m_nodeType;
    private Date m_timestamp;
    private long m_id;
    private static long m_nextNodeId = 0L;
    protected Icon m_icon = null;
    protected Icon m_expandedIcon = null;
    private String m_schemaName = null;

    public NodeData(String string, String string2) throws Exception {
        if (null == string || null == string2) {
            throw new Exception("Node name and type cannot be null");
        }
        this.m_name = string;
        this.m_nodeType = string2;
        this.m_id = this.getNewNodeId();
    }

    protected long getNewNodeId() {
        return m_nextNodeId++;
    }

    public long getNodeId() {
        return this.m_id;
    }

    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public void updateTimestamp() {
        Date date;
        this.m_timestamp = date = new Date();
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long l) {
        this.m_id = l;
    }

    public String getNodeType() {
        return this.m_nodeType;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String toString() {
        return this.m_name;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public Icon getExpandedIcon() {
        return this.m_expandedIcon;
    }

    protected Icon getIconResource(String string) {
        TreeIconManager treeIconManager = TreeIconManager.getInstance();
        return treeIconManager.getIcon(string);
    }

    public void setSchemaName(String string) {
        this.m_schemaName = string;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }
}

